# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


@register_command(
    "network application-gateway waf-policy update",
)
class Update(AAZCommand):
    """Update an application gateway WAF policy.

    :example: Update an application gateway WAF policy. (autogenerated)
        az network application-gateway waf-policy update --add communities='12076:5010' --name MyApplicationGatewayWAFPolicy --resource-group MyResourceGroup

    :example: Update an application gateway WAF policy. (autogenerated)
        az network application-gateway waf-policy update --name MyApplicationGatewayWAFPolicy --remove tags.no_80 --resource-group MyResourceGroup

    :example: Override (update) existing managed rule set (via shorthand-syntax).
        az network application-gateway waf-policy update --managed-rules "{managed-rule-sets:[{rule-group-overrides:[{rule-group-name:REQUEST-921-PROTOCOL-ATTACK,rules:[{rule-id:921100},{rule-id:921100}]}],rule-set-type:OWASP,rule-set-version:3.0}]}"
    """

    _aaz_info = {
        "version": "2022-05-01",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.network/applicationgatewaywebapplicationfirewallpolicies/{}", "2022-05-01"],
        ]
    }

    AZ_SUPPORT_GENERIC_UPDATE = True

    def _handler(self, command_args):
        super()._handler(command_args)
        self._execute_operations()
        return self._output()

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.name = AAZStrArg(
            options=["-n", "--name"],
            help="The name of the application gateway WAF policy.",
            required=True,
            id_part="name",
            fmt=AAZStrArgFormat(
                max_length=128,
            ),
        )
        _args_schema.resource_group = AAZResourceGroupNameArg(
            required=True,
        )
        _args_schema.tags = AAZDictArg(
            options=["--tags"],
            help="Space-separated tags: key[=value] [key[=value] ...].",
            nullable=True,
        )

        tags = cls._args_schema.tags
        tags.Element = AAZStrArg(
            nullable=True,
        )

        # define Arg Group "Parameters"

        # define Arg Group "Properties"

        _args_schema = cls._args_schema
        _args_schema.custom_rules = AAZListArg(
            options=["--custom-rules"],
            arg_group="Properties",
            help="The custom rules inside the policy.",
            nullable=True,
        )
        _args_schema.managed_rules = AAZObjectArg(
            options=["--managed-rules"],
            arg_group="Properties",
            help="Describes the managedRules structure.",
        )
        _args_schema.policy_settings = AAZObjectArg(
            options=["--policy-settings"],
            arg_group="Properties",
            help="The PolicySettings for policy.",
            nullable=True,
        )

        custom_rules = cls._args_schema.custom_rules
        custom_rules.Element = AAZObjectArg(
            nullable=True,
        )

        _element = cls._args_schema.custom_rules.Element
        _element.action = AAZStrArg(
            options=["action"],
            help="Type of Actions.",
            enum={"Allow": "Allow", "Block": "Block", "Log": "Log"},
        )
        _element.match_conditions = AAZListArg(
            options=["match-conditions"],
            help="List of match conditions.",
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="The name of the resource that is unique within a policy. This name can be used to access the resource.",
            nullable=True,
            fmt=AAZStrArgFormat(
                max_length=128,
            ),
        )
        _element.priority = AAZIntArg(
            options=["priority"],
            help="Priority of the rule. Rules with a lower value will be evaluated before rules with a higher value.",
        )
        _element.rule_type = AAZStrArg(
            options=["rule-type"],
            help="The rule type.",
            enum={"Invalid": "Invalid", "MatchRule": "MatchRule"},
        )

        match_conditions = cls._args_schema.custom_rules.Element.match_conditions
        match_conditions.Element = AAZObjectArg(
            nullable=True,
        )

        _element = cls._args_schema.custom_rules.Element.match_conditions.Element
        _element.match_values = AAZListArg(
            options=["match-values"],
            help="Match value.",
        )
        _element.match_variables = AAZListArg(
            options=["match-variables"],
            help="List of match variables.",
        )
        _element.negation_condition = AAZBoolArg(
            options=["negation-condition"],
            help="Whether this is negate condition or not.",
            nullable=True,
        )
        _element.operator = AAZStrArg(
            options=["operator"],
            help="The operator to be matched.",
            enum={"Any": "Any", "BeginsWith": "BeginsWith", "Contains": "Contains", "EndsWith": "EndsWith", "Equal": "Equal", "GeoMatch": "GeoMatch", "GreaterThan": "GreaterThan", "GreaterThanOrEqual": "GreaterThanOrEqual", "IPMatch": "IPMatch", "LessThan": "LessThan", "LessThanOrEqual": "LessThanOrEqual", "Regex": "Regex"},
        )
        _element.transforms = AAZListArg(
            options=["transforms"],
            help="List of transforms.",
            nullable=True,
        )

        match_values = cls._args_schema.custom_rules.Element.match_conditions.Element.match_values
        match_values.Element = AAZStrArg(
            nullable=True,
        )

        match_variables = cls._args_schema.custom_rules.Element.match_conditions.Element.match_variables
        match_variables.Element = AAZObjectArg(
            nullable=True,
        )

        _element = cls._args_schema.custom_rules.Element.match_conditions.Element.match_variables.Element
        _element.selector = AAZStrArg(
            options=["selector"],
            help="The selector of match variable.",
            nullable=True,
        )
        _element.variable_name = AAZStrArg(
            options=["variable-name"],
            help="Match Variable.",
            enum={"PostArgs": "PostArgs", "QueryString": "QueryString", "RemoteAddr": "RemoteAddr", "RequestBody": "RequestBody", "RequestCookies": "RequestCookies", "RequestHeaders": "RequestHeaders", "RequestMethod": "RequestMethod", "RequestUri": "RequestUri"},
        )

        transforms = cls._args_schema.custom_rules.Element.match_conditions.Element.transforms
        transforms.Element = AAZStrArg(
            nullable=True,
            enum={"HtmlEntityDecode": "HtmlEntityDecode", "Lowercase": "Lowercase", "RemoveNulls": "RemoveNulls", "Trim": "Trim", "Uppercase": "Uppercase", "UrlDecode": "UrlDecode", "UrlEncode": "UrlEncode"},
        )

        managed_rules = cls._args_schema.managed_rules
        managed_rules.exclusions = AAZListArg(
            options=["exclusions"],
            help="The Exclusions that are applied on the policy.",
            nullable=True,
        )
        managed_rules.managed_rule_sets = AAZListArg(
            options=["managed-rule-sets"],
            help="The managed rule sets that are associated with the policy.",
        )

        exclusions = cls._args_schema.managed_rules.exclusions
        exclusions.Element = AAZObjectArg(
            nullable=True,
        )

        _element = cls._args_schema.managed_rules.exclusions.Element
        _element.exclusion_managed_rule_sets = AAZListArg(
            options=["exclusion-managed-rule-sets"],
            help="The managed rule sets that are associated with the exclusion.",
            nullable=True,
        )
        _element.match_variable = AAZStrArg(
            options=["match-variable"],
            help="The variable to be excluded.",
            enum={"RequestArgKeys": "RequestArgKeys", "RequestArgNames": "RequestArgNames", "RequestArgValues": "RequestArgValues", "RequestCookieKeys": "RequestCookieKeys", "RequestCookieNames": "RequestCookieNames", "RequestCookieValues": "RequestCookieValues", "RequestHeaderKeys": "RequestHeaderKeys", "RequestHeaderNames": "RequestHeaderNames", "RequestHeaderValues": "RequestHeaderValues"},
        )
        _element.selector = AAZStrArg(
            options=["selector"],
            help="When matchVariable is a collection, operator used to specify which elements in the collection this exclusion applies to.",
        )
        _element.selector_match_operator = AAZStrArg(
            options=["selector-match-operator"],
            help="When matchVariable is a collection, operate on the selector to specify which elements in the collection this exclusion applies to.",
            enum={"Contains": "Contains", "EndsWith": "EndsWith", "Equals": "Equals", "EqualsAny": "EqualsAny", "StartsWith": "StartsWith"},
        )

        exclusion_managed_rule_sets = cls._args_schema.managed_rules.exclusions.Element.exclusion_managed_rule_sets
        exclusion_managed_rule_sets.Element = AAZObjectArg(
            nullable=True,
        )

        _element = cls._args_schema.managed_rules.exclusions.Element.exclusion_managed_rule_sets.Element
        _element.rule_groups = AAZListArg(
            options=["rule-groups"],
            help="Defines the rule groups to apply to the rule set.",
            nullable=True,
        )
        _element.rule_set_type = AAZStrArg(
            options=["rule-set-type"],
            help="Defines the rule set type to use.",
        )
        _element.rule_set_version = AAZStrArg(
            options=["rule-set-version"],
            help="Defines the version of the rule set to use.",
        )

        rule_groups = cls._args_schema.managed_rules.exclusions.Element.exclusion_managed_rule_sets.Element.rule_groups
        rule_groups.Element = AAZObjectArg(
            nullable=True,
        )

        _element = cls._args_schema.managed_rules.exclusions.Element.exclusion_managed_rule_sets.Element.rule_groups.Element
        _element.rule_group_name = AAZStrArg(
            options=["rule-group-name"],
            help="The managed rule group for exclusion.",
        )
        _element.rules = AAZListArg(
            options=["rules"],
            help="List of rules that will be excluded. If none specified, all rules in the group will be excluded.",
            nullable=True,
        )

        rules = cls._args_schema.managed_rules.exclusions.Element.exclusion_managed_rule_sets.Element.rule_groups.Element.rules
        rules.Element = AAZObjectArg(
            nullable=True,
        )

        _element = cls._args_schema.managed_rules.exclusions.Element.exclusion_managed_rule_sets.Element.rule_groups.Element.rules.Element
        _element.rule_id = AAZStrArg(
            options=["rule-id"],
            help="Identifier for the managed rule.",
        )

        managed_rule_sets = cls._args_schema.managed_rules.managed_rule_sets
        managed_rule_sets.Element = AAZObjectArg(
            nullable=True,
        )

        _element = cls._args_schema.managed_rules.managed_rule_sets.Element
        _element.rule_group_overrides = AAZListArg(
            options=["rule-group-overrides"],
            help="Defines the rule group overrides to apply to the rule set.",
            nullable=True,
        )
        _element.rule_set_type = AAZStrArg(
            options=["rule-set-type"],
            help="Defines the rule set type to use.",
        )
        _element.rule_set_version = AAZStrArg(
            options=["rule-set-version"],
            help="Defines the version of the rule set to use.",
        )

        rule_group_overrides = cls._args_schema.managed_rules.managed_rule_sets.Element.rule_group_overrides
        rule_group_overrides.Element = AAZObjectArg(
            nullable=True,
        )

        _element = cls._args_schema.managed_rules.managed_rule_sets.Element.rule_group_overrides.Element
        _element.rule_group_name = AAZStrArg(
            options=["rule-group-name"],
            help="The managed rule group to override.",
        )
        _element.rules = AAZListArg(
            options=["rules"],
            help="List of rules that will be disabled. If none specified, all rules in the group will be disabled.",
            nullable=True,
        )

        rules = cls._args_schema.managed_rules.managed_rule_sets.Element.rule_group_overrides.Element.rules
        rules.Element = AAZObjectArg(
            nullable=True,
        )

        _element = cls._args_schema.managed_rules.managed_rule_sets.Element.rule_group_overrides.Element.rules.Element
        _element.action = AAZStrArg(
            options=["action"],
            help="Describes the override action to be applied when rule matches.",
            nullable=True,
            enum={"Allow": "Allow", "AnomalyScoring": "AnomalyScoring", "Block": "Block", "Log": "Log"},
        )
        _element.rule_id = AAZStrArg(
            options=["rule-id"],
            help="Identifier for the managed rule.",
        )
        _element.state = AAZStrArg(
            options=["state"],
            help="The state of the managed rule. Defaults to Disabled if not specified.",
            nullable=True,
            enum={"Disabled": "Disabled", "Enabled": "Enabled"},
        )

        policy_settings = cls._args_schema.policy_settings
        policy_settings.file_upload_limit_in_mb = AAZIntArg(
            options=["file-upload-limit-in-mb"],
            help="Maximum file upload size in Mb for WAF.",
            nullable=True,
            fmt=AAZIntArgFormat(
                minimum=0,
            ),
        )
        policy_settings.max_request_body_size_in_kb = AAZIntArg(
            options=["max-request-body-size-in-kb"],
            help="Maximum request body size in Kb for WAF.",
            nullable=True,
            fmt=AAZIntArgFormat(
                minimum=8,
            ),
        )
        policy_settings.mode = AAZStrArg(
            options=["mode"],
            help="The mode of the policy.",
            nullable=True,
            enum={"Detection": "Detection", "Prevention": "Prevention"},
        )
        policy_settings.request_body_check = AAZBoolArg(
            options=["request-body-check"],
            help="Whether to allow WAF to check request Body.",
            nullable=True,
        )
        policy_settings.state = AAZStrArg(
            options=["state"],
            help="The state of the policy.",
            nullable=True,
            enum={"Disabled": "Disabled", "Enabled": "Enabled"},
        )
        return cls._args_schema

    def _execute_operations(self):
        self.pre_operations()
        self.WebApplicationFirewallPoliciesGet(ctx=self.ctx)()
        self.pre_instance_update(self.ctx.vars.instance)
        self.InstanceUpdateByJson(ctx=self.ctx)()
        self.InstanceUpdateByGeneric(ctx=self.ctx)()
        self.post_instance_update(self.ctx.vars.instance)
        self.WebApplicationFirewallPoliciesCreateOrUpdate(ctx=self.ctx)()
        self.post_operations()

    # @register_callback
    def pre_operations(self):
        pass

    # @register_callback
    def post_operations(self):
        pass

    # @register_callback
    def pre_instance_update(self, instance):
        pass

    # @register_callback
    def post_instance_update(self, instance):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class WebApplicationFirewallPoliciesGet(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200]:
                return self.on_200(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/ApplicationGatewayWebApplicationFirewallPolicies/{policyName}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "GET"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "policyName", self.ctx.args.name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2022-05-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()
            _build_schema_web_application_firewall_policy_read(cls._schema_on_200)

            return cls._schema_on_200

    class WebApplicationFirewallPoliciesCreateOrUpdate(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200, 201]:
                return self.on_200_201(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/ApplicationGatewayWebApplicationFirewallPolicies/{policyName}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "PUT"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "policyName", self.ctx.args.name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2022-05-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Content-Type", "application/json",
                ),
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        @property
        def content(self):
            _content_value, _builder = self.new_content_builder(
                self.ctx.args,
                value=self.ctx.vars.instance,
            )

            return self.serialize_content(_content_value)

        def on_200_201(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200_201
            )

        _schema_on_200_201 = None

        @classmethod
        def _build_schema_on_200_201(cls):
            if cls._schema_on_200_201 is not None:
                return cls._schema_on_200_201

            cls._schema_on_200_201 = AAZObjectType()
            _build_schema_web_application_firewall_policy_read(cls._schema_on_200_201)

            return cls._schema_on_200_201

    class InstanceUpdateByJson(AAZJsonInstanceUpdateOperation):

        def __call__(self, *args, **kwargs):
            self._update_instance(self.ctx.vars.instance)

        def _update_instance(self, instance):
            _instance_value, _builder = self.new_content_builder(
                self.ctx.args,
                value=instance,
                typ=AAZObjectType
            )
            _builder.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})
            _builder.set_prop("tags", AAZDictType, ".tags")

            properties = _builder.get(".properties")
            if properties is not None:
                properties.set_prop("customRules", AAZListType, ".custom_rules")
                properties.set_prop("managedRules", AAZObjectType, ".managed_rules", typ_kwargs={"flags": {"required": True}})
                properties.set_prop("policySettings", AAZObjectType, ".policy_settings")

            custom_rules = _builder.get(".properties.customRules")
            if custom_rules is not None:
                custom_rules.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.customRules[]")
            if _elements is not None:
                _elements.set_prop("action", AAZStrType, ".action", typ_kwargs={"flags": {"required": True}})
                _elements.set_prop("matchConditions", AAZListType, ".match_conditions", typ_kwargs={"flags": {"required": True}})
                _elements.set_prop("name", AAZStrType, ".name")
                _elements.set_prop("priority", AAZIntType, ".priority", typ_kwargs={"flags": {"required": True}})
                _elements.set_prop("ruleType", AAZStrType, ".rule_type", typ_kwargs={"flags": {"required": True}})

            match_conditions = _builder.get(".properties.customRules[].matchConditions")
            if match_conditions is not None:
                match_conditions.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.customRules[].matchConditions[]")
            if _elements is not None:
                _elements.set_prop("matchValues", AAZListType, ".match_values", typ_kwargs={"flags": {"required": True}})
                _elements.set_prop("matchVariables", AAZListType, ".match_variables", typ_kwargs={"flags": {"required": True}})
                _elements.set_prop("negationCondition", AAZBoolType, ".negation_condition")
                _elements.set_prop("operator", AAZStrType, ".operator", typ_kwargs={"flags": {"required": True}})
                _elements.set_prop("transforms", AAZListType, ".transforms")

            match_values = _builder.get(".properties.customRules[].matchConditions[].matchValues")
            if match_values is not None:
                match_values.set_elements(AAZStrType, ".")

            match_variables = _builder.get(".properties.customRules[].matchConditions[].matchVariables")
            if match_variables is not None:
                match_variables.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.customRules[].matchConditions[].matchVariables[]")
            if _elements is not None:
                _elements.set_prop("selector", AAZStrType, ".selector")
                _elements.set_prop("variableName", AAZStrType, ".variable_name", typ_kwargs={"flags": {"required": True}})

            transforms = _builder.get(".properties.customRules[].matchConditions[].transforms")
            if transforms is not None:
                transforms.set_elements(AAZStrType, ".")

            managed_rules = _builder.get(".properties.managedRules")
            if managed_rules is not None:
                managed_rules.set_prop("exclusions", AAZListType, ".exclusions")
                managed_rules.set_prop("managedRuleSets", AAZListType, ".managed_rule_sets", typ_kwargs={"flags": {"required": True}})

            exclusions = _builder.get(".properties.managedRules.exclusions")
            if exclusions is not None:
                exclusions.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.managedRules.exclusions[]")
            if _elements is not None:
                _elements.set_prop("exclusionManagedRuleSets", AAZListType, ".exclusion_managed_rule_sets")
                _elements.set_prop("matchVariable", AAZStrType, ".match_variable", typ_kwargs={"flags": {"required": True}})
                _elements.set_prop("selector", AAZStrType, ".selector", typ_kwargs={"flags": {"required": True}})
                _elements.set_prop("selectorMatchOperator", AAZStrType, ".selector_match_operator", typ_kwargs={"flags": {"required": True}})

            exclusion_managed_rule_sets = _builder.get(".properties.managedRules.exclusions[].exclusionManagedRuleSets")
            if exclusion_managed_rule_sets is not None:
                exclusion_managed_rule_sets.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.managedRules.exclusions[].exclusionManagedRuleSets[]")
            if _elements is not None:
                _elements.set_prop("ruleGroups", AAZListType, ".rule_groups")
                _elements.set_prop("ruleSetType", AAZStrType, ".rule_set_type", typ_kwargs={"flags": {"required": True}})
                _elements.set_prop("ruleSetVersion", AAZStrType, ".rule_set_version", typ_kwargs={"flags": {"required": True}})

            rule_groups = _builder.get(".properties.managedRules.exclusions[].exclusionManagedRuleSets[].ruleGroups")
            if rule_groups is not None:
                rule_groups.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.managedRules.exclusions[].exclusionManagedRuleSets[].ruleGroups[]")
            if _elements is not None:
                _elements.set_prop("ruleGroupName", AAZStrType, ".rule_group_name", typ_kwargs={"flags": {"required": True}})
                _elements.set_prop("rules", AAZListType, ".rules")

            rules = _builder.get(".properties.managedRules.exclusions[].exclusionManagedRuleSets[].ruleGroups[].rules")
            if rules is not None:
                rules.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.managedRules.exclusions[].exclusionManagedRuleSets[].ruleGroups[].rules[]")
            if _elements is not None:
                _elements.set_prop("ruleId", AAZStrType, ".rule_id", typ_kwargs={"flags": {"required": True}})

            managed_rule_sets = _builder.get(".properties.managedRules.managedRuleSets")
            if managed_rule_sets is not None:
                managed_rule_sets.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.managedRules.managedRuleSets[]")
            if _elements is not None:
                _elements.set_prop("ruleGroupOverrides", AAZListType, ".rule_group_overrides")
                _elements.set_prop("ruleSetType", AAZStrType, ".rule_set_type", typ_kwargs={"flags": {"required": True}})
                _elements.set_prop("ruleSetVersion", AAZStrType, ".rule_set_version", typ_kwargs={"flags": {"required": True}})

            rule_group_overrides = _builder.get(".properties.managedRules.managedRuleSets[].ruleGroupOverrides")
            if rule_group_overrides is not None:
                rule_group_overrides.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.managedRules.managedRuleSets[].ruleGroupOverrides[]")
            if _elements is not None:
                _elements.set_prop("ruleGroupName", AAZStrType, ".rule_group_name", typ_kwargs={"flags": {"required": True}})
                _elements.set_prop("rules", AAZListType, ".rules")

            rules = _builder.get(".properties.managedRules.managedRuleSets[].ruleGroupOverrides[].rules")
            if rules is not None:
                rules.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.managedRules.managedRuleSets[].ruleGroupOverrides[].rules[]")
            if _elements is not None:
                _elements.set_prop("action", AAZStrType, ".action")
                _elements.set_prop("ruleId", AAZStrType, ".rule_id", typ_kwargs={"flags": {"required": True}})
                _elements.set_prop("state", AAZStrType, ".state")

            policy_settings = _builder.get(".properties.policySettings")
            if policy_settings is not None:
                policy_settings.set_prop("fileUploadLimitInMb", AAZIntType, ".file_upload_limit_in_mb")
                policy_settings.set_prop("maxRequestBodySizeInKb", AAZIntType, ".max_request_body_size_in_kb")
                policy_settings.set_prop("mode", AAZStrType, ".mode")
                policy_settings.set_prop("requestBodyCheck", AAZBoolType, ".request_body_check")
                policy_settings.set_prop("state", AAZStrType, ".state")

            tags = _builder.get(".tags")
            if tags is not None:
                tags.set_elements(AAZStrType, ".")

            return _instance_value

    class InstanceUpdateByGeneric(AAZGenericInstanceUpdateOperation):

        def __call__(self, *args, **kwargs):
            self._update_instance_by_generic(
                self.ctx.vars.instance,
                self.ctx.generic_update_args
            )


_schema_application_gateway_backend_address_pool_read = None


def _build_schema_application_gateway_backend_address_pool_read(_schema):
    global _schema_application_gateway_backend_address_pool_read
    if _schema_application_gateway_backend_address_pool_read is not None:
        _schema.etag = _schema_application_gateway_backend_address_pool_read.etag
        _schema.id = _schema_application_gateway_backend_address_pool_read.id
        _schema.name = _schema_application_gateway_backend_address_pool_read.name
        _schema.properties = _schema_application_gateway_backend_address_pool_read.properties
        _schema.type = _schema_application_gateway_backend_address_pool_read.type
        return

    _schema_application_gateway_backend_address_pool_read = AAZObjectType(
        flags={"read_only": True}
    )

    application_gateway_backend_address_pool_read = _schema_application_gateway_backend_address_pool_read
    application_gateway_backend_address_pool_read.etag = AAZStrType(
        flags={"read_only": True},
    )
    application_gateway_backend_address_pool_read.id = AAZStrType(
        flags={"read_only": True},
    )
    application_gateway_backend_address_pool_read.name = AAZStrType(
        flags={"read_only": True},
    )
    application_gateway_backend_address_pool_read.properties = AAZObjectType(
        flags={"client_flatten": True, "read_only": True},
    )
    application_gateway_backend_address_pool_read.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_application_gateway_backend_address_pool_read.properties
    properties.backend_addresses = AAZListType(
        serialized_name="backendAddresses",
        flags={"read_only": True},
    )
    properties.backend_ip_configurations = AAZListType(
        serialized_name="backendIPConfigurations",
        flags={"read_only": True},
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )

    backend_addresses = _schema_application_gateway_backend_address_pool_read.properties.backend_addresses
    backend_addresses.Element = AAZObjectType(
        flags={"read_only": True},
    )

    _element = _schema_application_gateway_backend_address_pool_read.properties.backend_addresses.Element
    _element.fqdn = AAZStrType(
        flags={"read_only": True},
    )
    _element.ip_address = AAZStrType(
        serialized_name="ipAddress",
        flags={"read_only": True},
    )

    backend_ip_configurations = _schema_application_gateway_backend_address_pool_read.properties.backend_ip_configurations
    backend_ip_configurations.Element = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_network_interface_ip_configuration_read(backend_ip_configurations.Element)

    _schema.etag = _schema_application_gateway_backend_address_pool_read.etag
    _schema.id = _schema_application_gateway_backend_address_pool_read.id
    _schema.name = _schema_application_gateway_backend_address_pool_read.name
    _schema.properties = _schema_application_gateway_backend_address_pool_read.properties
    _schema.type = _schema_application_gateway_backend_address_pool_read.type


_schema_application_gateway_custom_error_read = None


def _build_schema_application_gateway_custom_error_read(_schema):
    global _schema_application_gateway_custom_error_read
    if _schema_application_gateway_custom_error_read is not None:
        _schema.custom_error_page_url = _schema_application_gateway_custom_error_read.custom_error_page_url
        _schema.status_code = _schema_application_gateway_custom_error_read.status_code
        return

    _schema_application_gateway_custom_error_read = AAZObjectType(
        flags={"read_only": True}
    )

    application_gateway_custom_error_read = _schema_application_gateway_custom_error_read
    application_gateway_custom_error_read.custom_error_page_url = AAZStrType(
        serialized_name="customErrorPageUrl",
        flags={"read_only": True},
    )
    application_gateway_custom_error_read.status_code = AAZStrType(
        serialized_name="statusCode",
        flags={"read_only": True},
    )

    _schema.custom_error_page_url = _schema_application_gateway_custom_error_read.custom_error_page_url
    _schema.status_code = _schema_application_gateway_custom_error_read.status_code


_schema_application_gateway_header_configuration_read = None


def _build_schema_application_gateway_header_configuration_read(_schema):
    global _schema_application_gateway_header_configuration_read
    if _schema_application_gateway_header_configuration_read is not None:
        _schema.header_name = _schema_application_gateway_header_configuration_read.header_name
        _schema.header_value = _schema_application_gateway_header_configuration_read.header_value
        return

    _schema_application_gateway_header_configuration_read = AAZObjectType(
        flags={"read_only": True}
    )

    application_gateway_header_configuration_read = _schema_application_gateway_header_configuration_read
    application_gateway_header_configuration_read.header_name = AAZStrType(
        serialized_name="headerName",
        flags={"read_only": True},
    )
    application_gateway_header_configuration_read.header_value = AAZStrType(
        serialized_name="headerValue",
        flags={"read_only": True},
    )

    _schema.header_name = _schema_application_gateway_header_configuration_read.header_name
    _schema.header_value = _schema_application_gateway_header_configuration_read.header_value


_schema_application_gateway_ip_configuration_read = None


def _build_schema_application_gateway_ip_configuration_read(_schema):
    global _schema_application_gateway_ip_configuration_read
    if _schema_application_gateway_ip_configuration_read is not None:
        _schema.etag = _schema_application_gateway_ip_configuration_read.etag
        _schema.id = _schema_application_gateway_ip_configuration_read.id
        _schema.name = _schema_application_gateway_ip_configuration_read.name
        _schema.properties = _schema_application_gateway_ip_configuration_read.properties
        _schema.type = _schema_application_gateway_ip_configuration_read.type
        return

    _schema_application_gateway_ip_configuration_read = AAZObjectType(
        flags={"read_only": True}
    )

    application_gateway_ip_configuration_read = _schema_application_gateway_ip_configuration_read
    application_gateway_ip_configuration_read.etag = AAZStrType(
        flags={"read_only": True},
    )
    application_gateway_ip_configuration_read.id = AAZStrType(
        flags={"read_only": True},
    )
    application_gateway_ip_configuration_read.name = AAZStrType(
        flags={"read_only": True},
    )
    application_gateway_ip_configuration_read.properties = AAZObjectType(
        flags={"client_flatten": True, "read_only": True},
    )
    application_gateway_ip_configuration_read.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_application_gateway_ip_configuration_read.properties
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.subnet = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(properties.subnet)

    _schema.etag = _schema_application_gateway_ip_configuration_read.etag
    _schema.id = _schema_application_gateway_ip_configuration_read.id
    _schema.name = _schema_application_gateway_ip_configuration_read.name
    _schema.properties = _schema_application_gateway_ip_configuration_read.properties
    _schema.type = _schema_application_gateway_ip_configuration_read.type


_schema_application_gateway_ssl_policy_read = None


def _build_schema_application_gateway_ssl_policy_read(_schema):
    global _schema_application_gateway_ssl_policy_read
    if _schema_application_gateway_ssl_policy_read is not None:
        _schema.cipher_suites = _schema_application_gateway_ssl_policy_read.cipher_suites
        _schema.disabled_ssl_protocols = _schema_application_gateway_ssl_policy_read.disabled_ssl_protocols
        _schema.min_protocol_version = _schema_application_gateway_ssl_policy_read.min_protocol_version
        _schema.policy_name = _schema_application_gateway_ssl_policy_read.policy_name
        _schema.policy_type = _schema_application_gateway_ssl_policy_read.policy_type
        return

    _schema_application_gateway_ssl_policy_read = AAZObjectType(
        flags={"read_only": True}
    )

    application_gateway_ssl_policy_read = _schema_application_gateway_ssl_policy_read
    application_gateway_ssl_policy_read.cipher_suites = AAZListType(
        serialized_name="cipherSuites",
        flags={"read_only": True},
    )
    application_gateway_ssl_policy_read.disabled_ssl_protocols = AAZListType(
        serialized_name="disabledSslProtocols",
        flags={"read_only": True},
    )
    application_gateway_ssl_policy_read.min_protocol_version = AAZStrType(
        serialized_name="minProtocolVersion",
        flags={"read_only": True},
    )
    application_gateway_ssl_policy_read.policy_name = AAZStrType(
        serialized_name="policyName",
        flags={"read_only": True},
    )
    application_gateway_ssl_policy_read.policy_type = AAZStrType(
        serialized_name="policyType",
        flags={"read_only": True},
    )

    cipher_suites = _schema_application_gateway_ssl_policy_read.cipher_suites
    cipher_suites.Element = AAZStrType(
        flags={"read_only": True},
    )

    disabled_ssl_protocols = _schema_application_gateway_ssl_policy_read.disabled_ssl_protocols
    disabled_ssl_protocols.Element = AAZStrType(
        flags={"read_only": True},
    )

    _schema.cipher_suites = _schema_application_gateway_ssl_policy_read.cipher_suites
    _schema.disabled_ssl_protocols = _schema_application_gateway_ssl_policy_read.disabled_ssl_protocols
    _schema.min_protocol_version = _schema_application_gateway_ssl_policy_read.min_protocol_version
    _schema.policy_name = _schema_application_gateway_ssl_policy_read.policy_name
    _schema.policy_type = _schema_application_gateway_ssl_policy_read.policy_type


_schema_application_security_group_read = None


def _build_schema_application_security_group_read(_schema):
    global _schema_application_security_group_read
    if _schema_application_security_group_read is not None:
        _schema.etag = _schema_application_security_group_read.etag
        _schema.id = _schema_application_security_group_read.id
        _schema.location = _schema_application_security_group_read.location
        _schema.name = _schema_application_security_group_read.name
        _schema.properties = _schema_application_security_group_read.properties
        _schema.tags = _schema_application_security_group_read.tags
        _schema.type = _schema_application_security_group_read.type
        return

    _schema_application_security_group_read = AAZObjectType(
        flags={"read_only": True}
    )

    application_security_group_read = _schema_application_security_group_read
    application_security_group_read.etag = AAZStrType(
        flags={"read_only": True},
    )
    application_security_group_read.id = AAZStrType(
        flags={"read_only": True},
    )
    application_security_group_read.location = AAZStrType(
        flags={"read_only": True},
    )
    application_security_group_read.name = AAZStrType(
        flags={"read_only": True},
    )
    application_security_group_read.properties = AAZObjectType(
        flags={"client_flatten": True, "read_only": True},
    )
    application_security_group_read.tags = AAZDictType(
        flags={"read_only": True},
    )
    application_security_group_read.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_application_security_group_read.properties
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.resource_guid = AAZStrType(
        serialized_name="resourceGuid",
        flags={"read_only": True},
    )

    tags = _schema_application_security_group_read.tags
    tags.Element = AAZStrType(
        flags={"read_only": True},
    )

    _schema.etag = _schema_application_security_group_read.etag
    _schema.id = _schema_application_security_group_read.id
    _schema.location = _schema_application_security_group_read.location
    _schema.name = _schema_application_security_group_read.name
    _schema.properties = _schema_application_security_group_read.properties
    _schema.tags = _schema_application_security_group_read.tags
    _schema.type = _schema_application_security_group_read.type


_schema_extended_location_read = None


def _build_schema_extended_location_read(_schema):
    global _schema_extended_location_read
    if _schema_extended_location_read is not None:
        _schema.name = _schema_extended_location_read.name
        _schema.type = _schema_extended_location_read.type
        return

    _schema_extended_location_read = AAZObjectType(
        flags={"read_only": True}
    )

    extended_location_read = _schema_extended_location_read
    extended_location_read.name = AAZStrType(
        flags={"read_only": True},
    )
    extended_location_read.type = AAZStrType(
        flags={"read_only": True},
    )

    _schema.name = _schema_extended_location_read.name
    _schema.type = _schema_extended_location_read.type


_schema_frontend_ip_configuration_read = None


def _build_schema_frontend_ip_configuration_read(_schema):
    global _schema_frontend_ip_configuration_read
    if _schema_frontend_ip_configuration_read is not None:
        _schema.etag = _schema_frontend_ip_configuration_read.etag
        _schema.id = _schema_frontend_ip_configuration_read.id
        _schema.name = _schema_frontend_ip_configuration_read.name
        _schema.properties = _schema_frontend_ip_configuration_read.properties
        _schema.type = _schema_frontend_ip_configuration_read.type
        _schema.zones = _schema_frontend_ip_configuration_read.zones
        return

    _schema_frontend_ip_configuration_read = AAZObjectType(
        flags={"read_only": True}
    )

    frontend_ip_configuration_read = _schema_frontend_ip_configuration_read
    frontend_ip_configuration_read.etag = AAZStrType(
        flags={"read_only": True},
    )
    frontend_ip_configuration_read.id = AAZStrType(
        flags={"read_only": True},
    )
    frontend_ip_configuration_read.name = AAZStrType(
        flags={"read_only": True},
    )
    frontend_ip_configuration_read.properties = AAZObjectType(
        flags={"client_flatten": True, "read_only": True},
    )
    frontend_ip_configuration_read.type = AAZStrType(
        flags={"read_only": True},
    )
    frontend_ip_configuration_read.zones = AAZListType(
        flags={"read_only": True},
    )

    properties = _schema_frontend_ip_configuration_read.properties
    properties.gateway_load_balancer = AAZObjectType(
        serialized_name="gatewayLoadBalancer",
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(properties.gateway_load_balancer)
    properties.inbound_nat_pools = AAZListType(
        serialized_name="inboundNatPools",
        flags={"read_only": True},
    )
    properties.inbound_nat_rules = AAZListType(
        serialized_name="inboundNatRules",
        flags={"read_only": True},
    )
    properties.load_balancing_rules = AAZListType(
        serialized_name="loadBalancingRules",
        flags={"read_only": True},
    )
    properties.outbound_rules = AAZListType(
        serialized_name="outboundRules",
        flags={"read_only": True},
    )
    properties.private_ip_address = AAZStrType(
        serialized_name="privateIPAddress",
        flags={"read_only": True},
    )
    properties.private_ip_address_version = AAZStrType(
        serialized_name="privateIPAddressVersion",
        flags={"read_only": True},
    )
    properties.private_ip_allocation_method = AAZStrType(
        serialized_name="privateIPAllocationMethod",
        flags={"read_only": True},
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.public_ip_address = AAZObjectType(
        serialized_name="publicIPAddress",
        flags={"read_only": True},
    )
    _build_schema_public_ip_address_read(properties.public_ip_address)
    properties.public_ip_prefix = AAZObjectType(
        serialized_name="publicIPPrefix",
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(properties.public_ip_prefix)
    properties.subnet = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_subnet_read(properties.subnet)

    inbound_nat_pools = _schema_frontend_ip_configuration_read.properties.inbound_nat_pools
    inbound_nat_pools.Element = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(inbound_nat_pools.Element)

    inbound_nat_rules = _schema_frontend_ip_configuration_read.properties.inbound_nat_rules
    inbound_nat_rules.Element = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(inbound_nat_rules.Element)

    load_balancing_rules = _schema_frontend_ip_configuration_read.properties.load_balancing_rules
    load_balancing_rules.Element = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(load_balancing_rules.Element)

    outbound_rules = _schema_frontend_ip_configuration_read.properties.outbound_rules
    outbound_rules.Element = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(outbound_rules.Element)

    zones = _schema_frontend_ip_configuration_read.zones
    zones.Element = AAZStrType(
        flags={"read_only": True},
    )

    _schema.etag = _schema_frontend_ip_configuration_read.etag
    _schema.id = _schema_frontend_ip_configuration_read.id
    _schema.name = _schema_frontend_ip_configuration_read.name
    _schema.properties = _schema_frontend_ip_configuration_read.properties
    _schema.type = _schema_frontend_ip_configuration_read.type
    _schema.zones = _schema_frontend_ip_configuration_read.zones


_schema_ip_configuration_read = None


def _build_schema_ip_configuration_read(_schema):
    global _schema_ip_configuration_read
    if _schema_ip_configuration_read is not None:
        _schema.etag = _schema_ip_configuration_read.etag
        _schema.id = _schema_ip_configuration_read.id
        _schema.name = _schema_ip_configuration_read.name
        _schema.properties = _schema_ip_configuration_read.properties
        return

    _schema_ip_configuration_read = AAZObjectType(
        flags={"read_only": True}
    )

    ip_configuration_read = _schema_ip_configuration_read
    ip_configuration_read.etag = AAZStrType(
        flags={"read_only": True},
    )
    ip_configuration_read.id = AAZStrType(
        flags={"read_only": True},
    )
    ip_configuration_read.name = AAZStrType(
        flags={"read_only": True},
    )
    ip_configuration_read.properties = AAZObjectType(
        flags={"client_flatten": True, "read_only": True},
    )

    properties = _schema_ip_configuration_read.properties
    properties.private_ip_address = AAZStrType(
        serialized_name="privateIPAddress",
        flags={"read_only": True},
    )
    properties.private_ip_allocation_method = AAZStrType(
        serialized_name="privateIPAllocationMethod",
        flags={"read_only": True},
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.public_ip_address = AAZObjectType(
        serialized_name="publicIPAddress",
        flags={"read_only": True},
    )
    _build_schema_public_ip_address_read(properties.public_ip_address)
    properties.subnet = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_subnet_read(properties.subnet)

    _schema.etag = _schema_ip_configuration_read.etag
    _schema.id = _schema_ip_configuration_read.id
    _schema.name = _schema_ip_configuration_read.name
    _schema.properties = _schema_ip_configuration_read.properties


_schema_network_interface_ip_configuration_read = None


def _build_schema_network_interface_ip_configuration_read(_schema):
    global _schema_network_interface_ip_configuration_read
    if _schema_network_interface_ip_configuration_read is not None:
        _schema.etag = _schema_network_interface_ip_configuration_read.etag
        _schema.id = _schema_network_interface_ip_configuration_read.id
        _schema.name = _schema_network_interface_ip_configuration_read.name
        _schema.properties = _schema_network_interface_ip_configuration_read.properties
        _schema.type = _schema_network_interface_ip_configuration_read.type
        return

    _schema_network_interface_ip_configuration_read = AAZObjectType(
        flags={"read_only": True}
    )

    network_interface_ip_configuration_read = _schema_network_interface_ip_configuration_read
    network_interface_ip_configuration_read.etag = AAZStrType(
        flags={"read_only": True},
    )
    network_interface_ip_configuration_read.id = AAZStrType(
        flags={"read_only": True},
    )
    network_interface_ip_configuration_read.name = AAZStrType(
        flags={"read_only": True},
    )
    network_interface_ip_configuration_read.properties = AAZObjectType(
        flags={"client_flatten": True, "read_only": True},
    )
    network_interface_ip_configuration_read.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_network_interface_ip_configuration_read.properties
    properties.application_gateway_backend_address_pools = AAZListType(
        serialized_name="applicationGatewayBackendAddressPools",
        flags={"read_only": True},
    )
    properties.application_security_groups = AAZListType(
        serialized_name="applicationSecurityGroups",
        flags={"read_only": True},
    )
    properties.gateway_load_balancer = AAZObjectType(
        serialized_name="gatewayLoadBalancer",
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(properties.gateway_load_balancer)
    properties.load_balancer_backend_address_pools = AAZListType(
        serialized_name="loadBalancerBackendAddressPools",
        flags={"read_only": True},
    )
    properties.load_balancer_inbound_nat_rules = AAZListType(
        serialized_name="loadBalancerInboundNatRules",
        flags={"read_only": True},
    )
    properties.primary = AAZBoolType(
        flags={"read_only": True},
    )
    properties.private_ip_address = AAZStrType(
        serialized_name="privateIPAddress",
        flags={"read_only": True},
    )
    properties.private_ip_address_version = AAZStrType(
        serialized_name="privateIPAddressVersion",
        flags={"read_only": True},
    )
    properties.private_ip_allocation_method = AAZStrType(
        serialized_name="privateIPAllocationMethod",
        flags={"read_only": True},
    )
    properties.private_link_connection_properties = AAZObjectType(
        serialized_name="privateLinkConnectionProperties",
        flags={"read_only": True},
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.public_ip_address = AAZObjectType(
        serialized_name="publicIPAddress",
        flags={"read_only": True},
    )
    _build_schema_public_ip_address_read(properties.public_ip_address)
    properties.subnet = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_subnet_read(properties.subnet)
    properties.virtual_network_taps = AAZListType(
        serialized_name="virtualNetworkTaps",
        flags={"read_only": True},
    )

    application_gateway_backend_address_pools = _schema_network_interface_ip_configuration_read.properties.application_gateway_backend_address_pools
    application_gateway_backend_address_pools.Element = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_application_gateway_backend_address_pool_read(application_gateway_backend_address_pools.Element)

    application_security_groups = _schema_network_interface_ip_configuration_read.properties.application_security_groups
    application_security_groups.Element = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_application_security_group_read(application_security_groups.Element)

    load_balancer_backend_address_pools = _schema_network_interface_ip_configuration_read.properties.load_balancer_backend_address_pools
    load_balancer_backend_address_pools.Element = AAZObjectType(
        flags={"read_only": True},
    )

    _element = _schema_network_interface_ip_configuration_read.properties.load_balancer_backend_address_pools.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.id = AAZStrType(
        flags={"read_only": True},
    )
    _element.name = AAZStrType(
        flags={"read_only": True},
    )
    _element.properties = AAZObjectType(
        flags={"client_flatten": True, "read_only": True},
    )
    _element.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_network_interface_ip_configuration_read.properties.load_balancer_backend_address_pools.Element.properties
    properties.backend_ip_configurations = AAZListType(
        serialized_name="backendIPConfigurations",
        flags={"read_only": True},
    )
    properties.drain_period_in_seconds = AAZIntType(
        serialized_name="drainPeriodInSeconds",
        flags={"read_only": True},
    )
    properties.inbound_nat_rules = AAZListType(
        serialized_name="inboundNatRules",
        flags={"read_only": True},
    )
    properties.load_balancer_backend_addresses = AAZListType(
        serialized_name="loadBalancerBackendAddresses",
        flags={"read_only": True},
    )
    properties.load_balancing_rules = AAZListType(
        serialized_name="loadBalancingRules",
        flags={"read_only": True},
    )
    properties.location = AAZStrType(
        flags={"read_only": True},
    )
    properties.outbound_rule = AAZObjectType(
        serialized_name="outboundRule",
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(properties.outbound_rule)
    properties.outbound_rules = AAZListType(
        serialized_name="outboundRules",
        flags={"read_only": True},
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.tunnel_interfaces = AAZListType(
        serialized_name="tunnelInterfaces",
        flags={"read_only": True},
    )

    backend_ip_configurations = _schema_network_interface_ip_configuration_read.properties.load_balancer_backend_address_pools.Element.properties.backend_ip_configurations
    backend_ip_configurations.Element = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_network_interface_ip_configuration_read(backend_ip_configurations.Element)

    inbound_nat_rules = _schema_network_interface_ip_configuration_read.properties.load_balancer_backend_address_pools.Element.properties.inbound_nat_rules
    inbound_nat_rules.Element = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(inbound_nat_rules.Element)

    load_balancer_backend_addresses = _schema_network_interface_ip_configuration_read.properties.load_balancer_backend_address_pools.Element.properties.load_balancer_backend_addresses
    load_balancer_backend_addresses.Element = AAZObjectType(
        flags={"read_only": True},
    )

    _element = _schema_network_interface_ip_configuration_read.properties.load_balancer_backend_address_pools.Element.properties.load_balancer_backend_addresses.Element
    _element.name = AAZStrType(
        flags={"read_only": True},
    )
    _element.properties = AAZObjectType(
        flags={"client_flatten": True, "read_only": True},
    )

    properties = _schema_network_interface_ip_configuration_read.properties.load_balancer_backend_address_pools.Element.properties.load_balancer_backend_addresses.Element.properties
    properties.admin_state = AAZStrType(
        serialized_name="adminState",
        flags={"read_only": True},
    )
    properties.inbound_nat_rules_port_mapping = AAZListType(
        serialized_name="inboundNatRulesPortMapping",
        flags={"read_only": True},
    )
    properties.ip_address = AAZStrType(
        serialized_name="ipAddress",
        flags={"read_only": True},
    )
    properties.load_balancer_frontend_ip_configuration = AAZObjectType(
        serialized_name="loadBalancerFrontendIPConfiguration",
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(properties.load_balancer_frontend_ip_configuration)
    properties.network_interface_ip_configuration = AAZObjectType(
        serialized_name="networkInterfaceIPConfiguration",
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(properties.network_interface_ip_configuration)
    properties.subnet = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(properties.subnet)
    properties.virtual_network = AAZObjectType(
        serialized_name="virtualNetwork",
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(properties.virtual_network)

    inbound_nat_rules_port_mapping = _schema_network_interface_ip_configuration_read.properties.load_balancer_backend_address_pools.Element.properties.load_balancer_backend_addresses.Element.properties.inbound_nat_rules_port_mapping
    inbound_nat_rules_port_mapping.Element = AAZObjectType(
        flags={"read_only": True},
    )

    _element = _schema_network_interface_ip_configuration_read.properties.load_balancer_backend_address_pools.Element.properties.load_balancer_backend_addresses.Element.properties.inbound_nat_rules_port_mapping.Element
    _element.backend_port = AAZIntType(
        serialized_name="backendPort",
        flags={"read_only": True},
    )
    _element.frontend_port = AAZIntType(
        serialized_name="frontendPort",
        flags={"read_only": True},
    )
    _element.inbound_nat_rule_name = AAZStrType(
        serialized_name="inboundNatRuleName",
        flags={"read_only": True},
    )

    load_balancing_rules = _schema_network_interface_ip_configuration_read.properties.load_balancer_backend_address_pools.Element.properties.load_balancing_rules
    load_balancing_rules.Element = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(load_balancing_rules.Element)

    outbound_rules = _schema_network_interface_ip_configuration_read.properties.load_balancer_backend_address_pools.Element.properties.outbound_rules
    outbound_rules.Element = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(outbound_rules.Element)

    tunnel_interfaces = _schema_network_interface_ip_configuration_read.properties.load_balancer_backend_address_pools.Element.properties.tunnel_interfaces
    tunnel_interfaces.Element = AAZObjectType(
        flags={"read_only": True},
    )

    _element = _schema_network_interface_ip_configuration_read.properties.load_balancer_backend_address_pools.Element.properties.tunnel_interfaces.Element
    _element.identifier = AAZIntType(
        flags={"read_only": True},
    )
    _element.port = AAZIntType(
        flags={"read_only": True},
    )
    _element.protocol = AAZStrType(
        flags={"read_only": True},
    )
    _element.type = AAZStrType(
        flags={"read_only": True},
    )

    load_balancer_inbound_nat_rules = _schema_network_interface_ip_configuration_read.properties.load_balancer_inbound_nat_rules
    load_balancer_inbound_nat_rules.Element = AAZObjectType(
        flags={"read_only": True},
    )

    _element = _schema_network_interface_ip_configuration_read.properties.load_balancer_inbound_nat_rules.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.id = AAZStrType(
        flags={"read_only": True},
    )
    _element.name = AAZStrType(
        flags={"read_only": True},
    )
    _element.properties = AAZObjectType(
        flags={"client_flatten": True, "read_only": True},
    )
    _element.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_network_interface_ip_configuration_read.properties.load_balancer_inbound_nat_rules.Element.properties
    properties.backend_address_pool = AAZObjectType(
        serialized_name="backendAddressPool",
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(properties.backend_address_pool)
    properties.backend_ip_configuration = AAZObjectType(
        serialized_name="backendIPConfiguration",
        flags={"read_only": True},
    )
    _build_schema_network_interface_ip_configuration_read(properties.backend_ip_configuration)
    properties.backend_port = AAZIntType(
        serialized_name="backendPort",
        flags={"read_only": True},
    )
    properties.enable_floating_ip = AAZBoolType(
        serialized_name="enableFloatingIP",
        flags={"read_only": True},
    )
    properties.enable_tcp_reset = AAZBoolType(
        serialized_name="enableTcpReset",
        flags={"read_only": True},
    )
    properties.frontend_ip_configuration = AAZObjectType(
        serialized_name="frontendIPConfiguration",
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(properties.frontend_ip_configuration)
    properties.frontend_port = AAZIntType(
        serialized_name="frontendPort",
        flags={"read_only": True},
    )
    properties.frontend_port_range_end = AAZIntType(
        serialized_name="frontendPortRangeEnd",
        flags={"read_only": True},
    )
    properties.frontend_port_range_start = AAZIntType(
        serialized_name="frontendPortRangeStart",
        flags={"read_only": True},
    )
    properties.idle_timeout_in_minutes = AAZIntType(
        serialized_name="idleTimeoutInMinutes",
        flags={"read_only": True},
    )
    properties.protocol = AAZStrType(
        flags={"read_only": True},
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )

    private_link_connection_properties = _schema_network_interface_ip_configuration_read.properties.private_link_connection_properties
    private_link_connection_properties.fqdns = AAZListType(
        flags={"read_only": True},
    )
    private_link_connection_properties.group_id = AAZStrType(
        serialized_name="groupId",
        flags={"read_only": True},
    )
    private_link_connection_properties.required_member_name = AAZStrType(
        serialized_name="requiredMemberName",
        flags={"read_only": True},
    )

    fqdns = _schema_network_interface_ip_configuration_read.properties.private_link_connection_properties.fqdns
    fqdns.Element = AAZStrType(
        flags={"read_only": True},
    )

    virtual_network_taps = _schema_network_interface_ip_configuration_read.properties.virtual_network_taps
    virtual_network_taps.Element = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_virtual_network_tap_read(virtual_network_taps.Element)

    _schema.etag = _schema_network_interface_ip_configuration_read.etag
    _schema.id = _schema_network_interface_ip_configuration_read.id
    _schema.name = _schema_network_interface_ip_configuration_read.name
    _schema.properties = _schema_network_interface_ip_configuration_read.properties
    _schema.type = _schema_network_interface_ip_configuration_read.type


_schema_network_interface_tap_configuration_read = None


def _build_schema_network_interface_tap_configuration_read(_schema):
    global _schema_network_interface_tap_configuration_read
    if _schema_network_interface_tap_configuration_read is not None:
        _schema.etag = _schema_network_interface_tap_configuration_read.etag
        _schema.id = _schema_network_interface_tap_configuration_read.id
        _schema.name = _schema_network_interface_tap_configuration_read.name
        _schema.properties = _schema_network_interface_tap_configuration_read.properties
        _schema.type = _schema_network_interface_tap_configuration_read.type
        return

    _schema_network_interface_tap_configuration_read = AAZObjectType(
        flags={"read_only": True}
    )

    network_interface_tap_configuration_read = _schema_network_interface_tap_configuration_read
    network_interface_tap_configuration_read.etag = AAZStrType(
        flags={"read_only": True},
    )
    network_interface_tap_configuration_read.id = AAZStrType(
        flags={"read_only": True},
    )
    network_interface_tap_configuration_read.name = AAZStrType(
        flags={"read_only": True},
    )
    network_interface_tap_configuration_read.properties = AAZObjectType(
        flags={"client_flatten": True, "read_only": True},
    )
    network_interface_tap_configuration_read.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_network_interface_tap_configuration_read.properties
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.virtual_network_tap = AAZObjectType(
        serialized_name="virtualNetworkTap",
        flags={"read_only": True},
    )
    _build_schema_virtual_network_tap_read(properties.virtual_network_tap)

    _schema.etag = _schema_network_interface_tap_configuration_read.etag
    _schema.id = _schema_network_interface_tap_configuration_read.id
    _schema.name = _schema_network_interface_tap_configuration_read.name
    _schema.properties = _schema_network_interface_tap_configuration_read.properties
    _schema.type = _schema_network_interface_tap_configuration_read.type


_schema_network_interface_read = None


def _build_schema_network_interface_read(_schema):
    global _schema_network_interface_read
    if _schema_network_interface_read is not None:
        _schema.etag = _schema_network_interface_read.etag
        _schema.extended_location = _schema_network_interface_read.extended_location
        _schema.id = _schema_network_interface_read.id
        _schema.location = _schema_network_interface_read.location
        _schema.name = _schema_network_interface_read.name
        _schema.properties = _schema_network_interface_read.properties
        _schema.tags = _schema_network_interface_read.tags
        _schema.type = _schema_network_interface_read.type
        return

    _schema_network_interface_read = AAZObjectType(
        flags={"read_only": True}
    )

    network_interface_read = _schema_network_interface_read
    network_interface_read.etag = AAZStrType(
        flags={"read_only": True},
    )
    network_interface_read.extended_location = AAZObjectType(
        serialized_name="extendedLocation",
        flags={"read_only": True},
    )
    _build_schema_extended_location_read(network_interface_read.extended_location)
    network_interface_read.id = AAZStrType(
        flags={"read_only": True},
    )
    network_interface_read.location = AAZStrType(
        flags={"read_only": True},
    )
    network_interface_read.name = AAZStrType(
        flags={"read_only": True},
    )
    network_interface_read.properties = AAZObjectType(
        flags={"client_flatten": True, "read_only": True},
    )
    network_interface_read.tags = AAZDictType(
        flags={"read_only": True},
    )
    network_interface_read.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_network_interface_read.properties
    properties.auxiliary_mode = AAZStrType(
        serialized_name="auxiliaryMode",
        flags={"read_only": True},
    )
    properties.disable_tcp_state_tracking = AAZBoolType(
        serialized_name="disableTcpStateTracking",
        flags={"read_only": True},
    )
    properties.dns_settings = AAZObjectType(
        serialized_name="dnsSettings",
        flags={"read_only": True},
    )
    properties.dscp_configuration = AAZObjectType(
        serialized_name="dscpConfiguration",
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(properties.dscp_configuration)
    properties.enable_accelerated_networking = AAZBoolType(
        serialized_name="enableAcceleratedNetworking",
        flags={"read_only": True},
    )
    properties.enable_ip_forwarding = AAZBoolType(
        serialized_name="enableIPForwarding",
        flags={"read_only": True},
    )
    properties.hosted_workloads = AAZListType(
        serialized_name="hostedWorkloads",
        flags={"read_only": True},
    )
    properties.ip_configurations = AAZListType(
        serialized_name="ipConfigurations",
        flags={"read_only": True},
    )
    properties.mac_address = AAZStrType(
        serialized_name="macAddress",
        flags={"read_only": True},
    )
    properties.migration_phase = AAZStrType(
        serialized_name="migrationPhase",
        flags={"read_only": True},
    )
    properties.network_security_group = AAZObjectType(
        serialized_name="networkSecurityGroup",
        flags={"read_only": True},
    )
    _build_schema_network_security_group_read(properties.network_security_group)
    properties.nic_type = AAZStrType(
        serialized_name="nicType",
        flags={"read_only": True},
    )
    properties.primary = AAZBoolType(
        flags={"read_only": True},
    )
    properties.private_endpoint = AAZObjectType(
        serialized_name="privateEndpoint",
        flags={"read_only": True},
    )
    _build_schema_private_endpoint_read(properties.private_endpoint)
    properties.private_link_service = AAZObjectType(
        serialized_name="privateLinkService",
        flags={"read_only": True},
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.resource_guid = AAZStrType(
        serialized_name="resourceGuid",
        flags={"read_only": True},
    )
    properties.tap_configurations = AAZListType(
        serialized_name="tapConfigurations",
        flags={"read_only": True},
    )
    properties.virtual_machine = AAZObjectType(
        serialized_name="virtualMachine",
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(properties.virtual_machine)
    properties.vnet_encryption_supported = AAZBoolType(
        serialized_name="vnetEncryptionSupported",
        flags={"read_only": True},
    )
    properties.workload_type = AAZStrType(
        serialized_name="workloadType",
        flags={"read_only": True},
    )

    dns_settings = _schema_network_interface_read.properties.dns_settings
    dns_settings.applied_dns_servers = AAZListType(
        serialized_name="appliedDnsServers",
        flags={"read_only": True},
    )
    dns_settings.dns_servers = AAZListType(
        serialized_name="dnsServers",
        flags={"read_only": True},
    )
    dns_settings.internal_dns_name_label = AAZStrType(
        serialized_name="internalDnsNameLabel",
        flags={"read_only": True},
    )
    dns_settings.internal_domain_name_suffix = AAZStrType(
        serialized_name="internalDomainNameSuffix",
        flags={"read_only": True},
    )
    dns_settings.internal_fqdn = AAZStrType(
        serialized_name="internalFqdn",
        flags={"read_only": True},
    )

    applied_dns_servers = _schema_network_interface_read.properties.dns_settings.applied_dns_servers
    applied_dns_servers.Element = AAZStrType(
        flags={"read_only": True},
    )

    dns_servers = _schema_network_interface_read.properties.dns_settings.dns_servers
    dns_servers.Element = AAZStrType(
        flags={"read_only": True},
    )

    hosted_workloads = _schema_network_interface_read.properties.hosted_workloads
    hosted_workloads.Element = AAZStrType(
        flags={"read_only": True},
    )

    ip_configurations = _schema_network_interface_read.properties.ip_configurations
    ip_configurations.Element = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_network_interface_ip_configuration_read(ip_configurations.Element)

    private_link_service = _schema_network_interface_read.properties.private_link_service
    private_link_service.etag = AAZStrType(
        flags={"read_only": True},
    )
    private_link_service.extended_location = AAZObjectType(
        serialized_name="extendedLocation",
        flags={"read_only": True},
    )
    _build_schema_extended_location_read(private_link_service.extended_location)
    private_link_service.id = AAZStrType(
        flags={"read_only": True},
    )
    private_link_service.location = AAZStrType(
        flags={"read_only": True},
    )
    private_link_service.name = AAZStrType(
        flags={"read_only": True},
    )
    private_link_service.properties = AAZObjectType(
        flags={"client_flatten": True, "read_only": True},
    )
    private_link_service.tags = AAZDictType(
        flags={"read_only": True},
    )
    private_link_service.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_network_interface_read.properties.private_link_service.properties
    properties.alias = AAZStrType(
        flags={"read_only": True},
    )
    properties.auto_approval = AAZObjectType(
        serialized_name="autoApproval",
        flags={"read_only": True},
    )
    properties.enable_proxy_protocol = AAZBoolType(
        serialized_name="enableProxyProtocol",
        flags={"read_only": True},
    )
    properties.fqdns = AAZListType(
        flags={"read_only": True},
    )
    properties.ip_configurations = AAZListType(
        serialized_name="ipConfigurations",
        flags={"read_only": True},
    )
    properties.load_balancer_frontend_ip_configurations = AAZListType(
        serialized_name="loadBalancerFrontendIpConfigurations",
        flags={"read_only": True},
    )
    properties.network_interfaces = AAZListType(
        serialized_name="networkInterfaces",
        flags={"read_only": True},
    )
    properties.private_endpoint_connections = AAZListType(
        serialized_name="privateEndpointConnections",
        flags={"read_only": True},
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.visibility = AAZObjectType(
        flags={"read_only": True},
    )

    auto_approval = _schema_network_interface_read.properties.private_link_service.properties.auto_approval
    auto_approval.subscriptions = AAZListType(
        flags={"read_only": True},
    )

    subscriptions = _schema_network_interface_read.properties.private_link_service.properties.auto_approval.subscriptions
    subscriptions.Element = AAZStrType(
        flags={"read_only": True},
    )

    fqdns = _schema_network_interface_read.properties.private_link_service.properties.fqdns
    fqdns.Element = AAZStrType(
        flags={"read_only": True},
    )

    ip_configurations = _schema_network_interface_read.properties.private_link_service.properties.ip_configurations
    ip_configurations.Element = AAZObjectType(
        flags={"read_only": True},
    )

    _element = _schema_network_interface_read.properties.private_link_service.properties.ip_configurations.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.id = AAZStrType(
        flags={"read_only": True},
    )
    _element.name = AAZStrType(
        flags={"read_only": True},
    )
    _element.properties = AAZObjectType(
        flags={"client_flatten": True, "read_only": True},
    )
    _element.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_network_interface_read.properties.private_link_service.properties.ip_configurations.Element.properties
    properties.primary = AAZBoolType(
        flags={"read_only": True},
    )
    properties.private_ip_address = AAZStrType(
        serialized_name="privateIPAddress",
        flags={"read_only": True},
    )
    properties.private_ip_address_version = AAZStrType(
        serialized_name="privateIPAddressVersion",
        flags={"read_only": True},
    )
    properties.private_ip_allocation_method = AAZStrType(
        serialized_name="privateIPAllocationMethod",
        flags={"read_only": True},
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.subnet = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_subnet_read(properties.subnet)

    load_balancer_frontend_ip_configurations = _schema_network_interface_read.properties.private_link_service.properties.load_balancer_frontend_ip_configurations
    load_balancer_frontend_ip_configurations.Element = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_frontend_ip_configuration_read(load_balancer_frontend_ip_configurations.Element)

    network_interfaces = _schema_network_interface_read.properties.private_link_service.properties.network_interfaces
    network_interfaces.Element = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_network_interface_read(network_interfaces.Element)

    private_endpoint_connections = _schema_network_interface_read.properties.private_link_service.properties.private_endpoint_connections
    private_endpoint_connections.Element = AAZObjectType(
        flags={"read_only": True},
    )

    _element = _schema_network_interface_read.properties.private_link_service.properties.private_endpoint_connections.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.id = AAZStrType(
        flags={"read_only": True},
    )
    _element.name = AAZStrType(
        flags={"read_only": True},
    )
    _element.properties = AAZObjectType(
        flags={"client_flatten": True, "read_only": True},
    )
    _element.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_network_interface_read.properties.private_link_service.properties.private_endpoint_connections.Element.properties
    properties.link_identifier = AAZStrType(
        serialized_name="linkIdentifier",
        flags={"read_only": True},
    )
    properties.private_endpoint = AAZObjectType(
        serialized_name="privateEndpoint",
        flags={"read_only": True},
    )
    _build_schema_private_endpoint_read(properties.private_endpoint)
    properties.private_link_service_connection_state = AAZObjectType(
        serialized_name="privateLinkServiceConnectionState",
        flags={"read_only": True},
    )
    _build_schema_private_link_service_connection_state_read(properties.private_link_service_connection_state)
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )

    visibility = _schema_network_interface_read.properties.private_link_service.properties.visibility
    visibility.subscriptions = AAZListType(
        flags={"read_only": True},
    )

    subscriptions = _schema_network_interface_read.properties.private_link_service.properties.visibility.subscriptions
    subscriptions.Element = AAZStrType(
        flags={"read_only": True},
    )

    tags = _schema_network_interface_read.properties.private_link_service.tags
    tags.Element = AAZStrType(
        flags={"read_only": True},
    )

    tap_configurations = _schema_network_interface_read.properties.tap_configurations
    tap_configurations.Element = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_network_interface_tap_configuration_read(tap_configurations.Element)

    tags = _schema_network_interface_read.tags
    tags.Element = AAZStrType(
        flags={"read_only": True},
    )

    _schema.etag = _schema_network_interface_read.etag
    _schema.extended_location = _schema_network_interface_read.extended_location
    _schema.id = _schema_network_interface_read.id
    _schema.location = _schema_network_interface_read.location
    _schema.name = _schema_network_interface_read.name
    _schema.properties = _schema_network_interface_read.properties
    _schema.tags = _schema_network_interface_read.tags
    _schema.type = _schema_network_interface_read.type


_schema_network_security_group_read = None


def _build_schema_network_security_group_read(_schema):
    global _schema_network_security_group_read
    if _schema_network_security_group_read is not None:
        _schema.etag = _schema_network_security_group_read.etag
        _schema.id = _schema_network_security_group_read.id
        _schema.location = _schema_network_security_group_read.location
        _schema.name = _schema_network_security_group_read.name
        _schema.properties = _schema_network_security_group_read.properties
        _schema.tags = _schema_network_security_group_read.tags
        _schema.type = _schema_network_security_group_read.type
        return

    _schema_network_security_group_read = AAZObjectType(
        flags={"read_only": True}
    )

    network_security_group_read = _schema_network_security_group_read
    network_security_group_read.etag = AAZStrType(
        flags={"read_only": True},
    )
    network_security_group_read.id = AAZStrType(
        flags={"read_only": True},
    )
    network_security_group_read.location = AAZStrType(
        flags={"read_only": True},
    )
    network_security_group_read.name = AAZStrType(
        flags={"read_only": True},
    )
    network_security_group_read.properties = AAZObjectType(
        flags={"client_flatten": True, "read_only": True},
    )
    network_security_group_read.tags = AAZDictType(
        flags={"read_only": True},
    )
    network_security_group_read.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_network_security_group_read.properties
    properties.default_security_rules = AAZListType(
        serialized_name="defaultSecurityRules",
        flags={"read_only": True},
    )
    properties.flow_logs = AAZListType(
        serialized_name="flowLogs",
        flags={"read_only": True},
    )
    properties.flush_connection = AAZBoolType(
        serialized_name="flushConnection",
        flags={"read_only": True},
    )
    properties.network_interfaces = AAZListType(
        serialized_name="networkInterfaces",
        flags={"read_only": True},
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.resource_guid = AAZStrType(
        serialized_name="resourceGuid",
        flags={"read_only": True},
    )
    properties.security_rules = AAZListType(
        serialized_name="securityRules",
        flags={"read_only": True},
    )
    properties.subnets = AAZListType(
        flags={"read_only": True},
    )

    default_security_rules = _schema_network_security_group_read.properties.default_security_rules
    default_security_rules.Element = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_security_rule_read(default_security_rules.Element)

    flow_logs = _schema_network_security_group_read.properties.flow_logs
    flow_logs.Element = AAZObjectType(
        flags={"read_only": True},
    )

    _element = _schema_network_security_group_read.properties.flow_logs.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.id = AAZStrType(
        flags={"read_only": True},
    )
    _element.location = AAZStrType(
        flags={"read_only": True},
    )
    _element.name = AAZStrType(
        flags={"read_only": True},
    )
    _element.properties = AAZObjectType(
        flags={"client_flatten": True, "read_only": True},
    )
    _element.tags = AAZDictType(
        flags={"read_only": True},
    )
    _element.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_network_security_group_read.properties.flow_logs.Element.properties
    properties.enabled = AAZBoolType(
        flags={"read_only": True},
    )
    properties.flow_analytics_configuration = AAZObjectType(
        serialized_name="flowAnalyticsConfiguration",
        flags={"read_only": True},
    )
    properties.format = AAZObjectType(
        flags={"read_only": True},
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.retention_policy = AAZObjectType(
        serialized_name="retentionPolicy",
        flags={"read_only": True},
    )
    properties.storage_id = AAZStrType(
        serialized_name="storageId",
        flags={"required": True, "read_only": True},
    )
    properties.target_resource_guid = AAZStrType(
        serialized_name="targetResourceGuid",
        flags={"read_only": True},
    )
    properties.target_resource_id = AAZStrType(
        serialized_name="targetResourceId",
        flags={"required": True, "read_only": True},
    )

    flow_analytics_configuration = _schema_network_security_group_read.properties.flow_logs.Element.properties.flow_analytics_configuration
    flow_analytics_configuration.network_watcher_flow_analytics_configuration = AAZObjectType(
        serialized_name="networkWatcherFlowAnalyticsConfiguration",
        flags={"read_only": True},
    )

    network_watcher_flow_analytics_configuration = _schema_network_security_group_read.properties.flow_logs.Element.properties.flow_analytics_configuration.network_watcher_flow_analytics_configuration
    network_watcher_flow_analytics_configuration.enabled = AAZBoolType(
        flags={"read_only": True},
    )
    network_watcher_flow_analytics_configuration.traffic_analytics_interval = AAZIntType(
        serialized_name="trafficAnalyticsInterval",
        flags={"read_only": True},
    )
    network_watcher_flow_analytics_configuration.workspace_id = AAZStrType(
        serialized_name="workspaceId",
        flags={"read_only": True},
    )
    network_watcher_flow_analytics_configuration.workspace_region = AAZStrType(
        serialized_name="workspaceRegion",
        flags={"read_only": True},
    )
    network_watcher_flow_analytics_configuration.workspace_resource_id = AAZStrType(
        serialized_name="workspaceResourceId",
        flags={"read_only": True},
    )

    format = _schema_network_security_group_read.properties.flow_logs.Element.properties.format
    format.type = AAZStrType(
        flags={"read_only": True},
    )
    format.version = AAZIntType(
        flags={"read_only": True},
    )

    retention_policy = _schema_network_security_group_read.properties.flow_logs.Element.properties.retention_policy
    retention_policy.days = AAZIntType(
        flags={"read_only": True},
    )
    retention_policy.enabled = AAZBoolType(
        flags={"read_only": True},
    )

    tags = _schema_network_security_group_read.properties.flow_logs.Element.tags
    tags.Element = AAZStrType(
        flags={"read_only": True},
    )

    network_interfaces = _schema_network_security_group_read.properties.network_interfaces
    network_interfaces.Element = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_network_interface_read(network_interfaces.Element)

    security_rules = _schema_network_security_group_read.properties.security_rules
    security_rules.Element = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_security_rule_read(security_rules.Element)

    subnets = _schema_network_security_group_read.properties.subnets
    subnets.Element = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_subnet_read(subnets.Element)

    tags = _schema_network_security_group_read.tags
    tags.Element = AAZStrType(
        flags={"read_only": True},
    )

    _schema.etag = _schema_network_security_group_read.etag
    _schema.id = _schema_network_security_group_read.id
    _schema.location = _schema_network_security_group_read.location
    _schema.name = _schema_network_security_group_read.name
    _schema.properties = _schema_network_security_group_read.properties
    _schema.tags = _schema_network_security_group_read.tags
    _schema.type = _schema_network_security_group_read.type


_schema_private_endpoint_read = None


def _build_schema_private_endpoint_read(_schema):
    global _schema_private_endpoint_read
    if _schema_private_endpoint_read is not None:
        _schema.etag = _schema_private_endpoint_read.etag
        _schema.extended_location = _schema_private_endpoint_read.extended_location
        _schema.id = _schema_private_endpoint_read.id
        _schema.location = _schema_private_endpoint_read.location
        _schema.name = _schema_private_endpoint_read.name
        _schema.properties = _schema_private_endpoint_read.properties
        _schema.tags = _schema_private_endpoint_read.tags
        _schema.type = _schema_private_endpoint_read.type
        return

    _schema_private_endpoint_read = AAZObjectType(
        flags={"read_only": True}
    )

    private_endpoint_read = _schema_private_endpoint_read
    private_endpoint_read.etag = AAZStrType(
        flags={"read_only": True},
    )
    private_endpoint_read.extended_location = AAZObjectType(
        serialized_name="extendedLocation",
        flags={"read_only": True},
    )
    _build_schema_extended_location_read(private_endpoint_read.extended_location)
    private_endpoint_read.id = AAZStrType(
        flags={"read_only": True},
    )
    private_endpoint_read.location = AAZStrType(
        flags={"read_only": True},
    )
    private_endpoint_read.name = AAZStrType(
        flags={"read_only": True},
    )
    private_endpoint_read.properties = AAZObjectType(
        flags={"client_flatten": True, "read_only": True},
    )
    private_endpoint_read.tags = AAZDictType(
        flags={"read_only": True},
    )
    private_endpoint_read.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_private_endpoint_read.properties
    properties.application_security_groups = AAZListType(
        serialized_name="applicationSecurityGroups",
        flags={"read_only": True},
    )
    properties.custom_dns_configs = AAZListType(
        serialized_name="customDnsConfigs",
        flags={"read_only": True},
    )
    properties.custom_network_interface_name = AAZStrType(
        serialized_name="customNetworkInterfaceName",
        flags={"read_only": True},
    )
    properties.ip_configurations = AAZListType(
        serialized_name="ipConfigurations",
        flags={"read_only": True},
    )
    properties.manual_private_link_service_connections = AAZListType(
        serialized_name="manualPrivateLinkServiceConnections",
        flags={"read_only": True},
    )
    properties.network_interfaces = AAZListType(
        serialized_name="networkInterfaces",
        flags={"read_only": True},
    )
    properties.private_link_service_connections = AAZListType(
        serialized_name="privateLinkServiceConnections",
        flags={"read_only": True},
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.subnet = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_subnet_read(properties.subnet)

    application_security_groups = _schema_private_endpoint_read.properties.application_security_groups
    application_security_groups.Element = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_application_security_group_read(application_security_groups.Element)

    custom_dns_configs = _schema_private_endpoint_read.properties.custom_dns_configs
    custom_dns_configs.Element = AAZObjectType(
        flags={"read_only": True},
    )

    _element = _schema_private_endpoint_read.properties.custom_dns_configs.Element
    _element.fqdn = AAZStrType(
        flags={"read_only": True},
    )
    _element.ip_addresses = AAZListType(
        serialized_name="ipAddresses",
        flags={"read_only": True},
    )

    ip_addresses = _schema_private_endpoint_read.properties.custom_dns_configs.Element.ip_addresses
    ip_addresses.Element = AAZStrType(
        flags={"read_only": True},
    )

    ip_configurations = _schema_private_endpoint_read.properties.ip_configurations
    ip_configurations.Element = AAZObjectType(
        flags={"read_only": True},
    )

    _element = _schema_private_endpoint_read.properties.ip_configurations.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.name = AAZStrType(
        flags={"read_only": True},
    )
    _element.properties = AAZObjectType(
        flags={"client_flatten": True, "read_only": True},
    )
    _element.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_private_endpoint_read.properties.ip_configurations.Element.properties
    properties.group_id = AAZStrType(
        serialized_name="groupId",
        flags={"read_only": True},
    )
    properties.member_name = AAZStrType(
        serialized_name="memberName",
        flags={"read_only": True},
    )
    properties.private_ip_address = AAZStrType(
        serialized_name="privateIPAddress",
        flags={"read_only": True},
    )

    manual_private_link_service_connections = _schema_private_endpoint_read.properties.manual_private_link_service_connections
    manual_private_link_service_connections.Element = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_private_link_service_connection_read(manual_private_link_service_connections.Element)

    network_interfaces = _schema_private_endpoint_read.properties.network_interfaces
    network_interfaces.Element = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_network_interface_read(network_interfaces.Element)

    private_link_service_connections = _schema_private_endpoint_read.properties.private_link_service_connections
    private_link_service_connections.Element = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_private_link_service_connection_read(private_link_service_connections.Element)

    tags = _schema_private_endpoint_read.tags
    tags.Element = AAZStrType(
        flags={"read_only": True},
    )

    _schema.etag = _schema_private_endpoint_read.etag
    _schema.extended_location = _schema_private_endpoint_read.extended_location
    _schema.id = _schema_private_endpoint_read.id
    _schema.location = _schema_private_endpoint_read.location
    _schema.name = _schema_private_endpoint_read.name
    _schema.properties = _schema_private_endpoint_read.properties
    _schema.tags = _schema_private_endpoint_read.tags
    _schema.type = _schema_private_endpoint_read.type


_schema_private_link_service_connection_state_read = None


def _build_schema_private_link_service_connection_state_read(_schema):
    global _schema_private_link_service_connection_state_read
    if _schema_private_link_service_connection_state_read is not None:
        _schema.actions_required = _schema_private_link_service_connection_state_read.actions_required
        _schema.description = _schema_private_link_service_connection_state_read.description
        _schema.status = _schema_private_link_service_connection_state_read.status
        return

    _schema_private_link_service_connection_state_read = AAZObjectType(
        flags={"read_only": True}
    )

    private_link_service_connection_state_read = _schema_private_link_service_connection_state_read
    private_link_service_connection_state_read.actions_required = AAZStrType(
        serialized_name="actionsRequired",
        flags={"read_only": True},
    )
    private_link_service_connection_state_read.description = AAZStrType(
        flags={"read_only": True},
    )
    private_link_service_connection_state_read.status = AAZStrType(
        flags={"read_only": True},
    )

    _schema.actions_required = _schema_private_link_service_connection_state_read.actions_required
    _schema.description = _schema_private_link_service_connection_state_read.description
    _schema.status = _schema_private_link_service_connection_state_read.status


_schema_private_link_service_connection_read = None


def _build_schema_private_link_service_connection_read(_schema):
    global _schema_private_link_service_connection_read
    if _schema_private_link_service_connection_read is not None:
        _schema.etag = _schema_private_link_service_connection_read.etag
        _schema.id = _schema_private_link_service_connection_read.id
        _schema.name = _schema_private_link_service_connection_read.name
        _schema.properties = _schema_private_link_service_connection_read.properties
        _schema.type = _schema_private_link_service_connection_read.type
        return

    _schema_private_link_service_connection_read = AAZObjectType(
        flags={"read_only": True}
    )

    private_link_service_connection_read = _schema_private_link_service_connection_read
    private_link_service_connection_read.etag = AAZStrType(
        flags={"read_only": True},
    )
    private_link_service_connection_read.id = AAZStrType(
        flags={"read_only": True},
    )
    private_link_service_connection_read.name = AAZStrType(
        flags={"read_only": True},
    )
    private_link_service_connection_read.properties = AAZObjectType(
        flags={"client_flatten": True, "read_only": True},
    )
    private_link_service_connection_read.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_private_link_service_connection_read.properties
    properties.group_ids = AAZListType(
        serialized_name="groupIds",
        flags={"read_only": True},
    )
    properties.private_link_service_connection_state = AAZObjectType(
        serialized_name="privateLinkServiceConnectionState",
        flags={"read_only": True},
    )
    _build_schema_private_link_service_connection_state_read(properties.private_link_service_connection_state)
    properties.private_link_service_id = AAZStrType(
        serialized_name="privateLinkServiceId",
        flags={"read_only": True},
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.request_message = AAZStrType(
        serialized_name="requestMessage",
        flags={"read_only": True},
    )

    group_ids = _schema_private_link_service_connection_read.properties.group_ids
    group_ids.Element = AAZStrType(
        flags={"read_only": True},
    )

    _schema.etag = _schema_private_link_service_connection_read.etag
    _schema.id = _schema_private_link_service_connection_read.id
    _schema.name = _schema_private_link_service_connection_read.name
    _schema.properties = _schema_private_link_service_connection_read.properties
    _schema.type = _schema_private_link_service_connection_read.type


_schema_public_ip_address_read = None


def _build_schema_public_ip_address_read(_schema):
    global _schema_public_ip_address_read
    if _schema_public_ip_address_read is not None:
        _schema.etag = _schema_public_ip_address_read.etag
        _schema.extended_location = _schema_public_ip_address_read.extended_location
        _schema.id = _schema_public_ip_address_read.id
        _schema.location = _schema_public_ip_address_read.location
        _schema.name = _schema_public_ip_address_read.name
        _schema.properties = _schema_public_ip_address_read.properties
        _schema.sku = _schema_public_ip_address_read.sku
        _schema.tags = _schema_public_ip_address_read.tags
        _schema.type = _schema_public_ip_address_read.type
        _schema.zones = _schema_public_ip_address_read.zones
        return

    _schema_public_ip_address_read = AAZObjectType(
        flags={"read_only": True}
    )

    public_ip_address_read = _schema_public_ip_address_read
    public_ip_address_read.etag = AAZStrType(
        flags={"read_only": True},
    )
    public_ip_address_read.extended_location = AAZObjectType(
        serialized_name="extendedLocation",
        flags={"read_only": True},
    )
    _build_schema_extended_location_read(public_ip_address_read.extended_location)
    public_ip_address_read.id = AAZStrType(
        flags={"read_only": True},
    )
    public_ip_address_read.location = AAZStrType(
        flags={"read_only": True},
    )
    public_ip_address_read.name = AAZStrType(
        flags={"read_only": True},
    )
    public_ip_address_read.properties = AAZObjectType(
        flags={"client_flatten": True, "read_only": True},
    )
    public_ip_address_read.sku = AAZObjectType(
        flags={"read_only": True},
    )
    public_ip_address_read.tags = AAZDictType(
        flags={"read_only": True},
    )
    public_ip_address_read.type = AAZStrType(
        flags={"read_only": True},
    )
    public_ip_address_read.zones = AAZListType(
        flags={"read_only": True},
    )

    properties = _schema_public_ip_address_read.properties
    properties.ddos_settings = AAZObjectType(
        serialized_name="ddosSettings",
        flags={"read_only": True},
    )
    properties.delete_option = AAZStrType(
        serialized_name="deleteOption",
        flags={"read_only": True},
    )
    properties.dns_settings = AAZObjectType(
        serialized_name="dnsSettings",
        flags={"read_only": True},
    )
    properties.idle_timeout_in_minutes = AAZIntType(
        serialized_name="idleTimeoutInMinutes",
        flags={"read_only": True},
    )
    properties.ip_address = AAZStrType(
        serialized_name="ipAddress",
        flags={"read_only": True},
    )
    properties.ip_configuration = AAZObjectType(
        serialized_name="ipConfiguration",
        flags={"read_only": True},
    )
    _build_schema_ip_configuration_read(properties.ip_configuration)
    properties.ip_tags = AAZListType(
        serialized_name="ipTags",
        flags={"read_only": True},
    )
    properties.linked_public_ip_address = AAZObjectType(
        serialized_name="linkedPublicIPAddress",
        flags={"read_only": True},
    )
    _build_schema_public_ip_address_read(properties.linked_public_ip_address)
    properties.migration_phase = AAZStrType(
        serialized_name="migrationPhase",
        flags={"read_only": True},
    )
    properties.nat_gateway = AAZObjectType(
        serialized_name="natGateway",
        flags={"read_only": True},
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.public_ip_address_version = AAZStrType(
        serialized_name="publicIPAddressVersion",
        flags={"read_only": True},
    )
    properties.public_ip_allocation_method = AAZStrType(
        serialized_name="publicIPAllocationMethod",
        flags={"read_only": True},
    )
    properties.public_ip_prefix = AAZObjectType(
        serialized_name="publicIPPrefix",
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(properties.public_ip_prefix)
    properties.resource_guid = AAZStrType(
        serialized_name="resourceGuid",
        flags={"read_only": True},
    )
    properties.service_public_ip_address = AAZObjectType(
        serialized_name="servicePublicIPAddress",
        flags={"read_only": True},
    )
    _build_schema_public_ip_address_read(properties.service_public_ip_address)

    ddos_settings = _schema_public_ip_address_read.properties.ddos_settings
    ddos_settings.ddos_protection_plan = AAZObjectType(
        serialized_name="ddosProtectionPlan",
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(ddos_settings.ddos_protection_plan)
    ddos_settings.protection_mode = AAZStrType(
        serialized_name="protectionMode",
        flags={"read_only": True},
    )

    dns_settings = _schema_public_ip_address_read.properties.dns_settings
    dns_settings.domain_name_label = AAZStrType(
        serialized_name="domainNameLabel",
        flags={"read_only": True},
    )
    dns_settings.fqdn = AAZStrType(
        flags={"read_only": True},
    )
    dns_settings.reverse_fqdn = AAZStrType(
        serialized_name="reverseFqdn",
        flags={"read_only": True},
    )

    ip_tags = _schema_public_ip_address_read.properties.ip_tags
    ip_tags.Element = AAZObjectType(
        flags={"read_only": True},
    )

    _element = _schema_public_ip_address_read.properties.ip_tags.Element
    _element.ip_tag_type = AAZStrType(
        serialized_name="ipTagType",
        flags={"read_only": True},
    )
    _element.tag = AAZStrType(
        flags={"read_only": True},
    )

    nat_gateway = _schema_public_ip_address_read.properties.nat_gateway
    nat_gateway.etag = AAZStrType(
        flags={"read_only": True},
    )
    nat_gateway.id = AAZStrType(
        flags={"read_only": True},
    )
    nat_gateway.location = AAZStrType(
        flags={"read_only": True},
    )
    nat_gateway.name = AAZStrType(
        flags={"read_only": True},
    )
    nat_gateway.properties = AAZObjectType(
        flags={"client_flatten": True, "read_only": True},
    )
    nat_gateway.sku = AAZObjectType(
        flags={"read_only": True},
    )
    nat_gateway.tags = AAZDictType(
        flags={"read_only": True},
    )
    nat_gateway.type = AAZStrType(
        flags={"read_only": True},
    )
    nat_gateway.zones = AAZListType(
        flags={"read_only": True},
    )

    properties = _schema_public_ip_address_read.properties.nat_gateway.properties
    properties.idle_timeout_in_minutes = AAZIntType(
        serialized_name="idleTimeoutInMinutes",
        flags={"read_only": True},
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.public_ip_addresses = AAZListType(
        serialized_name="publicIpAddresses",
        flags={"read_only": True},
    )
    properties.public_ip_prefixes = AAZListType(
        serialized_name="publicIpPrefixes",
        flags={"read_only": True},
    )
    properties.resource_guid = AAZStrType(
        serialized_name="resourceGuid",
        flags={"read_only": True},
    )
    properties.subnets = AAZListType(
        flags={"read_only": True},
    )

    public_ip_addresses = _schema_public_ip_address_read.properties.nat_gateway.properties.public_ip_addresses
    public_ip_addresses.Element = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(public_ip_addresses.Element)

    public_ip_prefixes = _schema_public_ip_address_read.properties.nat_gateway.properties.public_ip_prefixes
    public_ip_prefixes.Element = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(public_ip_prefixes.Element)

    subnets = _schema_public_ip_address_read.properties.nat_gateway.properties.subnets
    subnets.Element = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(subnets.Element)

    sku = _schema_public_ip_address_read.properties.nat_gateway.sku
    sku.name = AAZStrType(
        flags={"read_only": True},
    )

    tags = _schema_public_ip_address_read.properties.nat_gateway.tags
    tags.Element = AAZStrType(
        flags={"read_only": True},
    )

    zones = _schema_public_ip_address_read.properties.nat_gateway.zones
    zones.Element = AAZStrType(
        flags={"read_only": True},
    )

    sku = _schema_public_ip_address_read.sku
    sku.name = AAZStrType(
        flags={"read_only": True},
    )
    sku.tier = AAZStrType(
        flags={"read_only": True},
    )

    tags = _schema_public_ip_address_read.tags
    tags.Element = AAZStrType(
        flags={"read_only": True},
    )

    zones = _schema_public_ip_address_read.zones
    zones.Element = AAZStrType(
        flags={"read_only": True},
    )

    _schema.etag = _schema_public_ip_address_read.etag
    _schema.extended_location = _schema_public_ip_address_read.extended_location
    _schema.id = _schema_public_ip_address_read.id
    _schema.location = _schema_public_ip_address_read.location
    _schema.name = _schema_public_ip_address_read.name
    _schema.properties = _schema_public_ip_address_read.properties
    _schema.sku = _schema_public_ip_address_read.sku
    _schema.tags = _schema_public_ip_address_read.tags
    _schema.type = _schema_public_ip_address_read.type
    _schema.zones = _schema_public_ip_address_read.zones


_schema_security_rule_read = None


def _build_schema_security_rule_read(_schema):
    global _schema_security_rule_read
    if _schema_security_rule_read is not None:
        _schema.etag = _schema_security_rule_read.etag
        _schema.id = _schema_security_rule_read.id
        _schema.name = _schema_security_rule_read.name
        _schema.properties = _schema_security_rule_read.properties
        _schema.type = _schema_security_rule_read.type
        return

    _schema_security_rule_read = AAZObjectType(
        flags={"read_only": True}
    )

    security_rule_read = _schema_security_rule_read
    security_rule_read.etag = AAZStrType(
        flags={"read_only": True},
    )
    security_rule_read.id = AAZStrType(
        flags={"read_only": True},
    )
    security_rule_read.name = AAZStrType(
        flags={"read_only": True},
    )
    security_rule_read.properties = AAZObjectType(
        flags={"client_flatten": True, "read_only": True},
    )
    security_rule_read.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_security_rule_read.properties
    properties.access = AAZStrType(
        flags={"required": True, "read_only": True},
    )
    properties.description = AAZStrType(
        flags={"read_only": True},
    )
    properties.destination_address_prefix = AAZStrType(
        serialized_name="destinationAddressPrefix",
        flags={"read_only": True},
    )
    properties.destination_address_prefixes = AAZListType(
        serialized_name="destinationAddressPrefixes",
        flags={"read_only": True},
    )
    properties.destination_application_security_groups = AAZListType(
        serialized_name="destinationApplicationSecurityGroups",
        flags={"read_only": True},
    )
    properties.destination_port_range = AAZStrType(
        serialized_name="destinationPortRange",
        flags={"read_only": True},
    )
    properties.destination_port_ranges = AAZListType(
        serialized_name="destinationPortRanges",
        flags={"read_only": True},
    )
    properties.direction = AAZStrType(
        flags={"required": True, "read_only": True},
    )
    properties.priority = AAZIntType(
        flags={"read_only": True},
    )
    properties.protocol = AAZStrType(
        flags={"required": True, "read_only": True},
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.source_address_prefix = AAZStrType(
        serialized_name="sourceAddressPrefix",
        flags={"read_only": True},
    )
    properties.source_address_prefixes = AAZListType(
        serialized_name="sourceAddressPrefixes",
        flags={"read_only": True},
    )
    properties.source_application_security_groups = AAZListType(
        serialized_name="sourceApplicationSecurityGroups",
        flags={"read_only": True},
    )
    properties.source_port_range = AAZStrType(
        serialized_name="sourcePortRange",
        flags={"read_only": True},
    )
    properties.source_port_ranges = AAZListType(
        serialized_name="sourcePortRanges",
        flags={"read_only": True},
    )

    destination_address_prefixes = _schema_security_rule_read.properties.destination_address_prefixes
    destination_address_prefixes.Element = AAZStrType(
        flags={"read_only": True},
    )

    destination_application_security_groups = _schema_security_rule_read.properties.destination_application_security_groups
    destination_application_security_groups.Element = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_application_security_group_read(destination_application_security_groups.Element)

    destination_port_ranges = _schema_security_rule_read.properties.destination_port_ranges
    destination_port_ranges.Element = AAZStrType(
        flags={"read_only": True},
    )

    source_address_prefixes = _schema_security_rule_read.properties.source_address_prefixes
    source_address_prefixes.Element = AAZStrType(
        flags={"read_only": True},
    )

    source_application_security_groups = _schema_security_rule_read.properties.source_application_security_groups
    source_application_security_groups.Element = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_application_security_group_read(source_application_security_groups.Element)

    source_port_ranges = _schema_security_rule_read.properties.source_port_ranges
    source_port_ranges.Element = AAZStrType(
        flags={"read_only": True},
    )

    _schema.etag = _schema_security_rule_read.etag
    _schema.id = _schema_security_rule_read.id
    _schema.name = _schema_security_rule_read.name
    _schema.properties = _schema_security_rule_read.properties
    _schema.type = _schema_security_rule_read.type


_schema_sub_resource_read = None


def _build_schema_sub_resource_read(_schema):
    global _schema_sub_resource_read
    if _schema_sub_resource_read is not None:
        _schema.id = _schema_sub_resource_read.id
        return

    _schema_sub_resource_read = AAZObjectType(
        flags={"read_only": True}
    )

    sub_resource_read = _schema_sub_resource_read
    sub_resource_read.id = AAZStrType(
        flags={"read_only": True},
    )

    _schema.id = _schema_sub_resource_read.id


_schema_subnet_read = None


def _build_schema_subnet_read(_schema):
    global _schema_subnet_read
    if _schema_subnet_read is not None:
        _schema.etag = _schema_subnet_read.etag
        _schema.id = _schema_subnet_read.id
        _schema.name = _schema_subnet_read.name
        _schema.properties = _schema_subnet_read.properties
        _schema.type = _schema_subnet_read.type
        return

    _schema_subnet_read = AAZObjectType(
        flags={"read_only": True}
    )

    subnet_read = _schema_subnet_read
    subnet_read.etag = AAZStrType(
        flags={"read_only": True},
    )
    subnet_read.id = AAZStrType(
        flags={"read_only": True},
    )
    subnet_read.name = AAZStrType(
        flags={"read_only": True},
    )
    subnet_read.properties = AAZObjectType(
        flags={"client_flatten": True, "read_only": True},
    )
    subnet_read.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_subnet_read.properties
    properties.address_prefix = AAZStrType(
        serialized_name="addressPrefix",
        flags={"read_only": True},
    )
    properties.address_prefixes = AAZListType(
        serialized_name="addressPrefixes",
        flags={"read_only": True},
    )
    properties.application_gateway_ip_configurations = AAZListType(
        serialized_name="applicationGatewayIpConfigurations",
        flags={"read_only": True},
    )
    properties.delegations = AAZListType(
        flags={"read_only": True},
    )
    properties.ip_allocations = AAZListType(
        serialized_name="ipAllocations",
        flags={"read_only": True},
    )
    properties.ip_configuration_profiles = AAZListType(
        serialized_name="ipConfigurationProfiles",
        flags={"read_only": True},
    )
    properties.ip_configurations = AAZListType(
        serialized_name="ipConfigurations",
        flags={"read_only": True},
    )
    properties.nat_gateway = AAZObjectType(
        serialized_name="natGateway",
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(properties.nat_gateway)
    properties.network_security_group = AAZObjectType(
        serialized_name="networkSecurityGroup",
        flags={"read_only": True},
    )
    _build_schema_network_security_group_read(properties.network_security_group)
    properties.private_endpoint_network_policies = AAZStrType(
        serialized_name="privateEndpointNetworkPolicies",
        flags={"read_only": True},
    )
    properties.private_endpoints = AAZListType(
        serialized_name="privateEndpoints",
        flags={"read_only": True},
    )
    properties.private_link_service_network_policies = AAZStrType(
        serialized_name="privateLinkServiceNetworkPolicies",
        flags={"read_only": True},
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.purpose = AAZStrType(
        flags={"read_only": True},
    )
    properties.resource_navigation_links = AAZListType(
        serialized_name="resourceNavigationLinks",
        flags={"read_only": True},
    )
    properties.route_table = AAZObjectType(
        serialized_name="routeTable",
        flags={"read_only": True},
    )
    properties.service_association_links = AAZListType(
        serialized_name="serviceAssociationLinks",
        flags={"read_only": True},
    )
    properties.service_endpoint_policies = AAZListType(
        serialized_name="serviceEndpointPolicies",
        flags={"read_only": True},
    )
    properties.service_endpoints = AAZListType(
        serialized_name="serviceEndpoints",
        flags={"read_only": True},
    )

    address_prefixes = _schema_subnet_read.properties.address_prefixes
    address_prefixes.Element = AAZStrType(
        flags={"read_only": True},
    )

    application_gateway_ip_configurations = _schema_subnet_read.properties.application_gateway_ip_configurations
    application_gateway_ip_configurations.Element = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_application_gateway_ip_configuration_read(application_gateway_ip_configurations.Element)

    delegations = _schema_subnet_read.properties.delegations
    delegations.Element = AAZObjectType(
        flags={"read_only": True},
    )

    _element = _schema_subnet_read.properties.delegations.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.id = AAZStrType(
        flags={"read_only": True},
    )
    _element.name = AAZStrType(
        flags={"read_only": True},
    )
    _element.properties = AAZObjectType(
        flags={"client_flatten": True, "read_only": True},
    )
    _element.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_subnet_read.properties.delegations.Element.properties
    properties.actions = AAZListType(
        flags={"read_only": True},
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.service_name = AAZStrType(
        serialized_name="serviceName",
        flags={"read_only": True},
    )

    actions = _schema_subnet_read.properties.delegations.Element.properties.actions
    actions.Element = AAZStrType(
        flags={"read_only": True},
    )

    ip_allocations = _schema_subnet_read.properties.ip_allocations
    ip_allocations.Element = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(ip_allocations.Element)

    ip_configuration_profiles = _schema_subnet_read.properties.ip_configuration_profiles
    ip_configuration_profiles.Element = AAZObjectType(
        flags={"read_only": True},
    )

    _element = _schema_subnet_read.properties.ip_configuration_profiles.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.id = AAZStrType(
        flags={"read_only": True},
    )
    _element.name = AAZStrType(
        flags={"read_only": True},
    )
    _element.properties = AAZObjectType(
        flags={"client_flatten": True, "read_only": True},
    )
    _element.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_subnet_read.properties.ip_configuration_profiles.Element.properties
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.subnet = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_subnet_read(properties.subnet)

    ip_configurations = _schema_subnet_read.properties.ip_configurations
    ip_configurations.Element = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_ip_configuration_read(ip_configurations.Element)

    private_endpoints = _schema_subnet_read.properties.private_endpoints
    private_endpoints.Element = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_private_endpoint_read(private_endpoints.Element)

    resource_navigation_links = _schema_subnet_read.properties.resource_navigation_links
    resource_navigation_links.Element = AAZObjectType(
        flags={"read_only": True},
    )

    _element = _schema_subnet_read.properties.resource_navigation_links.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.id = AAZStrType(
        flags={"read_only": True},
    )
    _element.name = AAZStrType(
        flags={"read_only": True},
    )
    _element.properties = AAZObjectType(
        flags={"client_flatten": True, "read_only": True},
    )
    _element.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_subnet_read.properties.resource_navigation_links.Element.properties
    properties.link = AAZStrType(
        flags={"read_only": True},
    )
    properties.linked_resource_type = AAZStrType(
        serialized_name="linkedResourceType",
        flags={"read_only": True},
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )

    route_table = _schema_subnet_read.properties.route_table
    route_table.etag = AAZStrType(
        flags={"read_only": True},
    )
    route_table.id = AAZStrType(
        flags={"read_only": True},
    )
    route_table.location = AAZStrType(
        flags={"read_only": True},
    )
    route_table.name = AAZStrType(
        flags={"read_only": True},
    )
    route_table.properties = AAZObjectType(
        flags={"client_flatten": True, "read_only": True},
    )
    route_table.tags = AAZDictType(
        flags={"read_only": True},
    )
    route_table.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_subnet_read.properties.route_table.properties
    properties.disable_bgp_route_propagation = AAZBoolType(
        serialized_name="disableBgpRoutePropagation",
        flags={"read_only": True},
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.resource_guid = AAZStrType(
        serialized_name="resourceGuid",
        flags={"read_only": True},
    )
    properties.routes = AAZListType(
        flags={"read_only": True},
    )
    properties.subnets = AAZListType(
        flags={"read_only": True},
    )

    routes = _schema_subnet_read.properties.route_table.properties.routes
    routes.Element = AAZObjectType(
        flags={"read_only": True},
    )

    _element = _schema_subnet_read.properties.route_table.properties.routes.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.id = AAZStrType(
        flags={"read_only": True},
    )
    _element.name = AAZStrType(
        flags={"read_only": True},
    )
    _element.properties = AAZObjectType(
        flags={"client_flatten": True, "read_only": True},
    )
    _element.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_subnet_read.properties.route_table.properties.routes.Element.properties
    properties.address_prefix = AAZStrType(
        serialized_name="addressPrefix",
        flags={"read_only": True},
    )
    properties.has_bgp_override = AAZBoolType(
        serialized_name="hasBgpOverride",
        flags={"read_only": True},
    )
    properties.next_hop_ip_address = AAZStrType(
        serialized_name="nextHopIpAddress",
        flags={"read_only": True},
    )
    properties.next_hop_type = AAZStrType(
        serialized_name="nextHopType",
        flags={"required": True, "read_only": True},
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )

    subnets = _schema_subnet_read.properties.route_table.properties.subnets
    subnets.Element = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_subnet_read(subnets.Element)

    tags = _schema_subnet_read.properties.route_table.tags
    tags.Element = AAZStrType(
        flags={"read_only": True},
    )

    service_association_links = _schema_subnet_read.properties.service_association_links
    service_association_links.Element = AAZObjectType(
        flags={"read_only": True},
    )

    _element = _schema_subnet_read.properties.service_association_links.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.id = AAZStrType(
        flags={"read_only": True},
    )
    _element.name = AAZStrType(
        flags={"read_only": True},
    )
    _element.properties = AAZObjectType(
        flags={"client_flatten": True, "read_only": True},
    )
    _element.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_subnet_read.properties.service_association_links.Element.properties
    properties.allow_delete = AAZBoolType(
        serialized_name="allowDelete",
        flags={"read_only": True},
    )
    properties.link = AAZStrType(
        flags={"read_only": True},
    )
    properties.linked_resource_type = AAZStrType(
        serialized_name="linkedResourceType",
        flags={"read_only": True},
    )
    properties.locations = AAZListType(
        flags={"read_only": True},
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )

    locations = _schema_subnet_read.properties.service_association_links.Element.properties.locations
    locations.Element = AAZStrType(
        flags={"read_only": True},
    )

    service_endpoint_policies = _schema_subnet_read.properties.service_endpoint_policies
    service_endpoint_policies.Element = AAZObjectType(
        flags={"read_only": True},
    )

    _element = _schema_subnet_read.properties.service_endpoint_policies.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.id = AAZStrType(
        flags={"read_only": True},
    )
    _element.kind = AAZStrType(
        flags={"read_only": True},
    )
    _element.location = AAZStrType(
        flags={"read_only": True},
    )
    _element.name = AAZStrType(
        flags={"read_only": True},
    )
    _element.properties = AAZObjectType(
        flags={"client_flatten": True, "read_only": True},
    )
    _element.tags = AAZDictType(
        flags={"read_only": True},
    )
    _element.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_subnet_read.properties.service_endpoint_policies.Element.properties
    properties.contextual_service_endpoint_policies = AAZListType(
        serialized_name="contextualServiceEndpointPolicies",
        flags={"read_only": True},
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.resource_guid = AAZStrType(
        serialized_name="resourceGuid",
        flags={"read_only": True},
    )
    properties.service_alias = AAZStrType(
        serialized_name="serviceAlias",
        flags={"read_only": True},
    )
    properties.service_endpoint_policy_definitions = AAZListType(
        serialized_name="serviceEndpointPolicyDefinitions",
        flags={"read_only": True},
    )
    properties.subnets = AAZListType(
        flags={"read_only": True},
    )

    contextual_service_endpoint_policies = _schema_subnet_read.properties.service_endpoint_policies.Element.properties.contextual_service_endpoint_policies
    contextual_service_endpoint_policies.Element = AAZStrType(
        flags={"read_only": True},
    )

    service_endpoint_policy_definitions = _schema_subnet_read.properties.service_endpoint_policies.Element.properties.service_endpoint_policy_definitions
    service_endpoint_policy_definitions.Element = AAZObjectType(
        flags={"read_only": True},
    )

    _element = _schema_subnet_read.properties.service_endpoint_policies.Element.properties.service_endpoint_policy_definitions.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.id = AAZStrType(
        flags={"read_only": True},
    )
    _element.name = AAZStrType(
        flags={"read_only": True},
    )
    _element.properties = AAZObjectType(
        flags={"client_flatten": True, "read_only": True},
    )
    _element.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_subnet_read.properties.service_endpoint_policies.Element.properties.service_endpoint_policy_definitions.Element.properties
    properties.description = AAZStrType(
        flags={"read_only": True},
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.service = AAZStrType(
        flags={"read_only": True},
    )
    properties.service_resources = AAZListType(
        serialized_name="serviceResources",
        flags={"read_only": True},
    )

    service_resources = _schema_subnet_read.properties.service_endpoint_policies.Element.properties.service_endpoint_policy_definitions.Element.properties.service_resources
    service_resources.Element = AAZStrType(
        flags={"read_only": True},
    )

    subnets = _schema_subnet_read.properties.service_endpoint_policies.Element.properties.subnets
    subnets.Element = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_subnet_read(subnets.Element)

    tags = _schema_subnet_read.properties.service_endpoint_policies.Element.tags
    tags.Element = AAZStrType(
        flags={"read_only": True},
    )

    service_endpoints = _schema_subnet_read.properties.service_endpoints
    service_endpoints.Element = AAZObjectType(
        flags={"read_only": True},
    )

    _element = _schema_subnet_read.properties.service_endpoints.Element
    _element.locations = AAZListType(
        flags={"read_only": True},
    )
    _element.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    _element.service = AAZStrType(
        flags={"read_only": True},
    )

    locations = _schema_subnet_read.properties.service_endpoints.Element.locations
    locations.Element = AAZStrType(
        flags={"read_only": True},
    )

    _schema.etag = _schema_subnet_read.etag
    _schema.id = _schema_subnet_read.id
    _schema.name = _schema_subnet_read.name
    _schema.properties = _schema_subnet_read.properties
    _schema.type = _schema_subnet_read.type


_schema_virtual_network_tap_read = None


def _build_schema_virtual_network_tap_read(_schema):
    global _schema_virtual_network_tap_read
    if _schema_virtual_network_tap_read is not None:
        _schema.etag = _schema_virtual_network_tap_read.etag
        _schema.id = _schema_virtual_network_tap_read.id
        _schema.location = _schema_virtual_network_tap_read.location
        _schema.name = _schema_virtual_network_tap_read.name
        _schema.properties = _schema_virtual_network_tap_read.properties
        _schema.tags = _schema_virtual_network_tap_read.tags
        _schema.type = _schema_virtual_network_tap_read.type
        return

    _schema_virtual_network_tap_read = AAZObjectType(
        flags={"read_only": True}
    )

    virtual_network_tap_read = _schema_virtual_network_tap_read
    virtual_network_tap_read.etag = AAZStrType(
        flags={"read_only": True},
    )
    virtual_network_tap_read.id = AAZStrType(
        flags={"read_only": True},
    )
    virtual_network_tap_read.location = AAZStrType(
        flags={"read_only": True},
    )
    virtual_network_tap_read.name = AAZStrType(
        flags={"read_only": True},
    )
    virtual_network_tap_read.properties = AAZObjectType(
        flags={"client_flatten": True, "read_only": True},
    )
    virtual_network_tap_read.tags = AAZDictType(
        flags={"read_only": True},
    )
    virtual_network_tap_read.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_virtual_network_tap_read.properties
    properties.destination_load_balancer_front_end_ip_configuration = AAZObjectType(
        serialized_name="destinationLoadBalancerFrontEndIPConfiguration",
        flags={"read_only": True},
    )
    _build_schema_frontend_ip_configuration_read(properties.destination_load_balancer_front_end_ip_configuration)
    properties.destination_network_interface_ip_configuration = AAZObjectType(
        serialized_name="destinationNetworkInterfaceIPConfiguration",
        flags={"read_only": True},
    )
    _build_schema_network_interface_ip_configuration_read(properties.destination_network_interface_ip_configuration)
    properties.destination_port = AAZIntType(
        serialized_name="destinationPort",
        flags={"read_only": True},
    )
    properties.network_interface_tap_configurations = AAZListType(
        serialized_name="networkInterfaceTapConfigurations",
        flags={"read_only": True},
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.resource_guid = AAZStrType(
        serialized_name="resourceGuid",
        flags={"read_only": True},
    )

    network_interface_tap_configurations = _schema_virtual_network_tap_read.properties.network_interface_tap_configurations
    network_interface_tap_configurations.Element = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_network_interface_tap_configuration_read(network_interface_tap_configurations.Element)

    tags = _schema_virtual_network_tap_read.tags
    tags.Element = AAZStrType(
        flags={"read_only": True},
    )

    _schema.etag = _schema_virtual_network_tap_read.etag
    _schema.id = _schema_virtual_network_tap_read.id
    _schema.location = _schema_virtual_network_tap_read.location
    _schema.name = _schema_virtual_network_tap_read.name
    _schema.properties = _schema_virtual_network_tap_read.properties
    _schema.tags = _schema_virtual_network_tap_read.tags
    _schema.type = _schema_virtual_network_tap_read.type


_schema_web_application_firewall_policy_read = None


def _build_schema_web_application_firewall_policy_read(_schema):
    global _schema_web_application_firewall_policy_read
    if _schema_web_application_firewall_policy_read is not None:
        _schema.etag = _schema_web_application_firewall_policy_read.etag
        _schema.id = _schema_web_application_firewall_policy_read.id
        _schema.location = _schema_web_application_firewall_policy_read.location
        _schema.name = _schema_web_application_firewall_policy_read.name
        _schema.properties = _schema_web_application_firewall_policy_read.properties
        _schema.tags = _schema_web_application_firewall_policy_read.tags
        _schema.type = _schema_web_application_firewall_policy_read.type
        return

    _schema_web_application_firewall_policy_read = AAZObjectType()

    web_application_firewall_policy_read = _schema_web_application_firewall_policy_read
    web_application_firewall_policy_read.etag = AAZStrType(
        flags={"read_only": True},
    )
    web_application_firewall_policy_read.id = AAZStrType()
    web_application_firewall_policy_read.location = AAZStrType()
    web_application_firewall_policy_read.name = AAZStrType(
        flags={"read_only": True},
    )
    web_application_firewall_policy_read.properties = AAZObjectType(
        flags={"client_flatten": True},
    )
    web_application_firewall_policy_read.tags = AAZDictType()
    web_application_firewall_policy_read.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_web_application_firewall_policy_read.properties
    properties.application_gateways = AAZListType(
        serialized_name="applicationGateways",
        flags={"read_only": True},
    )
    properties.custom_rules = AAZListType(
        serialized_name="customRules",
    )
    properties.http_listeners = AAZListType(
        serialized_name="httpListeners",
        flags={"read_only": True},
    )
    properties.managed_rules = AAZObjectType(
        serialized_name="managedRules",
        flags={"required": True},
    )
    properties.path_based_rules = AAZListType(
        serialized_name="pathBasedRules",
        flags={"read_only": True},
    )
    properties.policy_settings = AAZObjectType(
        serialized_name="policySettings",
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.resource_state = AAZStrType(
        serialized_name="resourceState",
        flags={"read_only": True},
    )

    application_gateways = _schema_web_application_firewall_policy_read.properties.application_gateways
    application_gateways.Element = AAZObjectType(
        flags={"read_only": True},
    )

    _element = _schema_web_application_firewall_policy_read.properties.application_gateways.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.id = AAZStrType(
        flags={"read_only": True},
    )
    _element.identity = AAZObjectType(
        flags={"read_only": True},
    )
    _element.location = AAZStrType(
        flags={"read_only": True},
    )
    _element.name = AAZStrType(
        flags={"read_only": True},
    )
    _element.properties = AAZObjectType(
        flags={"client_flatten": True, "read_only": True},
    )
    _element.tags = AAZDictType(
        flags={"read_only": True},
    )
    _element.type = AAZStrType(
        flags={"read_only": True},
    )
    _element.zones = AAZListType(
        flags={"read_only": True},
    )

    identity = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.identity
    identity.principal_id = AAZStrType(
        serialized_name="principalId",
        flags={"read_only": True},
    )
    identity.tenant_id = AAZStrType(
        serialized_name="tenantId",
        flags={"read_only": True},
    )
    identity.type = AAZStrType(
        flags={"read_only": True},
    )
    identity.user_assigned_identities = AAZDictType(
        serialized_name="userAssignedIdentities",
        flags={"read_only": True},
    )

    user_assigned_identities = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.identity.user_assigned_identities
    user_assigned_identities.Element = AAZObjectType(
        flags={"read_only": True},
    )

    _element = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.identity.user_assigned_identities.Element
    _element.client_id = AAZStrType(
        serialized_name="clientId",
        flags={"read_only": True},
    )
    _element.principal_id = AAZStrType(
        serialized_name="principalId",
        flags={"read_only": True},
    )

    properties = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties
    properties.authentication_certificates = AAZListType(
        serialized_name="authenticationCertificates",
        flags={"read_only": True},
    )
    properties.autoscale_configuration = AAZObjectType(
        serialized_name="autoscaleConfiguration",
        flags={"read_only": True},
    )
    properties.backend_address_pools = AAZListType(
        serialized_name="backendAddressPools",
        flags={"read_only": True},
    )
    properties.backend_http_settings_collection = AAZListType(
        serialized_name="backendHttpSettingsCollection",
        flags={"read_only": True},
    )
    properties.backend_settings_collection = AAZListType(
        serialized_name="backendSettingsCollection",
        flags={"read_only": True},
    )
    properties.custom_error_configurations = AAZListType(
        serialized_name="customErrorConfigurations",
        flags={"read_only": True},
    )
    properties.enable_fips = AAZBoolType(
        serialized_name="enableFips",
        flags={"read_only": True},
    )
    properties.enable_http2 = AAZBoolType(
        serialized_name="enableHttp2",
        flags={"read_only": True},
    )
    properties.firewall_policy = AAZObjectType(
        serialized_name="firewallPolicy",
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(properties.firewall_policy)
    properties.force_firewall_policy_association = AAZBoolType(
        serialized_name="forceFirewallPolicyAssociation",
        flags={"read_only": True},
    )
    properties.frontend_ip_configurations = AAZListType(
        serialized_name="frontendIPConfigurations",
        flags={"read_only": True},
    )
    properties.frontend_ports = AAZListType(
        serialized_name="frontendPorts",
        flags={"read_only": True},
    )
    properties.gateway_ip_configurations = AAZListType(
        serialized_name="gatewayIPConfigurations",
        flags={"read_only": True},
    )
    properties.global_configuration = AAZObjectType(
        serialized_name="globalConfiguration",
        flags={"read_only": True},
    )
    properties.http_listeners = AAZListType(
        serialized_name="httpListeners",
        flags={"read_only": True},
    )
    properties.listeners = AAZListType(
        flags={"read_only": True},
    )
    properties.load_distribution_policies = AAZListType(
        serialized_name="loadDistributionPolicies",
        flags={"read_only": True},
    )
    properties.operational_state = AAZStrType(
        serialized_name="operationalState",
        flags={"read_only": True},
    )
    properties.private_endpoint_connections = AAZListType(
        serialized_name="privateEndpointConnections",
        flags={"read_only": True},
    )
    properties.private_link_configurations = AAZListType(
        serialized_name="privateLinkConfigurations",
        flags={"read_only": True},
    )
    properties.probes = AAZListType(
        flags={"read_only": True},
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.redirect_configurations = AAZListType(
        serialized_name="redirectConfigurations",
        flags={"read_only": True},
    )
    properties.request_routing_rules = AAZListType(
        serialized_name="requestRoutingRules",
        flags={"read_only": True},
    )
    properties.resource_guid = AAZStrType(
        serialized_name="resourceGuid",
        flags={"read_only": True},
    )
    properties.rewrite_rule_sets = AAZListType(
        serialized_name="rewriteRuleSets",
        flags={"read_only": True},
    )
    properties.routing_rules = AAZListType(
        serialized_name="routingRules",
        flags={"read_only": True},
    )
    properties.sku = AAZObjectType(
        flags={"read_only": True},
    )
    properties.ssl_certificates = AAZListType(
        serialized_name="sslCertificates",
        flags={"read_only": True},
    )
    properties.ssl_policy = AAZObjectType(
        serialized_name="sslPolicy",
        flags={"read_only": True},
    )
    _build_schema_application_gateway_ssl_policy_read(properties.ssl_policy)
    properties.ssl_profiles = AAZListType(
        serialized_name="sslProfiles",
        flags={"read_only": True},
    )
    properties.trusted_client_certificates = AAZListType(
        serialized_name="trustedClientCertificates",
        flags={"read_only": True},
    )
    properties.trusted_root_certificates = AAZListType(
        serialized_name="trustedRootCertificates",
        flags={"read_only": True},
    )
    properties.url_path_maps = AAZListType(
        serialized_name="urlPathMaps",
        flags={"read_only": True},
    )
    properties.web_application_firewall_configuration = AAZObjectType(
        serialized_name="webApplicationFirewallConfiguration",
        flags={"read_only": True},
    )

    authentication_certificates = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.authentication_certificates
    authentication_certificates.Element = AAZObjectType(
        flags={"read_only": True},
    )

    _element = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.authentication_certificates.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.id = AAZStrType(
        flags={"read_only": True},
    )
    _element.name = AAZStrType(
        flags={"read_only": True},
    )
    _element.properties = AAZObjectType(
        flags={"client_flatten": True, "read_only": True},
    )
    _element.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.authentication_certificates.Element.properties
    properties.data = AAZStrType(
        flags={"read_only": True},
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )

    autoscale_configuration = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.autoscale_configuration
    autoscale_configuration.max_capacity = AAZIntType(
        serialized_name="maxCapacity",
        flags={"read_only": True},
    )
    autoscale_configuration.min_capacity = AAZIntType(
        serialized_name="minCapacity",
        flags={"required": True, "read_only": True},
    )

    backend_address_pools = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.backend_address_pools
    backend_address_pools.Element = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_application_gateway_backend_address_pool_read(backend_address_pools.Element)

    backend_http_settings_collection = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.backend_http_settings_collection
    backend_http_settings_collection.Element = AAZObjectType(
        flags={"read_only": True},
    )

    _element = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.backend_http_settings_collection.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.id = AAZStrType(
        flags={"read_only": True},
    )
    _element.name = AAZStrType(
        flags={"read_only": True},
    )
    _element.properties = AAZObjectType(
        flags={"client_flatten": True, "read_only": True},
    )
    _element.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.backend_http_settings_collection.Element.properties
    properties.affinity_cookie_name = AAZStrType(
        serialized_name="affinityCookieName",
        flags={"read_only": True},
    )
    properties.authentication_certificates = AAZListType(
        serialized_name="authenticationCertificates",
        flags={"read_only": True},
    )
    properties.connection_draining = AAZObjectType(
        serialized_name="connectionDraining",
        flags={"read_only": True},
    )
    properties.cookie_based_affinity = AAZStrType(
        serialized_name="cookieBasedAffinity",
        flags={"read_only": True},
    )
    properties.host_name = AAZStrType(
        serialized_name="hostName",
        flags={"read_only": True},
    )
    properties.path = AAZStrType(
        flags={"read_only": True},
    )
    properties.pick_host_name_from_backend_address = AAZBoolType(
        serialized_name="pickHostNameFromBackendAddress",
        flags={"read_only": True},
    )
    properties.port = AAZIntType(
        flags={"read_only": True},
    )
    properties.probe = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(properties.probe)
    properties.probe_enabled = AAZBoolType(
        serialized_name="probeEnabled",
        flags={"read_only": True},
    )
    properties.protocol = AAZStrType(
        flags={"read_only": True},
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.request_timeout = AAZIntType(
        serialized_name="requestTimeout",
        flags={"read_only": True},
    )
    properties.trusted_root_certificates = AAZListType(
        serialized_name="trustedRootCertificates",
        flags={"read_only": True},
    )

    authentication_certificates = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.backend_http_settings_collection.Element.properties.authentication_certificates
    authentication_certificates.Element = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(authentication_certificates.Element)

    connection_draining = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.backend_http_settings_collection.Element.properties.connection_draining
    connection_draining.drain_timeout_in_sec = AAZIntType(
        serialized_name="drainTimeoutInSec",
        flags={"required": True, "read_only": True},
    )
    connection_draining.enabled = AAZBoolType(
        flags={"required": True, "read_only": True},
    )

    trusted_root_certificates = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.backend_http_settings_collection.Element.properties.trusted_root_certificates
    trusted_root_certificates.Element = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(trusted_root_certificates.Element)

    backend_settings_collection = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.backend_settings_collection
    backend_settings_collection.Element = AAZObjectType(
        flags={"read_only": True},
    )

    _element = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.backend_settings_collection.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.id = AAZStrType(
        flags={"read_only": True},
    )
    _element.name = AAZStrType(
        flags={"read_only": True},
    )
    _element.properties = AAZObjectType(
        flags={"client_flatten": True, "read_only": True},
    )
    _element.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.backend_settings_collection.Element.properties
    properties.host_name = AAZStrType(
        serialized_name="hostName",
        flags={"read_only": True},
    )
    properties.pick_host_name_from_backend_address = AAZBoolType(
        serialized_name="pickHostNameFromBackendAddress",
        flags={"read_only": True},
    )
    properties.port = AAZIntType(
        flags={"read_only": True},
    )
    properties.probe = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(properties.probe)
    properties.protocol = AAZStrType(
        flags={"read_only": True},
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.timeout = AAZIntType(
        flags={"read_only": True},
    )
    properties.trusted_root_certificates = AAZListType(
        serialized_name="trustedRootCertificates",
        flags={"read_only": True},
    )

    trusted_root_certificates = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.backend_settings_collection.Element.properties.trusted_root_certificates
    trusted_root_certificates.Element = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(trusted_root_certificates.Element)

    custom_error_configurations = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.custom_error_configurations
    custom_error_configurations.Element = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_application_gateway_custom_error_read(custom_error_configurations.Element)

    frontend_ip_configurations = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.frontend_ip_configurations
    frontend_ip_configurations.Element = AAZObjectType(
        flags={"read_only": True},
    )

    _element = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.frontend_ip_configurations.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.id = AAZStrType(
        flags={"read_only": True},
    )
    _element.name = AAZStrType(
        flags={"read_only": True},
    )
    _element.properties = AAZObjectType(
        flags={"client_flatten": True, "read_only": True},
    )
    _element.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.frontend_ip_configurations.Element.properties
    properties.private_ip_address = AAZStrType(
        serialized_name="privateIPAddress",
        flags={"read_only": True},
    )
    properties.private_ip_allocation_method = AAZStrType(
        serialized_name="privateIPAllocationMethod",
        flags={"read_only": True},
    )
    properties.private_link_configuration = AAZObjectType(
        serialized_name="privateLinkConfiguration",
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(properties.private_link_configuration)
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.public_ip_address = AAZObjectType(
        serialized_name="publicIPAddress",
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(properties.public_ip_address)
    properties.subnet = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(properties.subnet)

    frontend_ports = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.frontend_ports
    frontend_ports.Element = AAZObjectType(
        flags={"read_only": True},
    )

    _element = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.frontend_ports.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.id = AAZStrType(
        flags={"read_only": True},
    )
    _element.name = AAZStrType(
        flags={"read_only": True},
    )
    _element.properties = AAZObjectType(
        flags={"client_flatten": True, "read_only": True},
    )
    _element.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.frontend_ports.Element.properties
    properties.port = AAZIntType(
        flags={"read_only": True},
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )

    gateway_ip_configurations = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.gateway_ip_configurations
    gateway_ip_configurations.Element = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_application_gateway_ip_configuration_read(gateway_ip_configurations.Element)

    global_configuration = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.global_configuration
    global_configuration.enable_request_buffering = AAZBoolType(
        serialized_name="enableRequestBuffering",
        flags={"read_only": True},
    )
    global_configuration.enable_response_buffering = AAZBoolType(
        serialized_name="enableResponseBuffering",
        flags={"read_only": True},
    )

    http_listeners = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.http_listeners
    http_listeners.Element = AAZObjectType(
        flags={"read_only": True},
    )

    _element = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.http_listeners.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.id = AAZStrType(
        flags={"read_only": True},
    )
    _element.name = AAZStrType(
        flags={"read_only": True},
    )
    _element.properties = AAZObjectType(
        flags={"client_flatten": True, "read_only": True},
    )
    _element.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.http_listeners.Element.properties
    properties.custom_error_configurations = AAZListType(
        serialized_name="customErrorConfigurations",
        flags={"read_only": True},
    )
    properties.firewall_policy = AAZObjectType(
        serialized_name="firewallPolicy",
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(properties.firewall_policy)
    properties.frontend_ip_configuration = AAZObjectType(
        serialized_name="frontendIPConfiguration",
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(properties.frontend_ip_configuration)
    properties.frontend_port = AAZObjectType(
        serialized_name="frontendPort",
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(properties.frontend_port)
    properties.host_name = AAZStrType(
        serialized_name="hostName",
        flags={"read_only": True},
    )
    properties.host_names = AAZListType(
        serialized_name="hostNames",
        flags={"read_only": True},
    )
    properties.protocol = AAZStrType(
        flags={"read_only": True},
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.require_server_name_indication = AAZBoolType(
        serialized_name="requireServerNameIndication",
        flags={"read_only": True},
    )
    properties.ssl_certificate = AAZObjectType(
        serialized_name="sslCertificate",
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(properties.ssl_certificate)
    properties.ssl_profile = AAZObjectType(
        serialized_name="sslProfile",
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(properties.ssl_profile)

    custom_error_configurations = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.http_listeners.Element.properties.custom_error_configurations
    custom_error_configurations.Element = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_application_gateway_custom_error_read(custom_error_configurations.Element)

    host_names = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.http_listeners.Element.properties.host_names
    host_names.Element = AAZStrType(
        flags={"read_only": True},
    )

    listeners = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.listeners
    listeners.Element = AAZObjectType(
        flags={"read_only": True},
    )

    _element = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.listeners.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.id = AAZStrType(
        flags={"read_only": True},
    )
    _element.name = AAZStrType(
        flags={"read_only": True},
    )
    _element.properties = AAZObjectType(
        flags={"client_flatten": True, "read_only": True},
    )
    _element.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.listeners.Element.properties
    properties.frontend_ip_configuration = AAZObjectType(
        serialized_name="frontendIPConfiguration",
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(properties.frontend_ip_configuration)
    properties.frontend_port = AAZObjectType(
        serialized_name="frontendPort",
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(properties.frontend_port)
    properties.protocol = AAZStrType(
        flags={"read_only": True},
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.ssl_certificate = AAZObjectType(
        serialized_name="sslCertificate",
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(properties.ssl_certificate)
    properties.ssl_profile = AAZObjectType(
        serialized_name="sslProfile",
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(properties.ssl_profile)

    load_distribution_policies = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.load_distribution_policies
    load_distribution_policies.Element = AAZObjectType(
        flags={"read_only": True},
    )

    _element = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.load_distribution_policies.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.id = AAZStrType(
        flags={"read_only": True},
    )
    _element.name = AAZStrType(
        flags={"read_only": True},
    )
    _element.properties = AAZObjectType(
        flags={"client_flatten": True, "read_only": True},
    )
    _element.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.load_distribution_policies.Element.properties
    properties.load_distribution_algorithm = AAZStrType(
        serialized_name="loadDistributionAlgorithm",
        flags={"read_only": True},
    )
    properties.load_distribution_targets = AAZListType(
        serialized_name="loadDistributionTargets",
        flags={"read_only": True},
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )

    load_distribution_targets = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.load_distribution_policies.Element.properties.load_distribution_targets
    load_distribution_targets.Element = AAZObjectType(
        flags={"read_only": True},
    )

    _element = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.load_distribution_policies.Element.properties.load_distribution_targets.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.id = AAZStrType(
        flags={"read_only": True},
    )
    _element.name = AAZStrType(
        flags={"read_only": True},
    )
    _element.properties = AAZObjectType(
        flags={"client_flatten": True, "read_only": True},
    )
    _element.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.load_distribution_policies.Element.properties.load_distribution_targets.Element.properties
    properties.backend_address_pool = AAZObjectType(
        serialized_name="backendAddressPool",
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(properties.backend_address_pool)
    properties.weight_per_server = AAZIntType(
        serialized_name="weightPerServer",
        flags={"read_only": True},
    )

    private_endpoint_connections = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.private_endpoint_connections
    private_endpoint_connections.Element = AAZObjectType(
        flags={"read_only": True},
    )

    _element = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.private_endpoint_connections.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.id = AAZStrType(
        flags={"read_only": True},
    )
    _element.name = AAZStrType(
        flags={"read_only": True},
    )
    _element.properties = AAZObjectType(
        flags={"client_flatten": True, "read_only": True},
    )
    _element.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.private_endpoint_connections.Element.properties
    properties.link_identifier = AAZStrType(
        serialized_name="linkIdentifier",
        flags={"read_only": True},
    )
    properties.private_endpoint = AAZObjectType(
        serialized_name="privateEndpoint",
        flags={"read_only": True},
    )
    _build_schema_private_endpoint_read(properties.private_endpoint)
    properties.private_link_service_connection_state = AAZObjectType(
        serialized_name="privateLinkServiceConnectionState",
        flags={"read_only": True},
    )
    _build_schema_private_link_service_connection_state_read(properties.private_link_service_connection_state)
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )

    private_link_configurations = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.private_link_configurations
    private_link_configurations.Element = AAZObjectType(
        flags={"read_only": True},
    )

    _element = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.private_link_configurations.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.id = AAZStrType(
        flags={"read_only": True},
    )
    _element.name = AAZStrType(
        flags={"read_only": True},
    )
    _element.properties = AAZObjectType(
        flags={"client_flatten": True, "read_only": True},
    )
    _element.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.private_link_configurations.Element.properties
    properties.ip_configurations = AAZListType(
        serialized_name="ipConfigurations",
        flags={"read_only": True},
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )

    ip_configurations = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.private_link_configurations.Element.properties.ip_configurations
    ip_configurations.Element = AAZObjectType(
        flags={"read_only": True},
    )

    _element = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.private_link_configurations.Element.properties.ip_configurations.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.id = AAZStrType(
        flags={"read_only": True},
    )
    _element.name = AAZStrType(
        flags={"read_only": True},
    )
    _element.properties = AAZObjectType(
        flags={"client_flatten": True, "read_only": True},
    )
    _element.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.private_link_configurations.Element.properties.ip_configurations.Element.properties
    properties.primary = AAZBoolType(
        flags={"read_only": True},
    )
    properties.private_ip_address = AAZStrType(
        serialized_name="privateIPAddress",
        flags={"read_only": True},
    )
    properties.private_ip_allocation_method = AAZStrType(
        serialized_name="privateIPAllocationMethod",
        flags={"read_only": True},
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.subnet = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(properties.subnet)

    probes = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.probes
    probes.Element = AAZObjectType(
        flags={"read_only": True},
    )

    _element = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.probes.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.id = AAZStrType(
        flags={"read_only": True},
    )
    _element.name = AAZStrType(
        flags={"read_only": True},
    )
    _element.properties = AAZObjectType(
        flags={"client_flatten": True, "read_only": True},
    )
    _element.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.probes.Element.properties
    properties.host = AAZStrType(
        flags={"read_only": True},
    )
    properties.interval = AAZIntType(
        flags={"read_only": True},
    )
    properties.match = AAZObjectType(
        flags={"read_only": True},
    )
    properties.min_servers = AAZIntType(
        serialized_name="minServers",
        flags={"read_only": True},
    )
    properties.path = AAZStrType(
        flags={"read_only": True},
    )
    properties.pick_host_name_from_backend_http_settings = AAZBoolType(
        serialized_name="pickHostNameFromBackendHttpSettings",
        flags={"read_only": True},
    )
    properties.pick_host_name_from_backend_settings = AAZBoolType(
        serialized_name="pickHostNameFromBackendSettings",
        flags={"read_only": True},
    )
    properties.port = AAZIntType(
        flags={"read_only": True},
    )
    properties.protocol = AAZStrType(
        flags={"read_only": True},
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.timeout = AAZIntType(
        flags={"read_only": True},
    )
    properties.unhealthy_threshold = AAZIntType(
        serialized_name="unhealthyThreshold",
        flags={"read_only": True},
    )

    match = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.probes.Element.properties.match
    match.body = AAZStrType(
        flags={"read_only": True},
    )
    match.status_codes = AAZListType(
        serialized_name="statusCodes",
        flags={"read_only": True},
    )

    status_codes = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.probes.Element.properties.match.status_codes
    status_codes.Element = AAZStrType(
        flags={"read_only": True},
    )

    redirect_configurations = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.redirect_configurations
    redirect_configurations.Element = AAZObjectType(
        flags={"read_only": True},
    )

    _element = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.redirect_configurations.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.id = AAZStrType(
        flags={"read_only": True},
    )
    _element.name = AAZStrType(
        flags={"read_only": True},
    )
    _element.properties = AAZObjectType(
        flags={"client_flatten": True, "read_only": True},
    )
    _element.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.redirect_configurations.Element.properties
    properties.include_path = AAZBoolType(
        serialized_name="includePath",
        flags={"read_only": True},
    )
    properties.include_query_string = AAZBoolType(
        serialized_name="includeQueryString",
        flags={"read_only": True},
    )
    properties.path_rules = AAZListType(
        serialized_name="pathRules",
        flags={"read_only": True},
    )
    properties.redirect_type = AAZStrType(
        serialized_name="redirectType",
        flags={"read_only": True},
    )
    properties.request_routing_rules = AAZListType(
        serialized_name="requestRoutingRules",
        flags={"read_only": True},
    )
    properties.target_listener = AAZObjectType(
        serialized_name="targetListener",
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(properties.target_listener)
    properties.target_url = AAZStrType(
        serialized_name="targetUrl",
        flags={"read_only": True},
    )
    properties.url_path_maps = AAZListType(
        serialized_name="urlPathMaps",
        flags={"read_only": True},
    )

    path_rules = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.redirect_configurations.Element.properties.path_rules
    path_rules.Element = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(path_rules.Element)

    request_routing_rules = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.redirect_configurations.Element.properties.request_routing_rules
    request_routing_rules.Element = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(request_routing_rules.Element)

    url_path_maps = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.redirect_configurations.Element.properties.url_path_maps
    url_path_maps.Element = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(url_path_maps.Element)

    request_routing_rules = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.request_routing_rules
    request_routing_rules.Element = AAZObjectType(
        flags={"read_only": True},
    )

    _element = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.request_routing_rules.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.id = AAZStrType(
        flags={"read_only": True},
    )
    _element.name = AAZStrType(
        flags={"read_only": True},
    )
    _element.properties = AAZObjectType(
        flags={"client_flatten": True, "read_only": True},
    )
    _element.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.request_routing_rules.Element.properties
    properties.backend_address_pool = AAZObjectType(
        serialized_name="backendAddressPool",
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(properties.backend_address_pool)
    properties.backend_http_settings = AAZObjectType(
        serialized_name="backendHttpSettings",
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(properties.backend_http_settings)
    properties.http_listener = AAZObjectType(
        serialized_name="httpListener",
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(properties.http_listener)
    properties.load_distribution_policy = AAZObjectType(
        serialized_name="loadDistributionPolicy",
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(properties.load_distribution_policy)
    properties.priority = AAZIntType(
        flags={"read_only": True},
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.redirect_configuration = AAZObjectType(
        serialized_name="redirectConfiguration",
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(properties.redirect_configuration)
    properties.rewrite_rule_set = AAZObjectType(
        serialized_name="rewriteRuleSet",
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(properties.rewrite_rule_set)
    properties.rule_type = AAZStrType(
        serialized_name="ruleType",
        flags={"read_only": True},
    )
    properties.url_path_map = AAZObjectType(
        serialized_name="urlPathMap",
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(properties.url_path_map)

    rewrite_rule_sets = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.rewrite_rule_sets
    rewrite_rule_sets.Element = AAZObjectType(
        flags={"read_only": True},
    )

    _element = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.rewrite_rule_sets.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.id = AAZStrType(
        flags={"read_only": True},
    )
    _element.name = AAZStrType(
        flags={"read_only": True},
    )
    _element.properties = AAZObjectType(
        flags={"client_flatten": True, "read_only": True},
    )

    properties = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.rewrite_rule_sets.Element.properties
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.rewrite_rules = AAZListType(
        serialized_name="rewriteRules",
        flags={"read_only": True},
    )

    rewrite_rules = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.rewrite_rule_sets.Element.properties.rewrite_rules
    rewrite_rules.Element = AAZObjectType(
        flags={"read_only": True},
    )

    _element = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.rewrite_rule_sets.Element.properties.rewrite_rules.Element
    _element.action_set = AAZObjectType(
        serialized_name="actionSet",
        flags={"read_only": True},
    )
    _element.conditions = AAZListType(
        flags={"read_only": True},
    )
    _element.name = AAZStrType(
        flags={"read_only": True},
    )
    _element.rule_sequence = AAZIntType(
        serialized_name="ruleSequence",
        flags={"read_only": True},
    )

    action_set = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.rewrite_rule_sets.Element.properties.rewrite_rules.Element.action_set
    action_set.request_header_configurations = AAZListType(
        serialized_name="requestHeaderConfigurations",
        flags={"read_only": True},
    )
    action_set.response_header_configurations = AAZListType(
        serialized_name="responseHeaderConfigurations",
        flags={"read_only": True},
    )
    action_set.url_configuration = AAZObjectType(
        serialized_name="urlConfiguration",
        flags={"read_only": True},
    )

    request_header_configurations = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.rewrite_rule_sets.Element.properties.rewrite_rules.Element.action_set.request_header_configurations
    request_header_configurations.Element = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_application_gateway_header_configuration_read(request_header_configurations.Element)

    response_header_configurations = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.rewrite_rule_sets.Element.properties.rewrite_rules.Element.action_set.response_header_configurations
    response_header_configurations.Element = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_application_gateway_header_configuration_read(response_header_configurations.Element)

    url_configuration = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.rewrite_rule_sets.Element.properties.rewrite_rules.Element.action_set.url_configuration
    url_configuration.modified_path = AAZStrType(
        serialized_name="modifiedPath",
        flags={"read_only": True},
    )
    url_configuration.modified_query_string = AAZStrType(
        serialized_name="modifiedQueryString",
        flags={"read_only": True},
    )
    url_configuration.reroute = AAZBoolType(
        flags={"read_only": True},
    )

    conditions = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.rewrite_rule_sets.Element.properties.rewrite_rules.Element.conditions
    conditions.Element = AAZObjectType(
        flags={"read_only": True},
    )

    _element = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.rewrite_rule_sets.Element.properties.rewrite_rules.Element.conditions.Element
    _element.ignore_case = AAZBoolType(
        serialized_name="ignoreCase",
        flags={"read_only": True},
    )
    _element.negate = AAZBoolType(
        flags={"read_only": True},
    )
    _element.pattern = AAZStrType(
        flags={"read_only": True},
    )
    _element.variable = AAZStrType(
        flags={"read_only": True},
    )

    routing_rules = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.routing_rules
    routing_rules.Element = AAZObjectType(
        flags={"read_only": True},
    )

    _element = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.routing_rules.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.id = AAZStrType(
        flags={"read_only": True},
    )
    _element.name = AAZStrType(
        flags={"read_only": True},
    )
    _element.properties = AAZObjectType(
        flags={"client_flatten": True, "read_only": True},
    )
    _element.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.routing_rules.Element.properties
    properties.backend_address_pool = AAZObjectType(
        serialized_name="backendAddressPool",
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(properties.backend_address_pool)
    properties.backend_settings = AAZObjectType(
        serialized_name="backendSettings",
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(properties.backend_settings)
    properties.listener = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(properties.listener)
    properties.priority = AAZIntType(
        flags={"required": True, "read_only": True},
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.rule_type = AAZStrType(
        serialized_name="ruleType",
        flags={"read_only": True},
    )

    sku = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.sku
    sku.capacity = AAZIntType(
        flags={"read_only": True},
    )
    sku.name = AAZStrType(
        flags={"read_only": True},
    )
    sku.tier = AAZStrType(
        flags={"read_only": True},
    )

    ssl_certificates = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.ssl_certificates
    ssl_certificates.Element = AAZObjectType(
        flags={"read_only": True},
    )

    _element = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.ssl_certificates.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.id = AAZStrType(
        flags={"read_only": True},
    )
    _element.name = AAZStrType(
        flags={"read_only": True},
    )
    _element.properties = AAZObjectType(
        flags={"client_flatten": True, "read_only": True},
    )
    _element.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.ssl_certificates.Element.properties
    properties.data = AAZStrType(
        flags={"read_only": True},
    )
    properties.key_vault_secret_id = AAZStrType(
        serialized_name="keyVaultSecretId",
        flags={"read_only": True},
    )
    properties.password = AAZStrType(
        flags={"read_only": True},
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.public_cert_data = AAZStrType(
        serialized_name="publicCertData",
        flags={"read_only": True},
    )

    ssl_profiles = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.ssl_profiles
    ssl_profiles.Element = AAZObjectType(
        flags={"read_only": True},
    )

    _element = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.ssl_profiles.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.id = AAZStrType(
        flags={"read_only": True},
    )
    _element.name = AAZStrType(
        flags={"read_only": True},
    )
    _element.properties = AAZObjectType(
        flags={"client_flatten": True, "read_only": True},
    )
    _element.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.ssl_profiles.Element.properties
    properties.client_auth_configuration = AAZObjectType(
        serialized_name="clientAuthConfiguration",
        flags={"read_only": True},
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.ssl_policy = AAZObjectType(
        serialized_name="sslPolicy",
        flags={"read_only": True},
    )
    _build_schema_application_gateway_ssl_policy_read(properties.ssl_policy)
    properties.trusted_client_certificates = AAZListType(
        serialized_name="trustedClientCertificates",
        flags={"read_only": True},
    )

    client_auth_configuration = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.ssl_profiles.Element.properties.client_auth_configuration
    client_auth_configuration.verify_client_cert_issuer_dn = AAZBoolType(
        serialized_name="verifyClientCertIssuerDN",
        flags={"read_only": True},
    )
    client_auth_configuration.verify_client_revocation = AAZStrType(
        serialized_name="verifyClientRevocation",
        flags={"read_only": True},
    )

    trusted_client_certificates = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.ssl_profiles.Element.properties.trusted_client_certificates
    trusted_client_certificates.Element = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(trusted_client_certificates.Element)

    trusted_client_certificates = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.trusted_client_certificates
    trusted_client_certificates.Element = AAZObjectType(
        flags={"read_only": True},
    )

    _element = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.trusted_client_certificates.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.id = AAZStrType(
        flags={"read_only": True},
    )
    _element.name = AAZStrType(
        flags={"read_only": True},
    )
    _element.properties = AAZObjectType(
        flags={"client_flatten": True, "read_only": True},
    )
    _element.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.trusted_client_certificates.Element.properties
    properties.client_cert_issuer_dn = AAZStrType(
        serialized_name="clientCertIssuerDN",
        flags={"read_only": True},
    )
    properties.data = AAZStrType(
        flags={"read_only": True},
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.validated_cert_data = AAZStrType(
        serialized_name="validatedCertData",
        flags={"read_only": True},
    )

    trusted_root_certificates = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.trusted_root_certificates
    trusted_root_certificates.Element = AAZObjectType(
        flags={"read_only": True},
    )

    _element = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.trusted_root_certificates.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.id = AAZStrType(
        flags={"read_only": True},
    )
    _element.name = AAZStrType(
        flags={"read_only": True},
    )
    _element.properties = AAZObjectType(
        flags={"client_flatten": True, "read_only": True},
    )
    _element.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.trusted_root_certificates.Element.properties
    properties.data = AAZStrType(
        flags={"read_only": True},
    )
    properties.key_vault_secret_id = AAZStrType(
        serialized_name="keyVaultSecretId",
        flags={"read_only": True},
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )

    url_path_maps = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.url_path_maps
    url_path_maps.Element = AAZObjectType(
        flags={"read_only": True},
    )

    _element = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.url_path_maps.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.id = AAZStrType(
        flags={"read_only": True},
    )
    _element.name = AAZStrType(
        flags={"read_only": True},
    )
    _element.properties = AAZObjectType(
        flags={"client_flatten": True, "read_only": True},
    )
    _element.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.url_path_maps.Element.properties
    properties.default_backend_address_pool = AAZObjectType(
        serialized_name="defaultBackendAddressPool",
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(properties.default_backend_address_pool)
    properties.default_backend_http_settings = AAZObjectType(
        serialized_name="defaultBackendHttpSettings",
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(properties.default_backend_http_settings)
    properties.default_load_distribution_policy = AAZObjectType(
        serialized_name="defaultLoadDistributionPolicy",
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(properties.default_load_distribution_policy)
    properties.default_redirect_configuration = AAZObjectType(
        serialized_name="defaultRedirectConfiguration",
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(properties.default_redirect_configuration)
    properties.default_rewrite_rule_set = AAZObjectType(
        serialized_name="defaultRewriteRuleSet",
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(properties.default_rewrite_rule_set)
    properties.path_rules = AAZListType(
        serialized_name="pathRules",
        flags={"read_only": True},
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )

    path_rules = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.url_path_maps.Element.properties.path_rules
    path_rules.Element = AAZObjectType(
        flags={"read_only": True},
    )

    _element = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.url_path_maps.Element.properties.path_rules.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.id = AAZStrType(
        flags={"read_only": True},
    )
    _element.name = AAZStrType(
        flags={"read_only": True},
    )
    _element.properties = AAZObjectType(
        flags={"client_flatten": True, "read_only": True},
    )
    _element.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.url_path_maps.Element.properties.path_rules.Element.properties
    properties.backend_address_pool = AAZObjectType(
        serialized_name="backendAddressPool",
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(properties.backend_address_pool)
    properties.backend_http_settings = AAZObjectType(
        serialized_name="backendHttpSettings",
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(properties.backend_http_settings)
    properties.firewall_policy = AAZObjectType(
        serialized_name="firewallPolicy",
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(properties.firewall_policy)
    properties.load_distribution_policy = AAZObjectType(
        serialized_name="loadDistributionPolicy",
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(properties.load_distribution_policy)
    properties.paths = AAZListType(
        flags={"read_only": True},
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.redirect_configuration = AAZObjectType(
        serialized_name="redirectConfiguration",
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(properties.redirect_configuration)
    properties.rewrite_rule_set = AAZObjectType(
        serialized_name="rewriteRuleSet",
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(properties.rewrite_rule_set)

    paths = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.url_path_maps.Element.properties.path_rules.Element.properties.paths
    paths.Element = AAZStrType(
        flags={"read_only": True},
    )

    web_application_firewall_configuration = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.web_application_firewall_configuration
    web_application_firewall_configuration.disabled_rule_groups = AAZListType(
        serialized_name="disabledRuleGroups",
        flags={"read_only": True},
    )
    web_application_firewall_configuration.enabled = AAZBoolType(
        flags={"required": True, "read_only": True},
    )
    web_application_firewall_configuration.exclusions = AAZListType(
        flags={"read_only": True},
    )
    web_application_firewall_configuration.file_upload_limit_in_mb = AAZIntType(
        serialized_name="fileUploadLimitInMb",
        flags={"read_only": True},
    )
    web_application_firewall_configuration.firewall_mode = AAZStrType(
        serialized_name="firewallMode",
        flags={"required": True, "read_only": True},
    )
    web_application_firewall_configuration.max_request_body_size = AAZIntType(
        serialized_name="maxRequestBodySize",
        flags={"read_only": True},
    )
    web_application_firewall_configuration.max_request_body_size_in_kb = AAZIntType(
        serialized_name="maxRequestBodySizeInKb",
        flags={"read_only": True},
    )
    web_application_firewall_configuration.request_body_check = AAZBoolType(
        serialized_name="requestBodyCheck",
        flags={"read_only": True},
    )
    web_application_firewall_configuration.rule_set_type = AAZStrType(
        serialized_name="ruleSetType",
        flags={"required": True, "read_only": True},
    )
    web_application_firewall_configuration.rule_set_version = AAZStrType(
        serialized_name="ruleSetVersion",
        flags={"required": True, "read_only": True},
    )

    disabled_rule_groups = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.web_application_firewall_configuration.disabled_rule_groups
    disabled_rule_groups.Element = AAZObjectType(
        flags={"read_only": True},
    )

    _element = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.web_application_firewall_configuration.disabled_rule_groups.Element
    _element.rule_group_name = AAZStrType(
        serialized_name="ruleGroupName",
        flags={"required": True, "read_only": True},
    )
    _element.rules = AAZListType(
        flags={"read_only": True},
    )

    rules = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.web_application_firewall_configuration.disabled_rule_groups.Element.rules
    rules.Element = AAZIntType(
        flags={"read_only": True},
    )

    exclusions = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.web_application_firewall_configuration.exclusions
    exclusions.Element = AAZObjectType(
        flags={"read_only": True},
    )

    _element = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.properties.web_application_firewall_configuration.exclusions.Element
    _element.match_variable = AAZStrType(
        serialized_name="matchVariable",
        flags={"required": True, "read_only": True},
    )
    _element.selector = AAZStrType(
        flags={"required": True, "read_only": True},
    )
    _element.selector_match_operator = AAZStrType(
        serialized_name="selectorMatchOperator",
        flags={"required": True, "read_only": True},
    )

    tags = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.tags
    tags.Element = AAZStrType(
        flags={"read_only": True},
    )

    zones = _schema_web_application_firewall_policy_read.properties.application_gateways.Element.zones
    zones.Element = AAZStrType(
        flags={"read_only": True},
    )

    custom_rules = _schema_web_application_firewall_policy_read.properties.custom_rules
    custom_rules.Element = AAZObjectType()

    _element = _schema_web_application_firewall_policy_read.properties.custom_rules.Element
    _element.action = AAZStrType(
        flags={"required": True},
    )
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.match_conditions = AAZListType(
        serialized_name="matchConditions",
        flags={"required": True},
    )
    _element.name = AAZStrType()
    _element.priority = AAZIntType(
        flags={"required": True},
    )
    _element.rule_type = AAZStrType(
        serialized_name="ruleType",
        flags={"required": True},
    )

    match_conditions = _schema_web_application_firewall_policy_read.properties.custom_rules.Element.match_conditions
    match_conditions.Element = AAZObjectType()

    _element = _schema_web_application_firewall_policy_read.properties.custom_rules.Element.match_conditions.Element
    _element.match_values = AAZListType(
        serialized_name="matchValues",
        flags={"required": True},
    )
    _element.match_variables = AAZListType(
        serialized_name="matchVariables",
        flags={"required": True},
    )
    _element.negation_condition = AAZBoolType(
        serialized_name="negationCondition",
    )
    _element.operator = AAZStrType(
        flags={"required": True},
    )
    _element.transforms = AAZListType()

    match_values = _schema_web_application_firewall_policy_read.properties.custom_rules.Element.match_conditions.Element.match_values
    match_values.Element = AAZStrType()

    match_variables = _schema_web_application_firewall_policy_read.properties.custom_rules.Element.match_conditions.Element.match_variables
    match_variables.Element = AAZObjectType()

    _element = _schema_web_application_firewall_policy_read.properties.custom_rules.Element.match_conditions.Element.match_variables.Element
    _element.selector = AAZStrType()
    _element.variable_name = AAZStrType(
        serialized_name="variableName",
        flags={"required": True},
    )

    transforms = _schema_web_application_firewall_policy_read.properties.custom_rules.Element.match_conditions.Element.transforms
    transforms.Element = AAZStrType()

    http_listeners = _schema_web_application_firewall_policy_read.properties.http_listeners
    http_listeners.Element = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(http_listeners.Element)

    managed_rules = _schema_web_application_firewall_policy_read.properties.managed_rules
    managed_rules.exclusions = AAZListType()
    managed_rules.managed_rule_sets = AAZListType(
        serialized_name="managedRuleSets",
        flags={"required": True},
    )

    exclusions = _schema_web_application_firewall_policy_read.properties.managed_rules.exclusions
    exclusions.Element = AAZObjectType()

    _element = _schema_web_application_firewall_policy_read.properties.managed_rules.exclusions.Element
    _element.exclusion_managed_rule_sets = AAZListType(
        serialized_name="exclusionManagedRuleSets",
    )
    _element.match_variable = AAZStrType(
        serialized_name="matchVariable",
        flags={"required": True},
    )
    _element.selector = AAZStrType(
        flags={"required": True},
    )
    _element.selector_match_operator = AAZStrType(
        serialized_name="selectorMatchOperator",
        flags={"required": True},
    )

    exclusion_managed_rule_sets = _schema_web_application_firewall_policy_read.properties.managed_rules.exclusions.Element.exclusion_managed_rule_sets
    exclusion_managed_rule_sets.Element = AAZObjectType()

    _element = _schema_web_application_firewall_policy_read.properties.managed_rules.exclusions.Element.exclusion_managed_rule_sets.Element
    _element.rule_groups = AAZListType(
        serialized_name="ruleGroups",
    )
    _element.rule_set_type = AAZStrType(
        serialized_name="ruleSetType",
        flags={"required": True},
    )
    _element.rule_set_version = AAZStrType(
        serialized_name="ruleSetVersion",
        flags={"required": True},
    )

    rule_groups = _schema_web_application_firewall_policy_read.properties.managed_rules.exclusions.Element.exclusion_managed_rule_sets.Element.rule_groups
    rule_groups.Element = AAZObjectType()

    _element = _schema_web_application_firewall_policy_read.properties.managed_rules.exclusions.Element.exclusion_managed_rule_sets.Element.rule_groups.Element
    _element.rule_group_name = AAZStrType(
        serialized_name="ruleGroupName",
        flags={"required": True},
    )
    _element.rules = AAZListType()

    rules = _schema_web_application_firewall_policy_read.properties.managed_rules.exclusions.Element.exclusion_managed_rule_sets.Element.rule_groups.Element.rules
    rules.Element = AAZObjectType()

    _element = _schema_web_application_firewall_policy_read.properties.managed_rules.exclusions.Element.exclusion_managed_rule_sets.Element.rule_groups.Element.rules.Element
    _element.rule_id = AAZStrType(
        serialized_name="ruleId",
        flags={"required": True},
    )

    managed_rule_sets = _schema_web_application_firewall_policy_read.properties.managed_rules.managed_rule_sets
    managed_rule_sets.Element = AAZObjectType()

    _element = _schema_web_application_firewall_policy_read.properties.managed_rules.managed_rule_sets.Element
    _element.rule_group_overrides = AAZListType(
        serialized_name="ruleGroupOverrides",
    )
    _element.rule_set_type = AAZStrType(
        serialized_name="ruleSetType",
        flags={"required": True},
    )
    _element.rule_set_version = AAZStrType(
        serialized_name="ruleSetVersion",
        flags={"required": True},
    )

    rule_group_overrides = _schema_web_application_firewall_policy_read.properties.managed_rules.managed_rule_sets.Element.rule_group_overrides
    rule_group_overrides.Element = AAZObjectType()

    _element = _schema_web_application_firewall_policy_read.properties.managed_rules.managed_rule_sets.Element.rule_group_overrides.Element
    _element.rule_group_name = AAZStrType(
        serialized_name="ruleGroupName",
        flags={"required": True},
    )
    _element.rules = AAZListType()

    rules = _schema_web_application_firewall_policy_read.properties.managed_rules.managed_rule_sets.Element.rule_group_overrides.Element.rules
    rules.Element = AAZObjectType()

    _element = _schema_web_application_firewall_policy_read.properties.managed_rules.managed_rule_sets.Element.rule_group_overrides.Element.rules.Element
    _element.action = AAZStrType()
    _element.rule_id = AAZStrType(
        serialized_name="ruleId",
        flags={"required": True},
    )
    _element.state = AAZStrType()

    path_based_rules = _schema_web_application_firewall_policy_read.properties.path_based_rules
    path_based_rules.Element = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(path_based_rules.Element)

    policy_settings = _schema_web_application_firewall_policy_read.properties.policy_settings
    policy_settings.file_upload_limit_in_mb = AAZIntType(
        serialized_name="fileUploadLimitInMb",
    )
    policy_settings.max_request_body_size_in_kb = AAZIntType(
        serialized_name="maxRequestBodySizeInKb",
    )
    policy_settings.mode = AAZStrType()
    policy_settings.request_body_check = AAZBoolType(
        serialized_name="requestBodyCheck",
    )
    policy_settings.state = AAZStrType()

    tags = _schema_web_application_firewall_policy_read.tags
    tags.Element = AAZStrType()

    _schema.etag = _schema_web_application_firewall_policy_read.etag
    _schema.id = _schema_web_application_firewall_policy_read.id
    _schema.location = _schema_web_application_firewall_policy_read.location
    _schema.name = _schema_web_application_firewall_policy_read.name
    _schema.properties = _schema_web_application_firewall_policy_read.properties
    _schema.tags = _schema_web_application_firewall_policy_read.tags
    _schema.type = _schema_web_application_firewall_policy_read.type


__all__ = ["Update"]
