------------------------------------------------------------------------------
--                                                                          --
--                 ASIS-for-GNAT IMPLEMENTATION COMPONENTS                  --
--                                                                          --
--                                                                          --
--     A S I S . A D A _ E N V I R O N M E N T S . C O N T A I N E R S      --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--            Copyright (c) 1995-1999, Free Software Foundation, Inc.       --
--                                                                          --
-- ASIS-for-GNAT is free software; you can redistribute it and/or modify it --
-- under terms of the  GNU General Public License  as published by the Free --
-- Software Foundation;  either version 2,  or  (at your option)  any later --
-- version. ASIS-for-GNAT is distributed  in the hope  that it will be use- --
-- ful, but WITHOUT ANY WARRANTY; without even the implied warranty of MER- --
-- CHANTABILITY or  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General  --
-- Public License for more details. You should have received a copy of the  --
-- GNU General Public License  distributed with ASIS-for-GNAT; see file     --
-- COPYING. If not, write to the Free Software Foundation,  59 Temple Place --
-- - Suite 330,  Boston, MA 02111-1307, USA.                                --
--                                                                          --
-- As a special exception,  if other files  instantiate  generics from this --
-- unit, or you link  this unit with other files  to produce an executable, --
-- this  unit  does not  by itself cause  the resulting  executable  to  be --
-- covered  by the  GNU  General  Public  License.  This exception does not --
-- however invalidate  any other reasons why  the executable file  might be --
-- covered by the  GNU Public License.                                      --
--                                                                          --
-- ASIS-for-GNAT was originally developed  by the ASIS-for-GNAT team at the --
-- Software  Engineering  Laboratory  of  the Swiss  Federal  Institute  of --
-- Technology (LGL-EPFL) in Lausanne,  Switzerland, in cooperation with the --
-- Scientific  Research  Computer  Center of  Moscow State University (SRCC --
-- MSU), Russia,  with funding partially provided  by grants from the Swiss --
-- National  Science  Foundation  and  the  Swiss  Academy  of  Engineering --
-- Sciences.  ASIS-for-GNAT is now maintained by  Ada Core Technologies Inc --
-- (http://www.gnat.com).                                                   --
--                                                                          --
------------------------------------------------------------------------------

with Asis.Exceptions; use Asis.Exceptions;

with A4G.Vcheck; use A4G.Vcheck;

package body Asis.Ada_Environments.Containers is

   Nil_Container_List : Container_List (1 .. 0) := (others => Nil_Container);

------------------------------------------------------------------------------
--  NOT IMPLEMENTED

   function Defining_Containers (The_Context : in Asis.Context)
      return Container_List
   is
   begin

      Not_Implemented_Yet (Diagnosis =>
        "Asis.Ada_Environments.Containers.Defining_Containers");
      --  ASIS_Failed is raised, Not_Implemented_Error status is setted

      return Nil_Container_List; -- to make the code syntactically correct

   exception
      when ASIS_Failed =>
         Add_Call_Information (Outer_Call =>
            "Asis.Ada_Environments.Containers.Defining_Containers");
         raise;
      when others =>
         Raise_ASIS_Failed (Diagnosis =>
            "Asis.Ada_Environments.Containers.Defining_Containers");
   end Defining_Containers;
-----------------------------------------------------------------------------
--  NOT IMPLEMENTED

   function Enclosing_Context (The_Container : in Container)
      return Asis.Context
   is
   begin

      Not_Implemented_Yet (Diagnosis =>
        "Asis.Ada_Environments.Containers.Enclosing_Context");
      --  ASIS_Failed is raised, Not_Implemented_Error status is setted

      return Nil_Context; -- to make the code syntactically correct

   exception
      when ASIS_Failed =>
         Add_Call_Information (Outer_Call =>
           "Asis.Ada_Environments.Containers.Enclosing_Context");
         raise;
      when others =>
         Raise_ASIS_Failed (Diagnosis =>
           "Asis.Ada_Environments.Containers.Enclosing_Context");
   end Enclosing_Context;
-----------------------------------------------------------------------------
--  NOT IMPLEMENTED

   function Library_Unit_Declarations (The_Container : in Container)
      return Asis.Compilation_Unit_List
   is
   begin

      Not_Implemented_Yet (Diagnosis =>
        "Asis.Ada_Environments.Containers.Library_Unit_Declarations");
      --  ASIS_Failed is raised, Not_Implemented_Error status is setted

      return Nil_Compilation_Unit_List;
      --  to make the code syntactically correct

   exception
      when ASIS_Failed =>
         Add_Call_Information (Outer_Call =>
          "Asis.Ada_Environments.Containers.Library_Unit_Declarations");
         raise;
      when others =>
         Raise_ASIS_Failed (Diagnosis =>
           "Asis.Ada_Environments.Containers.Library_Unit_Declarations");
   end Library_Unit_Declarations;
-----------------------------------------------------------------------------
--  NOT IMPLEMENTED

   function Compilation_Unit_Bodies (The_Container : in Container)
      return Asis.Compilation_Unit_List
   is
   begin

      Not_Implemented_Yet (Diagnosis =>
        "Asis.Ada_Environments.Containers.Compilation_Unit_Bodies");
      --  ASIS_Failed is raised, Not_Implemented_Error status is setted

      return Nil_Compilation_Unit_List;
      --  to make the code syntactically correct

   exception
      when ASIS_Failed =>
         Add_Call_Information (Outer_Call =>
           "Asis.Ada_Environments.Containers.Compilation_Unit_Bodies");
         raise;
      when others =>
         Raise_ASIS_Failed (Diagnosis =>
           "Asis.Ada_Environments.Containers.Compilation_Unit_Bodies");
   end Compilation_Unit_Bodies;
-----------------------------------------------------------------------------
--  NOT IMPLEMENTED

   function Compilation_Units (The_Container : in Container)
      return Asis.Compilation_Unit_List
   is
   begin

      Not_Implemented_Yet (Diagnosis =>
        "Asis.Ada_Environments.Containers.Compilation_Units");
      --  ASIS_Failed is raised, Not_Implemented_Error status is setted

      return Nil_Compilation_Unit_List;
      --  to make the code syntactically correct

   exception
      when ASIS_Failed =>
         Add_Call_Information (Outer_Call =>
           "Asis.Ada_Environments.Containers.Compilation_Units");
         raise;
      when others =>
         Raise_ASIS_Failed (Diagnosis =>
           "Asis.Ada_Environments.Containers.Compilation_Units");
   end Compilation_Units;
-----------------------------------------------------------------------------
--  NOT IMPLEMENTED

   function Is_Equal (Left  : in Container;
                      Right : in Container) return Boolean
   is
   begin

      Not_Implemented_Yet (Diagnosis =>
        "Asis.Ada_Environments.Containers.Is_Equal");
      --  ASIS_Failed is raised, Not_Implemented_Error status is setted

      return False; -- to make the code syntactically correct

   exception
      when ASIS_Failed =>
         Add_Call_Information (Outer_Call =>
           "Asis.Ada_Environments.Containers.Is_Equal");
         raise;
      when others =>
         Raise_ASIS_Failed (Diagnosis =>
           "Asis.Ada_Environments.Containers.Is_Equal");
   end Is_Equal;
-----------------------------------------------------------------------------
--  NOT IMPLEMENTED

   function Is_Identical (Left  : in Container;
                          Right : in Container) return Boolean
   is
   begin

      Not_Implemented_Yet (Diagnosis =>
        "Asis.Ada_Environments.Containers.Is_Identical");
      --  ASIS_Failed is raised, Not_Implemented_Error status is setted

      return False; -- to make the code syntactically correct

   exception
      when ASIS_Failed =>
         Add_Call_Information (Outer_Call =>
            "Asis.Ada_Environments.Containers.Is_Identical");
         raise;
      when others =>
         Raise_ASIS_Failed (Diagnosis =>
           "Asis.Ada_Environments.Containers.Is_Identical");
   end Is_Identical;
-----------------------------------------------------------------------------
--  NOT IMPLEMENTED
   function Name (The_Container : in Container) return Wide_String is
   begin

      Not_Implemented_Yet (Diagnosis =>
        "Asis.Ada_Environments.Containers.Name");
      --  ASIS_Failed is raised, Not_Implemented_Error status is setted

      return Nil_Asis_Wide_String; -- to make the code syntactically correct

   exception
      when ASIS_Failed =>
         Add_Call_Information (Outer_Call =>
            "Asis.Ada_Environments.Containers.Name");
         raise;
      when others =>
         Raise_ASIS_Failed (Diagnosis =>
           "Asis.Ada_Environments.Containers.Name");
   end Name;
-----------------------------------------------------------------------------
end Asis.Ada_Environments.Containers;