#include <unistd.h>
#include <sys/stat.h>

#include <source-default.h>
#include <asd.h>
#include <sample-convert.h>

#include "source-socket.h"

static gboolean _source_socket_open(Source *s)
{
  SourceDefaultPrivate *p;
  g_assert(s);
  g_assert(p = (SourceDefaultPrivate*) s->private_data);
  g_assert(s->mode == SOURCE_DISABLED);

  if (!sample_type_equal(&s->sample_type, &default_sample_type))
    {
      p->buffer_size = sample_convert_length(&default_sample_type, &s->sample_type, default_block_size, FALSE);
      p->buffer = g_new(guint8, p->buffer_size);
    }

  source_set_mode(s, p->is_open ? SOURCE_RUNNING : SOURCE_DISABLED);

  return p->is_open;
}

static gboolean _source_socket_reopen(Source *s)
{
  g_assert(s);
  if (s->close)
    s->close(s);

  return FALSE;
}

Source* source_socket_new(gchar *shortname, gchar *name, int fd, SampleType *sample_type)
{
  Source *s;
  SourceDefaultPrivate *p;
  char _name[ASD_NAME_LENGTH];

  if (!name || !*name)
    {
      g_snprintf(_name, sizeof(_name), "Socket %i", fd);
      name = _name;
    }

  g_assert(s = source_new(shortname, name, FALSE));

  g_assert(s->private_data = p = source_default_alloc_private(NULL));
  p->is_open = TRUE;
  p->fd = fd;

  s->type = "SOCKET";
  s->open = _source_socket_open;
  s->reopen = _source_socket_reopen;

  s->sample_type = *sample_type;

  s->flags |= SOURCE_AUTOCLEAN;

  return s;
}
