#include <unistd.h>
#include <sys/stat.h>

#include <sink-default.h>
#include <asd.h>
#include <sample-convert.h>

#include "sink-socket.h"

static gboolean _sink_socket_open(Sink *s)
{
  SinkDefaultPrivate *p;
  g_assert(s);
  g_assert(p = (SinkDefaultPrivate *) s->private_data);
 
  if (!sample_type_equal(&s->sample_type, &default_sample_type))
    {
      p->buffer_size = sample_convert_length(&default_sample_type, &s->sample_type, default_block_size, FALSE);
      p->buffer = g_new(guint8, p->buffer_size);
    }

  sink_set_mode(s, p->is_open ? SINK_RUNNING : SINK_DISABLED);
  s->byte_counter_since_open = 0;

  return p->is_open;
}

static gboolean _sink_socket_reopen(Sink *s)
{
  g_assert(s);
  if (s->close)
    s->close(s);

  return FALSE;
}

Sink* sink_socket_new(gchar *shortname, gchar *name, int fd, SampleType *sample_type)
{
  Sink *s;
  SinkDefaultPrivate *p;
  char _name[ASD_NAME_LENGTH];

  if (!name || !*name)
    {
      g_snprintf(_name, sizeof(_name), "Socket %i", fd);
      name = _name;
    }

  g_assert(s = sink_new(shortname, name, FALSE));

  g_assert(s->private_data = p = sink_default_alloc_private(NULL));
  p->is_open = TRUE;
  p->fd = fd;

  s->type = "SOCKET";
  s->open = _sink_socket_open;
  s->reopen = _sink_socket_reopen;

  s->sample_type = *sample_type;

  s->flags |= SINK_AUTOCLEAN;

  return s;
}
