#include <byte-counter.h>

void byte_counter_reset(ByteCounter *b)
{
  g_assert(b);
  memset(b, 0, sizeof(ByteCounter));
}

static void _inc(ByteCounter *b, OriginId id, guint size)
{
  g_assert(b && (id.id < ORIGIN_MAX));

  if (id.instance == b->instance[id.id])
    b->counter[id.id] += size;
  else if (id.instance > b->instance[id.id])
    {
      b->counter[id.id] = size;
      b->instance[id.id] = id.instance;
    }
}

void byte_counter_process(ByteCounter *b, Block *block)
{
  OriginId id;
  g_assert(b && block);

  for (id.id = 0; id.id < ORIGIN_MAX; id.id++)
    if (block->origin.enabled[id.id])
      {
        id.instance = block->origin.instance[id.id];
        _inc(b, id, block->size);
      }
}

guint byte_counter_get(ByteCounter *b, OriginId id)
{
  g_assert(b && (id.id < ORIGIN_MAX));
  
  if (b->instance[id.id] == id.instance)
    return b->counter[id.id];

  return 0;
}
