#include "sample-type.h"

void sample_type_to_le(SampleType *t)
{
  g_assert(t);
  t->rate = GUINT32_TO_LE(t->rate);
}

void sample_type_from_le(SampleType *t)
{
  g_assert(t);
  t->rate = GUINT32_FROM_LE(t->rate);
}


void sample_type_to_string(SampleType *t, gchar *s, guint l)
{
  g_assert(t && s && l);
  g_snprintf(s, l, "PCM, %u channel%s, %u bit, %s, %s%u Hz",
	     t->channels,
	     t->channels > 1 ? "s" : "",
	     t->bits,
	     t->sign ? "signed" : "unsigned",
             t->bits > 8 ? (t->be ? "BE, " : "LE, ") : "",
	     t->rate);
}

gboolean sample_type_valid(SampleType *t)
{
  g_assert(t);
  return t->channels && t->bits && t->rate;
}
