#!/usr/bin/python
# -*- coding: iso-8859-15 -*-
######################################################
##
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published
#  by the Free Software Foundation; version 2 only.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
##
######################################################
## 
#  Project: AptOnCd
#  File: configDownload.py
#  Author: Alfredo Jr. <junix>
#  Creation: 18/11/2006
#  Changed: 20/11/2006
#  Purpose: Config Class
##
######################################################
import config
from xml.dom import minidom
FILE = config.XML_CONTENTS

def load_config(file):
    _xml = minidom.parse(file)
    xml_distros = _xml.getElementsByTagName("distro")
    distros = []
    for distro in xml_distros:
        distros.append({
        'name': distro.getElementsByTagName("name")[0].firstChild.nodeValue,
        'urls': [x.firstChild.nodeValue for x in distro.getElementsByTagName("url")],
        'archs': [x.firstChild.nodeValue for x in distro.getElementsByTagName("arch")],
        'versions': [x.firstChild.nodeValue for x in distro.getElementsByTagName("version")],
        'methods': [x.firstChild.nodeValue for x in distro.getElementsByTagName("method")],
        'sections': [x.firstChild.nodeValue for x in distro.getElementsByTagName("section")],
        'media': [x.firstChild.nodeValue for x in distro.getElementsByTagName("media")]
        })
    return distros

distros = load_config(FILE)
