#
# Copyright (C) 2007 Chris Halls <halls@debian.org>
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of version 2.1 of the GNU Lesser General Public
# License as published by the Free Software Foundation.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""Unit test for clients.py"""

import exceptions

from twisted.trial import unittest
from twisted.internet import reactor
from twisted.web import http

from apt_proxy.clients import HttpRequestClient
from apt_proxy.misc import log

class DummyFileType:
    contype = None

class DummyCacheEntry:
    filetype = DummyFileType()

class DummyBackend:
    base = 'dummy'
    uris = ['dummy']
    def get_cache_entry(self, path):
        return DummyCacheEntry()

class DummyFactory:
    def getBackend(self, name):
        return DummyBackend()

class DummyChannel:
    factory = DummyFactory()
    transport = None

class testRequests(unittest.TestCase):
    def setUp(self):
        self.req = HttpRequestClient(DummyChannel(), None)
    def testSimplifyPath(self):
        self.assertEquals(self.req.clean_path('/foo/bar/../baz'), '/foo/baz')
    def testRemoveHost(self):
        self.assertEquals(self.req.clean_path('http://test:1234/foo/bar'), '/foo/bar')

def dummyFinishCode(responseCode, message=None):
        global FinishCode
        log.debug("finishCode: %s, %s" % (responseCode, message))
        FinishCode = responseCode

class testErrors(unittest.TestCase):
    def setUp(self):
        global FinishCode
        self.req = HttpRequestClient(DummyChannel(), None)
        self.req.finishCode = dummyFinishCode # Hijack finishCode
        self.req.method = 'GET'
        FinishCode = None
    def testInvalidChars(self):
        global FinishCode
        for c in '!' '"' '*' '\n' '\0' '\001':
            log.debug("testing invalid character [%s]" % (c))
            self.req.uri = 'http://host/backend/test' + c + 'ing'
            self.req.process()
            self.assertEquals(FinishCode, http.FORBIDDEN)
    def testValidRequests(self):
        global FinishCode
        for uri in [
                        'http://aptproxy:9999/debian/dists/testing/main/binary-i386/Packages.gz',
                        'http://aptproxy:9999/debian/dists/testing/main/x/../binary-i386/Packages.gz',
                        'http://aptproxy:9999/debian/pool/main/i/imagemagick/libmagick++9c2a_6.2.4.5.dfsg1-0.13_i386.deb',
                        'http://aptproxy:9999/debian/pool/main/u/utf8-migration-tool/utf8-migration-tool_0.4.3_all.deb'
                        ]:
            log.debug("testing valid uri [%s]" % (uri))
            self.req.uri = uri
            try:
                self.req.process()
            except exceptions.AttributeError, e:
                log.debug("AttributeError exception caught - URI was validated")
            self.assertEquals(FinishCode, None)
            