/* ====================================================================
 * Copyright (c) 1995 The Apache Group.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by the Apache Group
 *    for use in the Apache HTTP server project (http://www.apache.org/)."
 *
 * 4. The names "Apache Server" and "Apache Group" must not be used to
 *    endorse or promote products derived from this software without
 *    prior written permission.
 *
 * 5. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by the Apache Group
 *    for use in the Apache HTTP server project (http://www.apache.org/)."
 *
 * THIS SOFTWARE IS PROVIDED BY THE APACHE GROUP ``AS IS'' AND ANY
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE APACHE GROUP OR
 * IT'S CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Group and was originally based
 * on public domain software written at the National Center for
 * Supercomputing Applications, University of Illinois, Urbana-Champaign.
 * For more information on the Apache Group and the Apache HTTP server
 * project, please see <http://www.apache.org/>.
 *
 */

/*
 * mod_qs2ssi.c
 * version 1.1
 * status advance beta
 * Pass query string variables to CGI/SSI scripts.
 * eg. ?Content=&Size=10  is the same as inserting
 *              <!--#set var="QAContent" value="1" -->
 *              <!--#set var="QASize" value="10" -->
 * at the start of a server side include document.
 *
 * This module should be placed so that it gets the query before the
 * server side include module does. ie. after ssi module in
 * module configuration file.
 * 
 * Marc A. Boschma <marcb@werj.com.au> 961001
 *
 * Change log:
 * 961107 Added @ boolean support. Use @letters up until &
 * 961001 initial version.
 */

#include "httpd.h"
#include "http_config.h"

#define DEFAULT_ARGUEMENT       "1"

module qs2ssi_module;

static
int qa2vars(request_rec *r)
{
    table *e = r->subprocess_env;
    table *vars = ap_make_table(r->pool, 10);
    char *start;
    char *tail;
    char *tmp;
    char *name;
    char *ident;
    char *value;
    int loop, i;

    if (!r->args)
        return DECLINED;        /* no QUERY_STRING ? */

    if ((start = ap_pstrdup(r->pool, r->args)) == NULL)
             return DECLINED;

    for (loop = 1, tail = start; loop; tail++) {
        loop = *tail != '\0';   /* remember loop termination */
        if (*tail == '&' || *tail == '\0') {
            name = start;
            *tail = '\0';       /* terminate argument */
            start = tail + 1;   /* get ready for next iteration */

            if (!*name)
                continue;       /* trailing & or && in QUERYSTRING */

            /* name is now either "var_name" or "var_name=value" or
               "@letters" or "@letters=value" */
            if ((value = strchr(name, '=')) == NULL)
                value = DEFAULT_ARGUEMENT;
            else {
                *value = '\0';  /* terminate name */
                value++;
            }

            /* remove '$' and spaces from name */
            for (tmp = name; *tmp;)
                if (isspace(*tmp) || *tmp == '$')
                    memmove(tmp, tmp + 1, strlen(tmp));
                else
                    tmp++;

            if (!*name || strcmp(name, "@") == 0)
                continue;       /* empty name. ie '=fred' */

            if ((tmp = ap_pstrdup(r->pool, name)) == NULL)
                     return DECLINED;

            if (*name == '@') {
                i = strlen(++name);
                tmp[0] = *name++;
                tmp[1] = '\0';
            }
            else
                i = 1;          /* once for non-@ names */
            for (; i--; tmp[0] = *name++) {
                /* prefix "QA" to name to avoid security issues */
                if ((ident = ap_pstrcat(r->pool, "QA", tmp, NULL)) == NULL)
                         return DECLINED;

                /* add to request environment */
                ap_table_set(vars, ident, value);
            }
        }
    }

    r->subprocess_env = ap_overlay_tables(r->pool, e, vars);

    return OK;
}

module qs2ssi_module =
{
    STANDARD_MODULE_STUFF,
    NULL,                       /* initializer */
    NULL,                       /* dir config creater */
    NULL,                       /* dir merger --- default is to override */
    NULL,                       /* server config */
    NULL,                       /* merge server configs */
    NULL,                       /* command table */
    NULL,                       /* handlers */
    NULL,                       /* filename translation */
    NULL,                       /* check_user_id */
    NULL,                       /* check auth */
    NULL,                       /* check access */
    NULL,                       /* type_checker */
    qa2vars,                    /* fixups */
    NULL,                       /* logger */
    NULL,                       /* header parse */
    NULL,                       /* child_init */
    NULL,                       /* child_exit */
    NULL                        /* post read-request */
};
