/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.codegen;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import org.antlr.v4.Tool;
import org.antlr.v4.codegen.OutputModelController;
import org.antlr.v4.codegen.OutputModelWalker;
import org.antlr.v4.codegen.ParserFactory;
import org.antlr.v4.codegen.Target;
import org.antlr.v4.codegen.model.OutputModelObject;
import org.antlr.v4.runtime.misc.NotNull;
import org.antlr.v4.runtime.misc.Nullable;
import org.antlr.v4.tool.ErrorType;
import org.antlr.v4.tool.Grammar;
import org.stringtemplate.v4.AutoIndentWriter;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;

public class CodeGenerator {
    public static final String TEMPLATE_ROOT = "org/antlr/v4/tool/templates/codegen";
    public static final String VOCAB_FILE_EXTENSION = ".tokens";
    public static final String DEFAULT_LANGUAGE = "Java";
    public static final String vocabFilePattern = "<tokens.keys:{t | <t>=<tokens.(t)>\n}><literals.keys:{t | <t>=<literals.(t)>\n}>";
    @NotNull
    public final Grammar g;
    @NotNull
    public final Tool tool;
    @NotNull
    public final String language;
    private Target target;
    public int lineWidth = 72;

    public CodeGenerator(@NotNull Grammar g) {
        this(g.tool, g, g.getOptionString("language"));
    }

    public CodeGenerator(@NotNull Tool tool, @NotNull Grammar g, String language) {
        this.g = g;
        this.tool = tool;
        this.language = language != null ? language : DEFAULT_LANGUAGE;
    }

    @Nullable
    public Target getTarget() {
        if (this.target == null) {
            this.loadLanguageTarget(this.language);
        }
        return this.target;
    }

    @Nullable
    public STGroup getTemplates() {
        Target target = this.getTarget();
        if (target == null) {
            return null;
        }
        return target.getTemplates();
    }

    protected void loadLanguageTarget(String language) {
        String targetName = "org.antlr.v4.codegen." + language + "Target";
        try {
            Class<Target> c = Class.forName(targetName).asSubclass(Target.class);
            Constructor<Target> ctor = c.getConstructor(CodeGenerator.class);
            this.target = ctor.newInstance(this);
        }
        catch (ClassNotFoundException cnfe) {
            this.tool.errMgr.toolError(ErrorType.CANNOT_CREATE_TARGET_GENERATOR, cnfe, targetName);
        }
        catch (NoSuchMethodException nsme) {
            this.tool.errMgr.toolError(ErrorType.CANNOT_CREATE_TARGET_GENERATOR, nsme, targetName);
        }
        catch (InvocationTargetException ite) {
            this.tool.errMgr.toolError(ErrorType.CANNOT_CREATE_TARGET_GENERATOR, ite, targetName);
        }
        catch (InstantiationException ie) {
            this.tool.errMgr.toolError(ErrorType.CANNOT_CREATE_TARGET_GENERATOR, ie, targetName);
        }
        catch (IllegalAccessException cnfe) {
            this.tool.errMgr.toolError(ErrorType.CANNOT_CREATE_TARGET_GENERATOR, cnfe, targetName);
        }
    }

    private OutputModelController createController() {
        ParserFactory factory = new ParserFactory(this);
        OutputModelController controller = new OutputModelController(factory);
        factory.setController(controller);
        return controller;
    }

    private ST walk(OutputModelObject outputModel) {
        Target target = this.getTarget();
        if (target == null) {
            throw new UnsupportedOperationException("Cannot generate code without a target.");
        }
        OutputModelWalker walker = new OutputModelWalker(this.tool, target.getTemplates());
        return walker.walk(outputModel);
    }

    public ST generateLexer() {
        return this.walk(this.createController().buildLexerOutputModel());
    }

    public ST generateParser() {
        return this.walk(this.createController().buildParserOutputModel());
    }

    public ST generateListener() {
        return this.walk(this.createController().buildListenerOutputModel());
    }

    public ST generateBaseListener() {
        return this.walk(this.createController().buildBaseListenerOutputModel());
    }

    public ST generateVisitor() {
        return this.walk(this.createController().buildVisitorOutputModel());
    }

    public ST generateBaseVisitor() {
        return this.walk(this.createController().buildBaseVisitorOutputModel());
    }

    ST getTokenVocabOutput() {
        ST vocabFileST = new ST(vocabFilePattern);
        HashMap<String, Integer> tokens = new HashMap<String, Integer>();
        for (String t : this.g.tokenNameToTypeMap.keySet()) {
            int tokenType = this.g.tokenNameToTypeMap.get(t);
            if (tokenType < 1) continue;
            tokens.put(t, tokenType);
        }
        vocabFileST.add("tokens", tokens);
        HashMap<String, Integer> literals = new HashMap<String, Integer>();
        for (String literal : this.g.stringLiteralToTypeMap.keySet()) {
            int tokenType = this.g.stringLiteralToTypeMap.get(literal);
            if (tokenType < 1) continue;
            literals.put(literal, tokenType);
        }
        vocabFileST.add("literals", literals);
        return vocabFileST;
    }

    public void writeRecognizer(ST outputFileST) {
        Target target = this.getTarget();
        if (target == null) {
            throw new UnsupportedOperationException("Cannot generate code without a target.");
        }
        target.genFile(this.g, outputFileST, this.getRecognizerFileName());
    }

    public void writeListener(ST outputFileST) {
        Target target = this.getTarget();
        if (target == null) {
            throw new UnsupportedOperationException("Cannot generate code without a target.");
        }
        target.genFile(this.g, outputFileST, this.getListenerFileName());
    }

    public void writeBaseListener(ST outputFileST) {
        Target target = this.getTarget();
        if (target == null) {
            throw new UnsupportedOperationException("Cannot generate code without a target.");
        }
        target.genFile(this.g, outputFileST, this.getBaseListenerFileName());
    }

    public void writeVisitor(ST outputFileST) {
        Target target = this.getTarget();
        if (target == null) {
            throw new UnsupportedOperationException("Cannot generate code without a target.");
        }
        target.genFile(this.g, outputFileST, this.getVisitorFileName());
    }

    public void writeBaseVisitor(ST outputFileST) {
        Target target = this.getTarget();
        if (target == null) {
            throw new UnsupportedOperationException("Cannot generate code without a target.");
        }
        target.genFile(this.g, outputFileST, this.getBaseVisitorFileName());
    }

    public void writeHeaderFile() {
        Target target = this.getTarget();
        if (target == null) {
            throw new UnsupportedOperationException("Cannot generate code without a target.");
        }
        String fileName = this.getHeaderFileName();
        if (fileName == null) {
            return;
        }
        if (target.getTemplates().isDefined("headerFile")) {
            ST extST = target.getTemplates().getInstanceOf("headerFileExtension");
            ST headerFileST = null;
            target.genRecognizerHeaderFile(this.g, headerFileST, extST.render(this.lineWidth));
        }
    }

    public void writeVocabFile() {
        Target target = this.getTarget();
        if (target == null) {
            throw new UnsupportedOperationException("Cannot generate code without a target.");
        }
        ST tokenVocabSerialization = this.getTokenVocabOutput();
        String fileName = this.getVocabFileName();
        if (fileName != null) {
            target.genFile(this.g, tokenVocabSerialization, fileName);
        }
    }

    public void write(ST code, String fileName) {
        try {
            long start = System.currentTimeMillis();
            Writer w = this.tool.getOutputFileWriter(this.g, fileName);
            AutoIndentWriter wr = new AutoIndentWriter(w);
            wr.setLineWidth(this.lineWidth);
            code.write(wr);
            w.close();
            long stop = System.currentTimeMillis();
        }
        catch (IOException ioe) {
            this.tool.errMgr.toolError(ErrorType.CANNOT_WRITE_FILE, ioe, fileName);
        }
    }

    public String getRecognizerFileName() {
        Target target = this.getTarget();
        if (target == null) {
            throw new UnsupportedOperationException("Cannot generate code without a target.");
        }
        ST extST = target.getTemplates().getInstanceOf("codeFileExtension");
        String recognizerName = this.g.getRecognizerName();
        return recognizerName + extST.render();
    }

    public String getListenerFileName() {
        Target target = this.getTarget();
        if (target == null) {
            throw new UnsupportedOperationException("Cannot generate code without a target.");
        }
        assert (this.g.name != null);
        ST extST = target.getTemplates().getInstanceOf("codeFileExtension");
        String listenerName = this.g.name + "Listener";
        return listenerName + extST.render();
    }

    public String getVisitorFileName() {
        Target target = this.getTarget();
        if (target == null) {
            throw new UnsupportedOperationException("Cannot generate code without a target.");
        }
        assert (this.g.name != null);
        ST extST = target.getTemplates().getInstanceOf("codeFileExtension");
        String listenerName = this.g.name + "Visitor";
        return listenerName + extST.render();
    }

    public String getBaseListenerFileName() {
        Target target = this.getTarget();
        if (target == null) {
            throw new UnsupportedOperationException("Cannot generate code without a target.");
        }
        assert (this.g.name != null);
        ST extST = target.getTemplates().getInstanceOf("codeFileExtension");
        String listenerName = this.g.name + "BaseListener";
        return listenerName + extST.render();
    }

    public String getBaseVisitorFileName() {
        Target target = this.getTarget();
        if (target == null) {
            throw new UnsupportedOperationException("Cannot generate code without a target.");
        }
        assert (this.g.name != null);
        ST extST = target.getTemplates().getInstanceOf("codeFileExtension");
        String listenerName = this.g.name + "BaseVisitor";
        return listenerName + extST.render();
    }

    public String getVocabFileName() {
        return this.g.name + VOCAB_FILE_EXTENSION;
    }

    public String getHeaderFileName() {
        Target target = this.getTarget();
        if (target == null) {
            throw new UnsupportedOperationException("Cannot generate code without a target.");
        }
        ST extST = target.getTemplates().getInstanceOf("headerFileExtension");
        if (extST == null) {
            return null;
        }
        String recognizerName = this.g.getRecognizerName();
        return recognizerName + extST.render();
    }
}

