(in-package "ACL2")

(include-book "fl2") ;or could use floor?
(local (include-book "fp2"))
(local (include-book "predicate"))
(local (include-book "unary-divide"))
(local (include-book "../../../ordinals/ordinals-without-arithmetic"))
(include-book "../../../ordinals/e0-ordinal")

;old version
;(defun power2p (x)
 ; (equal x (expt 2 (expo x))))

(defun power2p-measure (x)
;  (declare (xargs :guard (and (real/rationalp x) (not (equal x 0)))))
  (cond ((or (not (rationalp x))
             (<= x 0)) 0)
	((< x 1) (o+ (omega) (fl (/ x)))) ; changed for v2-8 from (cons 1 (fl (/ x))))
	(t (fl x))))

(defun power2p (x)
  (declare (xargs; :guard (real/rationalp x)
                  :measure (power2p-measure x)))
  (cond ((or (not (rationalp x))
             (<= x 0))
         nil)
        ((< x 1) (power2p (* 2 x)))
        ((<= 2 x) (power2p (* 1/2 x)))
        ((equal x 1) t)
        (t nil) ;got a number in the doubly-open interval (1,2)
        ))

(in-theory (disable power2p))

;also in power2-syntaxp
(defun power2-syntaxp (term)
  (if (not (consp term))
      nil
    (case (car term)
      (quote (and (rationalp (cadr term)) 
                  (power2p (cadr term))))
      (expt (equal (cadr term) '(quote 2))) ;allow the base to be any power of 2?
      (binary-* (and (power2-syntaxp (cadr term))
                     (power2-syntaxp (caddr term))))
      (binary-/ (and (power2-syntaxp (cadr term))
                     (power2-syntaxp (caddr term))))
      (unary-/ (power2-syntaxp (cadr term))))))

#|
(power2-syntaxp ''2)
(power2-syntaxp '(expt 2 i))
(power2-syntaxp '(unary-/ (expt 2 i)))
(power2-syntaxp '(binary-/ (expt 2 i) (expt 2 j)))
(power2-syntaxp '(binary-* (expt 2 i) (expt 2 j)))
(power2-syntaxp '(BINARY-* '2

                           (BINARY-* (EXPT '2 J)
                                     (EXPT '2
                                           k))))

(power2-syntaxp '(BINARY-* '2
                      (BINARY-* (EXPT '2 J)
                                (EXPT '2
                                      (BINARY-+ K (BINARY-* '-1 J))))))

|#

(in-theory (disable power2-syntaxp))






;induction?
(defthm power2p-with-arg-between-one-and-two
  (IMPLIES (AND (< 1/2 X)
                (< X 1)
                )
           (NOT (POWER2P x)))
  :hints (("Goal" :in-theory  (enable power2p)))
  )

(in-theory (disable power2p-with-arg-between-one-and-two))

(defthm power2p-of-non-rational
  (implies (not (rationalp x))
           (equal (power2p x)
                 nil))
  :hints (("Goal" :in-theory (enable power2p))))

;induction
(defthm power2p-/
  (equal (power2p (/ x))
         (power2p x))
  :otf-flg t
  :hints (("Goal" :in-theory (enable power2p
                                     power2p-with-arg-between-one-and-two))))


;three inductions?
(defthm power2p-prod
  (implies (and (power2p x)
                (power2p y))
           (power2p (* x y)))
  :hints (("Goal" :in-theory (enable power2p
                                     power2p-with-arg-between-one-and-two)))
  )


(defthm power2p-prod-not
  (implies (and (not (power2p x))
                (power2p y))
           (not (power2p (* x y))))
   :hints (("Goal" :in-theory (disable power2p-prod)
            :use (:instance power2p-prod (x (* x y)) (y (/ y))))))

(in-theory (disable power2p-prod power2p-prod-not))

(defthm power2p-shift
  (implies (and (syntaxp (power2-syntaxp x))
                (case-split (power2p x)) ;this should be true if the syntaxp hyp is satisfied
                )
           (equal (power2p (* x y))
                  (power2p y)))
  :hints (("Goal"
           :use ((:instance power2p-prod-not (y x) (x y))
                 (:instance power2p-prod (y x) (x y))))))

(defthm power2p-shift-2
  (implies (and (syntaxp (power2-syntaxp y))
                (case-split (power2p y)) ;this should be true if the syntaxp hyp is satisfied
                )
           (equal (power2p (* x y))
                  (power2p x)))
  :hints (("Goal" :in-theory (disable power2p)
           :use ( power2p-prod-not power2p-prod))))


