// $Id: ACE_Init_TestDlg.cpp 73451 2006-07-11 13:41:14Z shuston $

// ============================================================================
//
// = LIBRARY
//    tests
//
// = DESCRIPTION
//    This is a Win32-only test for verifying that the ACE dll
//    initializes itself without having a nonstatic object manager
//    present by way of a console app's main function.  It's a MFC dialog
//    app - it pops up a dialog and spawns a thread - this source file is
//    the code for implementing the dialog box.
//
//    This test program was initially generated from MSVC AppWizard, then
//    some files were renamed and moved around to fit in with the ACE
//    test directory structure.
//
// = AUTHOR
//    Steve Huston <shuston@riverace.com>
//
// ============================================================================

#if defined(ACE_HAS_MFC)

#include "ACE_Init_Test_StdAfx.h"
#include "ACE_Init_Test.h"
#include "ACE_Init_TestDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CACE_Init_TestDlg dialog

CACE_Init_TestDlg::CACE_Init_TestDlg(CWnd* pParent /*=NULL*/)
        : CDialog(CACE_Init_TestDlg::IDD, pParent)
{
        //{{AFX_DATA_INIT(CACE_Init_TestDlg)
                // NOTE: the ClassWizard will add member initialization here
        //}}AFX_DATA_INIT
        // Note that LoadIcon does not require a subsequent DestroyIcon in Win32
        m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CACE_Init_TestDlg::DoDataExchange(CDataExchange* pDX)
{
        CDialog::DoDataExchange(pDX);
        //{{AFX_DATA_MAP(CACE_Init_TestDlg)
                // NOTE: the ClassWizard will add DDX and DDV calls here
        //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CACE_Init_TestDlg, CDialog)
        //{{AFX_MSG_MAP(CACE_Init_TestDlg)
        ON_WM_PAINT()
        ON_WM_QUERYDRAGICON()
        //}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CACE_Init_TestDlg message handlers

BOOL CACE_Init_TestDlg::OnInitDialog()
{
        CDialog::OnInitDialog();

        // Set the icon for this dialog.  The framework does this automatically
        //  when the application's main window is not a dialog
        SetIcon(m_hIcon, TRUE);                 // Set big icon
        SetIcon(m_hIcon, FALSE);                // Set small icon

        // TODO: Add extra initialization here

        return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CACE_Init_TestDlg::OnPaint()
{
        if (IsIconic())
        {
                CPaintDC dc(this); // device context for painting

                SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

                // Center icon in client rectangle
                int cxIcon = GetSystemMetrics(SM_CXICON);
                int cyIcon = GetSystemMetrics(SM_CYICON);
                CRect rect;
                GetClientRect(&rect);
                int x = (rect.Width() - cxIcon + 1) / 2;
                int y = (rect.Height() - cyIcon + 1) / 2;

                // Draw the icon
                dc.DrawIcon(x, y, m_hIcon);
        }
        else
        {
                CDialog::OnPaint();
        }
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CACE_Init_TestDlg::OnQueryDragIcon()
{
        return (HCURSOR) m_hIcon;
}

#endif /* ACE_HAS_MFC */
