eval '(exit $?0)' && eval 'exec perl -S $0 ${1+"$@"}'
     & eval 'exec perl -S $0 $argv:q'
     if 0;

# $Id: run_test.pl 73792 2006-07-28 00:51:55Z wotte $
# -*- perl -*-

use lib "$ENV{ACE_ROOT}/bin";
use PerlACE::Run_Test;

$status = 0;


$iorfname_prefix = "server";
$num_servants=1;
$num_clients_per_servant=40;
$num_orb_threads=1;
$num_csd_threads=1;
$collocated_test=0;
$servant_cancellation_option="";

if ($ARGV[0] eq 'collocated') { 
  # 1 servant, 1 collocated client, 1 orb thread, 2 strategy working threads    
  $num_clients_per_servant=1;
  $collocated_test=1;
  $num_csd_threads=2;
}
elsif ($ARGV[0] eq 'multiple_servants') { 
  # multiple servants and single orb thread.
  # 10 servant, 40 client, 1 orb thread, 10 strategy working threads  
  $num_servants=10;
  $num_csd_threads=10;
  $num_clients_per_servant=4;
}
elsif ($ARGV[0] eq 'multiple_orb_threads') { 
  # multiple servants and multiple orb threads.
  # 10 servant, 40 client, 4 orb thread, 10 strategy working threads 
  $num_servants=10;
  $num_csd_threads=10;
  $num_clients_per_servant=4;
  $num_orb_threads=4;
}
elsif ($ARGV[0] eq 'cancel_servant') { 
  # Cancel one servant and leave the other alive.
  # 2 servant, 10 client, 5 orb thread, 1 strategy working threads 
  $num_clients_per_servant=5;
  $num_servants=2;
  $num_csd_threads=2;
  $num_orb_threads=5;
  $servant_cancellation_option = " -d 1 ";
}
elsif ($ARGV[0] eq '') {
  # default test - 1 servant, 40 clients , 1 orb thread, 1 csd thread  
}
else {
  print STDERR "ERROR: invalid parameter $ARGV[0] \n";
  exit 1;
}

$num_clients=$num_servants * $num_clients_per_servant;

#Delete old ior files.
for (my $i = 0; $i < $num_servants; $i++) {
  $servant_id = sprintf("%02d", ($i + 1));
  $iorfile[$i] = PerlACE::LocalFile($iorfname_prefix . "_$servant_id.ior");
    
  unlink $iorfile[$i];
}


if (PerlACE::is_vxworks_test()) {
    $SV  = new PerlACE::ProcessVX ("server_main", 
			     "-p $iorfname_prefix -s $num_servants "
			     . "-c $num_clients -t $num_orb_threads -n $num_csd_threads "
                             . "-l $collocated_test $servant_cancellation_option");
}
else {
    $SV  = new PerlACE::Process ("server_main", 
			     "-p $iorfname_prefix -s $num_servants "
			     . "-c $num_clients -t $num_orb_threads -n $num_csd_threads "
                             . "-l $collocated_test $servant_cancellation_option");
}

$SV->Spawn ();

# Wait for the servant ior files created by server.
for (my $i = 0; $i < $num_servants; $i++) {
  $servant_id = sprintf("%02d", ($i + 1));
  $iorfile[$i] = PerlACE::LocalFile($iorfname_prefix . "_$servant_id.ior");
    
  if (PerlACE::waitforfile_timed ($iorfile[$i],
                        $PerlACE::wait_interval_for_process_creation) == -1) {
    print STDERR "ERROR: cannot find file <$iorfile[$i]>\n";
    $SV->Kill (); $SV->TimedWait (1);
    exit 1;
  }
}

$count = 0;

if ($collocated_test == 0) {
  for (my $i = 0; $i < $num_servants; $i++) { 
    for ($j = 0; $j < $num_clients_per_servant; $j++) {
      $CLS[$count] = new PerlACE::Process ("client_main", " -i file://$iorfile[$i]");
      $CLS[$count]->Spawn ();
      $count ++;
    }
  }

  for (my $i = 0; $i < $num_clients; $i++) {
    $client = $CLS[$i]->WaitKill (60);

    if ($client != 0) {
      print STDERR "ERROR: client $i returned $client\n";
      $status = 1;
    }
  }
}

$server = $SV->WaitKill (60);

if ($server != 0) {
    print STDERR "ERROR: server returned $server\n";
    $status = 1;
}

#Delete ior files generated by this run.
for (my $i = 0; $i < $num_servants; $i++) {
  $servant_id = sprintf("%02d", ($i + 1));
  $iorfile[$i] = PerlACE::LocalFile($iorfname_prefix . "_$servant_id.ior");
  
  unlink $iorfile[$i];
}

exit $status;
