// file      : CCF/IDL3/SemanticAction/Component.hpp
// author    : Boris Kolpackov <boris@dre.vanderbilt.edu>
// cvs-id    : $Id: Component.hpp 75029 2006-10-25 15:07:31Z boris $

#ifndef CCF_IDL3_SEMANTIC_ACTION_COMPONENT_HPP
#define CCF_IDL3_SEMANTIC_ACTION_COMPONENT_HPP

#include "CCF/IDL3/SemanticAction/Elements.hpp"

namespace CCF
{
  namespace IDL3
  {
    namespace SemanticAction
    {
      struct Component : Scope
      {
        virtual void
        begin_def (SimpleIdentifierPtr const& id) = 0;

        virtual void
        begin_fwd (SimpleIdentifierPtr const& id) = 0;

        virtual void
        inherits (IdentifierPtr const& id) = 0;

        virtual void
        supports (IdentifierPtr const& id) = 0;

        virtual void
        open_scope () = 0;

        virtual void
        close_scope () = 0;

        virtual void
        end () = 0;
      };
    }
  }
}

#endif  // CCF_IDL3_SEMANTIC_ACTION_COMPONENT_HPP
