// -*- C++ -*-

// ===================================================================
/**
 *  @file   RequestInfo_Util.h
 *
 *  RequestInfo_Util.h,v 1.5 2003/10/28 18:29:20 bala Exp
 *
 *  @author Ossama Othman <ossama@uci.edu>
 */
// ===================================================================

#ifndef TAO_REQUEST_INFO_UTIL_H
#define TAO_REQUEST_INFO_UTIL_H

#include /**/ "ace/pre.h"
#include "ace/CORBA_macros.h"

#if !defined (ACE_LACKS_PRAGMA_ONCE)
# pragma once
#endif /* ACE_LACKS_PRAGMA_ONCE */

#include "tao/Basic_Types.h"
#include "tao/TAO_Export.h"

namespace CORBA
{
  class StringSeq;
  class Any;
  class Environment;
}

namespace Dynamic
{
  class ParameterList;
  class ExceptionList;
  typedef CORBA::StringSeq ContextList;
  typedef CORBA::StringSeq RequestContext;
}

/**
 * @class TAO_RequestInfo_Util
 *
 * @brief Helper class that provides methods useful for both
 * PortableInterceptor::ClientRequestInfo and
 * PortableInterceptor::ServerRequestInfo objects.
 */
class TAO_Export TAO_RequestInfo_Util
{
public:

  /**
   * @name Factory Methods
   *
   * These are methods called by TAO_{Client,Server}RequestInfo and
   * their subclasses.  Rather than having the same factory code in
   * each subclass, we factor the common code in to this utility
   * class.
   */
  //@{
  static Dynamic::ParameterList * make_parameter_list (
    ACE_ENV_SINGLE_ARG_DECL);

  static Dynamic::ExceptionList * make_exception_list (
    ACE_ENV_SINGLE_ARG_DECL);

  static Dynamic::ContextList * make_context_list (
    ACE_ENV_SINGLE_ARG_DECL);

  static Dynamic::RequestContext * make_request_context (
    ACE_ENV_SINGLE_ARG_DECL);

  static CORBA::Any * make_any (CORBA::Boolean tk_void_any
                                ACE_ENV_ARG_DECL);
  //@}
};

#include /**/ "ace/post.h"

#endif /* TAO_REQUEST_INFO_UTIL_H */
