// Time_Service_Clerk.cpp,v 1.6 2003/11/01 11:15:09 dhinton Exp

#include "Clerk_i.h"
#include "ace/OS_main.h"

ACE_RCSID(TimeService, Time_Service_Clerk, "Time_Service_Clerk.cpp,v 1.6 2003/11/01 11:15:09 dhinton Exp")

// This is the main driver program for the Time Service clerk.

int
ACE_TMAIN (int argc, ACE_TCHAR* argv[])
{
  Clerk_i clerk;

  ACE_DEBUG ((LM_DEBUG,
              "[SERVER] Process/Thread Id : (%P/%t) Time Service clerk\n"));

  ACE_DECLARE_NEW_CORBA_ENV;
  ACE_TRY
    {
      int r = clerk.init (argc, argv ACE_ENV_ARG_PARAMETER);
      ACE_TRY_CHECK;
      if (r == -1)
        return 1;
      else
        {
          clerk.run (ACE_ENV_SINGLE_ARG_PARAMETER);
          ACE_TRY_CHECK;
        }
    }
  ACE_CATCH (CORBA::SystemException, sysex)
    {
      ACE_PRINT_EXCEPTION (sysex, "System Exception");
      return -1;
    }
  ACE_CATCH (CORBA::UserException, userex)
    {
      ACE_PRINT_EXCEPTION (userex, "User Exception");
      return -1;
    }
  ACE_ENDTRY;

  return 0;
}
