// STD_PCD_Handler.cpp,v 1.1 2005/07/26 19:23:09 mxiong Exp
#include "STD_PCD_Handler.h"
#include "STD_CPD_Handler.h"
#include "Basic_Deployment_Data.hpp"
#include "ciao/Deployment_DataC.h"
#include "XML_Helper.h"
#include "Deployment.hpp"


namespace CIAO
{
  namespace Config_Handlers
  {

    bool
    STD_PCD_Handler::package_config (
      const PackageConfiguration &desc,
      ::Deployment::PackageConfiguration &toconfig)
    {
      toconfig.label =
        desc.label ().c_str ();

      toconfig.UUID =
        desc.UUID ().c_str ();

      if (!this->xml_helper_->is_initialized ())
        return false;

      // parse the .cpd (ComponentPackageDescription) file
      // that <basePackage> links to
      xercesc::DOMDocument* dom =
        this->xml_helper_->create_dom ((desc.basePackage()).href ().c_str ());

      if (!dom)
        return false;

      ComponentPackageDescription cpc =
        componentPackageDescription (dom);

      Deployment::ComponentPackageDescription idl_cpc;

      STD_CPD_Handler cpd_handler (this->xml_helper_);

      cpd_handler.component_package_descr (cpc,
                                           idl_cpc);

      toconfig.basePackage.length (1);
      toconfig.basePackage [0] = idl_cpc;

      return true;
    }
  }
}
