/* -*- C++ -*- */

//=============================================================================
/**
 *  @file    Local_Name_Space.h
 *
 *  Local_Name_Space.h,v 4.18 2001/03/26 21:18:41 coryan Exp
 *
 *  @author Prashant Jain (pjain@cs.wustl.edu)
 *  @author Irfan Pyarali (irfan@wuerl.wustl.edu)
 *  @author and Douglas C. Schmidt (schmidt@cs.wustl.edu).
 */
//=============================================================================


#ifndef ACE_LOCAL_NAME_SPACE_H
#define ACE_LOCAL_NAME_SPACE_H
#include "ace/pre.h"

#include "ace/SString.h"

#if !defined (ACE_LACKS_PRAGMA_ONCE)
# pragma once
#endif /* ACE_LACKS_PRAGMA_ONCE */

#include "ace/Malloc_T.h"
#include "ace/Synch.h"

/**
 * @class ACE_NS_String
 *
 * @brief This class and ACE_NS_Internal are used as Adapters to work
 * with the Map_Manager.
 *
 * In order to work correctly, this class must be able to
 * convert back and forth with <ACE_WStrings>.  Note that this
 * class must not have a destructor since otherwise we'll have
 * problems...
 */
class ACE_Export ACE_NS_String
{
public:
  // = Initialization.
  /// Default "no-op" constructor.
  ACE_NS_String (void);

  /// Initialization method.
  ACE_NS_String (ACE_USHORT16 *dst,
                 const ACE_USHORT16 *src,
                 size_t len);

  /// Converts an ACE_WString to an ACE_NS_String;
  ACE_NS_String (const ACE_WString &);

  /// Destructor
  ~ACE_NS_String (void);

  /// Converts an ACE_NS_String to fresh copy of an ACE_WString;
  operator ACE_WString () const;

  /// Return the ASCII character representation.
  char *char_rep (void) const;

  /// Matches on substrings.
  int strstr (const ACE_NS_String &) const;

  /// Compare an ACE_NS_String.
  int operator == (const ACE_NS_String &) const;

  /// Compare an ACE_NS_String.
  int operator != (const ACE_NS_String &) const;

  /// Returns length of the string
  size_t len (void) const;

  /// Returns the underlying representation.
  ACE_USHORT16 *fast_rep (void) const;

  /// Returns a hash value for this string.
  size_t hash (void) const;

private:
  /// Length of the string.
  size_t len_;

  /// This actually points into shared/persistent memory.
  ACE_USHORT16 *rep_;

  /// Should rep_ be deleted when destructed (only used
  /// for WString conversions)
  int delete_rep_;
};

/**
 * @class ACE_NS_Internal
 *
 * @brief This class and ACE_NS_String are used as Adapters to work
 * with the Map_Manager.
 */
class ACE_Export ACE_NS_Internal
{
public:
  /// No-op constructor.
  ACE_NS_Internal (void);

  /// Constructor.
  ACE_NS_Internal (ACE_NS_String &value, const char *type);

  /// Compare an ACE_NS_Internal
  int operator == (const ACE_NS_Internal &) const;

  /// Return value.
  ACE_NS_String value (void);

  /// Return type.
  const char *type (void);

private:
  /// Contains the value of the string.
  ACE_NS_String value_;

  /// Contains the type of the string.
  const char *type_;
};

// Include the ACE_Local_Name_Space templates stuff at this point.
#include "ace/Local_Name_Space_T.h"

#include "ace/post.h"
#endif /* ACE_LOCAL_NAME_SPACE_H */
