/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * This file is part of SableCC.                             *
 * See the file "LICENSE" for copyright information and the  *
 * terms and conditions for copying, distribution and        *
 * modification of SableCC.                                  *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

package org.sablecc.sablecc.node;

import org.sablecc.sablecc.Switch;
import org.sablecc.sablecc.analysis.Analysis;

public final class RegExpTail1 extends RegExpTail
{
    public void apply(Switch sw)
    {
        ((Analysis) sw).caseRegExpTail1(this);
    }

    public String toString()
    {
        return ""
            + node1
            + node2;
    }

    private TBar node1;

    public TBar getNode1()
    {
        return node1;
    }

    public void setNode1(TBar node)
    {
        if(node1 != null)
        {
            node1.setParent(null);
        }

        if(node.getParent() != null)
        {
            node.getParent().removeChild(node);
        }

        node.setParent(this);

        node1 = node;
    }

    private Concat node2;

    public Concat getNode2()
    {
        return node2;
    }

    public void setNode2(Concat node)
    {
        if(node2 != null)
        {
            node2.setParent(null);
        }

        if(node.getParent() != null)
        {
            node.getParent().removeChild(node);
        }

        node.setParent(this);

        node2 = node;
    }

    void removeChild(Node child)
    {
        if(node1 == child)
        {
            node1 = null;
        }

        if(node2 == child)
        {
            node2 = null;
        }

    }
}

