/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.instantdb.db;

import java.sql.Connection;
import java.sql.SQLException;
import org.enhydra.instantdb.db.Table;
import org.enhydra.instantdb.db.Trace;
import org.enhydra.instantdb.db.Transaction;

final class TableLock {
    private Transaction[] readers = new Transaction[5];
    private int readLockCount;
    private Transaction writer;
    private Table table;
    private int readersWaiting;

    TableLock(Table table) {
        this.table = table;
    }

    private String checkLocksValid() throws SQLException {
        StringBuffer stringBuffer = new StringBuffer(256);
        int n = 0;
        while (n < this.readLockCount) {
            Transaction transaction = this.readers[n];
            if (transaction.con != null && transaction.con.isClosed()) {
                stringBuffer.append("\nTransaction " + transaction.ID + " no longer valid");
                transaction.freeAllLocks(false);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    synchronized void freeReadLock(Transaction transaction) {
        int n = this.hasReadLock(transaction);
        if (--this.readLockCount != n) {
            this.readers[n] = this.readers[this.readLockCount];
        }
        this.notify();
        if (Trace.traceIt(16)) {
            Trace.traceOut("Free READ LOCK " + this.toString());
        }
    }

    void freeWriteLock(Transaction transaction) throws SQLException {
        boolean bl = false;
        TableLock tableLock = this;
        synchronized (tableLock) {
            if (this.writer != transaction) {
                this.freeReadLock(transaction);
                Object var4_5 = null;
                return;
            }
            this.writer = null;
            if (Trace.traceIt(16)) {
                Trace.traceOut("Free WRITE LOCK " + this.toString());
            }
            if (this.table.fd != null && this.table.transModified) {
                if (this.table.fd.valid() && !this.table.fastUpdate) {
                    bl = true;
                }
                this.table.transModified = false;
            }
            if (!bl) {
                this.freeReadLock(transaction);
            }
            this.notify();
        }
        if (bl) {
            try {
                this.table.fd.sync();
                this.freeReadLock(transaction);
            }
            catch (Exception exception) {
                System.out.println("Table " + this.table.tableName);
                exception.printStackTrace();
            }
        }
        if (this.readLockCount < 0) {
            throw new SQLException("Internal error - Transaction: " + transaction.ID + " has " + this.readLockCount + " lock(s) on table: " + this.table.tableName);
        }
    }

    /*
     * Unable to fully structure code
     */
    synchronized void getReadLock(Transaction var1_1) throws SQLException {
        if (this.hasReadLock(var1_1) < 0) ** GOTO lbl6
        return;
lbl-1000:
        // 1 sources

        {
            ++this.readersWaiting;
            this.waitForLockChange(var1_1, true);
            --this.readersWaiting;
lbl6:
            // 2 sources

            ** while (this.writer != null)
        }
lbl7:
        // 1 sources

        var1_1.setWaitTransaction(null);
        if (this.readLockCount == this.readers.length) {
            this.growReaders();
        }
        this.readers[this.readLockCount++] = var1_1;
        var1_1.addLock(this.table);
        if (this.readLockCount == 1) {
            this.table.minRowDeleted = 0x7FFFFFFF;
            this.table.maxRowDeleted = 0;
        }
        if (Trace.traceIt(16)) {
            Trace.traceOut("READ LOCK " + this.toString());
        }
    }

    synchronized void getWriteLock(Transaction transaction) throws SQLException {
        if (this.writer == transaction) {
            return;
        }
        int n = 0;
        if (this.hasReadLock(transaction) >= 0) {
            n = 1;
        }
        while (this.writer != null || this.readLockCount > n) {
            if (this.readersWaiting > 0) {
                this.notify();
            }
            this.waitForLockChange(transaction, false);
        }
        if (n == 0) {
            this.getReadLock(transaction);
        }
        this.writer = transaction;
        if (Trace.traceIt(16)) {
            Trace.traceOut("WRITE LOCK " + this.toString());
        }
    }

    public Connection getWritersConnection() {
        return this.writer.getConnection();
    }

    private void growReaders() {
        Transaction[] transactionArray = new Transaction[this.readLockCount * 2];
        int n = 0;
        while (n < this.readLockCount) {
            transactionArray[n] = this.readers[n];
            ++n;
        }
        this.readers = transactionArray;
    }

    private int hasReadLock(Transaction transaction) {
        int n = 0;
        while (n < this.readLockCount) {
            if (this.readers[n] == transaction) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append(" Table: " + this.table.tableName + ", has the following locks\n");
        stringBuffer.append("  Writers: ");
        if (this.writer != null) {
            stringBuffer.append(this.writer.ID);
        }
        stringBuffer.append('\n');
        stringBuffer.append("  Readers: \n");
        int n = 0;
        while (n < this.readLockCount) {
            stringBuffer.append("    " + this.readers[n] + "\n");
            ++n;
        }
        stringBuffer.append(String.valueOf(this.readersWaiting) + " waiting to get read locks.\n");
        return stringBuffer.toString();
    }

    void waitForLockChange(Transaction transaction, boolean bl) throws SQLException {
        try {
            if (transaction.getLockCount() > 0 && this.writer != null && this.writer.checkDeadLock(transaction)) {
                throw new SQLException("Deadlock detected by\n" + transaction.toString() + "\nTrying to lock table: " + this.table.tableName + "\nLock owner: \n" + this.writer.toString());
            }
            transaction.setWaitTransaction(this.writer);
            transaction.waitThread = Thread.currentThread();
            this.wait();
            if (!this.table.dbase.isValid()) {
                throw new SQLException("Database closed while waiting for table lock");
            }
        }
        catch (InterruptedException interruptedException) {
            if (bl) {
                --this.readersWaiting;
            }
            String string = this.toString();
            String string2 = this.checkLocksValid();
            this.notify();
            throw new SQLException("Timeout detected by\n" + transaction.toString() + "\n" + string + string2);
        }
    }
}

