/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.util;

import java.io.IOException;
import java.util.List;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSInteger;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSNumber;
import org.pdfbox.pdmodel.common.COSArrayList;
import org.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.pdfbox.pdmodel.graphics.color.PDColorSpaceFactory;

public class ImageParameters {
    private COSDictionary dictionary;

    public ImageParameters() {
        this.dictionary = new COSDictionary();
    }

    public ImageParameters(COSDictionary params) {
        this.dictionary = params;
    }

    public COSDictionary getDictionary() {
        return this.dictionary;
    }

    private COSBase getCOSObject(String abbreviatedName, String name) {
        COSBase retval = this.dictionary.getDictionaryObject(COSName.getPDFName(abbreviatedName));
        if (retval == null) {
            retval = this.dictionary.getDictionaryObject(COSName.getPDFName(name));
        }
        return retval;
    }

    private int getNumberOrNegativeOne(String abbreviatedName, String name) {
        int retval = -1;
        COSNumber number = (COSNumber)this.getCOSObject(abbreviatedName, name);
        if (number != null) {
            retval = number.intValue();
        }
        return retval;
    }

    public int getBitsPerComponent() {
        return this.getNumberOrNegativeOne("BPC", "BitsPerComponent");
    }

    public void setBitsPerComponent(int bpc) {
        this.dictionary.setItem(COSName.getPDFName("BPC"), (COSBase)new COSInteger(bpc));
    }

    public PDColorSpace getColorSpace() throws IOException {
        COSBase cs = this.getCOSObject("CS", "ColorSpace");
        PDColorSpace retval = null;
        if (cs != null) {
            retval = PDColorSpaceFactory.createColorSpace(cs);
        }
        return retval;
    }

    public void setColorSpace(PDColorSpace cs) {
        COSBase base = null;
        if (cs != null) {
            base = cs.getCOSObject();
        }
        this.dictionary.setItem(COSName.getPDFName("CS"), base);
    }

    public int getHeight() {
        return this.getNumberOrNegativeOne("H", "Height");
    }

    public void setHeight(int h) {
        this.dictionary.setItem(COSName.getPDFName("H"), (COSBase)new COSInteger(h));
    }

    public int getWidth() {
        return this.getNumberOrNegativeOne("W", "Width");
    }

    public void setWidth(int w) {
        this.dictionary.setItem(COSName.getPDFName("W"), (COSBase)new COSInteger(w));
    }

    public List getFilters() {
        List retval = null;
        COSBase filters = this.dictionary.getDictionaryObject(new String[]{"Filter", "F"});
        if (filters instanceof COSName) {
            COSName name = (COSName)filters;
            retval = new COSArrayList(name.getName(), name, this.dictionary, "Filter");
        } else if (filters instanceof COSArray) {
            retval = COSArrayList.convertCOSNameCOSArrayToList((COSArray)filters);
        }
        return retval;
    }

    public void setFilters(List filters) {
        COSArray obj = COSArrayList.convertStringListToCOSNameCOSArray(filters);
        this.dictionary.setItem("Filter", (COSBase)obj);
    }
}

