/* ShowGraphPropertiesAction.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.worksheet.actions;

import java.awt.event.ActionEvent;

import org.grinvin.list.graphs.GraphListElement;
import org.grinvin.gui.windows.GraphPropertiesWindow;

/**
 * Actions which shows the graph properties window of a certain graph list
 * element. The graph list element must be set before the action can be performed.
 */
public class ShowGraphPropertiesAction extends AbstractGraphListElementAction {
    
    /**
     * Create an action of this type for the given graph list element.
     */
    public ShowGraphPropertiesAction(GraphListElement[] graphListElements) {
        super(graphListElements, "showGraphProperties.description");
    }
    
    /**
     * Create an action of this type. The graph list elements to which
     * this action applies should be set later using {@link #setGraphListElements}
     */
    public ShowGraphPropertiesAction() {
        this(null);
    }
    
    public void actionPerformed(ActionEvent e) {
        // TODO: use a only a single window?
        for(GraphListElement element : graphListElements)
            new GraphPropertiesWindow(element).setVisible(true);
    }
    
}
