/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon;

import com.icl.saxon.Controller;
import com.icl.saxon.ExtendedInputSource;
import com.icl.saxon.Loader;
import com.icl.saxon.ParameterSet;
import com.icl.saxon.TransformerFactoryImpl;
import com.icl.saxon.Version;
import com.icl.saxon.expr.StringValue;
import com.icl.saxon.om.NamePool;
import com.icl.saxon.style.TerminationException;
import com.icl.saxon.trace.SimpleTraceListener;
import com.icl.saxon.trace.TraceListener;
import java.io.File;
import java.util.Date;
import java.util.Properties;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;

public class StyleSheet {
    protected TransformerFactoryImpl factory = new TransformerFactoryImpl();
    protected NamePool namePool = NamePool.getDefaultNamePool();
    boolean showTime = false;
    int repeat = 1;

    public static void main(String[] stringArray) throws Exception {
        new StyleSheet().doMain(stringArray, new StyleSheet(), " java com.icl.saxon.StyleSheet");
    }

    protected void doMain(String[] stringArray, StyleSheet styleSheet, String string) {
        String string2 = null;
        String string3 = null;
        File file = null;
        Object var7_7 = null;
        File file2 = null;
        boolean bl = false;
        ParameterSet parameterSet = new ParameterSet();
        Properties properties = new Properties();
        String string4 = null;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            Object object;
            int n = 0;
            while (true) {
                Object object2;
                if (n >= stringArray.length) {
                    this.badUsage(string, "No source file name");
                }
                if (stringArray[n].charAt(0) != '-') break;
                if (stringArray[n].equals("-a")) {
                    bl2 = true;
                    ++n;
                    continue;
                }
                if (stringArray[n].equals("-ds")) {
                    this.factory.setAttribute("http://icl.com/saxon/feature/treeModel", new Integer(0));
                    ++n;
                    continue;
                }
                if (stringArray[n].equals("-dt")) {
                    this.factory.setAttribute("http://icl.com/saxon/feature/treeModel", new Integer(1));
                    ++n;
                    continue;
                }
                if (stringArray[n].equals("-l")) {
                    this.factory.setAttribute("http://icl.com/saxon/feature/linenumbering", new Boolean(true));
                    ++n;
                    continue;
                }
                if (stringArray[n].equals("-u")) {
                    bl = true;
                    ++n;
                    continue;
                }
                if (stringArray[n].equals("-t")) {
                    System.err.println(Version.getProductName());
                    System.err.println("Java version " + System.getProperty("java.version"));
                    this.factory.setAttribute("http://icl.com/saxon/feature/timing", new Boolean(true));
                    Loader.setTracing(true);
                    this.showTime = true;
                    ++n;
                    continue;
                }
                if (stringArray[n].equals("-3")) {
                    ++n;
                    this.repeat = 3;
                    continue;
                }
                if (stringArray[n].equals("-9")) {
                    ++n;
                    this.repeat = 9;
                    continue;
                }
                if (stringArray[n].equals("-o")) {
                    if (stringArray.length < ++n + 2) {
                        this.badUsage(string, "No output file name");
                    }
                    string4 = stringArray[n++];
                    continue;
                }
                if (stringArray[n].equals("-x")) {
                    if (stringArray.length < ++n + 2) {
                        this.badUsage(string, "No source parser class");
                    }
                    object2 = stringArray[n++];
                    this.factory.setAttribute("http://icl.com/saxon/feature/sourceParserClass", object2);
                    continue;
                }
                if (stringArray[n].equals("-y")) {
                    if (stringArray.length < ++n + 2) {
                        this.badUsage(string, "No style parser class");
                    }
                    object2 = stringArray[n++];
                    this.factory.setAttribute("http://icl.com/saxon/feature/styleParserClass", object2);
                    continue;
                }
                if (stringArray[n].equals("-r")) {
                    if (stringArray.length < ++n + 2) {
                        this.badUsage(string, "No URIResolver class");
                    }
                    object2 = stringArray[n++];
                    this.factory.setURIResolver(StyleSheet.makeURIResolver((String)object2));
                    continue;
                }
                if (stringArray[n].equals("-T")) {
                    ++n;
                    object2 = new SimpleTraceListener();
                    this.factory.setAttribute("http://icl.com/saxon/feature/traceListener", object2);
                    this.factory.setAttribute("http://icl.com/saxon/feature/linenumbering", Boolean.TRUE);
                    continue;
                }
                if (stringArray[n].equals("-TL")) {
                    if (stringArray.length < ++n + 2) {
                        this.badUsage(string, "No TraceListener class");
                    }
                    object2 = StyleSheet.makeTraceListener(stringArray[n++]);
                    this.factory.setAttribute("http://icl.com/saxon/feature/traceListener", object2);
                    this.factory.setAttribute("http://icl.com/saxon/feature/linenumbering", Boolean.TRUE);
                    continue;
                }
                if (stringArray[n].equals("-w0")) {
                    ++n;
                    this.factory.setAttribute("http://icl.com/saxon/feature/recoveryPolicy", new Integer(0));
                    continue;
                }
                if (stringArray[n].equals("-w1")) {
                    ++n;
                    this.factory.setAttribute("http://icl.com/saxon/feature/recoveryPolicy", new Integer(1));
                    continue;
                }
                if (stringArray[n].equals("-w2")) {
                    ++n;
                    this.factory.setAttribute("http://icl.com/saxon/feature/recoveryPolicy", new Integer(2));
                    continue;
                }
                if (stringArray[n].equals("-m")) {
                    if (stringArray.length < ++n + 2) {
                        this.badUsage(string, "No message Emitter class");
                    }
                    this.factory.setAttribute("http://icl.com/saxon/feature/messageEmitterClass", stringArray[n++]);
                    continue;
                }
                this.badUsage(string, "Unknown option " + stringArray[n]);
            }
            if (stringArray.length < n + 1) {
                this.badUsage(string, "No source file name");
            }
            string2 = stringArray[n++];
            if (!bl2) {
                if (stringArray.length < n + 1) {
                    this.badUsage(string, "No stylesheet file name");
                }
                string3 = stringArray[n++];
            }
            int n2 = n;
            while (n2 < stringArray.length) {
                object = stringArray[n2];
                int n3 = ((String)object).indexOf("=");
                if (n3 < 1 || n3 >= ((String)object).length() - 1) {
                    this.badUsage(string, "Bad param=value pair on command line");
                }
                String string5 = ((String)object).substring(0, n3);
                int n4 = this.namePool.allocate("", "", string5);
                parameterSet.put(n4, new StringValue(((String)object).substring(n3 + 1)));
                ++n2;
            }
            object = null;
            if (bl || string2.startsWith("http:") || string2.startsWith("file:")) {
                object = this.factory.getURIResolver().resolve(string2, null);
            } else {
                file = new File(string2);
                if (!file.exists()) {
                    StyleSheet.quit("Source file " + file + " does not exist", 2);
                }
                if (file.isDirectory()) {
                    bl3 = true;
                    if (string4 == null) {
                        StyleSheet.quit("To process a directory, -o must be specified", 2);
                    } else if (string4.equals(string2)) {
                        StyleSheet.quit("Output directory must be different from input", 2);
                    } else {
                        file2 = new File(string4);
                        if (!file2.isDirectory()) {
                            StyleSheet.quit("Input is a directory, but output is not", 2);
                        }
                    }
                } else {
                    ExtendedInputSource extendedInputSource = new ExtendedInputSource(file);
                    object = new SAXSource(this.factory.getSourceParser(), extendedInputSource);
                    extendedInputSource.setEstimatedLength((int)file.length());
                }
            }
            if (string4 != null && !bl3 && (file2 = new File(string4)).isDirectory()) {
                StyleSheet.quit("Output is a directory, but input is not", 2);
            }
            if (bl2) {
                if (bl3) {
                    this.processDirectoryAssoc(file, file2, parameterSet);
                } else {
                    this.processFileAssoc((Source)object, null, file2, parameterSet);
                }
            } else {
                Object object3;
                Source source;
                long l = new Date().getTime();
                if (bl || string3.startsWith("http:") || string3.startsWith("file:")) {
                    source = this.factory.getURIResolver().resolve(string3, null);
                } else {
                    object3 = new File(string3);
                    if (!((File)object3).exists()) {
                        StyleSheet.quit("Stylesheet file " + object3 + " does not exist", 2);
                    }
                    ExtendedInputSource extendedInputSource = new ExtendedInputSource((File)object3);
                    source = new SAXSource(this.factory.getStyleParser(), extendedInputSource);
                }
                if (source == null) {
                    StyleSheet.quit("URIResolver for stylesheet file must return a Source", 2);
                }
                object3 = this.factory.newTemplates(source);
                if (this.showTime) {
                    long l2 = new Date().getTime();
                    System.err.println("Preparation time: " + (l2 - l) + " milliseconds");
                    l = l2;
                }
                if (bl3) {
                    this.processDirectory(file, (Templates)object3, file2, parameterSet);
                } else {
                    this.processFile((Source)object, (Templates)object3, file2, parameterSet);
                }
            }
        }
        catch (TerminationException terminationException) {
            StyleSheet.quit(terminationException.getMessage(), 1);
        }
        catch (TransformerException transformerException) {
            StyleSheet.quit("Transformation failed: " + transformerException.getMessage(), 2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.exit(0);
    }

    protected static void quit(String string, int n) {
        System.err.println(string);
        System.exit(n);
    }

    public void processDirectoryAssoc(File file, File file2, ParameterSet parameterSet) throws Exception {
        String[] stringArray = file.list();
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            File file3 = new File(file, stringArray[n2]);
            if (!file3.isDirectory()) {
                String string = file3.getName();
                try {
                    ExtendedInputSource extendedInputSource = new ExtendedInputSource(file3);
                    SAXSource sAXSource = new SAXSource(this.factory.getSourceParser(), extendedInputSource);
                    this.processFileAssoc(sAXSource, string, file2, parameterSet);
                }
                catch (TransformerException transformerException) {
                    ++n;
                    System.err.println("While processing " + string + ": " + transformerException.getMessage() + "\n");
                }
            }
            ++n2;
        }
        if (n > 0) {
            throw new TransformerException(n + " transformation" + (n == 1 ? "" : "s") + " failed");
        }
    }

    private File makeOutputFile(File file, String string, Templates templates) {
        String string2 = templates.getOutputProperties().getProperty("media-type");
        String string3 = ".xml";
        if ("text/html".equals(string2)) {
            string3 = ".html";
        } else if ("text/plain".equals(string2)) {
            string3 = ".txt";
        }
        String string4 = string;
        if (string.endsWith(".xml") || string.endsWith(".XML")) {
            string4 = string.substring(0, string.length() - 4);
        }
        return new File(file, string4 + string3);
    }

    public void processFileAssoc(Source source, String string, File file, ParameterSet parameterSet) throws TransformerException {
        if (this.showTime) {
            System.err.println("Processing " + source.getSystemId() + " using associated stylesheet");
        }
        long l = new Date().getTime();
        Source source2 = this.factory.getAssociatedStylesheet(source, null, null, null);
        Templates templates = this.factory.newTemplates(source2);
        if (this.showTime) {
            System.err.println("Prepared associated stylesheet " + source2.getSystemId());
        }
        Transformer transformer = templates.newTransformer();
        ((Controller)transformer).setParams(parameterSet);
        File file2 = file;
        if (file2 != null && file2.isDirectory()) {
            file2 = this.makeOutputFile(file2, string, templates);
        }
        StreamResult streamResult = file2 == null ? new StreamResult(System.out) : new StreamResult(file2);
        try {
            transformer.transform(source, streamResult);
        }
        catch (TerminationException terminationException) {
            throw terminationException;
        }
        catch (TransformerException transformerException) {
            throw new TransformerException("Run-time errors were reported");
        }
        if (this.showTime) {
            long l2 = new Date().getTime();
            System.err.println("Execution time: " + (l2 - l) + " milliseconds");
            l = l2;
        }
    }

    public void processDirectory(File file, Templates templates, File file2, ParameterSet parameterSet) throws TransformerException {
        String[] stringArray = file.list();
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            File file3 = new File(file, stringArray[n2]);
            String string = file3.getName();
            try {
                if (!file3.isDirectory()) {
                    File file4 = this.makeOutputFile(file2, string, templates);
                    ExtendedInputSource extendedInputSource = new ExtendedInputSource(file3);
                    SAXSource sAXSource = new SAXSource(this.factory.getSourceParser(), extendedInputSource);
                    this.processFile(sAXSource, templates, file4, parameterSet);
                }
            }
            catch (TransformerException transformerException) {
                ++n;
                System.err.println("While processing " + string + ": " + transformerException.getMessage() + "\n");
            }
            ++n2;
        }
        if (n > 0) {
            throw new TransformerException(n + " transformation" + (n == 1 ? "" : "s") + " failed");
        }
    }

    public void processFile(Source source, Templates templates, File file, ParameterSet parameterSet) throws TransformerException {
        int n = 0;
        while (n < this.repeat) {
            if (this.showTime) {
                System.err.println("Processing " + source.getSystemId());
            }
            long l = new Date().getTime();
            Transformer transformer = templates.newTransformer();
            ((Controller)transformer).setParams(parameterSet);
            StreamResult streamResult = file == null ? new StreamResult(System.out) : new StreamResult(file);
            try {
                transformer.transform(source, streamResult);
            }
            catch (TerminationException terminationException) {
                throw terminationException;
            }
            catch (TransformerException transformerException) {
                throw new TransformerException("Run-time errors were reported");
            }
            if (this.showTime) {
                long l2 = new Date().getTime();
                System.err.println("Execution time: " + (l2 - l) + " milliseconds");
                l = l2;
            }
            ++n;
        }
    }

    protected void badUsage(String string, String string2) {
        System.err.println(string2);
        System.err.println(Version.getProductName());
        System.err.println("Usage: " + string + " [options] source-doc style-doc {param=value}...");
        System.err.println("Options: ");
        System.err.println("  -a              Use xml-stylesheet PI, not style-doc argument ");
        System.err.println("  -ds             Use standard tree data structure ");
        System.err.println("  -dt             Use tinytree data structure (default)");
        System.err.println("  -o filename     Send output to named file or directory ");
        System.err.println("  -m classname    Use specified Emitter class for xsl:message output ");
        System.err.println("  -r classname    Use specified URIResolver class ");
        System.err.println("  -t              Display version and timing information ");
        System.err.println("  -T              Set standard TraceListener");
        System.err.println("  -TL classname   Set a specific TraceListener");
        System.err.println("  -u              Names are URLs not filenames ");
        System.err.println("  -w0             Recover silently from recoverable errors ");
        System.err.println("  -w1             Report recoverable errors and continue (default)");
        System.err.println("  -w2             Treat recoverable errors as fatal");
        System.err.println("  -x classname    Use specified SAX parser for source file ");
        System.err.println("  -y classname    Use specified SAX parser for stylesheet ");
        System.err.println("  -?              Display this message ");
        System.exit(2);
    }

    public static URIResolver makeURIResolver(String string) throws TransformerException {
        Object object = Loader.getInstance(string);
        if (object instanceof URIResolver) {
            return (URIResolver)object;
        }
        throw new TransformerException("Class " + string + " is not a URIResolver");
    }

    public static TraceListener makeTraceListener(String string) throws TransformerException {
        Object object = Loader.getInstance(string);
        if (object instanceof TraceListener) {
            return (TraceListener)object;
        }
        throw new TransformerException("Class " + string + " is not a TraceListener");
    }
}

