/*
 * Decompiled with CFR 0.152.
 */
package netscape.security;

import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.List;
import java.awt.Rectangle;
import java.util.Hashtable;
import netscape.security.EventEx;
import netscape.security.GlobalCtxt;
import netscape.security.ImgPanel;
import netscape.security.RszHints;

class XYLayout
implements LayoutManager {
    Hashtable rszHash = new Hashtable();
    Rectangle oldSize;
    Rectangle newSize;

    XYLayout(Rectangle rtCurSize) {
        this.oldSize = rtCurSize;
    }

    void setSize(Rectangle rtCurSize) {
        this.oldSize = rtCurSize;
    }

    void setHints(Component c, RszHints rsz) {
        this.rszHash.put(c, rsz);
    }

    void doLayout(Container cntr, Rectangle oldSize, Rectangle newSize, Hashtable rszHash) {
        int nc = cntr.countComponents();
        if (nc == 0) {
            return;
        }
        Component[] cmAr = cntr.getComponents();
        int dw = newSize.width - oldSize.width;
        int dh = newSize.height - oldSize.height;
        int nx = 0;
        int ny = 0;
        int nw = 0;
        int nh = 0;
        int i = 0;
        while (i < cntr.countComponents()) {
            Component c = cmAr[i];
            Rectangle r = c.bounds();
            RszHints rsz = (RszHints)rszHash.get(c);
            XYLayout hXYL = null;
            if (rsz != null) {
                nx = r.x + (int)((double)dw * rsz.x);
                ny = r.y + (int)((double)dh * rsz.y);
                nw = r.width + (int)((double)dw * rsz.wd);
                nh = r.height + (int)((double)dh * rsz.ht);
                Rectangle r1 = new Rectangle(nx, ny, nw, nh);
                if (c instanceof Label || c instanceof Button || c instanceof List) {
                    c.setFont(GlobalCtxt.initFn_g);
                }
                if (rsz.eexp != 0.0 || rsz.wexp != 0.0 || rsz.nexp != 0.0 || rsz.sexp != 0.0) {
                    Dimension dim = c.preferredSize();
                    int incr = 0;
                    if (nw < dim.width) {
                        RszHints rsz1;
                        Rectangle bo;
                        incr = dim.width - nw;
                        Component neibor = null;
                        if (rsz.eexp != 0.0) {
                            neibor = rsz.ecomp;
                            nw = (int)((double)nw + (double)incr * rsz.eexp);
                            while (neibor != null) {
                                bo = neibor.bounds();
                                neibor.reshape(bo.x + (int)((double)incr * rsz.eexp), bo.y, bo.width, bo.height);
                                rsz1 = (RszHints)rszHash.get(neibor);
                                neibor = null;
                                if (rsz1 == null) continue;
                                neibor = rsz1.ecomp;
                            }
                        }
                        if (rsz.wexp != 0.0) {
                            nx = (int)((double)nx - (double)incr * rsz.wexp);
                            nw += incr;
                            neibor = rsz.wcomp;
                            while (neibor != null) {
                                bo = neibor.bounds();
                                neibor.reshape(bo.x - (int)((double)incr * rsz.wexp), bo.y, bo.width, bo.height);
                                rsz1 = (RszHints)rszHash.get(neibor);
                                neibor = null;
                                if (rsz1 == null) continue;
                                neibor = rsz1.wcomp;
                            }
                        }
                    }
                }
                c.reshape(nx, ny, nw, nh);
                if (c instanceof ImgPanel && c.isEnabled()) {
                    hXYL = (XYLayout)((ImgPanel)c).getLayout();
                    this.doLayout((Container)c, r, r1, hXYL.rszHash);
                    EventEx evx = new EventEx(c, -1, r1);
                    c.handleEvent(evx);
                }
            }
            ++i;
        }
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    public Dimension preferredLayoutSize(Container parent) {
        Dimension d = parent.size();
        return d;
    }

    public Dimension minimumLayoutSize(Container parent) {
        Dimension d = parent.size();
        return d;
    }

    public void layoutContainer(Container parent) {
        if (parent instanceof ImgPanel) {
            return;
        }
        if (this.oldSize == null) {
            this.oldSize = parent.bounds();
            if (this.oldSize.width < 110 || this.oldSize.height < 50) {
                this.oldSize = null;
            }
            return;
        }
        this.newSize = parent.bounds();
        if (this.newSize.x < -1000 && this.newSize.y < -1000) {
            return;
        }
        if (this.newSize == null) {
            return;
        }
        this.doLayout(parent, this.oldSize, this.newSize, this.rszHash);
        this.oldSize = this.newSize;
    }
}

