/*
 * Decompiled with CFR 0.152.
 */
package netscape.security;

import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.util.Hashtable;
import netscape.applet.CastanetChannelInfo;
import netscape.security.AppletSecurityException;
import netscape.security.DialogCreator;
import netscape.security.ForbiddenTargetException;
import netscape.security.Principal;
import netscape.security.PrivilegeManager;
import netscape.security.Target;

public class AppletSecurity
extends SecurityManager {
    private static final boolean MARIMBA_ENABLED = true;
    private static boolean debug;
    static final int NETWORK_NONE = 1;
    static final int NETWORK_HOST = 2;
    static final int NETWORK_UNRESTRICTED = 3;
    private static final int PRIVELEGED_PORT = 1024;
    int networkMode;
    private static Hashtable resourceExtTable;
    private static Thread dlgCreatorThread;
    private static Target UniversalThreadAccessTarget;
    private static Target UniversalThreadGroupAccessTarget;
    private static Target UniversalExitAccessTarget;
    private static Target UniversalExecAccessTarget;
    private static Target UniversalLinkAccessTarget;
    private static Target UniversalPropertyWriteTarget;
    private static Target UniversalPropertyReadTarget;
    private static Target UniversalFileReadTarget;
    private static Target ParamFileReadTarget;
    private static Target UniversalFileWriteTarget;
    private static Target UniversalFileDeleteTarget;
    private static Target ParamFileWriteTarget;
    private static Target UniversalFdReadTarget;
    private static Target UniversalFdWriteTarget;
    private static Target UniversalListenTarget;
    private static Target UniversalAcceptTarget;
    private static Target UniversalConnectTarget;
    private static Target UniversalMulticastTarget;
    private static Target UniversalTopLevelWindowTarget;
    private static Target UniversalPackageAccessTarget;
    private static Target UniversalPackageDefinitionTarget;
    private static Target UniversalSetFactoryTarget;
    private static Target UniversalMemberAccessTarget;
    private static Target UniversalPrintJobAccessTarget;
    private static Target UniversalSystemClipboardAccessTarget;
    private static Target UniversalAwtEventQueueAccessTarget;
    private static Target UniversalSecurityProviderTarget;
    private static Target CreateSecurityManagerTarget;
    private static Target SuperUserTarget;
    private static PrivilegeManager privMgr;
    private static Class atg;

    public AppletSecurity() {
        this.reset();
        this.initTargets();
        if (dlgCreatorThread == null) {
            dlgCreatorThread = new DialogCreator();
        }
        AppletSecurity.loadResourceExtTable();
    }

    void reset() {
        SecurityManager.enablePrivilege((String)"UniversalPropertyRead");
        String str = System.getProperty("appletviewer.security.mode");
        if (str == null) {
            str = "host";
        }
        if (str.equals("unrestricted")) {
            this.networkMode = 3;
            return;
        }
        if (str.equals("none")) {
            this.networkMode = 1;
            return;
        }
        this.networkMode = 2;
    }

    private void initTargets() {
        UniversalThreadAccessTarget = Target.findTarget("UniversalThreadAccess");
        UniversalThreadGroupAccessTarget = Target.findTarget("UniversalThreadGroupAccess");
        UniversalExitAccessTarget = Target.findTarget("UniversalExitAccess");
        UniversalExecAccessTarget = Target.findTarget("UniversalExecAccess");
        UniversalLinkAccessTarget = Target.findTarget("UniversalLinkAccess");
        UniversalPropertyWriteTarget = Target.findTarget("UniversalPropertyWrite");
        UniversalPropertyReadTarget = Target.findTarget("UniversalPropertyRead");
        UniversalFileReadTarget = Target.findTarget("UniversalFileRead");
        ParamFileReadTarget = Target.findTarget("FileRead");
        UniversalFileWriteTarget = Target.findTarget("UniversalFileWrite");
        UniversalFileDeleteTarget = Target.findTarget("UniversalFileDelete");
        ParamFileWriteTarget = Target.findTarget("FileWrite");
        UniversalFdReadTarget = Target.findTarget("UniversalFdRead");
        UniversalFdWriteTarget = Target.findTarget("UniversalFdWrite");
        UniversalListenTarget = Target.findTarget("UniversalListen");
        UniversalAcceptTarget = Target.findTarget("UniversalAccept");
        UniversalConnectTarget = Target.findTarget("UniversalConnect");
        UniversalMulticastTarget = Target.findTarget("UniversalMulticast");
        UniversalTopLevelWindowTarget = Target.findTarget("UniversalTopLevelWindow");
        UniversalPackageAccessTarget = Target.findTarget("UniversalPackageAccess");
        UniversalPackageDefinitionTarget = Target.findTarget("UniversalPackageDefinition");
        UniversalSetFactoryTarget = Target.findTarget("UniversalSetFactory");
        UniversalMemberAccessTarget = Target.findTarget("UniversalMemberAccess");
        UniversalPrintJobAccessTarget = Target.findTarget("UniversalPrintJobAccess");
        UniversalSystemClipboardAccessTarget = Target.findTarget("UniversalSystemClipboardAccess");
        UniversalAwtEventQueueAccessTarget = Target.findTarget("UniversalAwtEventQueueAccess");
        UniversalSecurityProviderTarget = Target.findTarget("UniversalSecurityProvider");
        CreateSecurityManagerTarget = Target.findTarget("CreateSecurityManager");
        SuperUserTarget = Target.findTarget("SuperUser");
    }

    boolean fromApplet() {
        return this.checkClassLoader(1);
    }

    boolean inApplet() {
        return this.inClassLoader();
    }

    public Object getSecurityContext() {
        ClassLoader loader = this.currentClassLoader();
        if (loader == null) {
            return null;
        }
        return loader.getCodeBase();
    }

    public static void setPrivilegeManager(PrivilegeManager c) {
        if (privMgr != null) {
            throw new SecurityException("PrivilegeManager already set");
        }
        privMgr = c;
    }

    public static PrivilegeManager getPrivilegeManager() {
        return privMgr;
    }

    public static void enablePrivilege(String targetStr) {
        privMgr.enablePrivilege(targetStr, 1);
    }

    protected void checkCreateClassLoader(int callerDepth) {
        if (privMgr == null) {
            return;
        }
        Target t = Target.findTarget("MarimbaInternalTarget");
        if (privMgr.isPrivilegeEnabled(t, callerDepth + 1)) {
            return;
        }
        if (this.checkClassLoader(callerDepth + 1)) {
            throw new AppletSecurityException("checkcreateclassloader");
        }
    }

    private boolean isAppletThreadGroup(ThreadGroup g) {
        if (atg == null) {
            try {
                atg = Class.forName("netscape.applet.AppletThreadGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                return false;
            }
        }
        if (g == null) {
            return false;
        }
        Class<?> c = g.getClass();
        while (c != null) {
            if (c == atg) {
                return true;
            }
            c = c.getSuperclass();
        }
        return false;
    }

    protected void checkAccess(Thread t, int callerDepth) {
        if (privMgr != null) {
            if (this.isAppletThreadGroup(t.getThreadGroup())) {
                return;
            }
            if (!privMgr.isPrivilegeEnabled(UniversalThreadAccessTarget, callerDepth + 1)) {
                if (this.marimbaCheckThreadGroup(t.getThreadGroup())) {
                    return;
                }
                throw new AppletSecurityException(UniversalThreadAccessTarget, "thread");
            }
        }
    }

    protected void checkAccess(Thread t, Throwable o, int callerDepth) {
        if (privMgr != null) {
            if (o instanceof ThreadDeath) {
                return;
            }
            if (!privMgr.isPrivilegeEnabled(UniversalThreadAccessTarget, callerDepth + 1)) {
                throw new AppletSecurityException(UniversalThreadAccessTarget, "thread can't send exception");
            }
        }
    }

    public void checkAccess(ThreadGroup g, int callerDepth) {
        if (privMgr != null) {
            if (this.isAppletThreadGroup(g)) {
                return;
            }
            if (!privMgr.isPrivilegeEnabled(UniversalThreadGroupAccessTarget, callerDepth + 1)) {
                if (this.marimbaCheckThreadGroup(g)) {
                    return;
                }
                throw new AppletSecurityException(UniversalThreadGroupAccessTarget, "threadgroup", g.toString());
            }
        }
    }

    protected void checkExit(int status, int callerDepth) {
        if (privMgr != null && !privMgr.isPrivilegeEnabled(UniversalExitAccessTarget, callerDepth + 1)) {
            throw new AppletSecurityException(UniversalExitAccessTarget, "checkexit", String.valueOf(status));
        }
    }

    protected void checkExec(String cmd, int callerDepth) {
        if (privMgr != null && !privMgr.isPrivilegeEnabled(UniversalExecAccessTarget, callerDepth + 1)) {
            throw new AppletSecurityException(UniversalExecAccessTarget, "checkexec", cmd);
        }
    }

    protected void checkLink(String lib, int callerDepth) {
        if (privMgr != null && !privMgr.isPrivilegeEnabled(UniversalLinkAccessTarget, callerDepth + 1)) {
            throw new AppletSecurityException(UniversalLinkAccessTarget, "checklink", lib);
        }
    }

    protected void checkPropertiesAccess(int callerDepth) {
        if (privMgr != null && !privMgr.isPrivilegeEnabled(UniversalPropertyWriteTarget, callerDepth + 1)) {
            throw new AppletSecurityException(UniversalPropertyWriteTarget, "checkpropsaccess");
        }
    }

    protected void checkPropertyAccess(String key, int callerDepth) {
        if (privMgr != null && !privMgr.isPrivilegeEnabled(UniversalPropertyReadTarget, callerDepth + 1)) {
            throw new AppletSecurityException(UniversalPropertyReadTarget, "checkpropsaccess.key");
        }
    }

    protected void checkRead(String file, int callerDepth) {
        ClassLoader loader = this.currentClassLoader();
        if (loader != null) {
            this.checkRead(file, loader.getCodeBase(), callerDepth + 1);
            return;
        }
        this.checkRead(file, null, callerDepth + 1);
    }

    private static boolean directoryContainsFile(String dir, String file) {
        SecurityManager.enablePrivilege((String)"UniversalFileRead");
        SecurityManager.enablePrivilege((String)"UniversalPropertyRead");
        try {
            file = new File(file).getCanonicalPath();
            dir = new File(dir).getCanonicalPath();
        }
        catch (IOException iOException) {
            return false;
        }
        if (file.equals(dir)) {
            return true;
        }
        if (!file.startsWith(dir)) {
            return false;
        }
        int sepIndex = dir.length();
        if (file.charAt(sepIndex) == File.separatorChar) {
            return true;
        }
        return sepIndex > 0 && dir.charAt(sepIndex - 1) == File.separatorChar;
    }

    private static String unEscapeFileSpecificChars(String original) {
        int i;
        String retval = original;
        int past = 0;
        while ((i = retval.indexOf(37, past)) >= 0) {
            past = i + 1;
            String replacement = null;
            int continuation = i + 3;
            if (continuation > retval.length()) continue;
            String hex = retval.substring(i + 1, continuation);
            try {
                replacement = new Character((char)Integer.parseInt(hex, 16)).toString();
            }
            catch (NumberFormatException numberFormatException) {
                continue;
            }
            if (":/.\\|".indexOf(replacement) == -1) continue;
            retval = String.valueOf(retval.substring(0, i)) + replacement + retval.substring(continuation);
        }
        if (File.separatorChar == '\\') {
            if (retval.charAt(0) == '/' && (retval.charAt(2) == '|' || retval.charAt(2) == ':')) {
                retval = retval.substring(1);
            }
            if (retval.charAt(1) == '|') {
                retval = String.valueOf(retval.substring(0, 1)) + ":" + retval.substring(2);
            }
            retval = retval.replace('/', '\\');
        }
        return retval;
    }

    protected void checkRead(String file, URL base, int callerDepth) {
        if (privMgr == null) {
            return;
        }
        if (privMgr.isPrivilegeEnabled(UniversalFileReadTarget, callerDepth + 1)) {
            return;
        }
        Target[] targetArray = new Target[]{ParamFileReadTarget};
        if (privMgr.isPrivilegeEnabled(targetArray, callerDepth + 1, file)) {
            return;
        }
        String dir = null;
        if (base != null && base.getProtocol().equals("file") && AppletSecurity.directoryContainsFile(dir = AppletSecurity.unEscapeFileSpecificChars(base.getFile()), file)) {
            return;
        }
        if (this.marimbaCheckAccess(file, true)) {
            return;
        }
        if (dir != null) {
            throw new AppletSecurityException(UniversalFileReadTarget, "checkread", "Codebase '" + dir + "' does not include '" + file + "'");
        }
        throw new AppletSecurityException(UniversalFileReadTarget, "checkread", "Read of '" + file + "' not permitted");
    }

    protected void checkRead(String file, Object context, int callerDepth) {
        this.checkRead(file);
        if (context != null) {
            this.checkRead(file, (URL)context, callerDepth + 1);
        }
    }

    protected void checkWrite(String file, int callerDepth) {
        if (privMgr == null) {
            return;
        }
        if (privMgr.isPrivilegeEnabled(UniversalFileWriteTarget, callerDepth + 1)) {
            return;
        }
        Target[] targetArray = new Target[]{ParamFileWriteTarget};
        if (privMgr.isPrivilegeEnabled(targetArray, callerDepth + 1, file)) {
            return;
        }
        if (this.marimbaCheckAccess(file, false)) {
            return;
        }
        throw new AppletSecurityException(UniversalFileWriteTarget, "checkwrite", file);
    }

    protected void checkRead(FileDescriptor fd, int callerDepth) {
        if (!fd.valid()) {
            throw new AppletSecurityException("checkread", "invalid file descriptor");
        }
        if (privMgr == null) {
            return;
        }
        if (privMgr.isPrivilegeEnabled(UniversalFdReadTarget, callerDepth + 1)) {
            return;
        }
        throw new AppletSecurityException(UniversalFdReadTarget, "checkread");
    }

    protected void checkWrite(FileDescriptor fd, int callerDepth) {
        if (!fd.valid()) {
            throw new AppletSecurityException("checkwrite.fd", "invalid file descriptor");
        }
        if (privMgr == null) {
            return;
        }
        if (privMgr.isPrivilegeEnabled(UniversalFdWriteTarget, callerDepth + 1)) {
            return;
        }
        throw new AppletSecurityException(UniversalFdWriteTarget, "fd.write");
    }

    protected void checkDelete(String file, int callerDepth) {
        if (privMgr != null && !privMgr.isPrivilegeEnabled(UniversalFileDeleteTarget, callerDepth + 1)) {
            if (this.marimbaCheckAccess(file, false)) {
                return;
            }
            throw new AppletSecurityException(UniversalFileDeleteTarget, "checkdelete", file);
        }
    }

    protected void checkListen(int port, int callerDepth) {
        if (privMgr == null) {
            return;
        }
        if (privMgr.isPrivilegeEnabled(UniversalListenTarget, callerDepth + 1)) {
            return;
        }
        if (port > 0 && port < 1024) {
            throw new AppletSecurityException(UniversalListenTarget, "checklisten", String.valueOf(port));
        }
    }

    protected void checkAccept(String host, int port, int callerDepth) {
        if (privMgr == null) {
            return;
        }
        if (privMgr.isPrivilegeEnabled(UniversalAcceptTarget, callerDepth + 1)) {
            return;
        }
        if (port > 0 && port < 1024) {
            throw new AppletSecurityException(UniversalAcceptTarget, "checkaccept", host, String.valueOf(port));
        }
        this.checkConnect(host, port, callerDepth + 1);
    }

    protected void checkConnect(String host, int port, int callerDepth) {
        ClassLoader loader = this.currentClassLoader();
        if (loader == null) {
            if (privMgr == null || privMgr.isPrivilegeEnabled(UniversalConnectTarget, callerDepth + 1)) {
                return;
            }
            if (privMgr.getBoolPref("signed.applets.low_security_for_local_classes")) {
                return;
            }
            throw new AppletSecurityException(UniversalConnectTarget, AppletSecurity.connectErrorString("local-classpath-classes", host));
        }
        String checkHost = CastanetChannelInfo.marimbaGetHost((ClassLoader)loader);
        if (checkHost == null) {
            checkHost = loader.getCodeBase().getHost();
        }
        this.checkConnect(checkHost, host, callerDepth + 1);
    }

    protected void checkConnect(String host, int port, Object context, int callerDepth) {
        this.checkConnect(host, port, callerDepth + 1);
        if (context != null) {
            this.checkConnect(((URL)context).getHost(), host, callerDepth + 1);
        }
    }

    private static String connectErrorString(String fromHost, String toHost) {
        return "Couldn't connect to '" + toHost + "' with origin from '" + fromHost + "'.";
    }

    /*
     * Exception decompiling
     */
    protected void checkConnect(String fromHost, String toHost, boolean trustP, int callerDepth) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 0[TRYBLOCK]], but top level block is 12[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void checkConnect(String fromHost, String toHost, int callerDepth) {
        this.checkConnect(fromHost, toHost, Boolean.getBoolean("trustProxy"), callerDepth + 1);
    }

    protected void checkURLConnect(URL url, int callerDepth) {
        if (privMgr == null || privMgr.isPrivilegeEnabled(UniversalConnectTarget, callerDepth + 1)) {
            return;
        }
        ClassLoader loader = this.currentClassLoader();
        if (loader == null) {
            if (privMgr.getBoolPref("signed.applets.low_security_for_local_classes")) {
                return;
            }
            throw new AppletSecurityException(UniversalConnectTarget, "class from local disk trying to access url", url.toExternalForm());
        }
        this.checkURLConnectHelper(loader.getCodeBase(), url, callerDepth + 1);
    }

    protected void checkURLConnect(URL codeBaseURL, URL archiveURL, int callerDepth) {
        if (privMgr == null || privMgr.isPrivilegeEnabled(UniversalConnectTarget, callerDepth + 1)) {
            return;
        }
        this.checkURLConnectHelper(codeBaseURL, archiveURL, callerDepth + 1);
    }

    private void checkURLConnectHelper(URL codeBaseURL, URL targetURL, int callerDepth) {
        String protocol = targetURL.getProtocol();
        String checkHost = null;
        ClassLoader loader = this.currentClassLoader();
        if (loader != null) {
            checkHost = CastanetChannelInfo.marimbaGetHost((ClassLoader)loader);
        }
        if (checkHost == null) {
            checkHost = codeBaseURL.getHost();
        }
        this.checkConnect(checkHost, targetURL.getHost(), callerDepth + 1);
        String codeBaseProtocol = codeBaseURL.getProtocol();
        if (protocol.equals("http") || protocol.equals("https") || protocol.equals("castanet") || protocol.equals("ftp") || protocol.equals("gopher")) {
            if (codeBaseProtocol.equals("http") || codeBaseProtocol.equals("https") || codeBaseProtocol.equals("castanet")) {
                return;
            }
            throw new AppletSecurityException("protocol", "Cannot access '" + protocol + "' from a codebase protocol of '" + codeBaseProtocol + "'");
        }
        if (protocol.equals("file") && codeBaseProtocol.equals("file")) {
            String file = AppletSecurity.unEscapeFileSpecificChars(targetURL.getFile());
            this.checkRead(file, codeBaseURL, callerDepth + 1);
            return;
        }
        throw new AppletSecurityException("protocol", protocol);
    }

    protected void checkMulticast(InetAddress maddr, int callerDepth) {
        if (privMgr != null && !privMgr.isPrivilegeEnabled(UniversalMulticastTarget, callerDepth + 1)) {
            throw new AppletSecurityException(UniversalMulticastTarget, "can not access IP multicast");
        }
    }

    protected void checkMulticast(InetAddress maddr, byte ttl, int callerDepth) {
        if (privMgr != null && !privMgr.isPrivilegeEnabled(UniversalMulticastTarget, callerDepth + 1)) {
            throw new AppletSecurityException(UniversalMulticastTarget, "can not access IP multicast");
        }
    }

    public boolean checkTopLevelWindow(Object window) {
        this.marimbaCheckTopLevelWindow(window);
        return privMgr == null || privMgr.isPrivilegeEnabled(UniversalTopLevelWindowTarget, 2);
    }

    public void checkPackageAccess(String pkg) {
        if (!this.inClassLoader()) {
            return;
        }
        if (privMgr == null || privMgr.isPrivilegeEnabled(UniversalPackageAccessTarget, 2)) {
            return;
        }
        int i = pkg.indexOf(46);
        while (i > 0) {
            String subpkg = pkg.substring(0, i);
            if (Boolean.getBoolean("package.restrict.access." + subpkg)) {
                throw new AppletSecurityException(UniversalPackageAccessTarget, "checkpackageaccess", pkg);
            }
            i = pkg.indexOf(46, i + 1);
        }
    }

    public void checkPackageDefinition(String pkg) {
        if (!this.inClassLoader()) {
            return;
        }
        if (privMgr == null || privMgr.isPrivilegeEnabled(UniversalPackageDefinitionTarget, 2)) {
            return;
        }
        int i = pkg.indexOf(46);
        while (i > 0) {
            String subpkg = pkg.substring(0, i);
            if (Boolean.getBoolean("package.restrict.definition." + subpkg)) {
                throw new AppletSecurityException(UniversalPackageDefinitionTarget, "cannot define package:" + pkg);
            }
            i = pkg.indexOf(46, i + 1);
        }
    }

    public void checkSetFactory() {
        if (privMgr != null && !privMgr.isPrivilegeEnabled(UniversalSetFactoryTarget, 2)) {
            throw new AppletSecurityException(UniversalSetFactoryTarget, "cannot set factory");
        }
    }

    public void checkMemberAccess(Class clazz, int which) {
        this.checkMemberAccess(clazz, which, 2);
    }

    protected void checkMemberAccess(Class clazz, int which, int callerDepth) {
        if (which == 0) {
            return;
        }
        if (privMgr == null) {
            return;
        }
        if (privMgr.isPrivilegeEnabled(UniversalMemberAccessTarget, callerDepth + 1)) {
            return;
        }
        throw new AppletSecurityException(UniversalMemberAccessTarget, "member access");
    }

    public void checkPrintJobAccess() {
        if (privMgr != null && !privMgr.isPrivilegeEnabled(UniversalPrintJobAccessTarget, 2)) {
            throw new AppletSecurityException(UniversalPrintJobAccessTarget, "checkgetprintjob");
        }
    }

    public void checkSystemClipboardAccess() {
        if (privMgr != null && !privMgr.isPrivilegeEnabled(UniversalSystemClipboardAccessTarget, 2)) {
            throw new AppletSecurityException(UniversalSystemClipboardAccessTarget, "checksystemclipboardaccess");
        }
    }

    public void checkAwtEventQueueAccess() {
        if (privMgr != null && !privMgr.isPrivilegeEnabled(UniversalAwtEventQueueAccessTarget, 2)) {
            throw new AppletSecurityException(UniversalAwtEventQueueAccessTarget, "checkawteventqueueaccess");
        }
    }

    public void checkSecurityAccess(String provider) {
        if (privMgr != null && !privMgr.isPrivilegeEnabled(UniversalSecurityProviderTarget, 2)) {
            throw new AppletSecurityException(UniversalSecurityProviderTarget, "security operation: " + provider);
        }
    }

    protected void checkCreateSecurityManagerAccess(int callerDepth) {
        if (privMgr != null && !privMgr.isPrivilegeEnabled(CreateSecurityManagerTarget, callerDepth + 1)) {
            throw new AppletSecurityException(CreateSecurityManagerTarget, "can't create SecurityManager");
        }
    }

    protected void checkResourceAccess(String resource, int callerDepth) {
        String ext;
        int idx = resource.lastIndexOf(".");
        if (idx >= 0 && resourceExtTable.get(ext = resource.substring(idx)) != null) {
            return;
        }
        if (privMgr != null && !privMgr.isPrivilegeEnabled(UniversalPropertyReadTarget, callerDepth + 1)) {
            throw new AppletSecurityException(UniversalPropertyReadTarget, "checkResourceAccess");
        }
    }

    public static void addToResourceExtensionTable(String resourceExtension) {
        if (resourceExtTable.get(resourceExtension) != null) {
            return;
        }
        if (privMgr != null && !privMgr.isPrivilegeEnabled(UniversalPropertyWriteTarget, 1)) {
            throw new AppletSecurityException(UniversalPropertyWriteTarget, "checkResourceAccess");
        }
        resourceExtTable.put(resourceExtension, Boolean.TRUE);
    }

    private static void loadResourceExtTable() {
        Boolean valid = Boolean.TRUE;
        resourceExtTable.put(".txt", valid);
        resourceExtTable.put(".text", valid);
        resourceExtTable.put(".html", valid);
        resourceExtTable.put(".htm", valid);
        resourceExtTable.put(".rtf", valid);
        resourceExtTable.put(".pdf", valid);
        resourceExtTable.put(".tex", valid);
        resourceExtTable.put(".latex", valid);
        resourceExtTable.put(".dvi", valid);
        resourceExtTable.put(".texi", valid);
        resourceExtTable.put(".texi", valid);
        resourceExtTable.put(".vcf", valid);
        resourceExtTable.put(".gif", valid);
        resourceExtTable.put(".jpeg", valid);
        resourceExtTable.put(".jpg", valid);
        resourceExtTable.put(".jpe", valid);
        resourceExtTable.put(".jfif", valid);
        resourceExtTable.put(".pjpeg", valid);
        resourceExtTable.put(".pjp", valid);
        resourceExtTable.put(".tiff", valid);
        resourceExtTable.put(".tif", valid);
        resourceExtTable.put(".ras", valid);
        resourceExtTable.put(".xbm", valid);
        resourceExtTable.put(".xpm", valid);
        resourceExtTable.put(".xwd", valid);
        resourceExtTable.put(".pnm", valid);
        resourceExtTable.put(".pbm", valid);
        resourceExtTable.put(".pgm", valid);
        resourceExtTable.put(".ppm", valid);
        resourceExtTable.put(".rgb", valid);
        resourceExtTable.put(".bmp", valid);
        resourceExtTable.put(".pcd", valid);
        resourceExtTable.put(".png", valid);
        resourceExtTable.put(".ief", valid);
        resourceExtTable.put(".fif", valid);
        resourceExtTable.put(".au", valid);
        resourceExtTable.put(".snd", valid);
        resourceExtTable.put(".aif", valid);
        resourceExtTable.put(".aiff", valid);
        resourceExtTable.put(".aifc", valid);
        resourceExtTable.put(".wav", valid);
        resourceExtTable.put(".mp2", valid);
        resourceExtTable.put(".mpa", valid);
        resourceExtTable.put(".abs", valid);
        resourceExtTable.put(".mpega", valid);
        resourceExtTable.put(".ra", valid);
        resourceExtTable.put(".ram", valid);
        resourceExtTable.put(".mpeg", valid);
        resourceExtTable.put(".mpg", valid);
        resourceExtTable.put(".mpe", valid);
        resourceExtTable.put(".mpv", valid);
        resourceExtTable.put(".vbs", valid);
        resourceExtTable.put(".mpegv", valid);
        resourceExtTable.put(".mpv2", valid);
        resourceExtTable.put(".mpv2v", valid);
        resourceExtTable.put(".qt", valid);
        resourceExtTable.put(".mov", valid);
        resourceExtTable.put(".moov", valid);
        resourceExtTable.put(".avi", valid);
        resourceExtTable.put(".hqx", valid);
        resourceExtTable.put(".sit", valid);
        resourceExtTable.put(".ai", valid);
        resourceExtTable.put(".eps", valid);
        resourceExtTable.put(".ps", valid);
        resourceExtTable.put(".pac", valid);
        resourceExtTable.put(".jsc", valid);
        resourceExtTable.put(".doc", valid);
        resourceExtTable.put(".dot", valid);
        resourceExtTable.put(".xls", valid);
        resourceExtTable.put(".xlt", valid);
        resourceExtTable.put(".xlm", valid);
        resourceExtTable.put(".xld", valid);
        resourceExtTable.put(".xla", valid);
        resourceExtTable.put(".xlc", valid);
        resourceExtTable.put(".xlw", valid);
        resourceExtTable.put(".xll", valid);
        resourceExtTable.put(".mdb", valid);
        resourceExtTable.put(".mda", valid);
        resourceExtTable.put(".mde", valid);
        resourceExtTable.put(".ppt", valid);
        resourceExtTable.put(".pot", valid);
        resourceExtTable.put(".ppa", valid);
        resourceExtTable.put(".pps", valid);
        resourceExtTable.put(".pwz", valid);
        resourceExtTable.put(".scd", valid);
        resourceExtTable.put(".sch", valid);
        resourceExtTable.put(".sc2", valid);
        resourceExtTable.put(".lwp", valid);
        resourceExtTable.put(".sam", valid);
        resourceExtTable.put(".123", valid);
        resourceExtTable.put(".wk4", valid);
        resourceExtTable.put(".wk3", valid);
        resourceExtTable.put(".wk1", valid);
        resourceExtTable.put(".apr", valid);
        resourceExtTable.put(".vew", valid);
        resourceExtTable.put(".prz", valid);
        resourceExtTable.put(".pre", valid);
        resourceExtTable.put(".or3", valid);
        resourceExtTable.put(".or2", valid);
        resourceExtTable.put(".org", valid);
        resourceExtTable.put(".scm", valid);
        resourceExtTable.put(".wpd", valid);
        resourceExtTable.put(".wp6", valid);
        resourceExtTable.put(".t", valid);
        resourceExtTable.put(".tr", valid);
        resourceExtTable.put(".roff", valid);
        resourceExtTable.put(".me", valid);
        resourceExtTable.put(".ms", valid);
        resourceExtTable.put(".man", valid);
        resourceExtTable.put(".movie", valid);
        resourceExtTable.put(".properties", valid);
        resourceExtTable.put(".ser", valid);
    }

    protected void unknownLoaderException(String checkType) {
        throw new SecurityException("unknown class loader type.unable to check for " + checkType);
    }

    public void debug(String s) {
        if (debug) {
            System.err.println(s);
        }
    }

    protected boolean isPrivilegeEnabled(String targetStr, int callerDepth) {
        if (privMgr != null) {
            Target target = Target.findTarget(targetStr);
            if (target == null) {
                return false;
            }
            return privMgr.isPrivilegeEnabled(target, callerDepth + 1);
        }
        return true;
    }

    protected boolean securityCheckScopePermission(int callerDepth) {
        if (privMgr != null) {
            return privMgr.isPrivilegeEnabled(SuperUserTarget, callerDepth + 1);
        }
        return true;
    }

    protected Object securitySetScopePermission(int callerDepth) {
        if (privMgr != null) {
            return privMgr.setScopePrivilegeAssistant(callerDepth + 1);
        }
        return null;
    }

    protected Object securitySetScopePermission(int callerDepth, String targetStr) {
        if (privMgr != null) {
            return privMgr.setScopePrivilegeAssistant(callerDepth + 1, targetStr);
        }
        return null;
    }

    public boolean checkMatchPrincipalAlways(int callerDepth) {
        ClassLoader loader = this.currentClassLoader();
        if (loader == null) {
            return true;
        }
        return loader.checkMatchPrincipalAlways(callerDepth + 1);
    }

    public boolean canExtendTrust(Object[] from, Object[] to) {
        if (privMgr != null) {
            return privMgr.canExtendTrust((Principal[])from, (Principal[])to);
        }
        return true;
    }

    public String getNonSystemPrincipalFromStack(Object window) {
        if (privMgr == null) {
            return null;
        }
        if (this.checkTopLevelWindow(window)) {
            return null;
        }
        Class[] classArray = this.getClassContext();
        return privMgr.getNonSystemPrincipalFromStack(classArray);
    }

    public boolean isNotSecurePrincipalFromStack(Object window) {
        if (privMgr == null) {
            return true;
        }
        if (this.checkTopLevelWindow(window)) {
            return false;
        }
        Class[] classArray = this.getClassContext();
        return privMgr.isNotSecurePrincipalFromStack(classArray);
    }

    private boolean marimbaCheckThreadGroup(ThreadGroup group) {
        ClassLoader loader = this.currentClassLoader();
        if (loader == null) {
            return false;
        }
        return CastanetChannelInfo.checkThreadGroup((ClassLoader)loader, (ThreadGroup)group);
    }

    private void marimbaCheckTopLevelWindow(Object window) {
        ClassLoader loader = this.currentClassLoader();
        CastanetChannelInfo.checkTopLevelWindow((ClassLoader)loader, (Object)window);
    }

    private boolean marimbaCheckAccess(String file, boolean readonly) {
        boolean inMarimbaClass = false;
        PrivilegeManager privMgr = PrivilegeManager.getPrivilegeManager();
        if (privMgr != null) {
            try {
                Target target = Target.findTarget("MarimbaAppContextTarget");
                if (target != null) {
                    privMgr.checkPrivilegeEnabled(target);
                    inMarimbaClass = true;
                }
            }
            catch (ForbiddenTargetException forbiddenTargetException) {
                inMarimbaClass = false;
            }
        }
        ClassLoader loader = this.currentClassLoader();
        if (!inMarimbaClass && loader == null) {
            return false;
        }
        return CastanetChannelInfo.marimbaCheckAccess((String)file, (ClassLoader)loader, (boolean)readonly, (boolean)inMarimbaClass);
    }

    public ClassLoader getCurrentClassLoader() {
        PrivilegeManager privMgr = PrivilegeManager.getPrivilegeManager();
        Target target = Target.findTarget("MarimbaAppContextTarget");
        privMgr.checkPrivilegeEnabled(target);
        return this.currentClassLoader();
    }

    static {
        resourceExtTable = new Hashtable();
        dlgCreatorThread = null;
    }
}

