/*
 * Decompiled with CFR 0.152.
 */
package netscape.plugin.composer;

import java.io.File;
import java.io.IOException;
import java.io.StringBufferInputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import netscape.javascript.JSObject;
import netscape.plugin.composer.Composer;
import netscape.plugin.composer.ComposerDocument;
import netscape.plugin.composer.Factory;
import netscape.plugin.composer.GroupPlugin;
import netscape.plugin.composer.ImageEncoder;
import netscape.plugin.composer.ImageEncoderFactory;
import netscape.plugin.composer.ImageEncoderPlugin;
import netscape.plugin.composer.Plugin;
import netscape.plugin.composer.PluginKiller;
import netscape.plugin.composer.PluginRunner;
import netscape.plugin.composer.SortedStringTable;

class PluginManager {
    private SortedStringTable categories = new SortedStringTable();
    private SortedStringTable encoders = new SortedStringTable();
    private SortedStringTable events = new SortedStringTable();
    private Hashtable pluginThreads = new Hashtable();
    private PluginKiller pluginKiller = new PluginKiller();

    public void registerPlugin(String pluginFileName, String iniContents) {
        Properties properties = new Properties();
        File pluginFile = new File(pluginFileName);
        try {
            StringBufferInputStream stream = new StringBufferInputStream(iniContents);
            properties.load(stream);
            stream.close();
        }
        catch (IOException e) {
            System.err.println("Caught exception while parsing .ini contents:\n" + iniContents);
            e.printStackTrace();
        }
        this.registerPlugins(pluginFile, properties);
        this.registerEncoders(pluginFile, properties);
        this.registerEvents(properties);
    }

    public void registerPlugins(File pluginFile, Properties properties) {
        Enumeration plugins = null;
        String factoryName = null;
        try {
            factoryName = PluginManager.trimWhitespace(properties.getProperty("netscape.plugin.composer.Factory", "netscape.plugin.composer.Factory"));
            Factory factory = (Factory)Class.forName(factoryName).newInstance();
            plugins = factory.getPlugins(pluginFile, properties);
        }
        catch (Throwable t) {
            System.err.println("Caught exception while instantiating " + factoryName);
            t.printStackTrace();
        }
        PluginManager.registerPlugins(this.categories, plugins);
    }

    public static Enumeration instantiateClassList(String classNames) {
        Vector result = new Vector();
        if (classNames != null) {
            StringTokenizer tokenizer = new StringTokenizer(classNames, ":");
            while (tokenizer.hasMoreTokens()) {
                String className = PluginManager.trimWhitespace(tokenizer.nextToken());
                try {
                    Object object = Class.forName(className).newInstance();
                    result.addElement(object);
                }
                catch (Throwable t) {
                    System.err.println("Caught exception while instantiating " + className);
                    t.printStackTrace();
                }
            }
        }
        return result.elements();
    }

    protected void registerEvents(Properties properties) {
        String eventHandlers = properties.getProperty("netscape.plugin.composer.eventHandlers", "");
        PluginManager.registerPlugins(this.events, eventHandlers);
    }

    protected static void registerPlugins(SortedStringTable table, String classNames) {
        PluginManager.registerPlugins(table, PluginManager.instantiateClassList(classNames));
    }

    protected static void registerPlugins(SortedStringTable table, Enumeration plugins) {
        if (plugins != null) {
            while (plugins.hasMoreElements()) {
                Plugin plugin = (Plugin)plugins.nextElement();
                if (plugin == null) continue;
                try {
                    table.getOrCreateTable(plugin.getCategory()).put(plugin.getName(), plugin);
                }
                catch (Throwable t) {
                    System.err.println("Trouble registering plugin:" + plugin);
                    t.printStackTrace();
                }
            }
        }
    }

    public static String trimWhitespace(String string) {
        int length = string.length();
        StringBuffer out = new StringBuffer(length);
        int i = 0;
        while (i < length) {
            char c = string.charAt(i);
            if (!Character.isSpace(c)) {
                out.append(c);
            }
            ++i;
        }
        return out.toString();
    }

    public void registerEncoders(File pluginFile, Properties properties) {
        Enumeration encoderList = null;
        String factoryName = null;
        try {
            factoryName = PluginManager.trimWhitespace(properties.getProperty("netscape.plugin.composer.ImageEncoderFactory", "netscape.plugin.composer.ImageEncoderFactory"));
            ImageEncoderFactory factory = (ImageEncoderFactory)Class.forName(factoryName).newInstance();
            encoderList = factory.getImageEncoders(pluginFile, properties);
        }
        catch (Throwable t) {
            System.err.println("Caught exception while instantiating " + factoryName);
            t.printStackTrace();
        }
        if (encoderList != null) {
            while (encoderList.hasMoreElements()) {
                Object object = null;
                try {
                    object = encoderList.nextElement();
                    ImageEncoder encoder = object;
                    this.registerEncoderInstance(encoder);
                }
                catch (Throwable t) {
                    System.err.println("Caught exception while processing " + object);
                    t.printStackTrace();
                }
            }
        }
    }

    private void registerEncoderInstance(ImageEncoder encoder) {
        ImageEncoder.register(encoder);
        String name = encoder.getName();
        this.encoders.put(name, encoder);
    }

    public int getNumberOfCategories() {
        return this.categories.length();
    }

    public int getNumberOfPlugins(int category) {
        SortedStringTable categoryTable = (SortedStringTable)this.categories.get(category);
        if (categoryTable == null) {
            return 0;
        }
        return categoryTable.length();
    }

    public String getCategoryName(int category) {
        return this.categories.getKey(category);
    }

    public String getPluginName(int type, int index) {
        return this.getPlugin(type, index).getName();
    }

    public String getPluginHint(int type, int index) {
        return this.getPlugin(type, index).getHint();
    }

    public boolean performPlugin(Composer composer, int category, int index, String in, String base, String workDirectory, String workDirectoryURL, JSObject jsobject) {
        return this.performPlugin2(composer, this.getPlugin(category, index), in, base, workDirectory, workDirectoryURL, null, null, jsobject);
    }

    public boolean performPluginByName(Composer composer, String pluginName, String in, String base, String workDirectory, String workDirectoryURL, JSObject jsobject) {
        Plugin plugin = null;
        String destinationURL = null;
        String eventName = null;
        try {
            int eventMarker = pluginName.indexOf(58);
            if (eventMarker >= 0) {
                SortedStringTable table;
                eventName = pluginName.substring(0, eventMarker);
                destinationURL = pluginName.substring(eventMarker + 1);
                if (destinationURL.length() == 0) {
                    destinationURL = null;
                }
                if ((table = this.events) != null) {
                    plugin = new GroupPlugin(table);
                }
            } else {
                plugin = (Plugin)Class.forName(pluginName).newInstance();
            }
            if (plugin != null) {
                return this.performPlugin2(composer, plugin, in, base, workDirectory, workDirectoryURL, eventName, destinationURL, jsobject);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return false;
    }

    public boolean performPlugin2(Composer composer, Plugin plugin, String in, String base, String workDirectory, String workDirectoryURL, String eventName, String destinationURL, JSObject jsobject) {
        if (plugin != null) {
            try {
                URL baseURL = base != null ? new URL(base) : null;
                URL workDirectoryURLURL = null;
                URL destinationURLURL = null;
                if (workDirectoryURL != null) {
                    String prefix;
                    String slash = "/";
                    if (!workDirectoryURL.endsWith(slash)) {
                        workDirectoryURL = String.valueOf(workDirectoryURL) + slash;
                    }
                    workDirectoryURLURL = workDirectoryURL.indexOf(prefix = "file:") == 0 ? new URL("file", "", workDirectoryURL.substring(prefix.length())) : new URL(workDirectoryURL);
                }
                if (destinationURL != null) {
                    String prefix = "file:";
                    destinationURLURL = destinationURL.indexOf(prefix) == 0 ? new URL("file", "", destinationURL.substring(prefix.length())) : new URL(destinationURL);
                }
                ComposerDocument document = new ComposerDocument(composer, in, baseURL, workDirectory, workDirectoryURLURL, eventName, destinationURLURL, jsobject);
                SecurityManager.enablePrivilege((String)"SuperUser");
                ThreadGroup threadGroup = new ThreadGroup(Thread.currentThread().getThreadGroup(), plugin.getName());
                Thread thread = new Thread(threadGroup, new PluginRunner(plugin, document, this), plugin.getName());
                thread.start();
                this.pluginThreads.put(composer, threadGroup);
            }
            catch (IOException e) {
                System.err.println("Composer plugin runner threw this exception:");
                e.printStackTrace();
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public void stopPlugin(Composer composer) {
        this.killGroup(composer);
    }

    public int getNumberOfEncoders() {
        return this.encoders.length();
    }

    public String getEncoderName(int index) {
        return this.getEncoder(index).getName();
    }

    public String getEncoderFileType(int index) {
        byte[] fileType = new byte[4];
        this.getEncoder(index).getFileType(fileType);
        return new String(fileType, 0);
    }

    public boolean getEncoderNeedsQuantizedSource(int index) {
        return this.getEncoder(index).needsQuantizedSource();
    }

    public String getEncoderFileExtension(int index) {
        return this.getEncoder(index).getFileExtension();
    }

    public String getEncoderHint(int index) {
        return this.getEncoder(index).getHint();
    }

    protected ImageEncoder getEncoder(int index) {
        return (ImageEncoder)this.encoders.get(index);
    }

    public boolean startEncoder(Composer composer, int index, int width, int height, byte[][] pixels, String fileName) {
        ImageEncoderPlugin encoderPlugin = new ImageEncoderPlugin(this.getEncoder(index), width, height, pixels, fileName);
        return this.performPlugin2(composer, encoderPlugin, null, null, null, null, null, null, null);
    }

    protected Plugin getPlugin(int category, int index) {
        Plugin result = null;
        SortedStringTable categoryTable = (SortedStringTable)this.categories.get(category);
        if (categoryTable != null) {
            result = (Plugin)categoryTable.get(index);
        }
        return result;
    }

    void pluginFinished(Composer composer, int status, Object argument) {
        composer.pluginFinished(status, argument);
        this.killGroup(composer);
    }

    void killGroup(Composer composer) {
        ThreadGroup group = (ThreadGroup)this.pluginThreads.remove(composer);
        if (group != null) {
            this.pluginKiller.kill(group);
        }
    }
}

