/*
 * Decompiled with CFR 0.152.
 */
package netscape.util;

import java.io.IOException;
import java.io.InputStream;
import netscape.application.AWTCompatibility;
import netscape.application.FoundationApplet;
import netscape.util.Archive;
import netscape.util.ArchivingStack;
import netscape.util.ClassInfo;
import netscape.util.ClassTable;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.ExternalCoder;

public class Unarchiver
implements Decoder {
    Archive archive;
    ArchivingStack stack = new ArchivingStack();
    Object[] objectForId;
    boolean[] referenceGivenOut;
    int unarchivedCount;
    Object[] unarchivedObjects;
    ExternalCoder[] unarchivedCoders;
    Object currentObject;
    ClassTable currentTable;
    int currentId;
    int currentColumnCount;
    int currentRow;
    int currentColumn;
    FoundationApplet applet;
    boolean appletInitialized;

    public Unarchiver(Archive archive) {
        this.archive = archive;
    }

    public Archive archive() {
        return this.archive;
    }

    public static Object readObject(InputStream inputStream) throws IOException, CodingException {
        Archive archive = new Archive();
        archive.read(inputStream);
        Unarchiver unarchiver = new Unarchiver(archive);
        int[] rootIds = archive.rootIdentifiers();
        if (rootIds == null || rootIds.length == 0) {
            return null;
        }
        return unarchiver.unarchiveIdentifier(rootIds[0]);
    }

    public Object unarchiveIdentifier(int identifier) throws CodingException {
        Object rootObject;
        if (identifier == 0) {
            return null;
        }
        if (this.objectForId == null) {
            this.referenceGivenOut = new boolean[this.archive.identifierCount()];
            this.objectForId = new Object[this.referenceGivenOut.length];
            this.unarchivedObjects = new Object[this.referenceGivenOut.length];
            this.unarchivedCoders = new ExternalCoder[this.referenceGivenOut.length];
        }
        this.clearFinishList();
        try {
            rootObject = this.objectForIdentifier(identifier);
            this.processFinishList();
        }
        finally {
            Object var4_3 = null;
            this.clearFinishList();
        }
        return rootObject;
    }

    protected Class classForName(String className) throws CodingException {
        Class cls = null;
        if (!this.appletInitialized) {
            this.applet = (FoundationApplet)AWTCompatibility.awtApplet();
            this.appletInitialized = true;
        }
        try {
            cls = this.applet != null ? this.applet.classForName(className) : Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            this.creationException(e.toString(), className);
        }
        catch (NoSuchMethodError e) {
            this.creationException(e.toString(), className);
        }
        return cls;
    }

    protected Object newInstance(String className) throws CodingException {
        Object object = null;
        Class archivedClass = this.classForName(className);
        try {
            object = archivedClass.newInstance();
        }
        catch (InstantiationException e) {
            this.creationException(e.toString(), className);
        }
        catch (IllegalAccessException e) {
            this.creationException(e.toString(), className);
        }
        catch (NoSuchMethodError e) {
            this.creationException(e.toString(), className);
        }
        return object;
    }

    private void creationException(String baseException, String className) throws CodingException {
        throw new CodingException(String.valueOf(baseException) + ".  Class " + className + " must be public and define a constructor taking no arguments.");
    }

    private Object objectForIdentifier(int id) throws CodingException {
        Object object = this.objectForId[id];
        if (object != null) {
            this.referenceGivenOut[id] = true;
            return object;
        }
        if (id == 0) {
            return null;
        }
        ClassTable table = this.archive.classTableForIdentifier(id);
        String className = table.className();
        ExternalCoder coder = this.archive.externalCoderForName(className);
        object = coder != null ? coder.newInstance(className) : this.newInstance(className);
        if (!table.hasUniqueStrings()) {
            ClassInfo info = new ClassInfo(className);
            if (coder != null) {
                coder.describeClassInfo(object, info);
            } else {
                ((Codable)object).describeClassInfo(info);
            }
            table.uniqueStrings(info);
        }
        this.addToFinishList(coder, object);
        this.objectForId[id] = object;
        this.pushUnarchivingState(object, id);
        if (coder != null) {
            coder.decode(object, this);
        } else {
            ((Codable)object).decode(this);
        }
        this.popUnarchivingState();
        return this.objectForId[id];
    }

    private void pushUnarchivingState(Object object, int id) {
        this.stack.pushUnarchiver(this);
        this.currentObject = object;
        this.currentTable = this.archive.classTableForIdentifier(id);
        this.currentId = id;
        this.currentRow = this.archive.rowForIdentifier(id);
        this.currentColumn = -1;
        this.currentColumnCount = this.currentTable.fieldCount;
    }

    private void popUnarchivingState() {
        this.stack.popUnarchiver(this);
    }

    private void addToFinishList(ExternalCoder coder, Object object) {
        this.unarchivedCoders[this.unarchivedCount] = coder;
        this.unarchivedObjects[this.unarchivedCount] = object;
        ++this.unarchivedCount;
    }

    private void processFinishList() throws CodingException {
        int count = this.unarchivedCount;
        int i = 0;
        while (i < count) {
            ExternalCoder coder = this.unarchivedCoders[i];
            Object object = this.unarchivedObjects[i];
            if (coder != null) {
                coder.finishDecoding(object);
            } else {
                ((Codable)object).finishDecoding();
            }
            this.unarchivedCoders[i] = null;
            this.unarchivedObjects[i] = null;
            ++i;
        }
        this.unarchivedCount = 0;
    }

    private void clearFinishList() {
        int count = this.unarchivedCount;
        int i = 0;
        while (i < count) {
            this.unarchivedCoders[i] = null;
            this.unarchivedObjects[i] = null;
            ++i;
        }
        this.unarchivedCount = 0;
    }

    private void prepareToUnarchiveField(String key) throws CodingException {
        int count = this.currentColumnCount;
        String[] fieldNames = this.currentTable.fieldNames;
        int i = this.currentColumn + 1;
        while (i < count) {
            if (key == fieldNames[i]) {
                this.currentColumn = i;
                return;
            }
            ++i;
        }
        this.currentColumn = this.currentTable.columnForField(key);
        if (this.currentColumn < 0) {
            throw new CodingException("Unknown field name: " + key);
        }
    }

    public int versionForClassName(String className) throws CodingException {
        return this.currentTable.versionForClassName(className);
    }

    public boolean decodeBoolean(String key) throws CodingException {
        this.prepareToUnarchiveField(key);
        return this.currentTable.booleanAt(this.currentRow, this.currentColumn);
    }

    public boolean[] decodeBooleanArray(String key) throws CodingException {
        this.prepareToUnarchiveField(key);
        return this.currentTable.booleanArrayAt(this.currentRow, this.currentColumn);
    }

    public char decodeChar(String key) throws CodingException {
        this.prepareToUnarchiveField(key);
        return this.currentTable.charAt(this.currentRow, this.currentColumn);
    }

    public char[] decodeCharArray(String key) throws CodingException {
        this.prepareToUnarchiveField(key);
        return this.currentTable.charArrayAt(this.currentRow, this.currentColumn);
    }

    public byte decodeByte(String key) throws CodingException {
        this.prepareToUnarchiveField(key);
        return this.currentTable.byteAt(this.currentRow, this.currentColumn);
    }

    public byte[] decodeByteArray(String key) throws CodingException {
        this.prepareToUnarchiveField(key);
        return this.currentTable.byteArrayAt(this.currentRow, this.currentColumn);
    }

    public short decodeShort(String key) throws CodingException {
        this.prepareToUnarchiveField(key);
        return this.currentTable.shortAt(this.currentRow, this.currentColumn);
    }

    public short[] decodeShortArray(String key) throws CodingException {
        this.prepareToUnarchiveField(key);
        return this.currentTable.shortArrayAt(this.currentRow, this.currentColumn);
    }

    public int decodeInt(String key) throws CodingException {
        this.prepareToUnarchiveField(key);
        return this.currentTable.intAt(this.currentRow, this.currentColumn);
    }

    public int[] decodeIntArray(String key) throws CodingException {
        this.prepareToUnarchiveField(key);
        return this.currentTable.intArrayAt(this.currentRow, this.currentColumn);
    }

    public long decodeLong(String key) throws CodingException {
        this.prepareToUnarchiveField(key);
        return this.currentTable.longAt(this.currentRow, this.currentColumn);
    }

    public long[] decodeLongArray(String key) throws CodingException {
        this.prepareToUnarchiveField(key);
        return this.currentTable.longArrayAt(this.currentRow, this.currentColumn);
    }

    public float decodeFloat(String key) throws CodingException {
        this.prepareToUnarchiveField(key);
        return this.currentTable.floatAt(this.currentRow, this.currentColumn);
    }

    public float[] decodeFloatArray(String key) throws CodingException {
        this.prepareToUnarchiveField(key);
        return this.currentTable.floatArrayAt(this.currentRow, this.currentColumn);
    }

    public double decodeDouble(String key) throws CodingException {
        this.prepareToUnarchiveField(key);
        return this.currentTable.doubleAt(this.currentRow, this.currentColumn);
    }

    public double[] decodeDoubleArray(String key) throws CodingException {
        this.prepareToUnarchiveField(key);
        return this.currentTable.doubleArrayAt(this.currentRow, this.currentColumn);
    }

    public String decodeString(String key) throws CodingException {
        this.prepareToUnarchiveField(key);
        return this.currentTable.stringAt(this.currentRow, this.currentColumn);
    }

    public String[] decodeStringArray(String key) throws CodingException {
        this.prepareToUnarchiveField(key);
        return this.currentTable.stringArrayAt(this.currentRow, this.currentColumn);
    }

    public Object decodeObject(String key) throws CodingException {
        this.prepareToUnarchiveField(key);
        return this.objectForIdentifier(this.currentTable.identifierAt(this.currentRow, this.currentColumn));
    }

    public Object[] decodeObjectArray(String key) throws CodingException {
        this.prepareToUnarchiveField(key);
        int[] ids = this.currentTable.identifierArrayAt(this.currentRow, this.currentColumn);
        if (ids == null) {
            return null;
        }
        Object[] objects = new Object[ids.length];
        int i = 0;
        while (i < ids.length) {
            objects[i] = this.objectForIdentifier(ids[i]);
            ++i;
        }
        return objects;
    }

    public void replaceObject(Object replacement) throws CodingException {
        if (this.referenceGivenOut[this.currentId]) {
            throw new CodingException("Circular replacement exception");
        }
        this.objectForId[this.currentId] = replacement;
    }
}

