/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.Application;
import netscape.application.Event;
import netscape.application.EventFilter;
import netscape.application.EventLoop;
import netscape.application.EventProcessor;
import netscape.application.Target;
import netscape.application.TimerQueue;
import netscape.util.InconsistencyException;
import netscape.util.Vector;

public class Timer
implements EventProcessor,
EventFilter {
    EventLoop eventLoop;
    Target target;
    String command;
    Object data;
    long timeStamp;
    int initialDelay;
    int delay;
    boolean repeats = true;
    boolean coalesce = true;
    boolean removeEvents;
    long expirationTime;
    Timer nextTimer;
    boolean running;

    public Timer(EventLoop eventLoop, Target target, String command, int delay) {
        if (eventLoop == null) {
            throw new InconsistencyException("eventLoop parameter is null");
        }
        this.eventLoop = eventLoop;
        this.target = target;
        this.command = command;
        this.setDelay(delay);
        this.setInitialDelay(delay);
    }

    public Timer(Target target, String command, int delay) {
        this(Application.application().eventLoop(), target, command, delay);
    }

    TimerQueue timerQueue() {
        if (this.eventLoop != null && this.eventLoop.application != null) {
            return this.eventLoop.application.timerQueue();
        }
        return Application.application().timerQueue();
    }

    public EventLoop eventLoop() {
        return this.eventLoop;
    }

    public void setTarget(Target target) {
        this.target = target;
    }

    public Target target() {
        return this.target;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public String command() {
        return this.command;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public Object data() {
        return this.data;
    }

    public void setDelay(int delay) {
        if (delay < 0) {
            throw new InconsistencyException("Invalid initial delay: " + delay);
        }
        this.delay = delay;
        if (this.isRunning()) {
            TimerQueue queue = this.timerQueue();
            queue.removeTimer(this);
            this.removeEvents();
            queue.addTimer(this, System.currentTimeMillis() + (long)delay);
        }
    }

    public int delay() {
        return this.delay;
    }

    public void setInitialDelay(int initialDelay) {
        if (initialDelay < 0) {
            throw new InconsistencyException("Invalid initial delay: " + initialDelay);
        }
        this.initialDelay = initialDelay;
    }

    public int initialDelay() {
        return this.initialDelay;
    }

    public void setRepeats(boolean flag) {
        this.repeats = flag;
    }

    public boolean repeats() {
        return this.repeats;
    }

    public long timeStamp() {
        return this.timeStamp;
    }

    public void setCoalesce(boolean flag) {
        this.coalesce = flag;
    }

    public boolean doesCoalesce() {
        return this.coalesce;
    }

    public void start() {
        this.timerQueue().addTimer(this, System.currentTimeMillis() + (long)this.initialDelay());
    }

    public boolean isRunning() {
        return this.timerQueue().containsTimer(this);
    }

    public void stop() {
        this.timerQueue().removeTimer(this);
        this.removeEvents();
    }

    synchronized void removeEvents() {
        this.removeEvents = true;
        this.eventLoop.filterEvents(this);
    }

    synchronized boolean peekEvent() {
        this.removeEvents = false;
        return this.eventLoop.filterEvents(this) != null;
    }

    public Object filterEvents(Vector events) {
        int count = events.count();
        while (count-- > 0) {
            Event event = (Event)events.elementAt(count);
            if (event.processor() != this) continue;
            if (this.removeEvents) {
                events.removeElementAt(count);
                continue;
            }
            return event;
        }
        return null;
    }

    public void processEvent(Event event) {
        this.timeStamp = event.timeStamp;
        if (this.target != null) {
            this.target.performCommand(this.command, this.data);
        }
    }

    public String toString() {
        return "Timer {target = " + this.target + "; command = " + this.command + "; delay = " + this.delay + "; initialDelay = " + this.initialDelay + "; repeats = " + this.repeats + "}";
    }

    void post(long timeStamp) {
        if (!this.coalesce || !this.peekEvent()) {
            Event newEvent = new Event(timeStamp);
            newEvent.setProcessor(this);
            this.eventLoop.addEvent(newEvent);
        }
    }
}

