/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.BezelBorder;
import netscape.application.Border;
import netscape.application.Color;
import netscape.application.DragSession;
import netscape.application.DragSource;
import netscape.application.EmptyBorder;
import netscape.application.Graphics;
import netscape.application.Image;
import netscape.application.MouseEvent;
import netscape.application.Rect;
import netscape.application.View;
import netscape.util.ClassInfo;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;

public class DragWell
extends View
implements DragSource {
    Image image;
    String dataType;
    Object data;
    Border border = BezelBorder.loweredBezel();
    boolean enabled = true;
    static final String IMAGE_KEY = "image";
    static final String DATA_KEY = "data";
    static final String DATATYPE_KEY = "dataType";
    static final String ENABLED_KEY = "enabled";
    static final String BORDER_KEY = "border";

    public DragWell() {
        this(0, 0, 0, 0);
    }

    public DragWell(Rect rect) {
        this(rect.x, rect.y, rect.width, rect.height);
    }

    public DragWell(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    public boolean isTransparent() {
        return false;
    }

    public void setImage(Image anImage) {
        if (this.image != anImage) {
            this.image = anImage;
            this.draw();
        }
    }

    public Image image() {
        return this.image;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public String dataType() {
        return this.dataType;
    }

    public void setData(Object anObject) {
        this.data = anObject;
    }

    public Object data() {
        return this.data;
    }

    public void setEnabled(boolean flag) {
        if (this.enabled != flag) {
            this.enabled = flag;
            this.draw();
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setBorder(Border newBorder) {
        if (newBorder == null) {
            newBorder = EmptyBorder.emptyBorder();
        }
        this.border = newBorder;
    }

    public Border border() {
        return this.border;
    }

    public boolean mouseDown(MouseEvent event) {
        if (!this.enabled) {
            return false;
        }
        Image theImage = this.image();
        if (theImage == null) {
            return false;
        }
        Rect tmpRect = new Rect((this.width() - theImage.width()) / 2, (this.height() - theImage.height()) / 2, theImage.width(), theImage.height());
        if (!tmpRect.contains(event.x, event.y)) {
            return false;
        }
        new DragSession(this, theImage, tmpRect.x, tmpRect.y, event.x, event.y, this.dataType(), this.data);
        return true;
    }

    public void drawView(Graphics g) {
        g.setColor(Color.lightGray);
        g.fillRect(0, 0, this.width(), this.height());
        Image theImage = this.image();
        if (theImage != null) {
            theImage.drawCentered(g, 0, 0, this.width(), this.height());
        }
        this.border.drawInRect(g, 0, 0, this.width(), this.height());
    }

    public View sourceView(DragSession session) {
        return this;
    }

    public void dragWasAccepted(DragSession session) {
    }

    public boolean dragWasRejected(DragSession session) {
        return true;
    }

    public void describeClassInfo(ClassInfo info) {
        super.describeClassInfo(info);
        info.addClass("netscape.application.DragWell", 1);
        info.addField(IMAGE_KEY, (byte)18);
        info.addField(DATA_KEY, (byte)18);
        info.addField(DATATYPE_KEY, (byte)16);
        info.addField(ENABLED_KEY, (byte)0);
        info.addField(BORDER_KEY, (byte)18);
    }

    public void encode(Encoder encoder) throws CodingException {
        super.encode(encoder);
        encoder.encodeObject(IMAGE_KEY, this.image);
        encoder.encodeObject(DATA_KEY, (Codable)this.data);
        encoder.encodeString(DATATYPE_KEY, this.dataType);
        encoder.encodeBoolean(ENABLED_KEY, this.enabled);
        if (this.border instanceof EmptyBorder) {
            encoder.encodeObject(BORDER_KEY, null);
            return;
        }
        encoder.encodeObject(BORDER_KEY, this.border);
    }

    public void decode(Decoder decoder) throws CodingException {
        super.decode(decoder);
        this.image = (Image)decoder.decodeObject(IMAGE_KEY);
        this.data = decoder.decodeObject(DATA_KEY);
        this.dataType = decoder.decodeString(DATATYPE_KEY);
        this.enabled = decoder.decodeBoolean(ENABLED_KEY);
        this.setBorder((Border)decoder.decodeObject(BORDER_KEY));
    }
}

