/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.client;

import java.io.UnsupportedEncodingException;
import java.util.Vector;
import netscape.ldap.ber.stream.BEROctetString;

class JDAPFilterOpers {
    private static final String escapeKey = "\\";
    private static final boolean m_debug = false;

    static BEROctetString getOctetString(String str) {
        if (str.indexOf(escapeKey) >= 0) {
            byte[] byteVal = JDAPFilterOpers.getByteValues(str);
            return new BEROctetString(byteVal);
        }
        return new BEROctetString(str);
    }

    static byte[] getByteValues(String str) {
        int pos = 0;
        Vector<byte[]> v = new Vector<byte[]>();
        String val = new String(str);
        int totalSize = 0;
        while ((pos = val.indexOf(escapeKey)) >= 0) {
            String s1 = val.substring(0, pos);
            try {
                byte[] b = s1.getBytes("UTF8");
                totalSize += b.length;
                v.addElement(b);
            }
            catch (UnsupportedEncodingException e) {
                JDAPFilterOpers.printDebug(e.toString());
                return null;
            }
            String hex = "0x" + val.substring(pos + 1, pos + 3);
            Integer num = null;
            try {
                num = Integer.decode(hex);
            }
            catch (NumberFormatException e) {
                JDAPFilterOpers.printDebug(e.toString());
                return null;
            }
            byte[] b = new byte[]{(byte)num.intValue()};
            totalSize += b.length;
            v.addElement(b);
            val = val.substring(pos + 3);
        }
        if (val.length() > 0) {
            try {
                byte[] b = val.getBytes("UTF8");
                totalSize += b.length;
                v.addElement(b);
            }
            catch (UnsupportedEncodingException e) {
                JDAPFilterOpers.printDebug(e.toString());
                return null;
            }
        }
        byte[] result = new byte[totalSize];
        pos = 0;
        int i = 0;
        while (i < v.size()) {
            byte[] b = (byte[])v.elementAt(i);
            System.arraycopy(b, 0, result, pos, b.length);
            pos += b.length;
            ++i;
        }
        return result;
    }

    private static void printDebug(String str) {
    }

    JDAPFilterOpers() {
    }
}

