/*** analog 3.0      http://www.statslab.cam.ac.uk/~sret1/analog/  ***/

/*** output2.c; subsiduary output functions ***/

#include "analhea2.h"

extern unsigned int *rep2lng;

void pagetop(FILE *outf, Outchoices *od, Dateman *dman) {
  extern timecode_t starttimec;
  char *datestr;

  if (od -> outstyle == HTML) {
    (void)fputs("<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\">\n",
		outf);
    (void)fputs("<html>\n<head>\n", outf);
    (void)fprintf(outf, "<meta name=\"GENERATOR\" content=\"analog%s\">\n",
	    VERSION);
    (void)fprintf(outf, "<title>%s ", od -> lngstr[webstatsfor_]);
    htmlfprintf(outf, od -> outstyle, od -> hostname, &(od -> html), TRUE);
    (void)fputs("</title></head>\n", outf);
    (void)fputs("<body>\n<h1><a NAME=\"Top\">", outf);
    if (!STREQ(od -> logo, "none")) {
      (void)fputs("<IMG src=\"", outf);
      if (od -> logo[0] != '/' && strstr(od -> logo, "://") == NULL)
	htmlfprintf(outf, od -> outstyle, od -> imagedir, &(od -> html),
		    FALSE);
      htmlfprintf(outf, od -> outstyle, od -> logo, &(od -> html), FALSE);
      (void)fputs("\" alt=\"\"> ", outf);
    }
    if (STREQ(od -> hosturl, "none")) {
      (void)fprintf(outf, "%s</a> ", od -> lngstr[webstatsfor_]);
      htmlfprintf(outf, od -> outstyle, od -> hostname, &(od -> html), TRUE);
    }
    else {
      (void)fprintf(outf, "%s</a> <a HREF=\"", od -> lngstr[webstatsfor_]);
      htmlfprintf(outf, od -> outstyle, od -> hosturl, &(od -> html), FALSE);
      (void)fputs("\">", outf);
      htmlfprintf(outf, od -> outstyle, od -> hostname, &(od -> html), TRUE);
      (void)fputs("</a>", outf);
    }
    (void)fputs("</h1>\n\n", outf);
  }
  else if (od -> outstyle == ASCII) {
    (void)fprintf(outf, "%s %s\n", od -> lngstr[webstatsfor_], od -> hostname);
    matchlength(outf, od -> outstyle, od -> hostname, '=');
    matchlength(outf, od -> outstyle, od -> lngstr[webstatsfor_], '=');
    (void)fputs("=\n\n", outf);
  }
  if (!STREQ(od -> headerfile, "none"))
    include_file(outf, od -> outstyle, od -> headerfile, 'h', od -> pagewidth,
		 &(od -> html));
  if (od -> outstyle == COMPUTER) {
    (void)fprintf(outf, "x%sHN%s%s\n", od -> compsep, od -> compsep,
		  od -> hostname);
    if (!STREQ(od -> hosturl, "none"))
      (void)fprintf(outf, "x%sHU%s%s\n", od -> compsep, od -> compsep,
		    od -> hosturl);
  }

  datestr = (char *)xmalloc((size_t)datefmtlen(od -> lngstr[datefmt2_],
					       od -> plainmonthlen,
					       od -> plaindaylen,
					       od -> compsep) + 1);
  if (od -> outstyle == COMPUTER)
    (void)fprintf(outf, "x%sPS%s%s\n", od -> compsep, od -> compsep,
		datesprintf(datestr, od -> lngstr[datefmt2_],
			    starttimec / 1440, (starttimec % 1440) / 60,
			    starttimec % 60, 0, 0, NULL, NULL, 0, 0,
			    od -> compsep));
  else
    (void)fprintf(outf, "%s %s.\n", od -> lngstr[progstart_],
		  datesprintf(datestr, od -> lngstr[datefmt2_],
			      starttimec / 1440, (starttimec % 1440) / 60,
			      starttimec % 60, 0, 0, od -> monthname,
			      od -> dayname, 0, 0, NULL));
  if (od -> outstyle == HTML)
    (void)fputs("<br>", outf);
  if (dman -> firsttime <= dman -> lasttime) {
    if (od -> outstyle == COMPUTER) {
      (void)fprintf(outf, "x%sFR%s%s\n", od -> compsep, od -> compsep,
	      datesprintf(datestr, od -> lngstr[datefmt2_],
			  dman -> firsttime / 1440,
			  (dman -> firsttime % 1440) / 60,
			  dman -> firsttime % 60, 0, 0, NULL, NULL, 0, 0,
			  od -> compsep));
      (void)fprintf(outf, "x%sLR%s%s\n", od -> compsep, od -> compsep,
	      datesprintf(datestr, od -> lngstr[datefmt2_],
			  dman -> lasttime / 1440,
			  (dman -> lasttime % 1440) / 60,
			  dman -> lasttime % 60, 0, 0, NULL, NULL, 0, 0,
			  od -> compsep));
    }
    else {
      mprintf(outf, od -> pagewidth, "%s %s ", od -> lngstr[reqstart_],
	      datesprintf(datestr, od -> lngstr[datefmt2_],
			  dman -> firsttime / 1440,
			  (dman -> firsttime % 1440) / 60,
			  dman -> firsttime % 60, 0, 0, od -> monthname,
			  od -> dayname, 0, 0, NULL));
      mprintf(outf, od -> pagewidth, "%s %s", od -> lngstr[to_],
	      datesprintf(datestr, od -> lngstr[datefmt2_],
			  dman -> lasttime / 1440,
			  (dman -> lasttime % 1440) / 60,
			  dman -> lasttime % 60, 0, 0, od -> monthname,
			  od -> dayname, 0, 0, NULL));
      mprintf(outf, od -> pagewidth, " (%.1f %s).",
	      (dman -> lasttime - dman -> firsttime) / 1440.0,
	      od -> lngstr[days_]);
      mprintf(outf, 0, NULL);
    }
  }
  hrule(outf, od -> outstyle, od -> pagewidth);
}

void pagebot(FILE *outf, Outchoices *od) {
  extern time_t origstarttime;
  time_t stoptime;
  long secs;

  if (od -> outstyle == HTML) {
    (void)fprintf(outf, "<i>%s <a HREF=\"%s\">analog%s</a>.\n",
		  od -> lngstr[credit_], ANALOGURL, VERSION);
    (void)fprintf(outf, "<br><b>%s:</b> ", od -> lngstr[runtime_]);
  }
  else if (od -> outstyle == ASCII) {
    (void)fprintf(outf, "%s analog%s.\n", od -> lngstr[credit_], VERSION);
    (void)fprintf(outf, "%s: ", od -> lngstr[runtime_]);
  }
  if (od -> outstyle == HTML || od -> outstyle == ASCII) {
    (void)time(&stoptime);
    secs = (long)difftime(time((time_t *)NULL), origstarttime);
    if (secs == 0)
      (void)fprintf(outf, "%s %s.\n", od -> lngstr[lessone_],
		    od -> lngstr[second_]);
    else if (secs < 60)
      (void)fprintf(outf, "%ld %s.\n", secs, (secs == 1)?\
		    (od -> lngstr[second_]):(od -> lngstr[seconds_]));
    else
      (void)fprintf(outf, "%ld %s, %ld %s.\n", secs / 60, (secs < 120)?\
		    (od -> lngstr[minute_]):(od -> lngstr[minutes_]),
		    secs % 60, (secs % 60 == 1)?\
		    (od -> lngstr[second_]):(od -> lngstr[seconds_]));
  }
  if (od -> outstyle == HTML) {
    (void)fputs("</i>\n", outf);
    gotos(outf, INT_MAX, od -> gotoq, od -> repq, od -> lngstr,
	  od -> reporder);
  }
  if (!STREQ(od -> footerfile, "none"))
    include_file(outf, od -> outstyle, od -> footerfile, 'f', od -> pagewidth,
		 &(od -> html));
  if (od -> outstyle == HTML && od -> html) {
    (void)fputs("<p><a href=\"http://validator.w3.org/\">\n", outf);
    (void)fputs("<img src=\"", outf);
    htmlfprintf(outf, od -> outstyle, od -> imagedir, &(od -> html), FALSE);
    (void)fputs("html2.gif\"\n", outf);
    (void)fputs("alt=\"HTML 2.0 Conformant!\"></a>\n", outf);
  }
  if (od -> outstyle == HTML)
    (void)fputs("\n</body>\n</html>\n", outf);
}

/* Print "goto"s. Assume aq == HTML already tested. */
void gotos(FILE *outf, int code, logical gotoq, logical *repq, char **lngstr,
	   choice *reporder) {
  int i;

  if (gotoq) {
    (void)fprintf(outf, "<p>(<b>%s</b>", lngstr[goto_]);
    (void)fprintf(outf, ": <a HREF=\"#Top\">%s</a>", lngstr[top_]);
    for (i = 0; reporder[i] != -1; i++) {
      if (reporder[i] == code)
	(void)fprintf(outf, "%s %s", lngstr[colon_],
		      lngstr[rep2lng[reporder[i]]]);
      else if (repq[reporder[i]])
	(void)fprintf(outf, "%s <a HREF=\"#Rep%d\">%s</a>", lngstr[colon_],
		      reporder[i], lngstr[rep2lng[reporder[i]]]);
    }
    (void)fputs(")\n", outf);
  }
}

void report_title(FILE *outf, char *name, int code, logical gotoq,
		  logical *repq, char **lngstr, choice *reporder,
		  choice outstyle) {

  if (outstyle == HTML) {
    (void)fprintf(outf, "<h2><a NAME=\"Rep%d\">%s</a></h2>\n", code,
		  name);
    gotos(outf, code, gotoq, repq, lngstr, reporder);
  }
  else if (outstyle == ASCII) {
    (void)fprintf(outf, "%s\n", name);
    matchlength(outf, outstyle, name, '-');
    (void)fputc('\n', outf);
  }
}

size_t htmlstrlen(char *s, choice outstyle) {
  /* Assume string contains no &'s except as markup */
  logical f;
  size_t i;

  if (outstyle != HTML)
    return(strlen(s));
  for (f = TRUE, i = 0; *s != '\0'; s++) {
    if (*s == '&')
      f = FALSE;
    else if (*s == ';')
      f = TRUE;
    if (f)
      i++;
  }
  return(i);
}

void matchlength(FILE *outf, choice outstyle, char *s, char c) {
  size_t i;

  for (i = htmlstrlen(s, outstyle); i > 0; i--)
    myputc(outf, c, outstyle);
}

void myputc(FILE *outf, char c, choice outstyle) {
  if (outstyle != HTML)
    (void)putc(c, outf);
  else if (c == '<')
    (void)fputs("&lt;", outf);
  else if (c == '>')
    (void)fputs("&gt;", outf);
  else if (c == '&')
    (void)fputs("&amp;", outf);
  else if (c == '"')
    (void)fputs("&quot;", outf);
  else
    (void)putc(c, outf);
}

/* quicker than using myputc() */
void htmlfprintf(FILE *outf, choice outstyle, char *s, logical *html,
		 logical userinput) {
  char w1[64];
  char *c;
  char *w = w1;
  int len = 0;

  if (outstyle != HTML)
    (void)fputs(s, outf);
  else {
    for (c = s; *c != '\0'; c++) {
      if (*c == '<') {
	PUTs(w, "&lt;", 0);
	len += 4;
      }
      else if (*c == '>') {
	PUTs(w, "&gt;", 0);
	len += 4;
      }
      else if (*c == '&') {
	PUTs(w, "&amp;", 0);
	len += 5;
      }
      else if (*c == '"') {
	PUTs(w, "&quot;", 0);
	len += 6;
      }
      else if (userinput && *c == '\\' && *(c + 1) != '\0') {
	*html = FALSE;
	PUTc(w, *(++c));
	len += 1;
      }
      else {
	PUTc(w, *c);
	len += 1;
      }
      if (len > 57) {
	*w = '\0';
	(void)fputs(w1, outf);
	w = w1;
	len = 0;
      }
    }
  }
  *w = '\0';
  (void)fputs(w1, outf);
}

void hrule(FILE *outf, choice outstyle, unsigned int pagewidth) {
  unsigned int i;

  if (outstyle == HTML)
    (void)fputs("<hr>\n", outf);
  else if (outstyle == ASCII) {
    for (i = 0; i < pagewidth; i++)
      (void)putc('-', outf);
    (void)fputs("\n\n", outf);
  }
}

void include_file(FILE *outf, choice outstyle, char *name, char type,
		  unsigned int pagewidth, logical *html) {
  extern char *block_start, *block_end;
  FILE *inf;

  if ((inf = my_fopen(name, (type == 'h')?"header file":"footer file")) !=
      NULL) {
    *html = FALSE;
    if (type == 'f' || outstyle == HTML)
      hrule(outf, outstyle, pagewidth);
    while (getmoredata(inf, block_start, BLOCKSIZE) != EOF)
      (void)fwrite((void *)block_start, 1,
		   (size_t)((char *)block_end - (char *)block_start), outf);
    if (type == 'h')
      hrule(outf, outstyle, pagewidth);
    (void)my_fclose(inf, name, (type == 'h')?"header file":"footer file");
  }
}

/*** Date printing routine ***/

unsigned int datefmtlen(char *fmt, unsigned int monthlen, unsigned int daylen,
			char *compsep) {
  /* Assume no HTML accents in fmt. */
  unsigned int i = 0;
  char *c;

  for (c = fmt; *c != '\0'; c++) {
    if (*c == '%' && *(c + 1) != '\0') {
      c++;
      if (*c == '%')
	i += 1;
      else if (*c == 'd' || *c == 'D' || *c == 'y' || *c == 'h' || *c == 'H' ||
	       *c == 'i' || *c == 'I' || *c == 'n' || *c == 'o' || *c == '\v')
	i += 2;
      else if (*c == 'Y')
	i += 4;
      else if (*c == 'm')
	i += monthlen;
      else if (*c == 'w')
	i += daylen;
      else if (*c == '\b')
	i += (compsep == NULL)?0:strlen(compsep);
    }
    else
      i += 1;
  }
  return(i);
}

char *datesprintf(char *ans, char *fmt, datecode_t date, unsigned int hr,
		  unsigned int min, unsigned int newhr, unsigned int newmin,
		  char **monthname, char **dayname, unsigned int monthlen,
		  unsigned int daylen, char *compsep) {
  /* Puts date into ans. Calling fn. must ensure enough space in ans. */
  /* monthlen & daylen should be set to 0 in running (not formatted) text. */
  unsigned int d, m, y;
  char *s, *c;

  s = ans;
  if (date == 0) {
    ans[0] = '\0';
    return(ans);
  }
  code2date(date, &d, &m, &y);
  for (c = fmt; *c != '\0'; c++) {
    if (*c == '%' && *(c + 1) != '\0') {
      c++;
      switch (*c) {
      case '%':
	PUTc(s, '%');
	break;
      case 'd':
	PUT2d(s, d);
	break;
      case 'D':
	PUT02d(s, d);
	break;
      case 'm':
	if (monthname != NULL)
	  PUTs(s, monthname[m],    /* assume contains no &'s in not HTML */
	       (int)monthlen - (int)htmlstrlen(monthname[m], HTML));
	break;
      case '\v': /* \v and \b only used internally */
	PUT02d(s, m + 1);
	break;
      case '\b':
	if (compsep != NULL)
	  PUTs(s, compsep, 0);
	break;
      case 'y':
	PUT02d(s, y % 100);
	break;
      case 'Y':
	PUT04d(s, y);
	break;
      case 'h':
	PUT2d(s, hr);
	break;
      case 'H':
	PUT02d(s, hr);
	break;
      case 'i':
	PUT2d(s, newhr);
	break;
      case 'I':
	PUT02d(s, newhr);
	break;
      case 'n':
	PUT02d(s, min);
	break;
      case 'o':
	PUT02d(s, newmin);
	break;
      case 'w':
	if (dayname != NULL)
	  PUTs(s, dayname[DAYOFWEEK(date)],
	       (int)daylen - (int)htmlstrlen(dayname[DAYOFWEEK(date)], HTML));
	break;
      }
    }
    else
      PUTc(s, *c);
  }
  *s = '\0';
  return(ans);
}

void f3printf(FILE *outf, choice outstyle, double x, unsigned int width,
	      char sepchar) {
  int i;

  x += EPSILON;   /* just to make sure rounding down works OK */
  if (sepchar == '\0')
    (void)fprintf(outf, "%*.0f", width, x);
  else {
    for (i = 0; x >= 1000; i++)
      x /= 1000;  /* find out how big x is to get number of leading spaces */
    (void)fprintf(outf, "%*d", MAX((int)width - 4 * i, 0), (int)x);
    /* now run down again, printing each clump */
    for ( ; i > 0; i--) {
      myputc(outf, sepchar, outstyle);
      x -= (int)x;
      x *= 1000;
      (void)fprintf(outf, "%03d", (int)x);
    }
  }
}

void doublemprintf(FILE *outf, unsigned int pagewidth, double x, char decpt) {
  unsigned int prec;
  double d;

  /* first calculate how many decimal places we need */

  for (prec = 0, d = x - (double)((int)(x));
       d - (double)((int)(d + 0.000005)) > 0.00001; d *= 10)
    prec++;

  /* now print it */

  if (prec > 0)
    mprintf(outf, pagewidth, "%d%c%0*d", (int)x, decpt, prec,
	    (int)(d + EPSILON));
  else
    mprintf(outf, pagewidth, "%d", (int)(x + EPSILON));
}


long findunit(double n, unsigned int pagewidth, unsigned int width[],
	      unsigned int mingraphwidth, choice *cols) {
  int w;
  long unit;
  int c;
  int i, j;

  w = (int)pagewidth - (int)width[COL_TITLE] - 2;
  for (c = 0; cols[c] != COL_NUMBER; c++)
    w -= (int)width[cols[c]] + 2;
  w = MAX(w, (int)mingraphwidth);
  /* unit must be nice amount: i.e., {1, 1.5, 2, 2.5, 3, 4, 5, 6, 8} * 10^n */
  unit = (long)((n - 1) / (double)w);
  j = 0;
  while (unit > 24) {
    unit /= 10;
    j++;
  }
  if (unit == 6)
    unit = 7;
  else if (unit == 8)
      unit = 9;
  else if (unit >= 20)
    unit = 24;
  else if (unit >= 15)
    unit = 19;
  else if (unit >= 10)
    unit = 14;
  unit++;
  for (i = 0; i < j; i++) {
    unit *= 10;
  }
  return(unit);
}

void calcsizes(choice outstyle, unsigned int width[], unsigned int *bmult,
	       long *unit, unsigned long maxr, unsigned long maxp, double maxb,
	       unsigned int pagewidth, unsigned int mingraphwidth,
	       char graphby, char repsepchar, logical rawbytes, choice *cols,
	       unsigned int monthlen, unsigned int daylen, char **lngstr) {
  /* width[COL_TITLE] should be set before calling this function */
  extern unsigned int *col2colhead;
  int w;
  unsigned int i;

  if (outstyle == COMPUTER) {
    width[COL_REQS] = 0;
    width[COL_PAGES] = 0;
    width[COL_BYTES] = 0;
    width[COL_PREQS] = 0;
    width[COL_PPAGES] = 0;
    width[COL_PBYTES] = 0;
    width[COL_DATE] = 0;
    width[COL_TITLE] = 0;
    *bmult = 0;
  }
  else {
    width[COL_REQS] = MAX(LEN3(log10i(maxr), repsepchar) + 1,
			  htmlstrlen(lngstr[col2colhead[COL_REQS]], outstyle));
  width[COL_PAGES] = MAX(LEN3(log10i(maxp), repsepchar) + 1,
			 htmlstrlen(lngstr[col2colhead[COL_PAGES]], outstyle));
    if (rawbytes) {
      width[COL_BYTES] = MAX(LEN3(log10x(maxb), repsepchar) + 1,
			     htmlstrlen(lngstr[col2colhead[COL_BYTES]],
					outstyle));
      *bmult = 0;
    }
    else {
      width[COL_BYTES] = MAX(LEN3(6, repsepchar),
			     htmlstrlen(lngstr[col2colhead[COL_BYTES]],
					outstyle) + 1);
      *bmult = findbmult(maxb);             /* +1 for k, M etc. prefix */
    }
    width[COL_PREQS] = MAX(6, htmlstrlen(lngstr[col2colhead[COL_PREQS]],
					 outstyle));
    width[COL_PPAGES] = MAX(6, htmlstrlen(lngstr[col2colhead[COL_PPAGES]],
					  outstyle));
    width[COL_PBYTES] = MAX(6, htmlstrlen(lngstr[col2colhead[COL_PBYTES]],
					  outstyle));
    width[COL_DATE] = MAX(datefmtlen(lngstr[genrepfmt_], monthlen, daylen,
				     NULL),
			  htmlstrlen(lngstr[col2colhead[COL_DATE]], outstyle));
    if (*unit == 0) {  /* unit != 0 is used as a marker for not a timegraph */
      if (graphby == 'R' || graphby == 'r')
	*unit = findunit((double)maxr, pagewidth, width, mingraphwidth, cols);
      else if (graphby == 'P' || graphby == 'p')
	*unit = findunit((double)maxp, pagewidth, width, mingraphwidth, cols);
      else {
	for (i = 0; i < *bmult; i++)
	  maxb /= 1024;
	*unit = findunit(maxb, pagewidth, width, mingraphwidth, cols);
      }
    }
    if (width[COL_TITLE] == 0) {
      w = (int)pagewidth;
      for (i = 0; cols[i] != COL_NUMBER; i++)
	w -= (int)width[cols[i]] + 2;
      width[COL_TITLE] = (unsigned int)MAX(0, w);
    }
  }
}

void declareunit(FILE *outf, choice outstyle, char graphby, long unit,
		 unsigned int bmult, char markchar, char sepchar,
		 char *imagedir, char **lngstr) {
  extern char byteprefix[];

  if (outstyle == HTML || outstyle == ASCII) {
    if (outstyle == HTML)
      (void)fputs("<p>\n", outf);
    (void)fprintf(outf, "%s (", lngstr[eachunit_]);
    if (islower(graphby) || outstyle != HTML)
      (void)putc(markchar, outf);
    else
      (void)fprintf(outf, "<img src=\"%sbar1.gif\" alt=\"%c\">",
		    imagedir, markchar);
    (void)fprintf(outf, ") %s ", lngstr[represents_]);
    f3printf(outf, outstyle, (double)unit, 0, sepchar);
    (void)putc(' ', outf);
    if (graphby == 'R' || graphby == 'r') {
      if (unit == 1)
	(void)fprintf(outf, "%s.\n", lngstr[request_]);
      else
	(void)fprintf(outf, "%s, %s.\n", lngstr[requests_], lngstr[partof_]);
    }
    else if (graphby == 'P' || graphby == 'p') {
      if (unit == 1)
	(void)fprintf(outf, "%s.\n", lngstr[pagereq_]);
      else
	(void)fprintf(outf, "%s, %s.\n", lngstr[pagereqs_], lngstr[partof_]);
    }
    else {
      if (bmult >= 1)
	(void)putc(byteprefix[bmult], outf);
      (void)fprintf(outf, "%s, %s.\n", lngstr[bytes_], lngstr[partof_]);
    }
  }
}

void whatincluded(FILE *outf, choice outstyle, unsigned long n,
		  unsigned int pagewidth, Floor *floor, choice sortby,
		  char decpt, char *gens, char *genp, char gender,
		  choice requests, choice date, timecode_t firsttime,
		  char **monthname, char **dayname, unsigned int monthlen,
		  unsigned int daylen, char **lngstr) {
  extern unsigned int *method2sing, *method2pl, *method2date, *method2pc;
  extern unsigned int *method2relpc, *method2sort;
  int firsts, firstds, alls, sorted, alphsort, unsort;
  char *datestr;
  unsigned long temp;
  timecode_t tempd;

  if (outstyle == HTML || outstyle == ASCII) {
    if (gender == 'm') {
      firsts = firstsm_;
      firstds = firstdsm_;
      alls = allsm_;
      sorted = sortedm_;
      alphsort = STREQ(gens, lngstr[codegs_])?numsortm_:alphasortm_;
      unsort = unsortedm_;            /* quickest kludge for only one report */
    }
    else if (gender == 'f') {
      firsts = firstsf_;
      firstds = firstdsf_;
      alls = allsf_;
      sorted = sortedf_;
      alphsort = STREQ(gens, lngstr[codegs_])?numsortf_:alphasortf_;
      unsort = unsortedf_;
    }
    else { /* gender == 'n' */
      firsts = firstsn_;
      firstds = firstdsn_;
      alls = allsn_;
      sorted = sortedn_;
      alphsort = STREQ(gens, lngstr[codegs_])?numsortn_:alphasortn_;
      unsort = unsortedn_;
    }

    /* see also report_floor() in settings.c */
    if (outstyle == HTML)
      (void)fputs("<p>\n", outf);
    if (floor -> min < 0 && n < (unsigned long)(-floor -> min + EPSILON))
      floor -> min = 0;  /* not enough items for requested -ve floor */
    if (floor -> min < 0) {
      temp = (unsigned long)(-floor -> min + EPSILON);
      if (temp == 1)
	mprintf(outf, pagewidth, lngstr[firsts], gens);
      else
	mprintf(outf, pagewidth, lngstr[firstds], temp, genp);
      mprintf(outf, pagewidth, " %s ", lngstr[floorby_]);
      if (floor -> floorby == REQUESTS)
	mprintf(outf, pagewidth, lngstr[method2sort[requests]]);
      else if (floor -> floorby == DATESORT)
	mprintf(outf, pagewidth, lngstr[method2sort[date]]);
      else
	mprintf(outf, pagewidth, lngstr[method2sort[floor -> floorby]]);
    }
    else {   /* floor -> min >= 0 */
      mprintf(outf, pagewidth, lngstr[alls], genp);
      if (floor -> floorby == DATESORT) {
	tempd = (timecode_t)(floor -> min + EPSILON);
	if (tempd > firsttime) {
	  mprintf(outf, pagewidth, " %s ", lngstr[method2date[date]]);
	  datestr = (char *)xmalloc((size_t)datefmtlen(lngstr[whatincfmt_],
						       monthlen, daylen, NULL)
				    + 1);
	  mprintf(outf, pagewidth,
		  datesprintf(datestr, lngstr[whatincfmt_], tempd / 1440,
			      (tempd % 1440) / 60, tempd % 60, 0, 0, monthname,
			      dayname, 0, 0, NULL));
	  free((void *)datestr);
	}
      }
      else if (floor -> min > EPSILON) {
	mprintf(outf, pagewidth, " %s ", lngstr[atleast_]);
	if (floor -> qual == '\0') {
	  temp = (unsigned long)(floor -> min + EPSILON);
	  mprintf(outf, pagewidth, "%lu ", temp);
	  if (floor -> floorby == REQUESTS)
	    mprintf(outf, pagewidth, (temp == 1)?lngstr[method2sing[requests]]:
		    lngstr[method2pl[requests]]);
	  else
	    mprintf(outf, pagewidth, (temp == 1)?
		    lngstr[method2sing[floor -> floorby]]:
		    lngstr[method2pl[floor -> floorby]]);
	}
	else {  /* floor -> qual != '\0' */
	  doublemprintf(outf, pagewidth, floor -> min, decpt);
	  if (floor -> qual == '%') {
	    if (floor -> floorby == REQUESTS)
	      mprintf(outf, pagewidth, lngstr[method2pc[requests]]);
	    else
	      mprintf(outf, pagewidth, lngstr[method2pc[floor -> floorby]]);
	  }
	  else if (floor -> qual == ':') {
	    if (floor -> floorby == REQUESTS)
	      mprintf(outf, pagewidth, lngstr[method2relpc[requests]]);
	    else
	      mprintf(outf, pagewidth, lngstr[method2relpc[floor -> floorby]]);
	  }
	  else { /* if qual is anything else, must be (k|M|G|T)bytes */
	    mprintf(outf, pagewidth, " ");
	    mprintf(outf, pagewidth, "%c%s", floor -> qual, lngstr[bytes_]);
	  }
	}   /* end floor -> qual != '\0' */
      }     /* end floor -> min > EPSILON */
    }       /* end floor -> min > 0 */
    /* That completes the floor; now we are just left with the sortby */
    if (floor -> min >= 0 || temp != 1) { /* else only one item, so no sort */
      if (floor -> min < 0 && sortby == RANDOM)
	sortby = floor -> floorby;
      mprintf(outf, pagewidth, ", ");
      if (sortby == ALPHABETICAL)
	mprintf(outf, pagewidth, lngstr[alphsort]);
      else if (sortby == RANDOM)
	mprintf(outf, pagewidth, lngstr[unsort]);
      else {
	mprintf(outf, pagewidth, lngstr[sorted]);
	mprintf(outf, pagewidth, " ");
	if (sortby == REQUESTS)
	  mprintf(outf, pagewidth, lngstr[method2sort[requests]]);
	else if (sortby == DATESORT)
	  mprintf(outf, pagewidth, lngstr[method2sort[date]]);
	else
	  mprintf(outf, pagewidth, lngstr[method2sort[sortby]]);
      }
    }
    mprintf(outf, pagewidth, ".");
    mprintf(outf, 0, NULL);
  }
}

void busyprintf(FILE *outf, choice outstyle, char *datefmt,
		unsigned long reqs, unsigned long pages, double bys,
		datecode_t date, unsigned int hr, unsigned int min,
		unsigned int newhr, unsigned int newmin, char graphby,
		char sepchar, logical rawbytes, char **lngstr,
		char **monthname, char **dayname, unsigned int monthlen,
		unsigned int daylen, char *busystr) {
  extern char byteprefix[];
  char *datestr;
  unsigned int j, bmult;

  if (outstyle == ASCII || outstyle == HTML) {
    if (outstyle == ASCII)
      (void)putc('\n', outf);
    datestr = (char *)xmalloc((size_t)datefmtlen(datefmt, monthlen, daylen,
						 NULL) + 1);
    (void)fprintf(outf, "%s %s (", busystr,
		  datesprintf(datestr, datefmt, date, hr, min,
			      (newmin == 0)?(hr + 1):hr, (unsigned int)newmin,
			      monthname, dayname, 0, 0, NULL));
    free((void *)datestr);
    if (graphby == 'R' || graphby == 'r') {
      (void)f3printf(outf, outstyle, (double)reqs, 0, sepchar);
      (void)fprintf(outf, " %s).\n",
		    (reqs == 1)?lngstr[request_]:lngstr[requests_]);
    }
    else if (graphby == 'P' || graphby == 'p') {
      (void)f3printf(outf, outstyle, (double)pages, 0, sepchar);
      (void)fprintf(outf, " %s).\n",
		    (pages == 1)?lngstr[pagereq_]:lngstr[pagereqs_]);
    }
    else /* graphby == 'B' or 'b' */ {
      if (rawbytes)
	bmult = 0;
      else
	bmult = (int)findbmult(bys);
      for (j = 0; j < bmult; j++)
	bys /= 1024;
      (void)f3printf(outf, outstyle, bys, 0, sepchar);
      (void)putc(' ', outf);
      if (bmult >= 1)
	(void)putc(byteprefix[bmult], outf);
      (void)fprintf(outf, "%s).\n", lngstr[bytes_]);
    }
  }
}

void pccol(FILE *outf, choice outstyle, double n, double tot,
	   unsigned int width, char decpt) {
  double pc;
  unsigned int pc1, pc2;
  int i;

  if (outstyle == COMPUTER)
    (void)fprintf(outf, "%.3f", (tot == 0)?0.0:(n * 100.0 / tot));
  else {
    for (i = 0; i < (int)width - 6; i++)
      (void)putc(' ', outf);
    if (tot == 0)
      pc = 0.0;
    else
      pc = n * 10000.0 / tot;
    if (pc >= 9999.5)
      (void)fputs("  100%", outf);
    else if (pc < 0.5)
      (void)fputs("      ", outf);
    else {
      pc1 = ((int)(pc + 0.5)) / 100;
      pc2 = ((int)(pc + 0.5)) % 100;
      (void)fprintf(outf, "%2d", pc1);
      myputc(outf, decpt, outstyle);
      (void)fprintf(outf, "%02d%%", pc2);
    }
  }
}

void barchart(FILE *outf, choice outstyle, char graphby, unsigned long reqs,
	      unsigned long pages, double bys, long unit, char markchar,
	      char *imagedir) {
  int i, j;
  double x;
  int y;
  logical first = TRUE;

  if (graphby == 'P' || graphby == 'p')
    x = (double)pages;
  else if (graphby == 'R' || graphby == 'r')
    x = (double)reqs;
  else
    x = bys;
  x -= 0.5;
  x /= (double)unit;
  x += 1;
  y = (int)x;
  if (islower(graphby) || outstyle != HTML) {
    for (i = 0; i < y; i++)
      myputc(outf, markchar, outstyle);
  }
  else {
    for (j = 32; j >= 1; j /= 2) {
      while (y >= j) {
	(void)fprintf(outf, "<img src=\"%sbar%d.gif\" alt=\"", imagedir, j);
	if (first) {
	  for (i = 0; i < y; i++)
	    myputc(outf, markchar, outstyle);
	  first = FALSE;
	}
	(void)fputs("\">", outf);
	y -= j;
      }
    }
  }
}

void colheads(FILE *outf, choice *cols, choice outstyle, unsigned int width[],
	      unsigned int bmult, logical rawbytes, char *name,
	      logical name1st, char **lngstr) {
  extern unsigned int *col2colhead;
  extern char byteprefix[];
  int len;
  unsigned int c, i;

  if (outstyle == HTML || outstyle == ASCII) {
    if (name1st)
      (void)fprintf(outf, "%*s: ", width[COL_TITLE] + strlen(name)
		    - htmlstrlen(name, outstyle), name);
    for (c = 0; cols[c] != COL_NUMBER; c++) {
      if (cols[c] == COL_BYTES) {
	len = (int)htmlstrlen(lngstr[col2colhead[cols[c]]], outstyle) +
	  (int)(!rawbytes);
	for (i = width[cols[c]] - len; i > 0; i--)
	  (void)putc(' ', outf);
	if (!rawbytes)
	  (void)putc(byteprefix[bmult], outf);
	(void)fprintf(outf, "%s: ", lngstr[col2colhead[cols[c]]]);
      }
      else
	(void)fprintf(outf, "%*s: ", width[cols[c]]
		      + strlen(lngstr[col2colhead[cols[c]]])
		      - htmlstrlen(lngstr[col2colhead[cols[c]]], outstyle),
		      lngstr[col2colhead[cols[c]]]);
    }
    if (!name1st)
      (void)fputs(name, outf);
    (void)putc('\n', outf);
    if (name1st) {
      for (i = 0; i < width[COL_TITLE]; i++)
	(void)putc('-', outf);
      (void)fputs(": ", outf);
    }
    for (c = 0; cols[c] != COL_NUMBER; c++) {
      for (i = width[cols[c]] ; i > 0; i--)
	(void)putc('-', outf);
      (void)fputs(": ", outf);
    }
    if (!name1st)
      matchlength(outf, outstyle, name, '-');
    (void)fputc('\n', outf);
  }
}

void printcols(FILE *outf, choice rep, choice *cols, choice outstyle,
	       unsigned long reqs, unsigned long pages, double bys,
	       unsigned long totr, unsigned long totp, double totb,
	       unsigned int width[], unsigned int bmult, char graphby,
	       long unit, char markchar, char repsepchar, char decpt,
	       char *compsep, logical name1st, logical timegraph,
	       char *imagedir, logical html, char *name, logical ispage,
	       unsigned int spaces, Alias *aliashead, Include *linkhead,
	       char *baseurl, char *datefmt, datecode_t date, unsigned int hr,
	       unsigned int min, unsigned int newhr, unsigned int newmin,
	       char **monthname, char **dayname, unsigned int monthlen,
	       unsigned int daylen, unsigned int plainmonthlen,
	       unsigned int plaindaylen) {
  extern char *workspace;   /* see top of alias.c */
  extern char repcodes[];
  static char *datestr = NULL;
  static size_t len = 0, need;
  int c, i;
  double tempbys;

  if (outstyle == COMPUTER) {
    (void)fprintf(outf, "%c%s", repcodes[rep], compsep);
    for (c = 0; cols[c] != COL_NUMBER; c++) {
      switch(cols[c]) {
      case COL_REQS:
	(void)putc('R', outf);
	break;
      case COL_PREQS:
	(void)putc('r', outf);
	break;
      case COL_PAGES:
	(void)putc('P', outf);
	break;
      case COL_PPAGES:
	(void)putc('p', outf);
	break;
      case COL_BYTES:
	(void)putc('B', outf);
	break;
      case COL_PBYTES:
	(void)putc('b', outf);
	break;
      case COL_DATE:
	(void)putc('D', outf);
	break;
      }
    }
    (void)fputs(compsep, outf);
  }
  else if (name1st) {
    if (IS_EMPTY_STRING(name)) {
      need = datefmtlen(datefmt, plainmonthlen, plaindaylen, NULL) + 1;
      ENSURE_LEN(datestr, len, need);
      name = datesprintf(datestr, datefmt, date, hr, min, newhr, newmin,
			 monthname, dayname, monthlen, daylen, NULL);
    }
    for (i = (int)width[COL_TITLE] - (int)strlen(name); i > 0; i--)
      (void)putc(' ', outf);
    (void)fprintf(outf, "%s: ", name);
  }

  for (c = 0; cols[c] != COL_NUMBER; c++) {
    switch(cols[c]) {
    case COL_REQS:
      f3printf(outf, outstyle, (double)reqs, width[cols[c]], repsepchar);
      break;
    case COL_PREQS:
      pccol(outf, outstyle, (double)reqs, (double)totr, width[cols[c]],
	    decpt);
      break;
    case COL_PAGES:
      f3printf(outf, outstyle, (double)pages, width[cols[c]], repsepchar);
      break;
    case COL_PPAGES:
      pccol(outf, outstyle, (double)pages, (double)totp, width[cols[c]],
	    decpt);
      break;
    case COL_BYTES:
      tempbys = bys;
      for (i = 0; i < (int)bmult; i++)
	tempbys /= 1024;
      f3printf(outf, outstyle, tempbys, width[cols[c]], repsepchar);
      break;
    case COL_PBYTES:
      pccol(outf, outstyle, bys, totb, width[cols[c]], decpt);
      break;
    case COL_DATE:
      need = datefmtlen(datefmt, plainmonthlen, plaindaylen, compsep) + 1;
      ENSURE_LEN(datestr, len, need);
      (void)datesprintf(datestr, datefmt, date, hr, min, newhr, newmin,
			monthname, dayname, monthlen, daylen, compsep);
      for (i = (int)width[cols[c]] - (int)strlen(datestr); i > 0; i--)
	(void)putc(' ', outf);
      (void)fprintf(outf, "%s", datestr);
      break;
    }
    if (outstyle == HTML || outstyle == ASCII)
      (void)fputs(": ", outf);
    else
      (void)fputs(compsep, outf);
  }

  if (timegraph && (outstyle == HTML || outstyle == ASCII)) {
      for (i = 0; i < (int)bmult; i++)
	bys /= 1024;
      barchart(outf, outstyle, graphby, reqs, pages, bys, unit, markchar,
	       imagedir);
  }
  else if (!name1st) {
    if (name == NULL)
      return;   /* calling function supplies name and newline */
    if (outstyle != COMPUTER) {
      for (i = 0; i < (int)spaces; i++)  /* 2 padding types: never both used */
	(void)putc(' ', outf);
      for (i = (int)width[COL_TITLE] - (int)htmlstrlen(name, outstyle); i > 0;
	   i--)
	(void)putc(' ', outf);
    }
    (void)strcpy(workspace, name);
    do_aliasx(workspace, aliashead);
    if (linkhead != NULL && outstyle == HTML &&
	included(name, ispage, linkhead)) {
      (void)fputs("<a href=\"", outf);
      if (baseurl != NULL)
	htmlfprintf(outf, outstyle, baseurl, &html, FALSE);
      htmlfprintf(outf, outstyle, name, &html, FALSE);
      (void)fputs("\">", outf);
      htmlfprintf(outf, outstyle, workspace, &html, FALSE);
      (void)fputs("</a>", outf);
    }
    else
      htmlfprintf(outf, outstyle, workspace, &html, FALSE);
  }
  else if (outstyle == COMPUTER) {
    if (IS_EMPTY_STRING(name)) {
      need = datefmtlen(datefmt, plainmonthlen, plaindaylen, compsep) + 1;
      ENSURE_LEN(datestr, len, need);
      name = datesprintf(datestr, datefmt, date, hr, min, newhr, newmin,
			 monthname, dayname, monthlen, daylen, compsep);
    }
    (void)fprintf(outf, "%s", name);
  }
  (void)fputc('\n', outf);
}

void lastseven(FILE *outf, choice outstyle, timecode_t to, timecode_t last7,
	       char *compsep, char **monthname, char **dayname,
	       unsigned int monthlen, unsigned int daylen, char **lngstr) {
  char *datestr;

  datestr = (char *)xmalloc((size_t)datefmtlen(lngstr[datefmt1_], monthlen,
					       daylen, compsep) + 1);
  if (outstyle == HTML)
    (void)fputs("<p>", outf);
  if (outstyle == COMPUTER)
    (void)fprintf(outf, "x%sL7%s%s\n", compsep, compsep,
		  datesprintf(datestr, lngstr[datefmt1_], last7 / 1440,
			      (last7 % 1440) / 60, last7 % 60, 0, 0, NULL,
			      NULL, 0, 0, compsep));
  else if (to == LAST_TIME)
    (void)fprintf(outf, "(%s %s).\n", lngstr[brackets_],
		  lngstr[lastsevendays_]);
  else
    (void)fprintf(outf, "(%s %s %s).\n", lngstr[brackets_],
		  lngstr[sevendaysto_],
		  datesprintf(datestr, lngstr[datefmt1_], to / 1440,
			      (to % 1440) / 60, to % 60, 0, 0, monthname,
			      dayname, 0, 0, NULL));
  free((void *)datestr);
}

/*** Now some stuff for the general summary ***/

void distcount(Hashindex *gooditems, Hashindex *baditems, unsigned long *tot,
	       unsigned long *tot7, timecode_t last7time) {
  Hashindex *p;

  for (p = gooditems, *tot = 0, *tot7 = 0; p != NULL; TO_NEXT(p)) {
    if (p -> own != NULL && p -> own -> data[REQUESTS] > 0) {
      (*tot)++;
      *tot7 += (unsigned long)(p -> own -> data[SUCCDATE] > last7time);
    }
  }
  for (p = baditems; p != NULL; TO_NEXT(p)) {
    if (p -> own != NULL && p -> own -> data[REQUESTS] > 0) {
      (*tot)++;
      *tot7 += (unsigned long)(p -> own -> data[SUCCDATE] > last7time);
    }
  }
}

void gensumline(FILE *outf, choice outstyle, int namecode, unsigned long x,
		unsigned long x7, char sepchar, char *compsep, logical p,
		char **lngstr) {

  if ((x > 0 || namecode == succreqs_) && x != (unsigned long)UNSET) {
    if (outstyle == HTML) {
      if (p)
	(void)fprintf(outf, "<p><b>%s%s</b> ", lngstr[namecode],
		      lngstr[colon_]);
      else
	(void)fprintf(outf, "<br><b>%s%s</b> ", lngstr[namecode],
		      lngstr[colon_]);
    }
    else if (outstyle == ASCII)
      (void)fprintf(outf, "%s%s ", lngstr[namecode], lngstr[colon_]);
    else
      (void)fprintf(outf, "x%s%c%c%s", compsep, lngstr[namecode][0],
		    lngstr[namecode][1], compsep);
    f3printf(outf, outstyle, (double)x, 0, sepchar);
    if (x7 != (unsigned long)(-1)) {
      if (outstyle == COMPUTER) {
	(void)fprintf(outf, "\nx%s%c%c%s", compsep, lngstr[namecode][2],
		      lngstr[namecode][3], compsep);
	f3printf(outf, outstyle, (double)x7, 0, sepchar);
      }
      else {
	(void)fputs(" (", outf);
	f3printf(outf, outstyle, (double)x7, 0, sepchar);
	(void)putc(')', outf);
      }
    }
    (void)putc('\n', outf);
  }
}

void gensumlineb(FILE *outf, choice outstyle, int namecode, double x,
		 double x7, logical rawbytes, char sepchar, char *compsep,
		 char **lngstr) {
  /* same as gensumline() but for bytes */
  extern char byteprefix[];
  unsigned int i, j;

  if (x > 0) {
    if (outstyle == HTML)
      (void)fprintf(outf, "<br><b>%s%s</b> ", lngstr[namecode],
		    lngstr[colon_]);
    else if (outstyle == ASCII)
      (void)fprintf(outf, "%s%s ", lngstr[namecode], lngstr[colon_]);
    else
      (void)fprintf(outf, "x%s%c%c%s", compsep, lngstr[namecode][0],
		    lngstr[namecode][1], compsep);
    j = rawbytes?0:findbmult(x);
    for (i = 0; i < j; i++)
      x /= 1024;
    f3printf(outf, outstyle, x, 0, sepchar);
    if (outstyle == HTML || outstyle == ASCII) {
      if (j > 0)
	(void)fprintf(outf, " %c%s", byteprefix[j], lngstr[bytes_]);
      else
	(void)fprintf(outf, " %s", lngstr[bytes_]);
    }
    if (x7 != UNSET) {
      if (outstyle == COMPUTER) {
	(void)fprintf(outf, "\nx%s%c%c%s", compsep, lngstr[namecode][2],
		      lngstr[namecode][3], compsep);
	f3printf(outf, outstyle, (double)x7, 0, sepchar);
      }
      else {
	(void)fputs(" (", outf);
	j = rawbytes?0:findbmult(x7);
	for (i = 0; i < j; i++)
	  x7 /= 1024;
	f3printf(outf, outstyle, x7, 0, sepchar);
	if (j > 0)
	  (void)fprintf(outf, " %c%s)", byteprefix[j], lngstr[bytes_]);
	else
	  (void)fprintf(outf, " %s)", lngstr[bytes_]);
      }
    }
    (void)putc('\n', outf);
  }
}

#define GENSUM_RATE(x, m) (((m) < 30 || (x) <= 1)?((unsigned long)UNSET):\
  ((unsigned long)(((double)((x) - 1) * 1440.0) / (double)(m))))
void gensum(FILE *outf, choice outstyle, logical last7, unsigned long *data,
	    double bys, double bys7, Hashindex **gooditems,
	    Hashindex **baditems, Dateman *dman, logical rawbytes,
	    char sepchar, char *compsep, char **monthname, char **dayname,
	    unsigned int monthlen, unsigned int daylen, char **lngstr) {
  timecode_t totmins, totmins7;
  logical q7 = (last7 && dman -> firsttime < dman -> last7 &&
		dman -> last7 < dman -> lasttime);
  unsigned long tot, tot7;

  totmins = dman -> lasttime - dman -> firsttime;
  totmins7 = q7?MINS_IN_WEEK:0;
  if (q7)
    lastseven(outf, outstyle, dman -> to, dman -> last7, compsep, monthname,
	      dayname, monthlen, daylen, lngstr);
  gensumline(outf, outstyle, succreqs_, data[LOGDATA_SUCC],
	     q7?data[LOGDATA_SUCC7]:(unsigned long)UNSET, sepchar, compsep,
	     (logical)(!q7), lngstr);
  if (outstyle != COMPUTER) {
    gensumline(outf, outstyle, avereqs_,
	       GENSUM_RATE(data[LOGDATA_SUCC], totmins),
	       GENSUM_RATE(data[LOGDATA_SUCC7], totmins7), sepchar, compsep,
	       FALSE, lngstr);
  }
  gensumline(outf, outstyle, totunknown_, data[LOGDATA_UNKNOWN],
	     q7?data[LOGDATA_UNKNOWN7]:(unsigned long)UNSET, sepchar,
	     compsep, FALSE, lngstr);
  gensumline(outf, outstyle, totpages_, data[LOGDATA_PAGES],
	     q7?data[LOGDATA_PAGES7]:(unsigned long)UNSET, sepchar, compsep,
	     FALSE, lngstr);
  if (outstyle != COMPUTER) {
    gensumline(outf, outstyle, avepages_,
	       GENSUM_RATE(data[LOGDATA_PAGES], totmins),
	       GENSUM_RATE(data[LOGDATA_PAGES7], totmins7), sepchar, compsep,
	       FALSE, lngstr);
  }
  gensumline(outf, outstyle, totfails_, data[LOGDATA_FAIL],
	     q7?data[LOGDATA_FAIL7]:(unsigned long)UNSET, sepchar, compsep,
	     FALSE, lngstr);
  gensumline(outf, outstyle, totredirs_, data[LOGDATA_REDIR],
	     q7?data[LOGDATA_REDIR7]:(unsigned long)UNSET, sepchar, compsep,
	     FALSE, lngstr);
  gensumline(outf, outstyle, inforeqs_, data[LOGDATA_INFO],
	     q7?data[LOGDATA_INFO7]:(unsigned long)UNSET, sepchar, compsep,
	     FALSE, lngstr);
  distcount(gooditems[ITEM_FILE], baditems[ITEM_FILE], &tot, &tot7,
	    dman -> last7);
  gensumline(outf, outstyle, distfiles_, tot, q7?tot7:(unsigned long)UNSET,
	     sepchar, compsep, FALSE, lngstr);
  distcount(gooditems[ITEM_HOST], baditems[ITEM_HOST], &tot, &tot7,
	    dman -> last7);
  gensumline(outf, outstyle, disthosts_, tot, q7?tot7:(unsigned long)UNSET,
	     sepchar, compsep, FALSE, lngstr);
  gensumline(outf, outstyle, corrupt_, data[LOGDATA_CORRUPT],
	     (unsigned long)UNSET, sepchar, compsep, FALSE, lngstr);
  gensumline(outf, outstyle, unwanted_, data[LOGDATA_UNWANTED],
	     (unsigned long)UNSET, sepchar, compsep, FALSE, lngstr);
  gensumlineb(outf, outstyle, totdata_, bys, q7?bys7:UNSET, rawbytes,
	      sepchar, compsep, lngstr);
  if (outstyle != COMPUTER) {
    gensumlineb(outf, outstyle, avedata_,
		(totmins < 30)?UNSET:((bys * 1440.0) / (double)totmins),
		(q7 && totmins7 >= 30)?\
		((bys7 * 1440.0) / (double)totmins7):UNSET,
		rawbytes, sepchar, compsep, lngstr);
  }
}

void genrep(FILE *outf, choice rep, choice outstyle, Hashindex **gooditems,
	    Hashindex **baditems, Alias *aliashead, Include *wanthead,
	    choice requests, choice date, Floor *floor, choice sortby,
	    logical alphaback, unsigned int pagewidth, char sepchar,
	    char repsepchar, char decpt, char *compsep, logical rawbytes,
	    choice *cols, char *colhead, char *colheadp, char *gens,
	    char *genp, char gender, logical html, timecode_t firsttime,
	    char **monthname, char **dayname, unsigned int monthlen,
	    unsigned int daylen, unsigned int plainmonthlen,
	    unsigned int plaindaylen, char **lngstr) {
  Hashindex *ip;
  Hashentry *badp;
  unsigned long totr = 0, totp = 0, maxr = 0, maxp = 0, badn = 0, goodn = 0;
  double totb = 0.0, maxb = 0.0;
  unsigned int width[COL_NUMBER], bmult, tw = 0;
  char *notlistedstr;
  long unit = 1;

  /* run through all items finding totals and maxima for floors */
  for (ip = *gooditems; ip != NULL; TO_NEXT(ip)) {
    if (ip -> own != NULL) {
      totr += ip -> own -> data[requests];
      totp += ip -> own -> data[PAGES];
      totb += ip -> own -> bytes;
      maxr = MAX(maxr, ip -> own -> data[requests]);
      maxp = MAX(maxp, ip -> own -> data[PAGES]);
      maxb = MAX(maxb, ip -> own -> bytes);
    }
  }
  for (ip = *baditems; ip != NULL; TO_NEXT(ip)) {
    if (ip -> own != NULL) {
      totr += ip -> own -> data[requests];
      totp += ip -> own -> data[PAGES];
      totb += ip -> own -> bytes;
      maxr = MAX(maxr, ip -> own -> data[requests]);
      maxp = MAX(maxp, ip -> own -> data[PAGES]);
      maxb = MAX(maxb, ip -> own -> bytes);
    }
  }

  my_sort(gooditems, baditems, floor, sortby, alphaback, wanthead, requests,
	  date, totr, totp, totb, maxr, maxp, maxb);

  /* accumulate all unwanted items into a single entry */
  badp = newhashentry(FALSE);
  for (ip = *baditems; ip != NULL; TO_NEXT(ip)) {
    if (ip -> own != NULL && ip -> own -> data[requests] > 0) {
      badp -> data[requests] += ip -> own -> data[requests];
      badp -> data[PAGES] += ip -> own -> data[PAGES];
      badp -> bytes += ip -> own -> bytes;
      badp -> data[date] = MAX(badp -> data[date], ip -> own -> data[date]);
      badn++;
    }
  }

  /* now run through all good items, finding maxima of those for report */
  maxr = badp -> data[requests];
  maxp = badp -> data[PAGES];
  maxb = badp -> bytes;
  for (ip = *gooditems; ip != NULL; TO_NEXT(ip)) {
    if (ip -> own != NULL) {  /* should obey this already, but for safety... */
      maxr = MAX(maxr, ip -> own -> data[requests]);
      maxp = MAX(maxp, ip -> own -> data[PAGES]);
      maxb = MAX(maxb, ip -> own -> bytes);
      goodn++;
    }
  }

  width[COL_TITLE] = 0;
  calcsizes(outstyle, width, &bmult, &unit, maxr, maxp, maxb, pagewidth, 0,
	    '\0', repsepchar, rawbytes, cols, monthlen, daylen, lngstr);
  if (alphaback && sortby == ALPHABETICAL) {
    for (ip = *gooditems; ip != NULL; TO_NEXT(ip))
      tw = MAX(tw, htmlstrlen(ip -> name, outstyle));
    tw = MIN(tw, width[COL_TITLE]);
  }
  else
    width[COL_TITLE] = 0;
  whatincluded(outf, outstyle, goodn, pagewidth, floor, sortby, decpt, gens,
	       genp, gender, requests, date, firsttime, monthname, dayname,
	       plainmonthlen, plaindaylen, lngstr);
  PRESTART();
  colheads(outf, cols, outstyle, width, bmult, rawbytes, colhead, FALSE,
	   lngstr);
  for (ip = *gooditems; ip != NULL; TO_NEXT(ip)) {
    if (tw > 0)
      width[COL_TITLE] = (isdigit(ip -> name[0]) &&
			  isdigit(ip -> name[strlen(ip -> name) - 1]))?0:tw;
    printcols(outf, rep, cols, outstyle, ip -> own -> data[requests],
	      ip -> own -> data[PAGES], ip -> own -> bytes, totr, totp, totb,
	      width, bmult, '\0', unit, '\0', repsepchar, decpt, compsep,
	      FALSE, FALSE, NULL, html, ip -> name, ip -> own -> ispage, 0,
	      aliashead, NULL, NULL, lngstr[genrepfmt_],
	      ip -> own -> data[date] / 1440,
	      (ip -> own -> data[date] % 1440) / 60,
	      ip -> own -> data[date] % 60, 0, 0, monthname, dayname,
	      monthlen, daylen, plainmonthlen, plaindaylen);
  }
  if (badn > 0) {
    printcols(outf, rep, cols, outstyle, badp -> data[requests],
	      badp -> data[PAGES], badp -> bytes, totr, totp, totb, width,
	      bmult, '\0', unit, '\0', repsepchar, decpt, compsep, FALSE,
	      FALSE, NULL, html, NULL, FALSE, 0, NULL, NULL, NULL,
	      lngstr[genrepfmt_], badp -> data[date] / 1440,
	      (badp -> data[date] % 1440) / 60, badp -> data[date] % 60, 0, 0,
	      monthname, dayname, monthlen, daylen, plainmonthlen,
	      plaindaylen);
    if (gender == 'm')
      notlistedstr = lngstr[notlistedm_];
    else if (gender == 'f')
      notlistedstr = lngstr[notlistedf_];
    else
      notlistedstr = lngstr[notlistedn_];
    (void)fprintf(outf, "[%s: ", notlistedstr);
    f3printf(outf, outstyle, (double)badn, 0, sepchar);
    if (outstyle == COMPUTER)
      (void)fprintf(outf, "]\n");
    else
      (void)fprintf(outf, " %s]\n", (badn == 1)?colhead:colheadp);
  }
  PREEND();
}

void subdayrep(FILE *outf, choice rep, Daysdata *firstdp, Daysdata *lastdp,
	       datecode_t firstdate, datecode_t lastdate, choice outstyle,
	       unsigned int granularity, unsigned int repgran,
	       unsigned int pagewidth, unsigned int mingraphwidth,
	       logical back, logical rawbytes, choice *cols,
	       unsigned int rows, char graphby, char markchar, char sepchar,
	       char repsepchar, char decpt, char *compsep, choice weekbeginson,
	       char *imagedir, logical html, char **monthname, char **dayname,
	       unsigned int monthlen, unsigned int daylen,
	       unsigned int plainmonthlen, unsigned int plaindaylen,
	       char **lngstr, char *datefmt, char *colhead, char *busystr) {
  Daysdata *dp;
  Timerep *trhead, *trp, *oldtrp;
  int hr, min, newmin = 0, busyhr = 0, busymin = 0;
  long unit = 0;
  datecode_t busydate = 0, i;
  int j, firsttime, lasttime;
  unsigned int k;
  unsigned int relgran = granularity / repgran; /* guaranteed to be integer */
  unsigned long reqs, pages, totr = 0, totp = 0;
  unsigned long maxr = 0, maxp = 0, busyr = 0, busyp = 0;
  double bys, totb = 0.0, maxb = 0.0, busyb = 0.0;
  unsigned int width[COL_NUMBER], bmult, rowsdone = 0;
  logical first = TRUE;

  dp = lastdp;
  trhead = (Timerep *)xmalloc(sizeof(Timerep));
  trp = trhead;

  if (rows == 0)
    rows = INT_MAX;
  for (firsttime = 0; firsttime < (int)granularity &&
	 firstdp -> reqs[firsttime] == 0; firsttime++)
    ;    /* run to first time */
  for (lasttime = granularity - 1;
       lasttime >= 0 && lastdp -> reqs[lasttime] == 0; lasttime--)
    ;
  for (i = lastdate; i >= firstdate; i--) {
    for (j = (int)(granularity - relgran); j >= 0; j -= relgran) {
      reqs = 0;
      pages = 0;
      bys = 0.0;
      for (k = 0; k < relgran; k++) {
	reqs += dp -> reqs[j + k];
	pages += dp -> pages[j + k];
	bys += dp -> bytes[j + k];
      }
      if ((dp != lastdp || j <= lasttime) &&
	  (dp != firstdp || j + (int)relgran > firsttime)) {
	totr += reqs;
	totp += pages;
	totb += bys;
	if (((graphby == 'R' || graphby == 'r') && reqs >= busyr) ||
	    ((graphby == 'P' || graphby == 'p') && pages >= busyp) ||
	    ((graphby == 'B' || graphby == 'b') && bys >= busyb)) {
	  busyr = reqs;
	  busyp = pages;
	  busyb = bys;
	  busydate = i;
	  busymin = (1440 * j) / granularity;
	}
	if (rowsdone < rows) {
	  maxr = MAX(maxr, reqs);
	  maxp = MAX(maxp, pages);
	  maxb = MAX(maxb, bys);
	  trp -> prev = (Timerep *)xmalloc(sizeof(Timerep));
	  trp -> prev -> next = trp;
	  trp = trp -> prev;
	  trp -> reqs = reqs;
	  trp -> pages = pages;
	  trp -> bytes = bys;
	  trp -> date = i;
	  trp -> prev = NULL;
	  rowsdone++;
	  if (rowsdone == rows) /* set now because j will be destroyed */
	    min = (1440 * j) / granularity;
	}
      }
    }
    dp = dp -> prev;
  }

  width[COL_TITLE] = MAX(datefmtlen(datefmt, monthlen, daylen, compsep),
			 htmlstrlen(colhead, outstyle));
  calcsizes(outstyle, width, &bmult, &unit, maxr, maxp, maxb, pagewidth,
	    mingraphwidth, graphby, repsepchar, rawbytes, cols, 0, 0, lngstr);
  declareunit(outf, outstyle, graphby, unit, bmult, markchar, sepchar,
	      imagedir, lngstr);

  if (back || rowsdone != rows)  /* o/wise set above */
    min = (int)((1440 * ((back?lasttime:firsttime) / relgran)) / repgran);
  hr = min / 60;
  min %= 60;
  PRESTART();
  colheads(outf, cols, outstyle, width, bmult, rawbytes, colhead, TRUE,
	   lngstr);
  for (trp = back?(trhead -> prev):trp; trp != (back?NULL:trhead); ) {
    if (!first &&
	((rep == REP_HOURREP && hr == (back?23:0)) ||
	 (rep == REP_QUARTER && min == (back?45:0) &&
	  (hr % 4) == (back?3:0)) ||
	 (rep == REP_FIVE && min == (back?55:0)) ||
	 (rep == REP_DAYREP && DAYOFWEEK(trp -> date) ==
	  (back?((weekbeginson + 6) % 7):weekbeginson))))
      (void)fputc('\n', outf);
    if (rep == REP_QUARTER)
      newmin = (min + 15) % 60;
    else if (rep == REP_FIVE)
      newmin = (min + 5) % 60;
    printcols(outf, rep, cols, outstyle, trp -> reqs, trp -> pages,
	      trp -> bytes, totr, totp, totb, width, bmult, graphby, unit,
	      markchar, repsepchar, decpt, compsep, TRUE, TRUE, imagedir, html,
	      "", FALSE, 0, NULL, NULL, NULL, datefmt, trp -> date,
	      (unsigned int)hr, (unsigned int)min,
	      (unsigned int)((newmin == 0)?(hr + 1):(hr)),
	      (unsigned int)newmin, monthname, dayname, monthlen, daylen,
	      plainmonthlen, plaindaylen);
    first = FALSE;
    if (rep == REP_HOURREP)
      hr += back?(-1):(+1);
    else if (rep == REP_QUARTER)
      min += back?(-15):(+15);
    else if (rep == REP_FIVE)
      min += back?(-5):(+5);
    if (min >= 60) {
      min -= 60;
      hr++;
    }
    else if (min < 0) {
      min += 60;
      hr--;
    }
    if (hr >= 24)
      hr -= 24;
    else if (hr < 0)
      hr += 24;
    oldtrp = trp;
    trp = back?(trp -> prev):(trp -> next);
    free((void *)oldtrp);
  }
  PREEND();
  busyhr = busymin / 60;
  busymin %= 60;
  if (rep == REP_QUARTER)
    newmin = (busymin + 15) % 60;
  else if (rep == REP_FIVE)
    newmin = (busymin + 5) % 60;
  busyprintf(outf, outstyle, datefmt, busyr, busyp, busyb, busydate,
	     (unsigned int)busyhr, (unsigned int)busymin,
	     (unsigned int)((newmin == 0)?(busyhr + 1):(busyhr)),
	     (unsigned int)newmin, graphby, sepchar, rawbytes, lngstr,
	     monthname, dayname, plainmonthlen, plaindaylen, busystr);
}

void superdayrep(FILE *outf, choice rep, Daysdata *firstdp, Daysdata *lastdp,
		 datecode_t firstdate, datecode_t lastdate, choice outstyle,
		 unsigned int granularity, unsigned int pagewidth,
		 unsigned int mingraphwidth, logical back, logical rawbytes,
		 choice *cols, unsigned int rows, char graphby, char markchar,
		 char sepchar, char repsepchar, char decpt, char *compsep,
		 choice weekbeginson, char *imagedir, logical html,
		 char **monthname, unsigned int monthlen,
		 unsigned int plainmonthlen, char **lngstr, char *datefmt,
		 char *colhead, char *busystr) {
  Daysdata *dp;
  Timerep *trhead, *trp, *oldtrp;
  unsigned long reqs = 0, pages = 0, totr = 0, totp = 0;
  unsigned long maxr = 0, maxp = 0, busyr = 0, busyp = 0;
  double bys = 0.0, totb = 0.0, maxb = 0.0, busyb = 0.0;
  long unit = 0;
  unsigned int width[COL_NUMBER], bmult, date, dummy1, dummy2;
  logical save, first = TRUE;
  datecode_t busydate, i;
  unsigned long rowsdone = 0;
  unsigned int j;

  dp = lastdp;
  trhead = (Timerep *)xmalloc(sizeof(Timerep));
  trp = trhead;

  if (rows == 0)
    rows = INT_MAX;
  for (i = lastdate; i >= firstdate; i--) {
    for (j = 0; j < granularity; j++) {
      reqs += dp -> reqs[j];
      pages += dp -> pages[j];
      bys += dp -> bytes[j];
    }
    if (rep == REP_MONTH) {
      code2date(i, &date, &dummy1, &dummy2);
      save = (date == 1) || (i == firstdate);
    }
    else
      save = (DAYOFWEEK(i) == weekbeginson) || (i == firstdate);
    if (save) {
      totr += reqs;
      totp += pages;
      totb += bys;
      if (((graphby == 'R' || graphby == 'r') && reqs >= busyr) ||
	  ((graphby == 'P' || graphby == 'p') && pages >= busyp) ||
	  ((graphby == 'B' || graphby == 'b') && bys >= busyb)) {
	busyr = reqs;
	busyp = pages;
	busyb = bys;
	busydate = i;
      }
      if (rowsdone < rows) {
	maxr = MAX(maxr, reqs);
	maxp = MAX(maxp, pages);
	maxb = MAX(maxb, bys);
	trp -> prev = (Timerep *)xmalloc(sizeof(Timerep));
	trp -> prev -> next = trp;
	trp = trp -> prev;
	trp -> reqs = reqs;
	trp -> pages = pages;
	trp -> bytes = bys;
	while (rep == REP_WEEK && DAYOFWEEK(i) != weekbeginson)
	  i--;  /* destroys i, but in this case we've finished with it */
	trp -> date = i;
	trp -> prev = NULL;
	rowsdone++;
      }
      reqs = 0;
      pages = 0;
      bys = 0.0;
    }
    dp = dp -> prev;
  }

  width[COL_TITLE] = MAX(datefmtlen(datefmt, monthlen, 0, compsep),
			 htmlstrlen(colhead, outstyle));
  calcsizes(outstyle, width, &bmult, &unit, maxr, maxp, maxb, pagewidth,
	    mingraphwidth, graphby, repsepchar, rawbytes, cols, 0, 0, lngstr);
  declareunit(outf, outstyle, graphby, unit, bmult, markchar, sepchar,
	      imagedir, lngstr);
  PRESTART();
  colheads(outf, cols, outstyle, width, bmult, rawbytes, colhead, TRUE,
	   lngstr);
  for (trp = back?(trhead -> prev):trp; trp != (back?NULL:trhead); ) {
    if (rep == REP_MONTH) {
      code2date(trp -> date, &dummy1, &date, &dummy2);
      if (date == (unsigned int)((back?11:0) && !first))
	(void)fputc('\n', outf);
      first = FALSE;
    }
    printcols(outf, rep, cols, outstyle, trp -> reqs, trp -> pages,
	      trp -> bytes, totr, totp, totb, width, bmult, graphby, unit,
	      markchar, repsepchar, decpt, compsep, TRUE, TRUE, imagedir, html,
	      "", FALSE, 0, NULL, NULL, NULL, datefmt, trp -> date, 0, 0, 0, 0,
	      monthname, NULL, monthlen, 0, plainmonthlen, 0);
    oldtrp = trp;
    trp = back?(trp -> prev):(trp -> next);
    free((void *)oldtrp);
  }
  PREEND();
  while (rep == REP_WEEK && DAYOFWEEK(busydate) != weekbeginson)
    busydate--;  /* if first week is busiest */
  busyprintf(outf, outstyle, datefmt, busyr, busyp, busyb, busydate, 0, 0, 0,
	     0, graphby, sepchar, rawbytes, lngstr, monthname, NULL,
	     plainmonthlen, 0, busystr);
}

void daysum(FILE *outf, Daysdata *firstdp, datecode_t firstdate,
	    datecode_t lastdate, choice outstyle, unsigned int granularity,
	    choice weekbeginson, unsigned int pagewidth,
	    unsigned int mingraphwidth, logical rawbytes, choice *cols,
	    char graphby, char markchar, char sepchar, char repsepchar,
	    char decpt, char *compsep, char *imagedir, logical html,
	    char *colhead, char **dayname, unsigned int daylen,
	    char **lngstr) {
  Daysdata *dp;
  unsigned long reqs[7], pages[7], totr = 0, totp = 0;
  double bys[7], totb = 0.0;
  long unit = 0;
  unsigned int width[COL_NUMBER], bmult;
  choice weekday;
  datecode_t date;
  unsigned int i;

  for (i = 0; i < 7; i++) {
    reqs[i] = 0;
    pages[i] = 0;
    bys[i] = 0.0;
  }

  dp = firstdp;
  for (date = firstdate; date <= lastdate; date++) {
    weekday = DAYOFWEEK(date);
    for (i = 0; i < granularity; i++) {
      reqs[weekday] += dp -> reqs[i];
      totr += dp -> reqs[i];
      pages[weekday] += dp -> pages[i];
      totp += dp -> pages[i];
      bys[weekday] += dp -> bytes[i];
      totb += dp -> bytes[i];
    }
    dp = dp -> next;
  }

  width[COL_TITLE] = MAX(daylen, htmlstrlen(lngstr[day_], outstyle));

  calcsizes(outstyle, width, &bmult, &unit, arraymaxl(reqs, 7),
	    arraymaxl(pages, 7), arraymaxd(bys, 7), pagewidth, mingraphwidth,
	    graphby, repsepchar, rawbytes, cols, 0, 0, lngstr);
  declareunit(outf, outstyle, graphby, unit, bmult, markchar, sepchar,
	      imagedir, lngstr);
  PRESTART();
  colheads(outf, cols, outstyle, width, bmult, rawbytes, colhead, TRUE,
	   lngstr);
  for (i = 0; i < 7; i++) {
    weekday = (weekbeginson + i) % 7;
    printcols(outf, REP_DAYSUM, cols, outstyle, reqs[weekday], pages[weekday],
	      bys[weekday], totr, totp, totb, width, bmult, graphby, unit,
	      markchar, repsepchar, decpt, compsep, TRUE, TRUE, imagedir, html,
	      dayname[weekday], FALSE, 0, NULL, NULL, NULL, "", 0, 0, 0, 0, 0,
	      NULL, NULL, 0, 0, 0, 0);
  }
  PREEND();
}

void hoursum(FILE *outf, Daysdata *firstdp, Daysdata *lastdp, choice outstyle,
	     unsigned int granularity, unsigned int pagewidth,
	     unsigned int mingraphwidth, logical rawbytes, choice *cols,
	     char graphby, char markchar, char sepchar, char repsepchar,
	     char decpt, char *compsep, char *imagedir, logical html,
	     char *colhead, char **lngstr) {
  Daysdata *dp;
  unsigned long reqs[24], pages[24], totr = 0, totp = 0;
  long unit = 0;
  double bys[24], totb = 0.0;
  unsigned int width[COL_NUMBER], bmult;
  logical finished = FALSE;
  char temps[3];
  unsigned int i;

  for (i = 0; i < 24; i++) {
    reqs[i] = 0;
    pages[i] = 0;
    bys[i] = 0.0;
  }
  
  for (dp = firstdp; !finished; TO_NEXT(dp)) {
    for (i = 0; i < granularity; i++) {
      reqs[(i * 24) / granularity] += dp -> reqs[i];
      totr += dp -> reqs[i];
      pages[(i * 24) / granularity] += dp -> pages[i];
      totp += dp -> pages[i];
      bys[(i * 24) / granularity] += dp -> bytes[i];
      totb += dp -> bytes[i];
    }
    if (dp == lastdp)
      finished = TRUE;
  }

  width[COL_TITLE] = MAX(2, htmlstrlen(lngstr[hr_], outstyle));
  calcsizes(outstyle, width, &bmult, &unit, arraymaxl(reqs, 24),
	    arraymaxl(pages, 24), arraymaxd(bys, 24), pagewidth, mingraphwidth,
	    graphby, repsepchar, rawbytes, cols, 0, 0, lngstr);
  declareunit(outf, outstyle, graphby, unit, bmult, markchar, sepchar,
	      imagedir, lngstr);
  PRESTART();
  colheads(outf, cols, outstyle, width, bmult, rawbytes, colhead, TRUE,
	   lngstr);
  for (i = 0; i < 24; i++) {
    (void)sprintf(temps, "%d", i);
    printcols(outf, REP_HOURSUM, cols, outstyle, reqs[i], pages[i], bys[i],
	      totr, totp, totb, width, bmult, graphby, unit, markchar,
	      repsepchar, decpt, compsep, TRUE, TRUE, imagedir, html, temps,
	      FALSE, 0, NULL, NULL, NULL, "", 0, 0, 0, 0, 0, NULL, NULL, 0, 0,
	      0, 0);
  }
  PREEND();
}

void printtree(FILE *outf, choice rep, choice outstyle, Hashtable *tree,
	       choice requests, choice date, Hashentry *badp,
	       unsigned long badn, unsigned int level,
	       Strlist *partname, Alias *aliashead, Include *linkhead,
	       char *baseurl, unsigned long totr, unsigned long totp,
	       double totb, unsigned int width[], unsigned int bmult,
	       long unit, char sepchar, char repsepchar, char decpt,
	       char *compsep, logical rawbytes, choice *cols, char *colhead,
	       char *colheadp, char gender, logical html, char **monthname,
	       char **dayname, unsigned int monthlen, unsigned int daylen,
	       unsigned int plainmonthlen, unsigned int plaindaylen,
	       char **lngstr) {
  static char *name = NULL;
  static size_t len = 0;
  size_t need = (size_t)level + 3;
  Hashindex *p;
  Strlist s, *pn, *n;
  logical back = (rep == REP_TYPE || rep == REP_DOM);
  logical numdom = FALSE;
  char *notlistedstr;
  char *glue = back?".":
    ((rep == REP_DIR || rep == REP_REFSITE || rep == REP_BROWSUM)?"/":"?");

  if (tree != NULL) {
    for (pn = partname; pn != NULL; TO_NEXT(pn))
      need += strlen(pn -> name);
    for (p = tree -> head[0]; p != NULL; TO_NEXT(p)) {
      ENSURE_LEN(name, len, need + strlen(p -> name));
      s.name = p -> name;
      if (rep == REP_DOM && partname != NULL && STREQ(partname -> name, "0")) {
	back = FALSE;
	numdom = TRUE;
      }
      if (back || partname == NULL) {
	s.next = partname;
	n = &s;
      }
      else {
	for (pn = partname; pn -> next != NULL; TO_NEXT(pn))
	  ;
	pn -> next = &s;
	s.next = NULL;
	n = partname;
      }
      if (numdom)
	maketreename(name, n -> next, glue, FALSE, FALSE);
      else
	maketreename(name, n, glue, (logical)(rep == REP_TYPE),
		     (logical)(rep == REP_REFSITE || rep == REP_DIR));
      printcols(outf, rep, cols, outstyle, p -> own -> data[requests],
		p -> own -> data[PAGES], p -> own -> bytes, totr, totp, totb,
		width, bmult, '\0', unit, '\0', repsepchar, decpt, compsep,
		FALSE, FALSE, NULL, html, name,
		(logical)(p -> own -> ispage % 16), 2 * level, aliashead,
		linkhead, baseurl, lngstr[genrepfmt_],
		p -> own -> data[date] / 1440,
		(p -> own -> data[date] % 1440) / 60,
		p -> own -> data[date] % 60, 0, 0, monthname, dayname,
		monthlen, daylen, plainmonthlen, plaindaylen);
      printtree(outf, rep, outstyle, (Hashtable *)(p -> other),
		requests, date, NULL, 0, level + 1, n, aliashead, linkhead,
		baseurl, totr, totp, totb, width, bmult, unit, sepchar,
		repsepchar, decpt, compsep, rawbytes, cols, NULL, NULL, gender,
		html, monthname, dayname, monthlen, daylen, plainmonthlen,
		plaindaylen, lngstr);
    }
  }
  if (badn > 0 && level == 0) {
    printcols(outf, rep, cols, outstyle, badp -> data[requests],
	      badp -> data[PAGES], badp -> bytes, totr, totp, totb, width,
	      bmult, '\0', unit, '\0', repsepchar, decpt, compsep, FALSE,
	      FALSE, NULL, html, NULL, FALSE, 0, NULL, NULL, NULL,
	      lngstr[genrepfmt_], badp -> data[date] / 1440,
	      (badp -> data[date] % 1440) / 60, badp -> data[date] % 60, 0, 0,
	      monthname, dayname, monthlen, daylen, plainmonthlen,
	      plaindaylen);
    if (gender == 'm')
      notlistedstr = lngstr[notlistedm_];
    else if (gender == 'f')
      notlistedstr = lngstr[notlistedf_];
    else
      notlistedstr = lngstr[notlistedn_];
    (void)fprintf(outf, "[%s: ", notlistedstr);
    f3printf(outf, outstyle, (double)badn, 0, sepchar);
    if (outstyle == COMPUTER)
      (void)fprintf(outf, "]\n");
    else
      (void)fprintf(outf, " %s]\n", (badn == 1)?colhead:colheadp);
  }
}

void treerep(FILE *outf, choice rep, choice outstyle, Tree *treex,
	     Hashindex *gooditems, Hashindex *baditems, Alias *aliashead,
	     Include *wanthead, Include *linkhead, char *baseurl,
	     choice *alltrees, choice requests, choice date, Floor *floor,
	     choice sortby, Floor *subfloor, choice subsortby,
	     unsigned int pagewidth, char sepchar, char repsepchar, char decpt,
	     char *compsep, logical rawbytes, choice *cols, char *colhead,
	     char *colheadp, char *gens, char *genp, char gender, logical html,
	     timecode_t firsttime, char **monthname, char **dayname,
	     unsigned int monthlen, unsigned int daylen,
	     unsigned int plainmonthlen, unsigned int plaindaylen,
	     char **lngstr) {
  Hashtable *tree;
  Hashindex *p;
  Hashentry *badp;
  unsigned long totr = 0, totp = 0, maxr = 0, maxp = 0, goodn = 0, badn, i;
  double totb = 0.0, maxb = 0.0;
  unsigned int width[COL_NUMBER], bmult;
  long unit = 1;
  logical templ = FALSE;

  for (i = 0; alltrees[i] != REP_NUMBER; i++)
    if (rep == alltrees[i])
      templ = TRUE;   /* tree already constructed */
  if (!templ)
    maketree(treex, gooditems, baditems);
  tree = treex -> tree;
  for (i = 0; i < tree -> size; i++) {
    for (p = tree -> head[i]; p != NULL; TO_NEXT(p)) {
      totr += p -> own -> data[requests]; /* tot of top level = overall tot */
      totp += p -> own -> data[PAGES];    /* also max's all on top level */
      totb += p -> own -> bytes;
      maxr = MAX(maxr, p -> own -> data[requests]);
      maxp = MAX(maxp, p -> own -> data[PAGES]);
      maxb = MAX(maxb, p -> own -> bytes);
    }
  }

  tree -> head[0] = sorttree(tree, floor, sortby, subfloor, subsortby,
			     wanthead, (rep == REP_DOM)?aliashead:NULL,
			     requests, date, totr, totp, totb, maxr, maxp,
			     maxb, &badp, &badn, treex -> space);
  maxr = badp -> data[requests];
  maxp = badp -> data[PAGES];
  maxb = badp -> bytes;
  for (p = tree -> head[0]; p != NULL; TO_NEXT(p)) {
    maxr = MAX(maxr, p -> own -> data[requests]);
    maxp = MAX(maxp, p -> own -> data[PAGES]);
    maxb = MAX(maxb, p -> own -> bytes);
    goodn++;
  }
  width[COL_TITLE] = 0;
  calcsizes(outstyle, width, &bmult, &unit, maxr, maxp, maxb, 0, 0, '\0',
	    repsepchar, rawbytes, cols, monthlen, daylen, lngstr);
  whatincluded(outf, outstyle, goodn, pagewidth, floor, sortby, decpt, gens,
	       genp, gender, requests, date, firsttime, monthname, dayname,
	       plainmonthlen, plaindaylen, lngstr);
  PRESTART();
  colheads(outf, cols, outstyle, width, bmult, rawbytes, colhead, FALSE,
	   lngstr);
  printtree(outf, rep, outstyle, tree, requests, date, badp, badn, 0, NULL,
	    aliashead, linkhead, baseurl, totr, totp, totb, width, bmult, unit,
	    sepchar, repsepchar, decpt, compsep, rawbytes, cols, colhead,
	    colheadp, gender, html, monthname, dayname, monthlen, daylen,
	    plainmonthlen, plaindaylen, lngstr);
  PREEND();

  freemm(treex -> space);
}

void sizerep(FILE *outf, choice outstyle, Sizedata *sizes, char repsepchar,
	     char decpt, char *compsep, logical rawbytes, choice *cols,
	     char *colhead, logical html, char **monthname, char **dayname,
	     unsigned int monthlen, unsigned int daylen,
	     unsigned int plainmonthlen, unsigned int plaindaylen,
	     char **lngstr) {
  extern char *sizestr[];

  unsigned long totr = 0, totp = 0, maxr = 0, maxp = 0;
  double totb = 0.0, maxb = 0.0;
  unsigned int width[COL_NUMBER], bmult;
  long unit = 1;
  choice i, maxi = 0;

  for (i = 0; i < SIZEBINS; i++) {
    totr += sizes -> reqs[i];
    totp += sizes -> pages[i];
    totb += sizes -> bytes[i];
    maxr = MAX(maxr, sizes -> reqs[i]);
    maxp = MAX(maxp, sizes -> pages[i]);
    maxb = MAX(maxb, sizes -> bytes[i]);
    if (sizes -> reqs[i] > 0)
      maxi = i;
  }
  width[COL_TITLE] = MAX(arraymaxlen(sizestr, SIZEBINS, outstyle),
			 htmlstrlen(colhead, outstyle));
  calcsizes(outstyle, width, &bmult, &unit, maxr, maxp, maxb, 0, 0, '\0',
	    repsepchar, rawbytes, cols, monthlen, daylen, lngstr);
  PRESTART();
  colheads(outf, cols, outstyle, width, bmult, rawbytes, colhead, TRUE,
	   lngstr);
  for (i = 0; i <= maxi; i++)
    printcols(outf, REP_SIZE, cols, outstyle, sizes -> reqs[i],
	      sizes -> pages[i], sizes -> bytes[i], totr, totp, totb, width,
	      bmult, '\0', unit, '\0', repsepchar, decpt, compsep, TRUE, FALSE,
	      NULL, html, sizestr[i], FALSE, 0, NULL, NULL, NULL,
	      lngstr[genrepfmt_], sizes -> lastdate[i] / 1440,
	      (sizes -> lastdate[i] % 1440) / 60, sizes -> lastdate[i] % 60, 0,
	      0, monthname, dayname, monthlen, daylen, plainmonthlen,
	      plaindaylen);
  PREEND();
}

void coderep(FILE *outf, choice outstyle, Floor *floor, choice sortby,
	     unsigned int pagewidth, char sepchar, char repsepchar, char decpt,
	     char *compsep, choice *cols, char *colhead, char *colheadp,
	     char *gens, char *genp, char gender, logical html,
	     timecode_t firsttime, char **monthname, char **dayname,
	     unsigned int monthlen, unsigned int daylen,
	     unsigned int plainmonthlen, unsigned int plaindaylen,
	     char **lngstr) {
  extern Memman *xmemman;
  extern Statuscodes scs[];
  Hashindex *good = NULL, *bad = NULL, *gp;
  choice i;
  /* strategy: construct list of (Hashindex *), and pass to genrep() */

  for (i = 0; scs[i].code < 600; i++) {
    if (scs[i].n > 0) {
      if (good == NULL) {
	gp = (Hashindex *)submalloc(xmemman, sizeof(Hashindex));
	good = gp;
      }
      else {
	gp -> next = (Hashindex *)submalloc(xmemman, sizeof(Hashindex));
	TO_NEXT(gp);
      }
      gp -> name = scs[i].description;
      gp -> own = newhashentry(FALSE);
      gp -> own -> data[REQUESTS] = scs[i].n;
      gp -> own -> data[SUCCDATE] = scs[i].lastdate;
      gp -> next = NULL;
    }
  }
  genrep(outf, REP_CODE, outstyle, &good, &bad, NULL, NULL, REQUESTS, SUCCDATE,
	 floor, sortby, FALSE, pagewidth, sepchar, repsepchar, decpt, compsep,
	 TRUE, cols, colhead, colheadp, gens, genp, gender, html, firsttime,
	 monthname, dayname, monthlen, daylen, plainmonthlen, plaindaylen,
	 lngstr);
}

logical checkonerep(Hashindex *gp, choice requests) {

  for ( ; gp != NULL; TO_NEXT(gp)) {
    if (gp -> own != NULL && gp -> own -> data[requests] > 0)
      return(TRUE);
  }
  return(FALSE);
}

void checkreps(logical *repq, Dateman *dman, choice *alltrees,
	       Hashindex **gooditems, Sizedata *sizes) {
  extern Statuscodes scs[];
  extern choice *rep2type, *rep2reqs;
  extern char *repname[];
  int i, j;
  logical ok;

  if (dman -> currdp == NULL) {
    for (i = 0; i < DATEREP_NUMBER; i++) {
      if (repq[i]) {
	warn('R', "Turning off empty time reports");
	for ( ; i < DATEREP_NUMBER; i++)
	  repq[i] = FALSE;
      }
    }
  }
  for (i = FIRST_GENREP; i <= LAST_NORMALREP; i++) {
    for (ok = FALSE, j = 0; alltrees[j] != REP_NUMBER; j++) {
      if (i == alltrees[j])
	ok = TRUE;
    }
    if (repq[i] && !ok && !checkonerep(gooditems[rep2type[i]],
				       rep2reqs[G(i)])) {
      warn('R', "Turning off empty %s", repname[i]);
      repq[i] = FALSE;
    }
  }
  if (repq[REP_SIZE]) {
    for (ok = FALSE, i = 0; !ok && i < SIZEBINS; i++) {
      if (sizes -> reqs[i] > 0)
	ok = TRUE;
    }
    if (!ok) {
      warn('R', "Turning off empty %s", repname[REP_SIZE]);
      repq[REP_SIZE] = FALSE;
    }
  }
  if (repq[REP_CODE]) {
    for (ok = FALSE, i = 0; !ok && scs[i].code < 600; i++) {
      if (scs[i].n > 0)
	ok = TRUE;
    }
    if (!ok) {
      warn('R', "Turning off empty %s", repname[REP_CODE]);
      repq[REP_CODE] = FALSE;
    }
  }
}
