/*** analog 3.0 ***/
/* Please read Readme.html, or http://www.statslab.cam.ac.uk/~sret1/analog/  */

/*** init.c; initialisation routines and declaration of global variables ***/
/* See also init2.c */

#include "analhea2.h"

/*** First declare all global variables ***/

/* Program time */
time_t origstarttime, starttime;
timecode_t starttimec;

/* What to read from input lines */
unsigned int year, month, date, hr, min, code;
double bytes;
char am;

/* Input processing */
char *block_start, *block_end, *block_bell, *record_start, *pos;
logical termchar[256];

/* Memory allocation */
Memman *xmemman, *amemman, mm[ITEM_NUMBER], mmq;
char *workspace;

/* DNS lookups: externs so that no worries about whether to pass them around */
#ifndef NODNS
choice dnslevel;
char *dnsfile;
FILE *dnsfilep;
Hashtable *dnstable;
unsigned int dnsgoodhrs, dnsbadhrs;
#endif

/* Signal entries for unwanted hash entries (NULL is already used for unset) */
Hashentry *unwanted_entry, *blank_entry;
Hashindex *dummy_item;

/* Translating reports to other arrays */
choice *rep2type, *rep2reqs, *rep2date;
unsigned int *rep2gran, *rep2lng, *rep2datefmt, *rep2colhead, *rep2busystr;
unsigned int *col2colhead, *method2sing, *method2pl, *method2date;
unsigned int *method2pc, *method2relpc, *method2sort;
char byteprefix[] = {' ', 'k', 'M', 'G', 'T'};

/* Log formats */
Inputformatlist *logformat = NULL, *deflogformat;
logical newloglist = TRUE;
int tz = 0, stz = 0;
Alias *uncompresshead = NULL;
choice wantitem[INPUT_NUMBER];

/* Debugging and warnings */
char *commandname;
char *debug_args, *warn_args;
logical anywarns = FALSE, errmess = FALSE, vblesonly = FALSE;
unsigned long progressfreq = 0;

/* Report code letters in order of enum in analhea2.h */
char repcodes[] = "mWDdHh45xrEItiSofskKBbvuJzc";
/* Names for things, always in order of enums in analhea2.h */
char *item_type[] = {"virtual hosts", "files", "users", "referrers",
		       "browsers", "hosts"};
/* In methodname, we don't need them all, because some only occur internally */
char *methodname[] = {"requests", "pages", "", "", "date", "", "", "bytes",
			"alphabetical", "random"};
/* These report names are in English, so not the same as in langfile */
char *repname[] = {"Monthly Report", "Weekly Report", "Daily Report",
		   "Daily Summary", "Hourly Report", "Hourly Summary",
		   "Quarter-Hour Report", "Five-Minute Report",
		   "General Summary", "Request Report", "Redirection Report",
		   "Failure Report", "File Type Report", "Directory Report",
		   "Host Report", "Domain Report", "Referrer Report",
		   "Referring Site Report", "Redirected Referrer Report",
		   "Failed Referrer Report", "Browser Report",
		   "Browser Summary", "Virtual Host Report", "User Report",
		   "User Failure Report", "File Size Report",
		   "Status Code Report"};

Statuscodes scs[] = {
  {100, "100 Continue with request", 0, 0},
  {101, "101 Switching protocols", 0, 0},
  {199, "    [Miscellaneous informational]", 0, 0},
  {200, "200 OK", 0, 0},
  {201, "201 Created", 0, 0},
  {202, "202 Accepted for future processing", 0, 0},
  {203, "203 Non-authoritative information", 0, 0},
  {204, "204 OK, but nothing to send", 0, 0},
  {205, "205 Reset document", 0, 0},
  {206, "206 Partial content", 0, 0},
  {299, "    [Miscellaneous successes]", 0, 0},
  {300, "300 Multiple documents available", 0, 0},
  {301, "301 Document moved permanently", 0, 0},
  {302, "302 Document found elsewhere", 0, 0},
  {303, "303 See other document", 0, 0},
  {304, "304 Not modified since last retrieval", 0, 0},
  {305, "305 Use proxy", 0, 0},
  {306, "306 Switch proxy", 0, 0},
  {307, "307 Document moved temporarily", 0, 0},
  {399, "    [Miscellaneous redirections]", 0, 0},
  {400, "400 Bad request", 0, 0},
  {401, "401 Authentication required", 0, 0},
  {402, "402 Payment required", 0, 0},
  {403, "403 Access forbidden", 0, 0},
  {404, "404 Document not found", 0, 0},
  {405, "405 Method not allowed", 0, 0},
  {406, "406 Document not acceptable to client", 0, 0},
  {407, "407 Proxy authentication required", 0, 0},
  {408, "408 Request timeout", 0, 0},
  {409, "409 Request conflicts with state of resource", 0, 0},
  {410, "410 Document gone permanently", 0, 0},
  {411, "411 Length required", 0, 0},
  {412, "412 Precondition failed", 0, 0},
  {413, "413 Request too long", 0, 0},
  {414, "414 Requested filename too long", 0, 0},
  {415, "415 Unsupported media type", 0, 0},
  {416, "416 Requested range not valid", 0, 0},
  {417, "417 Failed", 0, 0},
  {418, "418 Failed", 0, 0},
  {419, "419 Expectation failed", 0, 0},
  {499, "    [Miscellaneous client/user errors]", 0, 0},
  {500, "500 Internal server error", 0, 0},
  {501, "501 Request type not supported", 0, 0},
  {502, "502 Error at upstream server", 0, 0},
  {503, "503 Service temporarily unavailable", 0, 0},
  {504, "504 Gateway timeout", 0, 0},
  {505, "505 HTTP version not supported", 0, 0},
  {506, "506 Redirection failed", 0, 0},
  {599, "    [Miscellaneous server errors]", 0, 0},
  {600, "Dummy to signal end of list", 0, 0}
};

/* EBCDIC character set */
/* This character set was contributed to analog by
   Martin Kraemer (Martin.Kraemer@Mch.SNI.De) and
   Holger Schranz (schranz@munich.crosswinds.net). It was originally
   developed by the Apache Group for use in the Apache HTTP server project
   (http://www.apache.org/).
   Copyright (c) 1998 The Apache Group.  All rights reserved. */
#ifdef EBCDIC
unsigned char os_toebcdic[256] = {
  /*00*/  0x00, 0x01, 0x02, 0x03, 0x37, 0x2d, 0x2e, 0x2f,
	  0x16, 0x05, 0x15, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,  /*................*/
  /*10*/  0x10, 0x11, 0x12, 0x13, 0x3c, 0x3d, 0x32, 0x26,
	  0x18, 0x19, 0x3f, 0x27, 0x1c, 0x1d, 0x1e, 0x1f,  /*................*/
  /*20*/  0x40, 0x5a, 0x7f, 0x7b, 0x5b, 0x6c, 0x50, 0x7d,
	  0x4d, 0x5d, 0x5c, 0x4e, 0x6b, 0x60, 0x4b, 0x61,  /*!"#$%&'()*+,-./ */
  /*30*/  0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7,
	  0xf8, 0xf9, 0x7a, 0x5e, 0x4c, 0x7e, 0x6e, 0x6f,  /*0123456789:;<=>?*/
  /*40*/  0x7c, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7,
	  0xc8, 0xc9, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6,  /*@ABCDEFGHIJKLMNO*/
  /*50*/  0xd7, 0xd8, 0xd9, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6,
	  0xe7, 0xe8, 0xe9, 0xbb, 0xbc, 0xbd, 0x6a, 0x6d,  /*PQRSTUVWXYZ[\]^_*/
  /*60*/  0x4a, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87,
	  0x88, 0x89, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96,  /*`abcdefghijklmno*/
  /*70*/  0x97, 0x98, 0x99, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6,
	  0xa7, 0xa8, 0xa9, 0xfb, 0x4f, 0xfd, 0xff, 0x07,  /*pqrstuvwxyz{|}~.*/
  /*80*/  0x20, 0x21, 0x22, 0x23, 0x24, 0x04, 0x06, 0x08,
	  0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x09, 0x0a, 0x14,  /*................*/
  /*90*/  0x30, 0x31, 0x25, 0x33, 0x34, 0x35, 0x36, 0x17,
	  0x38, 0x39, 0x3a, 0x3b, 0x1a, 0x1b, 0x3e, 0x5f,  /*................*/
  /*a0*/  0x41, 0xaa, 0xb0, 0xb1, 0x9f, 0xb2, 0xd0, 0xb5,
	  0x79, 0xb4, 0x9a, 0x8a, 0xba, 0xca, 0xaf, 0xa1,  /*................*/
  /*b0*/  0x90, 0x8f, 0xea, 0xfa, 0xbe, 0xa0, 0xb6, 0xb3,
	  0x9d, 0xda, 0x9b, 0x8b, 0xb7, 0xb8, 0xb9, 0xab,  /*................*/
  /*c0*/  0x64, 0x65, 0x62, 0x66, 0x63, 0x67, 0x9e, 0x68,
	  0x74, 0x71, 0x72, 0x73, 0x78, 0x75, 0x76, 0x77,  /*................*/
  /*d0*/  0xac, 0x69, 0xed, 0xee, 0xeb, 0xef, 0xec, 0xbf,
	  0x80, 0xe0, 0xfe, 0xdd, 0xfc, 0xad, 0xae, 0x59,  /*................*/
  /*e0*/  0x44, 0x45, 0x42, 0x46, 0x43, 0x47, 0x9c, 0x48,
	  0x54, 0x51, 0x52, 0x53, 0x58, 0x55, 0x56, 0x57,  /*................*/
  /*f0*/  0x8c, 0x49, 0xcd, 0xce, 0xcb, 0xcf, 0xcc, 0xe1,
	  0x70, 0xc0, 0xde, 0xdb, 0xdc, 0x8d, 0x8e, 0xdf   /*................*/
};
#endif

Inputfns inpfns[] = { /* first the ITEM fns in any order */
  /* See also ITEMFNS_NUMBER in analhea2.c */
  {'v', ITEM_VHOST, &parsestring, &mm[ITEM_VHOST]},
  {'r', ITEM_FILE, &parsestring, &mm[ITEM_FILE]},
  {'R', ITEM_FILE, &parsemacfile, &mm[ITEM_FILE]},
  {'u', ITEM_USER, &parsestring, &mm[ITEM_USER]},
  {'f', ITEM_REFERRER, &parsestring, &mm[ITEM_REFERRER]},
  {'B', ITEM_BROWSER, &parsestring, &mm[ITEM_BROWSER]},
  {'S', ITEM_HOST, &parsestring, &mm[ITEM_HOST]},
  {'F', ITEM_REFERRER, &parseref, &mm[ITEM_REFERRER]},
  {'q', INP_QUERY, &parsestring, &mmq},
  {'n', INP_MIN, &parseuint2strict, (void *)&min},
  {'h', INP_HOUR, &parseuint2, (void *)&hr},
  {'a', INP_AM, &parseam, (void *)&am},
  {'d', INP_DATE, &parseuint2, (void *)&date},
  {'m', INP_MONTH, &parsenmonth, (void *)&month},
  {'M', INP_MONTH, &parsemonth, (void *)&month},
  {'y', INP_YEAR, &parseyear, (void *)&year},
  {'Y', INP_YEAR, &parseuint4strict, (void *)&year},
  {'c', INP_CODE, &parseuint3strict, (void *)&code},
  {'C', INP_CODE, &parsecode, (void *)&code},
  {'b', INP_BYTES, &parseudint, (void *)&bytes},
  {'w', UNSET, &parsespace, NULL},
  {'W', UNSET, &parseoptspace, NULL},
  {'j', UNSET, &parsejunk, NULL},
  {'x', UNSET, &parselogfmt, NULL},
  {'\0', UNSET, &checkchar, NULL}  /* this one must be last as marker */
};
Inputfns pnlinpfn = {'\n', UNSET, &parsenewline, NULL};
Inputfns ccinpfn = {'\0', UNSET, &checkchar, NULL};
Inputfns pjinpfn = {'j', UNSET, &parsejunk, NULL};

static Options opts;
/* So that in future we can have several sets of options, and yet still
   declare cf[] neatly as below, we shunt them in and out of opts */
static Configfns cf[] = {
  {"TIMECOLS", &configallcols, (void *)(opts.outopts.cols)},
  {"MONTHCOLS", &configcols, (void *)(opts.outopts.cols[REP_MONTH])},
  {"WEEKCOLS", &configcols, (void *)(opts.outopts.cols[REP_WEEK])},
  {"FULLDAYCOLS", &configcols, (void *)(opts.outopts.cols[REP_DAYREP])},
  {"DAYCOLS", &configcols, (void *)(opts.outopts.cols[REP_DAYSUM])},
  {"FULLHOURCOLS", &configcols, (void *)(opts.outopts.cols[REP_HOURREP])},
  {"HOURCOLS", &configcols, (void *)(opts.outopts.cols[REP_HOURSUM])},
  {"QUARTERCOLS", &configcols, (void *)(opts.outopts.cols[REP_QUARTER])},
  {"FIVECOLS", &configcols, (void *)(opts.outopts.cols[REP_FIVE])},
  {"REQCOLS", &configcols, (void *)(opts.outopts.cols[REP_REQ])},
  {"REDIRCOLS", &configcols, (void *)(opts.outopts.cols[REP_REDIR])},
  {"FAILCOLS", &configcols, (void *)(opts.outopts.cols[REP_FAIL])},
  {"TYPECOLS", &configcols, (void *)(opts.outopts.cols[REP_TYPE])},
  {"SIZECOLS", &configcols, (void *)(opts.outopts.cols[REP_SIZE])},
  {"DIRCOLS", &configcols, (void *)(opts.outopts.cols[REP_DIR])},
  {"HOSTCOLS", &configcols, (void *)(opts.outopts.cols[REP_HOST])},
  {"DOMCOLS", &configcols, (void *)(opts.outopts.cols[REP_DOM])},
  {"REFCOLS", &configcols, (void *)(opts.outopts.cols[REP_REF])},
  {"REFSITECOLS", &configcols, (void *)(opts.outopts.cols[REP_REFSITE])},
  {"REDIRREFCOLS", &configcols, (void *)(opts.outopts.cols[REP_REDIRREF])},
  {"FAILREFCOLS", &configcols, (void *)(opts.outopts.cols[REP_FAILREF])},
  {"FULLBROWCOLS", &configcols, (void *)(opts.outopts.cols[REP_BROWREP])},
  {"BROWCOLS", &configcols, (void *)(opts.outopts.cols[REP_BROWSUM])},
  {"VHOSTCOLS", &configcols, (void *)(opts.outopts.cols[REP_VHOST])},
  {"USERCOLS", &configcols, (void *)(opts.outopts.cols[REP_USER])},
  {"FAILUSERCOLS", &configcols, (void *)(opts.outopts.cols[REP_FAILUSER])},
  {"STATUSCOLS", &configcols, (void *)(opts.outopts.cols[REP_CODE])},
  {"MONTHGRAPH", &configgraph, (void *)&(opts.outopts.graph[REP_MONTH])},
  {"WEEKGRAPH", &configgraph, (void *)&(opts.outopts.graph[REP_WEEK])},
  {"FULLDAYGRAPH", &configgraph, (void *)&(opts.outopts.graph[REP_DAYREP])},
  {"DAYGRAPH", &configgraph, (void *)&(opts.outopts.graph[REP_DAYSUM])},
  {"FULLHOURGRAPH", &configgraph, (void *)&(opts.outopts.graph[REP_HOURREP])},
  {"HOURGRAPH", &configgraph, (void *)&(opts.outopts.graph[REP_HOURSUM])},
  {"QUARTERGRAPH", &configgraph, (void *)&(opts.outopts.graph[REP_QUARTER])},
  {"FIVEGRAPH", &configgraph, (void *)&(opts.outopts.graph[REP_FIVE])},
  {"ALLGRAPH", &configallgraph, (void *)(opts.outopts.graph)},
  {"COMPSEP", &configstr, (void *)&(opts.outopts.compsep)},
  {"PRESEP", &configstr, (void *)&(opts.outopts.compsep)},
  {"HOSTNAME", &configstr, (void *)&(opts.outopts.hostname)},
  {"HOSTURL", &configstr, (void *)&(opts.outopts.hosturl)},
  {"LOGO", &configstr, (void *)&(opts.outopts.logo)},
  {"BASEURL", &configstr, (void *)&(opts.outopts.baseurl)},
  {"LOGFORMAT", &configlogfmt, (void *)&logformat},
  {"DEFAULTLOGFORMAT", &configlogfmt, (void *)&deflogformat},
  {"TIMEOFFSET", &configoffset, (void *)&stz},
  {"LOGTIMEOFFSET", &configoffset, (void *)&tz},
  {"LOGFILE", &configlogfile, (void *)&(opts.miscopts.logfile)},
  {"CACHEFILE", &configcachefile, (void *)&(opts.miscopts.cachefile)},
  {"IMAGEDIR", &configstr, (void *)&(opts.outopts.imagedir)},
  {"HEADERFILE", &configstr, (void *)&(opts.outopts.headerfile)},
  {"FOOTERFILE", &configstr, (void *)&(opts.outopts.footerfile)},
  {"LANGUAGE", &configlang, (void *)&(opts.outopts.lang)},
  {"LANGFILE", &configstr, (void *)&(opts.outopts.lang.file)},
  {"OUTFILE", &configstr, (void *)&(opts.outopts.outfile)},
  {"CACHEOUTFILE", &configstr, (void *)&(opts.outopts.cacheoutfile)},
  {"DOMAINSFILE", &configstr, (void *)&(opts.outopts.domainsfile)},
  {"DIRSUFFIX", &configstr, (void *)&(opts.miscopts.dirsuffix)},
  {"SEPCHAR", &configchar, (void *)&(opts.outopts.sepchar)},
  {"REPSEPCHAR", &configchar, (void *)&(opts.outopts.repsepchar)},
  {"DECPOINT", &configchar, (void *)&(opts.outopts.decpt)},
  {"MARKCHAR", &configchar, (void *)&(opts.outopts.markchar)},
  {"REQFLOOR", &configfloor, (void *)&(opts.outopts.floor[G(REP_REQ)])},
  {"REQARGSFLOOR", &configfloor, (void *)&(opts.outopts.subfloor[G(REP_REQ)])},
  {"REDIRFLOOR", &configfloor, (void *)&(opts.outopts.floor[G(REP_REDIR)])},
  {"REDIRARGSFLOOR", &configfloor,
   (void *)&(opts.outopts.subfloor[G(REP_REDIR)])},
  {"FAILFLOOR", &configfloor, (void *)&(opts.outopts.floor[G(REP_FAIL)])},
  {"FAILARGSFLOOR", &configfloor,
   (void *)&(opts.outopts.subfloor[G(REP_FAIL)])},
  {"TYPEFLOOR", &configfloor, (void *)&(opts.outopts.floor[G(REP_TYPE)])},
  {"SUBTYPEFLOOR", &configfloor,
   (void *)&(opts.outopts.subfloor[G(REP_TYPE)])},
  {"DIRFLOOR", &configfloor, (void *)&(opts.outopts.floor[G(REP_DIR)])},
  {"SUBDIRFLOOR", &configfloor, (void *)&(opts.outopts.subfloor[G(REP_DIR)])},
  {"HOSTFLOOR", &configfloor, (void *)&(opts.outopts.floor[G(REP_HOST)])},
  {"DOMFLOOR", &configfloor, (void *)&(opts.outopts.floor[G(REP_DOM)])},
  {"SUBDOMFLOOR", &configfloor, (void *)&(opts.outopts.subfloor[G(REP_DOM)])},
  {"REFFLOOR", &configfloor, (void *)&(opts.outopts.floor[G(REP_REF)])},
  {"REFARGSFLOOR", &configfloor, (void *)&(opts.outopts.subfloor[G(REP_REF)])},
  {"REFSITEFLOOR", &configfloor,
   (void *)&(opts.outopts.floor[G(REP_REFSITE)])},
  {"REFDIRFLOOR", &configfloor,
   (void *)&(opts.outopts.subfloor[G(REP_REFSITE)])},
  {"REDIRREFFLOOR", &configfloor,
   (void *)&(opts.outopts.floor[G(REP_REDIRREF)])},
  {"REDIRREFARGSFLOOR", &configfloor,
   (void *)&(opts.outopts.subfloor[G(REP_REDIRREF)])},
  {"FAILREFFLOOR", &configfloor,
   (void *)&(opts.outopts.floor[G(REP_FAILREF)])},
  {"FAILREFARGSFLOOR", &configfloor,
   (void *)&(opts.outopts.subfloor[G(REP_FAILREF)])},
  {"FULLBROWFLOOR", &configfloor,
   (void *)&(opts.outopts.floor[G(REP_BROWREP)])},
  {"BROWFLOOR", &configfloor, (void *)&(opts.outopts.floor[G(REP_BROWSUM)])},
  {"SUBBROWFLOOR", &configfloor,
   (void *)&(opts.outopts.subfloor[G(REP_BROWSUM)])},
  {"VHOSTFLOOR", &configfloor, (void *)&(opts.outopts.floor[G(REP_VHOST)])},
  {"USERFLOOR", &configfloor, (void *)&(opts.outopts.floor[G(REP_USER)])},
  {"FAILUSERFLOOR", &configfloor,
   (void *)&(opts.outopts.floor[G(REP_FAILUSER)])},
  {"STATUSFLOOR", &configfloor, (void *)&(opts.outopts.floor[G(REP_CODE)])},
  {"FILEALIAS", &configalias, (void *)&(opts.aliashead[ITEM_FILE])},
  {"HOSTALIAS", &configalias, (void *)&(opts.aliashead[ITEM_HOST])},
  {"REFALIAS", &configalias, (void *)&(opts.aliashead[ITEM_REFERRER])},
  {"BROWALIAS", &configalias, (void *)&(opts.aliashead[ITEM_BROWSER])},
  {"USERALIAS", &configalias, (void *)&(opts.aliashead[ITEM_USER])},
  {"VHOSTALIAS", &configalias, (void *)&(opts.aliashead[ITEM_VHOST])},
  {"REQOUTPUTALIAS", &configalias,
   (void *)&(opts.outopts.aliashead[G(REP_REQ)])},
  {"REDIROUTPUTALIAS", &configalias,
   (void *)&(opts.outopts.aliashead[G(REP_REDIR)])},
  {"FAILOUTPUTALIAS", &configalias,
   (void *)&(opts.outopts.aliashead[G(REP_FAIL)])},
  {"TYPEOUTPUTALIAS", &configalias,
   (void *)&(opts.outopts.aliashead[G(REP_TYPE)])},
  {"DIROUTPUTALIAS", &configalias,
   (void *)&(opts.outopts.aliashead[G(REP_DIR)])},
  {"HOSTOUTPUTALIAS", &configalias,
   (void *)&(opts.outopts.aliashead[G(REP_HOST)])},
  {"DOMOUTPUTALIAS", &configalias,
   (void *)&(opts.outopts.aliashead[G(REP_DOM)])},
  {"REFOUTPUTALIAS", &configalias,
   (void *)&(opts.outopts.aliashead[G(REP_REF)])},
  {"REFSITEOUTPUTALIAS", &configalias,
   (void *)&(opts.outopts.aliashead[G(REP_REFSITE)])},
  {"REDIRREFOUTPUTALIAS", &configalias,
   (void *)&(opts.outopts.aliashead[G(REP_REDIRREF)])},
  {"FAILREFOUTPUTALIAS", &configalias,
   (void *)&(opts.outopts.aliashead[G(REP_FAILREF)])},
  {"FULLBROWOUTPUTALIAS", &configalias,
   (void *)&(opts.outopts.aliashead[G(REP_BROWREP)])},
  {"BROWOUTPUTALIAS", &configalias,
   (void *)&(opts.outopts.aliashead[G(REP_BROWSUM)])},
  {"VHOSTOUTPUTALIAS", &configalias,
   (void *)&(opts.outopts.aliashead[G(REP_VHOST)])},
  {"USEROUTPUTALIAS", &configalias,
   (void *)&(opts.outopts.aliashead[G(REP_USER)])},
  {"FAILUSEROUTPUTALIAS", &configalias,
   (void *)&(opts.outopts.aliashead[G(REP_FAILUSER)])},
  {"UNCOMPRESS", &configaliaslist, (void *)&uncompresshead},
  {"REQARGS", &configtree, (void *)&(opts.outopts.tree[G(REP_REQ)])},
  {"REDIRARGS", &configtree, (void *)&(opts.outopts.tree[G(REP_REDIR)])},
  {"FAILARGS", &configtree, (void *)&(opts.outopts.tree[G(REP_FAIL)])},
  {"REFARGS", &configtree, (void *)&(opts.outopts.tree[G(REP_REF)])},
  {"REDIRREFARGS", &configtree, (void *)&(opts.outopts.tree[G(REP_REDIRREF)])},
  {"FAILREFARGS", &configtree, (void *)&(opts.outopts.tree[G(REP_FAILREF)])},
  {"SUBDOMAIN", &configtree, (void *)&(opts.outopts.tree[G(REP_DOM)])},
  {"SUBDOM", &configtree, (void *)&(opts.outopts.tree[G(REP_DOM)])},
  {"SUBDIR", &configtree, (void *)&(opts.outopts.tree[G(REP_DIR)])},
  {"SUBTYPE", &configtree, (void *)&(opts.outopts.tree[G(REP_TYPE)])},
  {"REFDIR", &configtree, (void *)&(opts.outopts.tree[G(REP_REFSITE)])},
  {"SUBBROW", &configtree, (void *)&(opts.outopts.tree[G(REP_BROWSUM)])},
  {"FILEINCLUDE", &configinc, (void *)&(opts.wanthead[ITEM_FILE])},
  {"FILEEXCLUDE", &configexc, (void *)&(opts.wanthead[ITEM_FILE])},
  {"HOSTINCLUDE", &configinc, (void *)&(opts.wanthead[ITEM_HOST])},
  {"HOSTEXCLUDE", &configexc, (void *)&(opts.wanthead[ITEM_HOST])},
  {"REFINCLUDE", &configinc, (void *)&(opts.wanthead[ITEM_REFERRER])},
  {"REFEXCLUDE", &configexc, (void *)&(opts.wanthead[ITEM_REFERRER])},
  {"BROWINCLUDE", &configinc, (void *)&(opts.wanthead[ITEM_BROWSER])},
  {"BROWEXCLUDE", &configexc, (void *)&(opts.wanthead[ITEM_BROWSER])},
  {"USERINCLUDE", &configinc, (void *)&(opts.wanthead[ITEM_USER])},
  {"USEREXCLUDE", &configexc, (void *)&(opts.wanthead[ITEM_USER])},
  {"VHOSTINCLUDE", &configinc, (void *)&(opts.wanthead[ITEM_VHOST])},
  {"VHOSTEXCLUDE", &configexc, (void *)&(opts.wanthead[ITEM_VHOST])},
  {"REQINCLUDE", &configinc, (void *)&(opts.outopts.wanthead[G(REP_REQ)])},
  {"REQEXCLUDE", &configexc, (void *)&(opts.outopts.wanthead[G(REP_REQ)])},
  {"REDIRINCLUDE", &configinc, (void *)&(opts.outopts.wanthead[G(REP_REDIR)])},
  {"REDIREXCLUDE", &configexc, (void *)&(opts.outopts.wanthead[G(REP_REDIR)])},
  {"FAILINCLUDE", &configinc, (void *)&(opts.outopts.wanthead[G(REP_FAIL)])},
  {"FAILEXCLUDE", &configexc, (void *)&(opts.outopts.wanthead[G(REP_FAIL)])},
  {"TYPEINCLUDE", &configincd, (void *)&(opts.outopts.wanthead[G(REP_TYPE)])},
  {"TYPEEXCLUDE", &configexcd, (void *)&(opts.outopts.wanthead[G(REP_TYPE)])},
  {"DIRINCLUDE", &configincs, (void *)&(opts.outopts.wanthead[G(REP_DIR)])},
  {"DIREXCLUDE", &configexcs, (void *)&(opts.outopts.wanthead[G(REP_DIR)])},
  {"HOSTREPINCLUDE", &configinc,
   (void *)&(opts.outopts.wanthead[G(REP_HOST)])},
  {"HOSTREPEXCLUDE", &configexc,
   (void *)&(opts.outopts.wanthead[G(REP_HOST)])},
  {"DOMINCLUDE", &configincd, (void *)&(opts.outopts.wanthead[G(REP_DOM)])},
  {"DOMEXCLUDE", &configexcd, (void *)&(opts.outopts.wanthead[G(REP_DOM)])},
  {"REFREPINCLUDE", &configinc, (void *)&(opts.outopts.wanthead[G(REP_REF)])},
  {"REFREPEXCLUDE", &configexc, (void *)&(opts.outopts.wanthead[G(REP_REF)])},
  {"REFSITEINCLUDE", &configincs,
   (void *)&(opts.outopts.wanthead[G(REP_REFSITE)])},
  {"REFSITEEXCLUDE", &configexcs,
   (void *)&(opts.outopts.wanthead[G(REP_REFSITE)])},
  {"REDIRREFINCLUDE", &configinc,
   (void *)&(opts.outopts.wanthead[G(REP_REDIRREF)])},
  {"REDIRREFEXCLUDE", &configexc,
   (void *)&(opts.outopts.wanthead[G(REP_REDIRREF)])},
  {"FAILREFINCLUDE", &configinc,
   (void *)&(opts.outopts.wanthead[G(REP_FAILREF)])},
  {"FAILREFEXCLUDE", &configexc,
   (void *)&(opts.outopts.wanthead[G(REP_FAILREF)])},
  {"BROWSUMINCLUDE", &configinc,
   (void *)&(opts.outopts.wanthead[G(REP_BROWSUM)])},
  {"BROWSUMEXCLUDE", &configexc,
   (void *)&(opts.outopts.wanthead[G(REP_BROWSUM)])},
  {"FULLBROWINCLUDE", &configinc,
   (void *)&(opts.outopts.wanthead[G(REP_BROWREP)])},
  {"FULLBROWEXCLUDE", &configexc,
   (void *)&(opts.outopts.wanthead[G(REP_BROWREP)])},
  {"VHOSTREPINCLUDE", &configinc,
   (void *)&(opts.outopts.wanthead[G(REP_VHOST)])},
  {"VHOSTREPEXCLUDE", &configexc,
   (void *)&(opts.outopts.wanthead[G(REP_VHOST)])},
  {"USERREPINCLUDE", &configinc,
   (void *)&(opts.outopts.wanthead[G(REP_USER)])},
  {"USERREPEXCLUDE", &configexc,
   (void *)&(opts.outopts.wanthead[G(REP_USER)])},
  {"FAILUSERINCLUDE", &configinc,
   (void *)&(opts.outopts.wanthead[G(REP_FAILUSER)])},
  {"FAILUSEREXCLUDE", &configexc,
   (void *)&(opts.outopts.wanthead[G(REP_FAILUSER)])},
  {"LINKINCLUDE", &configinc, (void *)&(opts.outopts.link)},
  {"LINKEXCLUDE", &configexc, (void *)&(opts.outopts.link)},
  {"REFLINKINCLUDE", &configinc, (void *)&(opts.outopts.reflink)},
  {"REFLINKEXCLUDE", &configexc, (void *)&(opts.outopts.reflink)},
  {"ARGSINCLUDE", &configinc, (void *)&(opts.argshead)},
  {"ARGSEXCLUDE", &configexc, (void *)&(opts.argshead)},
  {"REFARGSINCLUDE", &configinc, (void *)&(opts.refargshead)},
  {"REFARGSEXCLUDE", &configexc, (void *)&(opts.refargshead)},
  {"PAGEINCLUDE", &configinc, (void *)&(opts.ispagehead)},
  {"PAGEEXCLUDE", &configexc, (void *)&(opts.ispagehead)},
  {"REQSORTBY", &configsortby, (void *)&(opts.outopts.sortby[G(REP_REQ)])},
  {"REQARGSSORTBY", &configsortby,
   (void *)&(opts.outopts.subsortby[G(REP_REQ)])},
  {"REDIRSORTBY", &configsortby, (void *)&(opts.outopts.sortby[G(REP_REDIR)])},
  {"REDIRARGSSORTBY", &configsortby,
   (void *)&(opts.outopts.subsortby[G(REP_REDIR)])},
  {"FAILSORTBY", &configsortby, (void *)&(opts.outopts.sortby[G(REP_FAIL)])},
  {"FAILARGSSORTBY", &configsortby,
   (void *)&(opts.outopts.subsortby[G(REP_FAIL)])},
  {"TYPESORTBY", &configsortby, (void *)&(opts.outopts.sortby[G(REP_TYPE)])},
  {"SUBTYPESORTBY", &configsortby,
   (void *)&(opts.outopts.subsortby[G(REP_TYPE)])},
  {"DIRSORTBY", &configsortby, (void *)&(opts.outopts.sortby[G(REP_DIR)])},
  {"SUBDIRSORTBY", &configsortby,
   (void *)&(opts.outopts.subsortby[G(REP_DIR)])},
  {"HOSTSORTBY", &configsortby, (void *)&(opts.outopts.sortby[G(REP_HOST)])},
  {"DOMSORTBY", &configsortby, (void *)&(opts.outopts.sortby[G(REP_DOM)])},
  {"SUBDOMSORTBY", &configsortby,
   (void *)&(opts.outopts.subsortby[G(REP_DOM)])},
  {"REFSORTBY", &configsortby, (void *)&(opts.outopts.sortby[G(REP_REF)])},
  {"REFARGSSORTBY", &configsortby,
   (void *)&(opts.outopts.subsortby[G(REP_REF)])},
  {"REFSITESORTBY", &configsortby,
   (void *)&(opts.outopts.sortby[G(REP_REFSITE)])},
  {"REFDIRSORTBY", &configsortby,
   (void *)&(opts.outopts.subsortby[G(REP_REFSITE)])},
  {"REDIRREFSORTBY", &configsortby,
   (void *)&(opts.outopts.sortby[G(REP_REDIRREF)])},
  {"REDIRREFARGSSORTBY", &configsortby,
   (void *)&(opts.outopts.subsortby[G(REP_REDIRREF)])},
  {"FAILREFSORTBY", &configsortby,
   (void *)&(opts.outopts.sortby[G(REP_FAILREF)])},
  {"FAILREFARGSSORTBY", &configsortby,
   (void *)&(opts.outopts.subsortby[G(REP_FAILREF)])},
  {"FULLBROWSORTBY", &configsortby,
   (void *)&(opts.outopts.sortby[G(REP_BROWREP)])},
  {"BROWSORTBY", &configsortby,
   (void *)&(opts.outopts.sortby[G(REP_BROWSUM)])},
  {"STATUSSORTBY", &configsortby, (void *)&(opts.outopts.sortby[G(REP_CODE)])},
  {"SUBBROWSORTBY", &configsortby,
   (void *)&(opts.outopts.subsortby[G(REP_BROWSUM)])},
  {"VHOSTSORTBY", &configsortby, (void *)&(opts.outopts.sortby[G(REP_VHOST)])},
  {"USERSORTBY", &configsortby, (void *)&(opts.outopts.sortby[G(REP_USER)])},
  {"FAILUSERSORTBY", &configsortby,
   (void *)&(opts.outopts.sortby[G(REP_FAILUSER)])},
  {"ALL", &configall, (void *)(opts.outopts.repq)},
  {"ALLBACK", &configallback, (void *)(opts.outopts.back)},
  {"MONTHLY", &configonoff, (void *)&(opts.outopts.repq[REP_MONTH])},
  {"WEEKLY", &configonoff, (void *)&(opts.outopts.repq[REP_WEEK])},
  {"FULLDAILY", &configonoff, (void *)&(opts.outopts.repq[REP_DAYREP])},
  {"DAILY", &configonoff, (void *)&(opts.outopts.repq[REP_DAYSUM])},
  {"FULLHOURLY", &configonoff, (void *)&(opts.outopts.repq[REP_HOURREP])},
  {"HOURLY", &configonoff, (void *)&(opts.outopts.repq[REP_HOURSUM])},
  {"QUARTER", &configonoff, (void *)&(opts.outopts.repq[REP_QUARTER])},
  {"FIVE", &configonoff, (void *)&(opts.outopts.repq[REP_FIVE])},
  {"GENERAL", &configonoff, (void *)&(opts.outopts.repq[REP_GENSUM])},
  {"LASTSEVEN", &configonoff, (void *)&(opts.outopts.last7)},
  {"GOTOS", &configonoff, (void *)&(opts.outopts.gotoq)},
  {"REQUEST", &configonoff, (void *)&(opts.outopts.repq[REP_REQ])},
  {"REDIR", &configonoff, (void *)&(opts.outopts.repq[REP_REDIR])},
  {"FAILURE", &configonoff, (void *)&(opts.outopts.repq[REP_FAIL])},
  {"FILETYPE", &configonoff, (void *)&(opts.outopts.repq[REP_TYPE])},
  {"SIZE", &configonoff, (void *)&(opts.outopts.repq[REP_SIZE])},
  {"DIRECTORY", &configonoff, (void *)&(opts.outopts.repq[REP_DIR])},
  {"HOST", &configonoff, (void *)&(opts.outopts.repq[REP_HOST])},
  {"DOMAIN", &configonoff, (void *)&(opts.outopts.repq[REP_DOM])},
  {"REFERRER", &configonoff, (void *)&(opts.outopts.repq[REP_REF])},
  {"REFERER", &configonoff, (void *)&(opts.outopts.repq[REP_REF])},
  {"REFSITE", &configonoff, (void *)&(opts.outopts.repq[REP_REFSITE])},
  {"REDIRREF", &configonoff, (void *)&(opts.outopts.repq[REP_REDIRREF])},
  {"FAILREF", &configonoff, (void *)&(opts.outopts.repq[REP_FAILREF])},
  {"FULLBROWSER", &configonoff, (void *)&(opts.outopts.repq[REP_BROWREP])},
  {"BROWSER", &configonoff, (void *)&(opts.outopts.repq[REP_BROWSUM])},
  {"VHOST", &configonoff, (void *)&(opts.outopts.repq[REP_VHOST])},
  {"USER", &configonoff, (void *)&(opts.outopts.repq[REP_USER])},
  {"FAILUSER", &configonoff, (void *)&(opts.outopts.repq[REP_FAILUSER])},
  {"STATUS", &configonoff, (void *)&(opts.outopts.repq[REP_CODE])},
  {"MONTHBACK", &configonoff, (void *)&(opts.outopts.back[REP_MONTH])},
  {"WEEKBACK", &configonoff, (void *)&(opts.outopts.back[REP_WEEK])},
  {"FULLDAYBACK", &configonoff, (void *)&(opts.outopts.back[REP_DAYREP])},
  {"FULLHOURBACK", &configonoff, (void *)&(opts.outopts.back[REP_HOURREP])},
  {"QUARTERBACK", &configonoff, (void *)&(opts.outopts.back[REP_QUARTER])},
  {"FIVEBACK", &configonoff, (void *)&(opts.outopts.back[REP_FIVE])},
  {"RAWBYTES", &configonoff, (void *)&(opts.outopts.rawbytes)},
  {"PRINTVARS", &configonoff, (void *)&vblesonly},
  {"OUTPUT", &configoutstyle, (void *)&(opts.outopts.outstyle)},
  {"CASE", &configcase, (void *)&(opts.miscopts.case_insensitive)},
  {"MONTHROWS", &configuint, (void *)&(opts.outopts.rows[REP_MONTH])},
  {"WEEKROWS", &configuint, (void *)&(opts.outopts.rows[REP_WEEK])},
  {"FULLDAYROWS", &configuint, (void *)&(opts.outopts.rows[REP_DAYREP])},
  {"FULLHOURROWS", &configuint, (void *)&(opts.outopts.rows[REP_HOURREP])},
  {"QUARTERROWS", &configuint, (void *)&(opts.outopts.rows[REP_QUARTER])},
  {"FIVEROWS", &configuint, (void *)&(opts.outopts.rows[REP_FIVE])},
  {"FILELOWMEM", &configlowmem, (void *)&(opts.miscopts.lowmem[ITEM_FILE])},
  {"HOSTLOWMEM", &configlowmem, (void *)&(opts.miscopts.lowmem[ITEM_HOST])},
  {"REFLOWMEM", &configlowmem, (void *)&(opts.miscopts.lowmem[ITEM_REFERRER])},
  {"BROWLOWMEM", &configlowmem, (void *)&(opts.miscopts.lowmem[ITEM_BROWSER])},
  {"USERLOWMEM", &configlowmem, (void *)&(opts.miscopts.lowmem[ITEM_USER])},
  {"VHOSTLOWMEM", &configlowmem, (void *)&(opts.miscopts.lowmem[ITEM_VHOST])},
  {"PAGEWIDTH", &configuint, (void *)&(opts.outopts.pagewidth)},
  {"MINGRAPHWIDTH", &configuint, (void *)&(opts.outopts.mingraphwidth)},
  {"PROGRESSFREQ", &configulong, (void *)&progressfreq},
  {"WEEKBEGINSON", &configweekday, (void *)&(opts.outopts.weekbeginson)},
  {"FROM", &configstr, (void *)&(opts.dman.fromstr)},
  {"TO", &configstr, (void *)&(opts.dman.tostr)},
  {"REPORTORDER", &configrepord, (void *)(opts.outopts.reporder)},
  {"DEBUG", &configdebug, (void *)&debug_args},
  {"WARNINGS", &configdebug, (void *)&warn_args},
#ifndef NODNS
  {"DNS", &configdns, (void *)&dnslevel},
  {"DNSFILE", &configstr, (void *)&dnsfile},
  {"DNSGOODHOURS", &configuint, (void *)&dnsgoodhrs},
  {"DNSBADHOURS", &configuint, (void *)&dnsbadhrs},
#endif
  {"CONFIGFILE", &configcall, NULL},
  {"", NULL, NULL}  /* at end as marker */
};

/*** Now the main initialise() function ***/

void initialise(int argc, char *argv[], Options *op) {
#ifdef MAC_EVENTS
  MacInit(&argc, &argv);
#endif
#ifdef WIN32
  Win32Init();
#endif
  globals(argv[0]);
  defaults(op);
  settings(op, argc, argv);
  correct(op);
  finalinit(op);
}

void globals(char *comname) {
  int i;

  (void)time(&starttime);
  (void)parsedate(starttime, "-00-00-00:-00-00", &starttimec, FALSE);
  block_start = (char *)xmalloc(BLOCKSIZE);
  workspace = (char *)xmalloc(BLOCKSIZE);
  for (i = 0; i < ITEM_NUMBER; i++) {
    mm[i].curr_pos = NULL;
    mm[i].first = NULL;
    mm[i].alignment = 1;
  }
  mmq.curr_pos = NULL;
  mmq.first = NULL;
  mmq.alignment = 1;
  xmemman = (Memman *)xmalloc(sizeof(Memman));
  xmemman -> curr_pos = NULL;
  xmemman -> first = NULL;
  xmemman -> alignment = ALIGNMENT;
  amemman = (Memman *)xmalloc(sizeof(Memman));
  amemman -> curr_pos = NULL;
  amemman -> first = NULL;
  amemman -> alignment = ALIGNMENT;
  for (i = 0; i < 256; i++)
    termchar[i] = FALSE;
  termchar[(unsigned char)'\r'] = TRUE;
  termchar[(unsigned char)'\n'] = TRUE;
  termchar[(unsigned char)'\0'] = TRUE;
  if (IS_EMPTY_STRING(comname))
    DEFAULTSTR(commandname, "analog")  /* no semicolon by defn of DEFAULTSTR */
  else
    DEFAULTSTR(commandname, comname);
  unwanted_entry = newhashentry(FALSE);
  blank_entry = newhashentry(FALSE);
  dummy_item = (Hashindex *)submalloc(xmemman, sizeof(Hashindex));
  dummy_item -> own = newhashentry(FALSE);
  rep2lng = (unsigned int *)xmalloc(REP_NUMBER * sizeof(unsigned int));
  rep2lng[REP_GENSUM] = gensum_;
  rep2lng[REP_MONTH] = monthrep_;
  rep2lng[REP_WEEK] = weekrep_;
  rep2lng[REP_DAYREP] = dayrep_;
  rep2lng[REP_DAYSUM] = daysum_;
  rep2lng[REP_HOURREP] = hourrep_;
  rep2lng[REP_HOURSUM] = hoursum_;
  rep2lng[REP_QUARTER] = quarter_;
  rep2lng[REP_FIVE] = five_;
  rep2lng[REP_REQ] = reqrep_;
  rep2lng[REP_REDIR] = redirrep_;
  rep2lng[REP_FAIL] = failrep_;
  rep2lng[REP_TYPE] = typerep_;
  rep2lng[REP_SIZE] = sizerep_;
  rep2lng[REP_DIR] = dirrep_;
  rep2lng[REP_HOST] = hostrep_;
  rep2lng[REP_DOM] = domrep_;
  rep2lng[REP_REF] = refrep_;
  rep2lng[REP_REFSITE] = refsiterep_;
  rep2lng[REP_REDIRREF] = redirrefrep_;
  rep2lng[REP_FAILREF] = failrefrep_;
  rep2lng[REP_BROWREP] = browrep_;
  rep2lng[REP_BROWSUM] = browsum_;
  rep2lng[REP_VHOST] = vhostrep_;
  rep2lng[REP_USER] = userrep_;
  rep2lng[REP_FAILUSER] = failuserrep_;
  rep2lng[REP_CODE] = statrep_;
  rep2type = (choice *)xmalloc(REP_NUMBER * sizeof(choice));
  rep2type[REP_MONTH] = INP_DATE;
  rep2type[REP_WEEK] = INP_DATE;
  rep2type[REP_DAYREP] = INP_DATE;
  rep2type[REP_DAYSUM] = INP_DATE;
  rep2type[REP_HOURREP] = INP_DATE;
  rep2type[REP_HOURSUM] = INP_DATE;
  rep2type[REP_QUARTER] = INP_DATE;
  rep2type[REP_FIVE] = INP_DATE;
  rep2type[REP_GENSUM] = UNSET;
  rep2type[REP_REQ] = ITEM_FILE;
  rep2type[REP_TYPE] = ITEM_FILE;
  rep2type[REP_DIR] = ITEM_FILE;
  rep2type[REP_REDIR] = ITEM_FILE;
  rep2type[REP_FAIL] = ITEM_FILE;
  rep2type[REP_HOST] = ITEM_HOST;
  rep2type[REP_DOM] = ITEM_HOST;
  rep2type[REP_USER] = ITEM_USER;
  rep2type[REP_FAILUSER] = ITEM_USER;
  rep2type[REP_REF] = ITEM_REFERRER;
  rep2type[REP_REFSITE] = ITEM_REFERRER;
  rep2type[REP_REDIRREF] = ITEM_REFERRER;
  rep2type[REP_FAILREF] = ITEM_REFERRER;
  rep2type[REP_BROWREP] = ITEM_BROWSER;
  rep2type[REP_BROWSUM] = ITEM_BROWSER;
  rep2type[REP_VHOST] = ITEM_VHOST;
  rep2type[REP_SIZE] = INP_BYTES;
  rep2type[REP_CODE] = INP_CODE;
  rep2reqs = (choice *)xmalloc(GENREP_NUMBER * sizeof(choice));
  rep2reqs[G(REP_REQ)] = REQUESTS;
  rep2reqs[G(REP_REDIR)] = REDIR;
  rep2reqs[G(REP_FAIL)] = FAIL;
  rep2reqs[G(REP_HOST)] = REQUESTS;
  rep2reqs[G(REP_USER)] = REQUESTS;
  rep2reqs[G(REP_FAILUSER)] = FAIL;
  rep2reqs[G(REP_REF)] = REQUESTS;
  rep2reqs[G(REP_REDIRREF)] = REDIR;
  rep2reqs[G(REP_FAILREF)] = FAIL;
  rep2reqs[G(REP_BROWREP)] = REQUESTS;
  rep2reqs[G(REP_VHOST)] = REQUESTS;
  rep2reqs[G(REP_TYPE)] = REQUESTS;
  rep2reqs[G(REP_DIR)] = REQUESTS;
  rep2reqs[G(REP_DOM)] = REQUESTS;
  rep2reqs[G(REP_REFSITE)] = REQUESTS;
  rep2reqs[G(REP_BROWSUM)] = REQUESTS;
  rep2date = (choice *)xmalloc(GENREP_NUMBER * sizeof(choice));
  rep2date[G(REP_REQ)] = SUCCDATE;
  rep2date[G(REP_REDIR)] = REDIRDATE;
  rep2date[G(REP_FAIL)] = FAILDATE;
  rep2date[G(REP_HOST)] = SUCCDATE;
  rep2date[G(REP_USER)] = SUCCDATE;
  rep2date[G(REP_FAILUSER)] = FAILDATE;
  rep2date[G(REP_REF)] = SUCCDATE;
  rep2date[G(REP_REDIRREF)] = REDIRDATE;
  rep2date[G(REP_FAILREF)] = FAILDATE;
  rep2date[G(REP_BROWREP)] = SUCCDATE;
  rep2date[G(REP_VHOST)] = SUCCDATE;
  rep2date[G(REP_TYPE)] = SUCCDATE;
  rep2date[G(REP_DIR)] = SUCCDATE;
  rep2date[G(REP_DOM)] = SUCCDATE;
  rep2date[G(REP_REFSITE)] = SUCCDATE;
  rep2date[G(REP_BROWSUM)] = SUCCDATE;
  rep2gran = (unsigned int *)xmalloc(DATEREP_NUMBER * sizeof(unsigned int));
  rep2gran[REP_DAYREP] = 1;
  rep2gran[REP_HOURREP] = 24;
  rep2gran[REP_QUARTER] = 96;
  rep2gran[REP_FIVE] = 288;
  rep2gran[REP_MONTH] = 1;  /* next four only used in setting granularity */
  rep2gran[REP_WEEK] = 1;
  rep2gran[REP_DAYSUM] = 1;
  rep2gran[REP_HOURSUM] = 24;
  rep2datefmt = (unsigned int *)xmalloc(DATEREP_NUMBER * sizeof(unsigned int));
  rep2datefmt[REP_DAYREP] = dayrepfmt_;
  rep2datefmt[REP_HOURREP] = hourrepfmt_;
  rep2datefmt[REP_QUARTER] = quarterfmt_;
  rep2datefmt[REP_FIVE] = quarterfmt_;
  rep2datefmt[REP_WEEK] = weekfmt_;
  rep2datefmt[REP_MONTH] = monthfmt_;
  rep2colhead = (unsigned int *)xmalloc(REP_NUMBER * sizeof(unsigned int));
  rep2colhead[REP_DAYREP] = date_;
  rep2colhead[REP_DAYSUM] = day_;
  rep2colhead[REP_HOURREP] = datetime_;
  rep2colhead[REP_HOURSUM] = hr_;
  rep2colhead[REP_QUARTER] = datetime_;
  rep2colhead[REP_FIVE] = datetime_;
  rep2colhead[REP_WEEK] = weekbeg_;
  rep2colhead[REP_MONTH] = month_;
  rep2colhead[REP_REQ] = file_;
  rep2colhead[REP_REDIR] = file_;
  rep2colhead[REP_FAIL] = file_;
  rep2colhead[REP_TYPE] = ext_;
  rep2colhead[REP_SIZE] = size_;
  rep2colhead[REP_DIR] = dir_;
  rep2colhead[REP_HOST] = host_;
  rep2colhead[REP_DOM] = dom_;
  rep2colhead[REP_REF] = url_;
  rep2colhead[REP_REFSITE] = site_;
  rep2colhead[REP_REDIRREF] = url_;
  rep2colhead[REP_FAILREF] = url_;
  rep2colhead[REP_BROWREP] = browser_;
  rep2colhead[REP_BROWSUM] = browser_;
  rep2colhead[REP_VHOST] = vhost_;
  rep2colhead[REP_USER] = user_;
  rep2colhead[REP_FAILUSER] = user_;
  rep2colhead[REP_CODE] = code_;
  rep2busystr = (unsigned int *)xmalloc(DATEREP_NUMBER * sizeof(unsigned int));
  rep2busystr[REP_DAYREP] = busyday_;
  rep2busystr[REP_HOURREP] = busyhour_;
  rep2busystr[REP_QUARTER] = busyquarter_;
  rep2busystr[REP_FIVE] = busyfive_;
  rep2busystr[REP_WEEK] = busyweek_;
  rep2busystr[REP_MONTH] = busymonth_;
  col2colhead = (unsigned int *)xmalloc(COL_NUMBER * sizeof(unsigned int));
  col2colhead[COL_REQS] = nreqs_;
  col2colhead[COL_PAGES] = npgs_;
  col2colhead[COL_BYTES] = nbytes_;
  col2colhead[COL_PREQS] = preqs_;
  col2colhead[COL_PPAGES] = ppgs_;
  col2colhead[COL_PBYTES] = pbytes_;
  col2colhead[COL_DATE] = lastdate_;
  method2sing = (unsigned int *)xmalloc(METHOD_NUMBER * sizeof(unsigned int));
  method2sing[REQUESTS] = request_;
  method2sing[PAGES] = pagereq_;
  method2sing[REDIR] = redirreq_;
  method2sing[FAIL] = failreq_;
  method2sing[BYTES] = byte_;
  method2pl = (unsigned int *)xmalloc(METHOD_NUMBER * sizeof(unsigned int));
  method2pl[REQUESTS] = requests_;
  method2pl[PAGES] = pagereqs_;
  method2pl[REDIR] = redirreqs_;
  method2pl[FAIL] = failreqs_;
  method2pl[BYTES] = bytes_;
  method2date = (unsigned int *)xmalloc(METHOD_NUMBER * sizeof(unsigned int));
  method2date[SUCCDATE] = sincedate_;
  method2date[REDIRDATE] = sinceredirdate_;
  method2date[FAILDATE] = sincefaildate_;
  method2pc = (unsigned int *)xmalloc(METHOD_NUMBER * sizeof(unsigned int));
  method2pc[REQUESTS] = prequests_;
  method2pc[PAGES] = ppages_;
  method2pc[REDIR] = predirs_;
  method2pc[FAIL] = pfails_;
  method2pc[BYTES] = ptraffic_;
  method2relpc = (unsigned int *)xmalloc(METHOD_NUMBER * sizeof(unsigned int));
  method2relpc[REQUESTS] = pmrequests_;
  method2relpc[PAGES] = pmpages_;
  method2relpc[REDIR] = pmredirs_;
  method2relpc[FAIL] = pmfails_;
  method2relpc[BYTES] = pmtraffic_;
  method2sort = (unsigned int *)xmalloc(METHOD_NUMBER * sizeof(unsigned int));
  method2sort[REQUESTS] = nrequests_;
  method2sort[PAGES] = npages_;
  method2sort[REDIR] = nredirs_;
  method2sort[FAIL] = nfails_;
  method2sort[SUCCDATE] = succdate_;
  method2sort[REDIRDATE] = redirdate_;
  method2sort[FAILDATE] = faildate_;
  method2sort[BYTES] = traffic_;
}

void defaults(Options *op) {
  int i;

  confline(op, "DEBUG", "OFF", NULL, -1);
  confline(op, "WARNINGS", "ON", NULL, -1);
  deflogformat = (Inputformatlist *)submalloc(xmemman,
					      sizeof(Inputformatlist));
  logformat = (Inputformatlist *)submalloc(xmemman, sizeof(Inputformatlist));
  deflogformat -> used = TRUE;
  logformat -> used = TRUE;
  configlogfmt((void *)&deflogformat, "DEFAULTLOGFORMAT", "AUTO", NULL, -1);
  configlogfmt((void *)&logformat, "LOGFORMAT", "DEFAULT", NULL, -1);
  deflogformat -> used = TRUE;
  confline(op, "LOGFILE", LOGFILE, NULL, -1);
  confline(op, "CACHEFILE", CACHEFILE, NULL, -1);
  DEFAULTSTR(op -> outopts.domainsfile, DOMAINSFILE);
  DEFAULTSTR(op -> miscopts.dirsuffix, DIRSUFFIX);
  op -> miscopts.form = FALSE;
#ifndef NODNS
  dnslevel = DNS;
  dnsgoodhrs = DNSGOODHOURS;
  dnsbadhrs = DNSBADHOURS;
  DEFAULTSTR(dnsfile, DNSFILE);
#endif
  op -> miscopts.case_insensitive = CASE_INSENSITIVE;
  op -> outopts.outstyle = OUTPUT;
  op -> outopts.html = TRUE;
  DEFAULTSTR(op -> outopts.headerfile, HEADERFILE);
  DEFAULTSTR(op -> outopts.footerfile, FOOTERFILE);
  DEFAULTSTR(op -> outopts.outfile, OUTFILE);
  DEFAULTSTR(op -> outopts.cacheoutfile, CACHEOUTFILE);
  DEFAULTSTR(op -> outopts.imagedir, IMAGEDIR);
  confline(op, "MONTHCOLS", MONTHCOLS, NULL, -1);
  confline(op, "WEEKCOLS", WEEKCOLS, NULL, -1);
  confline(op, "FULLDAYCOLS", FULLDAYCOLS, NULL, -1);
  confline(op, "DAYCOLS", DAYCOLS, NULL, -1);
  confline(op, "FULLHOURCOLS", FULLHOURCOLS, NULL, -1);
  confline(op, "HOURCOLS", HOURCOLS, NULL, -1);
  confline(op, "QUARTERCOLS", QUARTERCOLS, NULL, -1);
  confline(op, "FIVECOLS", FIVECOLS, NULL, -1);
  confline(op, "REQCOLS", REQCOLS, NULL, -1);
  confline(op, "REDIRCOLS", REDIRCOLS, NULL, -1);
  confline(op, "FAILCOLS", FAILCOLS, NULL, -1);
  confline(op, "TYPECOLS", TYPECOLS, NULL, -1);
  confline(op, "SIZECOLS", SIZECOLS, NULL, -1);
  confline(op, "DIRCOLS", DIRCOLS, NULL, -1);
  confline(op, "HOSTCOLS", HOSTCOLS, NULL, -1);
  confline(op, "DOMCOLS", DOMCOLS, NULL, -1);
  confline(op, "REFCOLS", REFCOLS, NULL, -1);
  confline(op, "REFSITECOLS", REFSITECOLS, NULL, -1);
  confline(op, "REDIRREFCOLS", REDIRREFCOLS, NULL, -1);
  confline(op, "FAILREFCOLS", FAILREFCOLS, NULL, -1);
  confline(op, "FULLBROWCOLS", FULLBROWCOLS, NULL, -1);
  confline(op, "BROWCOLS", BROWCOLS, NULL, -1);
  confline(op, "VHOSTCOLS", VHOSTCOLS, NULL, -1);
  confline(op, "USERCOLS", USERCOLS, NULL, -1);
  confline(op, "FAILUSERCOLS", FAILUSERCOLS, NULL, -1);
  confline(op, "STATUSCOLS", STATUSCOLS, NULL, -1);
  op -> outopts.repq[REP_MONTH] = MONTHLY;
  op -> outopts.repq[REP_WEEK] = WEEKLY;
  op -> outopts.repq[REP_DAYREP] = FULLDAILY;
  op -> outopts.repq[REP_DAYSUM] = DAILY;
  op -> outopts.repq[REP_HOURREP] = FULLHOURLY;
  op -> outopts.repq[REP_HOURSUM] = HOURLY;
  op -> outopts.repq[REP_QUARTER] = QUARTER;
  op -> outopts.repq[REP_FIVE] = FIVE;
  op -> outopts.repq[REP_GENSUM] = GENERAL;
  op -> outopts.repq[REP_REQ] = REQUEST;
  op -> outopts.repq[REP_REDIR] = REDIRREP;
  op -> outopts.repq[REP_FAIL] = FAILREP;
  op -> outopts.repq[REP_TYPE] = STATUS;
  op -> outopts.repq[REP_SIZE] = SIZEREP;
  op -> outopts.repq[REP_DIR] = DIRECTORY;
  op -> outopts.repq[REP_HOST] = HOST;
  op -> outopts.repq[REP_DOM] = DOMAINREP;
  op -> outopts.repq[REP_REF] = REFERRER;
  op -> outopts.repq[REP_REFSITE] = REFSITE;
  op -> outopts.repq[REP_REDIRREF] = REDIRREF;
  op -> outopts.repq[REP_FAILREF] = FAILREF;
  op -> outopts.repq[REP_BROWREP] = FULLBROWSER;
  op -> outopts.repq[REP_BROWSUM] = BROWSER;
  op -> outopts.repq[REP_VHOST] = VHOST;
  op -> outopts.repq[REP_USER] = USER;
  op -> outopts.repq[REP_FAILUSER] = FAILUSER;
  op -> outopts.repq[REP_CODE] = STATUS;
  op -> outopts.last7 = LASTSEVEN;
  op -> outopts.gotoq = GOTOS;
  op -> outopts.lang.code = LANGUAGE;
  op -> outopts.lang.file = NULL;
  op -> outopts.graph[REP_MONTH] = MONTHGRAPH;
  op -> outopts.graph[REP_WEEK] = WEEKGRAPH;
  op -> outopts.graph[REP_DAYREP] = FULLDAYGRAPH;
  op -> outopts.graph[REP_DAYSUM] = DAYGRAPH;
  op -> outopts.graph[REP_HOURREP] = FULLHOURGRAPH;
  op -> outopts.graph[REP_HOURSUM] = HOURGRAPH;
  op -> outopts.graph[REP_QUARTER] = QUARTERGRAPH;
  op -> outopts.graph[REP_FIVE] = FIVEGRAPH;
  op -> outopts.back[REP_MONTH] = MONTHBACK;
  op -> outopts.back[REP_WEEK] = WEEKBACK;
  op -> outopts.back[REP_DAYREP] = FULLDAYBACK;
  op -> outopts.back[REP_HOURREP] = FULLHOURBACK;
  op -> outopts.back[REP_QUARTER] = QUARTERBACK;
  op -> outopts.back[REP_FIVE] = FIVEBACK;
  op -> outopts.rows[REP_MONTH] = MONTHROWS;
  op -> outopts.rows[REP_WEEK] = WEEKROWS;
  op -> outopts.rows[REP_DAYREP] = FULLDAYROWS;
  op -> outopts.rows[REP_HOURREP] = FULLHOURROWS;
  op -> outopts.rows[REP_QUARTER] = QUARTERROWS;
  op -> outopts.rows[REP_FIVE] = FIVEROWS;
  op -> outopts.sortby[G(REP_REQ)] = REQSORTBY;
  op -> outopts.subsortby[G(REP_REQ)] = REQARGSSORTBY;
  op -> outopts.sortby[G(REP_REDIR)] = REDIRSORTBY;
  op -> outopts.subsortby[G(REP_REDIR)] = REDIRARGSSORTBY;
  op -> outopts.sortby[G(REP_FAIL)] = FAILSORTBY;
  op -> outopts.subsortby[G(REP_FAIL)] = FAILARGSSORTBY;
  op -> outopts.sortby[G(REP_TYPE)] = TYPESORTBY;
  op -> outopts.subsortby[G(REP_TYPE)] = SUBTYPESORTBY;
  op -> outopts.sortby[G(REP_SIZE)] = ALPHABETICAL;
  op -> outopts.sortby[G(REP_DIR)] = DIRSORTBY;
  op -> outopts.subsortby[G(REP_DIR)] = SUBDIRSORTBY;
  op -> outopts.sortby[G(REP_HOST)] = HOSTSORTBY;
  op -> outopts.sortby[G(REP_DOM)] = DOMSORTBY;
  op -> outopts.subsortby[G(REP_DOM)] = SUBDOMSORTBY;
  op -> outopts.sortby[G(REP_REF)] = REFSORTBY;
  op -> outopts.subsortby[G(REP_REF)] = REFARGSSORTBY;
  op -> outopts.sortby[G(REP_REFSITE)] = REFSITESORTBY;
  op -> outopts.subsortby[G(REP_REFSITE)] = REFDIRSORTBY;
  op -> outopts.sortby[G(REP_REDIRREF)] = REDIRREFSORTBY;
  op -> outopts.subsortby[G(REP_REDIRREF)] = REDIRREFARGSSORTBY;
  op -> outopts.sortby[G(REP_FAILREF)] = FAILREFSORTBY;
  op -> outopts.subsortby[G(REP_FAILREF)] = FAILREFARGSSORTBY;
  op -> outopts.sortby[G(REP_BROWREP)] = FULLBROWSORTBY;
  op -> outopts.sortby[G(REP_BROWSUM)] = BROWSORTBY;
  op -> outopts.subsortby[G(REP_BROWSUM)] = BROWSORTBY;
  op -> outopts.sortby[G(REP_VHOST)] = VHOSTSORTBY;
  op -> outopts.sortby[G(REP_USER)] = USERSORTBY;
  op -> outopts.sortby[G(REP_FAILUSER)] = FAILUSERSORTBY;
  op -> outopts.sortby[G(REP_CODE)] = STATUSSORTBY;
  confline(op, "REQFLOOR", REQFLOOR, NULL, -1);
  confline(op, "REQARGSFLOOR", REQARGSFLOOR, NULL, -1);
  confline(op, "REDIRFLOOR", REDIRFLOOR, NULL, -1);
  confline(op, "REDIRARGSFLOOR", REDIRARGSFLOOR, NULL, -1);
  confline(op, "FAILFLOOR", FAILFLOOR, NULL, -1);
  confline(op, "FAILARGSFLOOR", FAILARGSFLOOR, NULL, -1);
  confline(op, "TYPEFLOOR", TYPEFLOOR, NULL, -1);
  confline(op, "SUBTYPEFLOOR", SUBTYPEFLOOR, NULL, -1);
  confline(op, "DIRFLOOR", DIRFLOOR, NULL, -1);
  confline(op, "SUBDIRFLOOR", SUBDIRFLOOR, NULL, -1);
  confline(op, "HOSTFLOOR", HOSTFLOOR, NULL, -1);
  confline(op, "DOMFLOOR", DOMFLOOR, NULL, -1);
  confline(op, "SUBDOMFLOOR", SUBDOMFLOOR, NULL, -1);
  confline(op, "REFFLOOR", REFFLOOR, NULL, -1);
  confline(op, "REFARGSFLOOR", REFARGSFLOOR, NULL, -1);
  confline(op, "REFSITEFLOOR", REFSITEFLOOR, NULL, -1);
  confline(op, "REFDIRFLOOR", REFDIRFLOOR, NULL, -1);
  confline(op, "REDIRREFFLOOR", REDIRREFFLOOR, NULL, -1);
  confline(op, "REDIRREFARGSFLOOR", REDIRREFARGSFLOOR, NULL, -1);
  confline(op, "FAILREFFLOOR", FAILREFFLOOR, NULL, -1);
  confline(op, "FAILREFARGSFLOOR", FAILREFARGSFLOOR, NULL, -1);
  confline(op, "FULLBROWFLOOR", FULLBROWFLOOR, NULL, -1);
  confline(op, "BROWFLOOR", BROWFLOOR, NULL, -1);
  confline(op, "SUBBROWFLOOR", BROWFLOOR, NULL, -1);
  confline(op, "VHOSTFLOOR", VHOSTFLOOR, NULL, -1);
  confline(op, "USERFLOOR", USERFLOOR, NULL, -1);
  confline(op, "FAILUSERFLOOR", FAILUSERFLOOR, NULL, -1);
  confline(op, "STATUSFLOOR", STATUSFLOOR, NULL, -1);
  op -> outopts.floor[G(REP_SIZE)].floorby = REQUESTS;
  confline(op, "REPORTORDER", REPORTORDER, NULL, -1);
  op -> outopts.markchar = MARKCHAR;
  op -> outopts.rawbytes = RAWBYTES;
  DEFAULTSTR(op -> outopts.hostname, HOSTNAME);
  DEFAULTSTR(op -> outopts.hosturl, HOSTURL);
  op -> outopts.baseurl = NULL;
  DEFAULTSTR(op -> outopts.logo, LOGO);
  op -> outopts.weekbeginson = WEEKBEGINSON;
  op -> outopts.pagewidth = PAGEWIDTH;
  op -> outopts.mingraphwidth = MINGRAPHWIDTH;
  op -> outopts.sepchar = SEPCHAR;
  op -> outopts.repsepchar = REPSEPCHAR;
  op -> outopts.decpt = DECPOINT;
  DEFAULTSTR(op -> outopts.compsep, COMPSEP);
  op -> outopts.link = NULL;
  op -> outopts.reflink = NULL;
  for (i = 0; i < GENREP_NUMBER; i++) {
    op -> outopts.wanthead[i] = NULL;
    op -> outopts.aliashead[i] = NULL;
    op -> outopts.tree[i] = (Tree *)xmalloc(sizeof(Tree));
    op -> outopts.tree[i] -> tree = NULL;
    op -> outopts.tree[i] -> space = (Memman *)xmalloc(sizeof(Memman));
    op -> outopts.tree[i] -> space -> curr_pos = NULL;
    op -> outopts.tree[i] -> space -> first = NULL;
    op -> outopts.tree[i] -> space -> alignment = ALIGNMENT;
  }
  op -> outopts.tree[G(REP_REQ)] -> cutfn = &rnextname;
  op -> outopts.tree[G(REP_REDIR)] -> cutfn = &rnextname;
  op -> outopts.tree[G(REP_FAIL)] -> cutfn = &rnextname;
  op -> outopts.tree[G(REP_REF)] -> cutfn = &rnextname;
  op -> outopts.tree[G(REP_REDIRREF)] -> cutfn = &rnextname;
  op -> outopts.tree[G(REP_FAILREF)] -> cutfn = &rnextname;
  op -> outopts.tree[G(REP_TYPE)] -> cutfn = &tnextname;
  op -> outopts.tree[G(REP_DIR)] -> cutfn = &inextname;
  op -> outopts.tree[G(REP_DOM)] -> cutfn = &onextname;
  op -> outopts.tree[G(REP_REFSITE)] -> cutfn = &fnextname;
  op -> outopts.tree[G(REP_BROWSUM)] -> cutfn = &bnextname;
  for (i = 0; i < LOGDATA_NUMBER; i++)
    op -> miscopts.data[i] = 0;
  op -> miscopts.bytes = 0.0;
  op -> miscopts.bytes7 = 0.0;
  confline(op, "REQARGS", "*?*", NULL, -1);
  confline(op, "REDIRARGS", "*?*", NULL, -1);
  confline(op, "FAILARGS", "*?*", NULL, -1);
  confline(op, "REFARGS", "*?*", NULL, -1);
  confline(op, "REDIRREFARGS", "*?*", NULL, -1);
  confline(op, "FAILREFARGS", "*?*", NULL, -1);
  confline(op, "SUBDOMAIN", "*", NULL, -1);
  confline(op, "SUBDIR", "*", NULL, -1);
  confline(op, "SUBTYPE", "*", NULL, -1);
  confline(op, "REFDIR", "*", NULL, -1);
  confline(op, "SUBBROW", "*", NULL, -1);
  for (i = 0; i < ITEM_NUMBER; i++) {
    op -> wanthead[i] = NULL;
    op -> aliashead[i] = NULL;
    op -> hash[i] = rehash(NULL, HASHSIZE, NULL);
    op -> miscopts.lowmem[i] = 0;
  }
  op -> ispagehead = NULL;
  op -> argshead = NULL;
  op -> refargshead = NULL;
  confline(op, "PAGEINCLUDE", "*.html", NULL, -1);
  confline(op, "PAGEINCLUDE", "*/", NULL, -1);
  confline(op, "PAGEINCLUDE", "*.htm", NULL, -1);
  op -> dman.fromstr = NULL;
  op -> dman.tostr = NULL;
  op -> dman.currdp = NULL;
  op -> dman.firsttime = LAST_TIME;
  op -> dman.lasttime = FIRST_TIME;
  op -> sizes = (Sizedata *)xmalloc(sizeof(Sizedata));
  for (i = 0; i < SIZEBINS; i++) {
    op -> sizes -> reqs[i] = 0;
    op -> sizes -> pages[i] = 0;
    op -> sizes -> bytes[i] = 0;
    op -> sizes -> lastdate[i] = 0;
  }
}

void confline(Options *op, char *cmd, char *arg1, char *arg2, int rc) {
  char u[520];   /* see nextconfline() */
  char *savepos;
  int i;
  logical done = FALSE;

  (void)strtoupper(cmd);
  if (rc >= 2 && STREQ(cmd, "SUBDOMAIN")) {   /* ugly but easy */
    (void)sprintf(u, "%s (%s)", arg1, arg2);
    configalias((void *)&(op -> outopts.aliashead[G(REP_DOM)]), NULL, arg1, u,
		-1);
    rc--;  /* to avoid error message */
  }
  for (i = 0; cf[i].fn != NULL && !done; i++) {
    if (STREQ(cmd, cf[i].name)) {
      (void)memcpy((void *)&opts, (void *)op, sizeof(Options));
      cf[i].fn(cf[i].opt, cmd, arg1, arg2, rc);
      (void)memcpy((void *)op, (void *)&opts, sizeof(Options));
      if (cf[i].fn == &configcall && rc != '\0' && !IS_EMPTY_STRING(arg1)) {
	savepos = pos;
	(void)strcpy(u, arg1); /* or name will get obliterated before fclose */
	(void)config(u, op);
	pos = savepos;
      }
      done = TRUE;
    }
  }
  if (!done)
    unknownwarn(cmd, arg1, arg2);
}

choice config(char *filename, Options *op) {
  static int no_confs = 0;
  FILE *f;
  char *cmd, *arg1, *arg2;
  int rc;

  if ((f = my_fopen(filename, "configuration file")) == NULL)
    return(ERR);
  if (no_confs++ >= MAX_CONFIGS)
    error("Attempted to read more than %d configuration files", MAX_CONFIGS);
  pos = NULL;
  while ((rc = nextconfline(f, &cmd, &arg1, &arg2)) != EOF)
    confline(op, cmd, arg1, arg2, rc);
  (void)my_fclose(f, filename, "configuration file");
  configlogfmt((void *)&logformat, "LOGFORMAT", "DEFAULT", NULL, -1);
  return(OK);
}

void settings(Options *op, int argc, char *argv[]) {
  int i;
  logical done;

  newloglist = TRUE;
  /* once through command line arguments to see if default config wanted */
  if (!strcaseeq(DEFAULTCONFIGFILE, "none")) {
    for (i = argc - 1, done = FALSE; i >= 1 && !done; i--) {
      if (!IS_EMPTY_STRING(argv[i]) && argv[i][1] == 'G' &&
	  (argv[i][0] == '+' || argv[i][0] == '-')) {
	done = TRUE;
	CLLONGCHECK(if (argv[i][0] == '+') (void)config(DEFAULTCONFIGFILE, op);)
      }
    }
    if (!done)
      (void)config(DEFAULTCONFIGFILE, op);
  }
  newloglist = TRUE;

  /* now read in rest of command line arguments */
  clargs(op, argc, argv);
  configlogfmt((void *)&logformat, "LOGFORMAT", "DEFAULT", NULL, -1);
  newloglist = TRUE;

  /* finally, read in mandatory config file, aborting if not found */
  if (!strcaseeq(MANDATORYCONFIGFILE, "none") &&
      config(MANDATORYCONFIGFILE, op) == ERR)
    error("Cannot ignore mandatory configuration file");
}

Inputformatlist *correctlogfmt(Filelist *lp, Include **wanthead,
			       Dateman *dman) {
  Inputformatlist *fmt;
  Inputformat *fns;
  int count, i, j;
  logical done, done2;

  for (count = 0, fmt = lp -> format; fmt != NULL; TO_NEXT(fmt)) {
    if (!wantitem[INP_CODE] && fmt -> count[INP_CODE] == 2)
      fmt -> count[INP_CODE] = 1;
    if (!wantitem[INP_DATE] && fmt -> count[INP_DATE] == 2)
      fmt -> count[INP_DATE] = 1;  /* NB read date even if not filtered */
    for (fns = fmt -> form; fns -> inpfns != NULL; TO_NEXT(fns)) {
      for (i = 0; i < ITEMFNS_NUMBER; i++) {
	if (fns -> inpfns == &inpfns[i]) {
	  j = inpfns[i].type;
	  if (!wantitem[j] && fmt -> count[j] == 2 &&
	      !(j == ITEM_FILE && (fmt -> count[INP_DATE] == 2 ||
				  fmt -> count[INP_CODE] > 0 ||
				  fmt -> count[INP_BYTES] > 0)))
	    fmt -> count[j] = 1;
	  if (wanthead[j] == NULL && fmt -> count[j] == 1 && j != ITEM_FILE &&
	      !(j == ITEM_VHOST && lp -> pvpos != UNSET)) {
	    if (inpfns[i].fn != &parseref)
	      fns -> inpfns = &pjinpfn;
	    fmt -> count[j] = 0;
	  }
	  count += (int)(fmt -> count[j] == 2);
	}
      }     /* end for i through ITEMFNS */
      if (fns -> inpfns -> fn == &parselogfmt) {
	count++;
	for (i = 0; i < INPUT_NUMBER; i++)
	  fmt -> count[i] = 1;   /* just so doesn't trigger warnings below */
      }
    }       /* end for fns in fmt */
  }         /* end for fmt through formats */

  if (count == 0)
    lp -> format = NULL;  /* i.e., mark logfile to be ignored */
  else {
    for (i = 0; i < ITEM_NUMBER; i++) {
      if (wanthead[i] != NULL) {
	for (done = FALSE, fmt = lp -> format; fmt != NULL && !done;
	     TO_NEXT(fmt)) {
	  for (count = 0, j = 0; j < INPUT_NUMBER; j++)
	    count += (int)(fmt -> count[j] == 2);
	  if (fmt -> count[i] == 0 && count > 0) {
	    warn('M', "Logfile %s contains lines with no %s, which are "
		 "being filtered", lp -> name, item_type[i]);
	    done = TRUE;
	  }
	}
      }
    }
    if (dman -> from > FIRST_TIME || dman -> to < LAST_TIME) {
      for (done = FALSE, fmt = lp -> format; fmt != NULL && !done;
	   TO_NEXT(fmt)) {
	for (count = 0, j = 0; j < INPUT_NUMBER; j++)
	  count += (int)(fmt -> count[j] == 2);
	if (fmt -> count[INP_DATE] == 0 && count > 0) {
	  warn('M', "Logfile %s contains lines with no dates, which are "
	       "being filtered", lp -> name, item_type[i]);
	  done = TRUE;
	}
      }
    }
    for (done = FALSE, done2 = FALSE, fmt = lp -> format; fmt != NULL;
	 TO_NEXT(fmt)) {
      for (count = 0, j = 0; j < INPUT_NUMBER; j++)
	count += (int)(fmt -> count[j] == 2);
      if (fmt -> count[ITEM_FILE] == 0 && count > 0 && !done) {
	warn('M', "Logfile %s contains lines with no file names: page counts "
	     "may be low", lp -> name);
	done = TRUE;
      }
      if (fmt -> count[INP_BYTES] == 0 && count > 0 && !done2) {
	warn('M', "Logfile %s contains lines with no bytes: byte counts "
	     "may be low", lp -> name);
	done2 = TRUE;
      }
    }
  }
    
  return(lp -> format);
}

void correct(Options *op) {
  Filelist *lp;
  Include *incp, *lastincp;
  choice rep, *cols, floor, subfloor, sortby, subsortby;
  logical colsinc[COL_NUMBER], istree, templ;
  char graph;
  int i, j, k;

  /* NB some options, e.g. reportorder, corrected when parsed */
  origstarttime = starttime;
  starttime = shifttime(starttime, stz);
  starttimec += stz;
  if (op -> outopts.markchar == '\0') {
    warn('C', "MARKCHAR none not allowed. Using + instead.");
    op -> outopts.markchar = '+';
  }
  if (op -> outopts.decpt == '\0') {
    warn('C', "DECPOINT none not allowed. Using '.' instead.");
    op -> outopts.decpt = '.';
  }
  op -> dman.from = FIRST_TIME;
  if (op -> dman.fromstr != NULL &&  /* so parse unless fromstr is NULL */
      parsedate(starttime, op -> dman.fromstr, &(op -> dman.from), TRUE)
      == ERR)
    warn('C', "Invalid FROM string %s: ignoring it", op -> dman.fromstr);
  op -> dman.to = LAST_TIME;
  if (op -> dman.tostr != NULL &&
      parsedate(starttime, op -> dman.tostr, &(op -> dman.to), FALSE) == ERR)
    warn('C', "Invalid TO string %s: ignoring it", op -> dman.tostr);
  if (op -> dman.to < LAST_TIME)
    op -> dman.last7 = op -> dman.to - MINS_IN_WEEK;
  else
    op -> dman.last7 = starttimec - MINS_IN_WEEK;
  if (op -> outopts.pagewidth < MINPAGEWIDTH) {
    warn('C', "PAGEWIDTH %u too small: using minimum allowed value of %u",
	 op -> outopts.pagewidth, MINPAGEWIDTH);
    op -> outopts.pagewidth = MINPAGEWIDTH;
  }
  if (op -> outopts.pagewidth > MAXPAGEWIDTH) {
    warn('C', "PAGEWIDTH %u too large: using maximum allowed value of %u",
	 op -> outopts.pagewidth, MAXPAGEWIDTH);
    op -> outopts.pagewidth = MAXPAGEWIDTH;
  }
  for (i = 0, j = 0, k = 0; i < DATEREP_NUMBER; i++) {
    if (i != REP_DAYSUM && i != REP_HOURSUM) {
      j += (int)(op -> outopts.repq[i] && op -> outopts.back[i]);
      k += (int)(op -> outopts.repq[i]);
    }
  }
  for (lastincp = NULL, incp = op -> argshead, templ = FALSE; incp != NULL;
       TO_NEXT(incp)) {
    if (STREQ(incp -> name, "pages")) {
      if (!templ)
	warn('C', "ARGSINCLUDE/EXCLUDE can't include 'pages'");
      templ = TRUE;
      if (lastincp == NULL)
	op -> argshead = incp -> next;
      else
	lastincp -> next = incp -> next;
    }
    else
      lastincp = incp;
  }
  for (lastincp = NULL, incp = op -> refargshead, templ = FALSE; incp != NULL;
       TO_NEXT(incp)) {
    if (STREQ(incp -> name, "pages")) {
      if (!templ)
	warn('C', "REFARGSINCLUDE/EXCLUDE can't include 'pages'");
      templ = TRUE;
      if (lastincp == NULL)
	op -> refargshead = incp -> next;
      else
	lastincp -> next = incp -> next;
    }
    else
      lastincp = incp;
  }
  if (j != 0 && j != k)
    warn('D', "Time reports have not all got same value of BACK");
  for (i = 0; op -> outopts.reporder[i] != -1; i++) {
    rep = op -> outopts.reporder[i];
    cols = op -> outopts.cols[rep];
    for (j = 0; j < COL_NUMBER; j++)
      colsinc[j] = FALSE;
    for (j = 0; cols[j] != COL_NUMBER; j++)
      colsinc[cols[j]] = TRUE;
    /* for date reports: warning if graphby doesn't match cols */
    if (rep < DATEREP_NUMBER && op -> outopts.repq[rep]) {
      graph = op -> outopts.graph[rep];
      if (colsinc[COL_DATE]) {
	warn('C', "In %s, D not allowed in COLS: ignoring it", repname[rep]);
	for (j = 0; cols[j] != COL_NUMBER; j++) {
	  if (cols[j] == COL_DATE) {
	    for (k = j; cols[k] != COL_NUMBER; k++)
	      cols[k] = cols[k + 1];
	    j--;
	  }
	}
      }
      if (cols[0] != COL_NUMBER) {  /* o/wise different warning below */
	if (((graph == 'R' || graph == 'r') &&
	     !colsinc[COL_REQS] && !colsinc[COL_PREQS]) ||
	    ((graph == 'P' || graph == 'p') &&
	     !colsinc[COL_PAGES] && !colsinc[COL_PPAGES]) ||
	    ((graph == 'B' || graph == 'b') &&
	     !colsinc[COL_BYTES] && !colsinc[COL_PBYTES]))
	  warn('C', "In %s, GRAPH (%c) isn't included in COLS", repname[rep],
	       graph);
      }
    }   /* end if date rep */
    /* for general reports: warning if any of sortby/floor/cols don't match */
    else if (rep >= FIRST_GENREP && op -> outopts.repq[rep] &&
	     rep2type[rep] != -1) {
      sortby = op -> outopts.sortby[G(rep)];
      floor = op -> outopts.floor[G(rep)].floorby;
      subsortby = op -> outopts.subsortby[G(rep)];
      subfloor = op -> outopts.subfloor[G(rep)].floorby;
      istree = sublevels(op -> outopts.tree[G(rep)] -> tree);
      /* this (istree) is not perfect, because ARGSINCLUDE isn't analysed */
      if (rep == REP_REQ || rep == REP_TYPE) {
	if (colsinc[COL_PAGES]) {
	  warn('C', "In %s, P not allowed in COLS: ignoring it",
	       repname[rep]);
	  for (j = 0; cols[j] != COL_NUMBER; j++) {
	    if (cols[j] == COL_PAGES) {
	      for (k = j; cols[k] != COL_NUMBER; k++)
		cols[k] = cols[k + 1];
	      j--;
	    }
	  }
	  colsinc[COL_PAGES] = FALSE;
	}
	if (sortby == PAGES) {
	  warn('C', "In %s, illegal SORTBY (pages): "
	       "will sort by requests instead", repname[rep]);
	  op -> outopts.sortby[G(rep)] = REQUESTS;
	}
	if (floor == PAGES) {
	  warn('C', "In %s, illegal FLOOR (pages): will use -50r instead",
	       repname[rep]);
	  op -> outopts.floor[G(rep)].min = -50;
	  op -> outopts.floor[G(rep)].qual = '\0';
	  op -> outopts.floor[G(rep)].floorby = REQUESTS;
	}
	if (istree) {
	  if (subsortby == PAGES) {
	    warn('C', "In %s, illegal SUBSORTBY (pages): "
		 "will sort by requests instead", repname[rep]);
	    op -> outopts.subsortby[G(rep)] = REQUESTS;
	  }
	  if (subfloor == PAGES) {
	    warn('C', "In %s, illegal SUBFLOOR (pages): will use -1r instead",
		 repname[rep]);
	    op -> outopts.subfloor[G(rep)].min = -1;
	    op -> outopts.subfloor[G(rep)].qual = '\0';
	    op -> outopts.subfloor[G(rep)].floorby = REQUESTS;
	  }
	}
      }    /* end rep == REP_REQ || rep == REP_TYPE */
      else if (rep == REP_REDIR || rep == REP_FAIL || rep == REP_REDIRREF ||
	       rep == REP_FAILREF || rep == REP_FAILUSER || rep == REP_CODE) {
	if (colsinc[COL_PAGES] || colsinc[COL_PPAGES] || colsinc[COL_BYTES] ||
	    colsinc[COL_PBYTES]) {
	  warn('C', "In %s, P, p, B and b not allowed in COLS: ignoring them",
	       repname[rep]);
	  for (j = 0; cols[j] != COL_NUMBER; j++) {
	    if (cols[j] == COL_PAGES || cols[j] == COL_PPAGES ||
		cols[j] == COL_BYTES || cols[j] == COL_PBYTES) {
	      for (k = j; cols[k] != COL_NUMBER; k++)
		cols[k] = cols[k + 1];
	      j--;
	    }
	  }
	  colsinc[COL_PAGES] = FALSE;
	  colsinc[COL_PPAGES] = FALSE;
	  colsinc[COL_BYTES] = FALSE;
	  colsinc[COL_PBYTES] = FALSE;
	}
	if (sortby == PAGES || sortby == BYTES) {
	  warn('C', "In %s, illegal SORTBY (%s): will sort by "
	       "requests instead", repname[rep], methodname[sortby]);
	  op -> outopts.sortby[G(rep)] = REQUESTS;
	}
	if (floor == PAGES || floor == BYTES) {
	  warn('C', "In %s, illegal FLOOR (%s): will use -50r instead",
	       repname[rep], methodname[floor]);
	  op -> outopts.floor[G(rep)].min = -50;
	  op -> outopts.floor[G(rep)].qual = '\0';
	  op -> outopts.floor[G(rep)].floorby = REQUESTS;
	}
	if (istree) {
	  if (subsortby == PAGES || subsortby == BYTES) {
	    warn('C', "In %s, illegal SUBSORTBY (%s): will sort by "
		 "requests instead", repname[rep], methodname[subsortby]);
	    op -> outopts.subsortby[G(rep)] = REQUESTS;
	  }
	  if (subfloor == PAGES || subfloor == BYTES) {
	    warn('C', "In %s, illegal SUBFLOOR (%s): will use -1r instead",
		 repname[rep], methodname[subfloor]);
	    op -> outopts.subfloor[G(rep)].min = -1;
	    op -> outopts.subfloor[G(rep)].qual = '\0';
	    op -> outopts.subfloor[G(rep)].floorby = REQUESTS;
	  }
	}
      }   /* end rep == (list of 6 reps) */
      if (istree) {
	if (sortby != subsortby && subsortby != ALPHABETICAL &&
	    subsortby != RANDOM)
	  warn('D', "In %s, SORTBY (%s) doesn't match SUBSORTBY (%s)",
	       repname[rep], methodname[sortby], methodname[subsortby]);
	if (floor != subfloor)
	  warn('D', "In %s, FLOOR (%s) doesn't match SUBFLOOR (%s)",
	       repname[rep], methodname[floor], methodname[subfloor]);
	if ((subsortby == REQUESTS || subsortby == PAGES ||
	     subsortby == BYTES) &&
	    (subfloor == REQUESTS || subfloor == PAGES || subfloor == BYTES) &&
	    subsortby != subfloor)
	  warn('D', "In %s, SUBSORTBY (%s) doesn't match SUBFLOOR (%s)",
	       repname[rep], methodname[subsortby], methodname[subfloor]);
      }
      if ((sortby == REQUESTS || sortby == PAGES || sortby == BYTES) &&
	  (floor == REQUESTS || floor == PAGES || floor == BYTES) &&
	  sortby != floor)
	warn('D', "In %s, SORTBY (%s) doesn't match FLOOR (%s)", repname[rep],
	     methodname[sortby], methodname[floor]);
      if (cols[0] != COL_NUMBER) {  /* o/wise different warning below */
	if ((sortby == REQUESTS && !colsinc[COL_REQS] &&
	     !colsinc[COL_PREQS]) ||
	    (sortby == PAGES && !colsinc[COL_PAGES] && !colsinc[COL_PPAGES]) ||
	    (sortby == BYTES && !colsinc[COL_BYTES] && !colsinc[COL_PBYTES]) ||
	    (sortby == DATESORT && !colsinc[COL_DATE]))
	  warn('D', "In %s, SORTBY (%s) isn't included in COLS", repname[rep],
	       methodname[sortby]);
	if ((floor == REQUESTS && !colsinc[COL_REQS] && !colsinc[COL_PREQS]) ||
	    (floor == PAGES && !colsinc[COL_PAGES] && !colsinc[COL_PPAGES]) ||
	    (floor == BYTES && !colsinc[COL_BYTES] && !colsinc[COL_PBYTES]) ||
	    (floor == DATESORT && !colsinc[COL_DATE]))
	  warn('D', "In %s, FLOOR (%s) isn't included in COLS", repname[rep],
	       methodname[floor]);
	if (istree) {
	  if ((subsortby == REQUESTS && !colsinc[COL_REQS] &&
	       !colsinc[COL_PREQS]) ||
	      (subsortby == PAGES && !colsinc[COL_PAGES] &&
	       !colsinc[COL_PPAGES]) ||
	      (subsortby == BYTES && !colsinc[COL_BYTES] &&
	       !colsinc[COL_PBYTES]) ||
	      (subsortby == DATESORT && !colsinc[COL_DATE]))
	    warn('D', "In %s, SUBSORTBY (%s) isn't included in COLS",
		 repname[rep], methodname[subsortby]);
	  if ((subfloor == REQUESTS && !colsinc[COL_REQS] &&
	       !colsinc[COL_PREQS]) ||
	      (subfloor == PAGES && !colsinc[COL_PAGES] &&
	       !colsinc[COL_PPAGES]) ||
	      (subfloor == BYTES && !colsinc[COL_BYTES] &&
	       !colsinc[COL_PBYTES]) ||
	      (subfloor == DATESORT && !colsinc[COL_DATE]))
	    warn('D', "In %s, SUBFLOOR (%s) isn't included in COLS",
		 repname[rep], methodname[subfloor]);
	}
      }
    }
    if (cols[0] == COL_NUMBER)
      warn('D', "%s contains no COLS", repname[rep]);
  }
  /* change logformats to ignore items which are not wanted (see 28/10/97) */
  for (lp = op -> miscopts.logfile; lp != NULL; TO_NEXT(lp)) {
    if (lp -> format -> form -> inpfns -> fn == &parselogfmt &&
	lp -> format -> form -> sep == '0')  /* DEFAULT format */
      lp -> format = deflogformat;
  }
  if (!vblesonly) {
    for (i = 0; i < INPUT_NUMBER; i++)
      wantitem[i] = FALSE;
    for (op -> miscopts.granularity = 1, i = 0;
	 op -> outopts.reporder[i] != -1; i++) {
      rep = op -> outopts.reporder[i];
      if (rep < DATEREP_NUMBER &&	op -> outopts.repq[rep])
	op -> miscopts.granularity = MAX(op -> miscopts.granularity,
					 rep2gran[rep]);
      if (op -> outopts.repq[rep] && rep2type[rep] != UNSET)
	wantitem[rep2type[rep]] = TRUE;
    }
    for (lp = op -> miscopts.logfile, templ = FALSE; lp != NULL; TO_NEXT(lp)) {
      (void)correctlogfmt(lp, op -> wanthead, &(op -> dman));
      if (op -> miscopts.lowmem[ITEM_VHOST] >= 3 && lp -> pvpos != UNSET) {
	if (!templ) {
	  warn('C',
	       "Ignoring %%v in logfile prefixes because of VHOSTLOWMEM 3");
	  templ = TRUE;
	}
	lp -> pvpos = UNSET;
      }
    }
  }
  if (op -> outopts.outstyle == COMPUTER) {
    op -> outopts.sepchar = '\0';
    op -> outopts.repsepchar = '\0';
    op -> outopts.decpt = '.';
    op -> outopts.rawbytes = TRUE;
  }
  if (!STREQ(op -> outopts.cacheoutfile, "none")) {
    op -> miscopts.granularity = rep2gran[REP_FIVE];
    for (i = 0, j = 0; i < ITEM_NUMBER; i++)
      j += (int)(op -> miscopts.lowmem[i] >= 3);
    if (j != 0)
      warn('D', "LOWMEM 3 prevents that item being cached");
    if (STREQ(op -> outopts.cacheoutfile, op -> outopts.outfile))
      warn('D', "OUTFILE and CACHEOUTFILE are the same");
    /* doesn't detect stdout & -, but... */
  }
  else if (op -> outopts.outstyle == OUT_NONE)
    error("OUTPUT NONE and CACHEOUTFILE none selected");
}

#define POSSTREE(r) if (op -> miscopts.lowmem[rep2type[r]] >= 3 && \
			op -> outopts.repq[r]) \
		       op -> outopts.alltrees[i++] = r
void finalinit(Options *op) {
  FILE *tempf;
#ifndef NODNS
  timecode_t timec, goodtimec, badtimec;
  char *name, *alias;
  choice rc;
#endif
  int i;

  if (op -> outopts.lang.file == NULL) {
    if (op -> outopts.lang.code == ENGLISH)
      configstr(&(op -> outopts.lang.file), NULL, LANGDIR"uk"EXTSEP"lng",
		NULL, -1);
    else if (op -> outopts.lang.code == US_ENGLISH)
      configstr(&(op -> outopts.lang.file), NULL, LANGDIR"us"EXTSEP"lng",
		NULL, -1);
    else if (op -> outopts.lang.code == FLEMISH)
      configstr(&(op -> outopts.lang.file), NULL, LANGDIR"nl"EXTSEP"lng",
		NULL, -1);
    else if (op -> outopts.lang.code == POLISH)
      configstr(&(op -> outopts.lang.file), NULL, LANGDIR"pl"EXTSEP"lng",
		NULL, -1);
    else if (op -> outopts.lang.code == ROMANIAN)
      configstr(&(op -> outopts.lang.file), NULL, LANGDIR"ro"EXTSEP"lng",
		NULL, -1);
    else if (op -> outopts.outstyle == HTML) {/* other langs have 2 versions */
      if (op -> outopts.lang.code == FRENCH)
	configstr(&(op -> outopts.lang.file), NULL, LANGDIR"frh"EXTSEP"lng",
		  NULL, -1);
      else if (op -> outopts.lang.code == GERMAN)
	configstr(&(op -> outopts.lang.file), NULL, LANGDIR"deh"EXTSEP"lng",
		  NULL, -1);
      else if (op -> outopts.lang.code == ITALIAN)
	configstr(&(op -> outopts.lang.file), NULL, LANGDIR"ith"EXTSEP"lng",
		  NULL, -1);
      else if (op -> outopts.lang.code == SPANISH)
	configstr(&(op -> outopts.lang.file), NULL, LANGDIR"esh"EXTSEP"lng",
		  NULL, -1);
      else if (op -> outopts.lang.code == DANISH)
	configstr(&(op -> outopts.lang.file), NULL, LANGDIR"dkh"EXTSEP"lng",
		  NULL, -1);
      else if (op -> outopts.lang.code == CATALAN)
	configstr(&(op -> outopts.lang.file), NULL, LANGDIR"cath"EXTSEP"lng",
		  NULL, -1);
      else if (op -> outopts.lang.code == SLOVENE)
	configstr(&(op -> outopts.lang.file), NULL, LANGDIR"sih"EXTSEP"lng",
		  NULL, -1);
      else if (op -> outopts.lang.code == RUSSIAN)
	configstr(&(op -> outopts.lang.file), NULL, LANGDIR"ruh"EXTSEP"lng",
		  NULL, -1);
      else if (op -> outopts.lang.code == FINNISH)
	configstr(&(op -> outopts.lang.file), NULL, LANGDIR"fih"EXTSEP"lng",
		  NULL, -1);
      else if (op -> outopts.lang.code == NORWEGIAN)
	configstr(&(op -> outopts.lang.file), NULL, LANGDIR"noh"EXTSEP"lng",
		  NULL, -1);
      else if (op -> outopts.lang.code == SWEDISH)
	configstr(&(op -> outopts.lang.file), NULL, LANGDIR"seh"EXTSEP"lng",
		  NULL, -1);
      else if (op -> outopts.lang.code == PORTUGUESE)
	configstr(&(op -> outopts.lang.file), NULL, LANGDIR"pth"EXTSEP"lng",
		  NULL, -1);
      else if (op -> outopts.lang.code == BR_PORTUGUESE)
	configstr(&(op -> outopts.lang.file), NULL, LANGDIR"brh"EXTSEP"lng",
		  NULL, -1);
      else if (op -> outopts.lang.code == HUNGARIAN)
	configstr(&(op -> outopts.lang.file), NULL, LANGDIR"huh"EXTSEP"lng",
		  NULL, -1);
      else if (op -> outopts.lang.code == CZECH)
	configstr(&(op -> outopts.lang.file), NULL, LANGDIR"czh"EXTSEP"lng",
		  NULL, -1);
      else if (op -> outopts.lang.code == SLOVAK)
	configstr(&(op -> outopts.lang.file), NULL, LANGDIR"skh"EXTSEP"lng",
		  NULL, -1);
    }
    else {
      if (op -> outopts.lang.code == FRENCH)
	configstr(&(op -> outopts.lang.file), NULL, LANGDIR"fra"EXTSEP"lng",
		  NULL, -1);
      else if (op -> outopts.lang.code == GERMAN)
	configstr(&(op -> outopts.lang.file), NULL, LANGDIR"dea"EXTSEP"lng",
		  NULL, -1);
      else if (op -> outopts.lang.code == ITALIAN)
	configstr(&(op -> outopts.lang.file), NULL, LANGDIR"ita"EXTSEP"lng",
		  NULL, -1);
      else if (op -> outopts.lang.code == SPANISH)
	configstr(&(op -> outopts.lang.file), NULL, LANGDIR"esa"EXTSEP"lng",
		  NULL, -1);
      else if (op -> outopts.lang.code == DANISH)
	configstr(&(op -> outopts.lang.file), NULL, LANGDIR"dka"EXTSEP"lng",
		  NULL, -1);
      else if (op -> outopts.lang.code == CATALAN)
	configstr(&(op -> outopts.lang.file), NULL, LANGDIR"cata"EXTSEP"lng",
		  NULL, -1);
      else if (op -> outopts.lang.code == SLOVENE)
	configstr(&(op -> outopts.lang.file), NULL, LANGDIR"sia"EXTSEP"lng",
		  NULL, -1);
      else if (op -> outopts.lang.code == RUSSIAN)
	configstr(&(op -> outopts.lang.file), NULL, LANGDIR"rua"EXTSEP"lng",
		  NULL, -1);
      else if (op -> outopts.lang.code == FINNISH)
	configstr(&(op -> outopts.lang.file), NULL, LANGDIR"fia"EXTSEP"lng",
		  NULL, -1);
      else if (op -> outopts.lang.code == NORWEGIAN)
	configstr(&(op -> outopts.lang.file), NULL, LANGDIR"noa"EXTSEP"lng",
		  NULL, -1);
      else if (op -> outopts.lang.code == SWEDISH)
	configstr(&(op -> outopts.lang.file), NULL, LANGDIR"sea"EXTSEP"lng",
		  NULL, -1);
      else if (op -> outopts.lang.code == PORTUGUESE)
	configstr(&(op -> outopts.lang.file), NULL, LANGDIR"pta"EXTSEP"lng",
		  NULL, -1);
      else if (op -> outopts.lang.code == BR_PORTUGUESE)
	configstr(&(op -> outopts.lang.file), NULL, LANGDIR"bra"EXTSEP"lng",
		  NULL, -1);
      else if (op -> outopts.lang.code == HUNGARIAN)
	configstr(&(op -> outopts.lang.file), NULL, LANGDIR"hua"EXTSEP"lng",
		  NULL, -1);
      else if (op -> outopts.lang.code == CZECH)
	configstr(&(op -> outopts.lang.file), NULL, LANGDIR"cza"EXTSEP"lng",
		  NULL, -1);
      else if (op -> outopts.lang.code == SLOVAK)
	configstr(&(op -> outopts.lang.file), NULL, LANGDIR"ska"EXTSEP"lng",
		  NULL, -1);
    }
  }
  if (!vblesonly) {
    if ((tempf = my_fopen(op -> outopts.lang.file, "language file")) == NULL)
      error("Can't find language file %s", op -> outopts.lang.file);
    op -> outopts.dayname = (char **)xmalloc(7 * sizeof(char *));
    op -> outopts.monthname = (char **)xmalloc(12 * sizeof(char *));
    op -> outopts.lngstr = (char **)xmalloc(LNGSTR_NUMBER * sizeof(char *));
    pos = NULL;
    for (i = 0; i < 7; i++)
      DEFAULTSTR(op -> outopts.dayname[i],
		 nextlngstr(tempf, op -> outopts.lang.file));
    for (i = 0; i < 12; i++)
      DEFAULTSTR(op -> outopts.monthname[i],
		 nextlngstr(tempf, op -> outopts.lang.file));
    for (i = 0; i < LNGSTR_NUMBER; i++)
      DEFAULTSTR(op -> outopts.lngstr[i],
		 nextlngstr(tempf, op -> outopts.lang.file));
    op -> outopts.plainmonthlen = (unsigned int)arraymaxlen(op -> outopts.monthname, 12, ASCII);
    op -> outopts.monthlen = (unsigned int)arraymaxlen(op -> outopts.monthname,
						       12,
						       op -> outopts.outstyle);
    op -> outopts.plaindaylen = (unsigned int)arraymaxlen(op -> outopts.dayname, 7, ASCII);
    op -> outopts.daylen = (unsigned int)arraymaxlen(op -> outopts.dayname, 7,
						     op -> outopts.outstyle);
    if (op -> outopts.baseurl != NULL && STREQ(op -> outopts.baseurl, "none"))
      op -> outopts.baseurl = NULL;
    if (op -> outopts.outstyle == COMPUTER) {
      DEFAULTSTR(op -> outopts.lngstr[succreqs_], "SRS7");
      DEFAULTSTR(op -> outopts.lngstr[totunknown_], "NCC7");
      DEFAULTSTR(op -> outopts.lngstr[totpages_], "PRP7");
      DEFAULTSTR(op -> outopts.lngstr[totfails_], "FLF7");
      DEFAULTSTR(op -> outopts.lngstr[totredirs_], "RRR7");
      DEFAULTSTR(op -> outopts.lngstr[inforeqs_], "NII7");
      DEFAULTSTR(op -> outopts.lngstr[distfiles_], "NFN7");
      DEFAULTSTR(op -> outopts.lngstr[disthosts_], "NHH7");
      DEFAULTSTR(op -> outopts.lngstr[corrupt_], "CL");
      DEFAULTSTR(op -> outopts.lngstr[unwanted_], "UL");
      DEFAULTSTR(op -> outopts.lngstr[totdata_], "BTB7");
      DEFAULTSTR(op -> outopts.lngstr[dayrepfmt_], "%Y%\b%\v%\b%D");
      DEFAULTSTR(op -> outopts.lngstr[hourrepfmt_], "%Y%\b%\v%\b%D%\b%H");
      DEFAULTSTR(op -> outopts.lngstr[quarterfmt_], "%Y%\b%\v%\b%D%\b%H%\b%n");
      DEFAULTSTR(op -> outopts.lngstr[weekfmt_], "%Y%\b%\v%\b%D");
      DEFAULTSTR(op -> outopts.lngstr[monthfmt_], "%Y%\b%\v");
      DEFAULTSTR(op -> outopts.lngstr[genrepfmt_], "%Y%\b%\v%\b%D%\b%H%\b%n");
      DEFAULTSTR(op -> outopts.lngstr[datefmt1_], "%Y%\b%\v%\b%D%\b%H%\b%n");
      DEFAULTSTR(op -> outopts.lngstr[datefmt2_], "%Y%\b%\v%\b%D%\b%H%\b%n");
    }
    (void)my_fclose(tempf, op -> outopts.lang.file, "language file");
    op -> miscopts.dirsufflength = strlen(op -> miscopts.dirsuffix);
    for (i = 0; i < GENREP_NUMBER; i++)
      allgraft(op -> outopts.tree[i] -> tree, op -> outopts.tree[i] -> space);
    tempf = my_fopen(op -> outopts.domainsfile, "domains file");
    if (tempf != NULL) {
      process_domainsfile(tempf, op);
      (void)my_fclose(tempf, op -> outopts.domainsfile, "domains file");
    }
    op -> outopts.alltrees = (choice *)submalloc(xmemman, 6 * sizeof(choice));
    i = 0;
    POSSTREE(REP_DIR);
    POSSTREE(REP_DOM);
    POSSTREE(REP_TYPE);
    POSSTREE(REP_REFSITE);
    POSSTREE(REP_BROWSUM);
    op -> outopts.alltrees[i] = REP_NUMBER;
    confline(op, "DOMOUTPUTALIAS", "0", "[unresolved numerical addresses]",
	     -1);
    confline(op, "DOMOUTPUTALIAS", "1", "[domain not given]", -1);
    confline(op, "DIROUTPUTALIAS", "/", "[root directory]", -1);
    confline(op, "DIROUTPUTALIAS", "//", "[no directory]", -1);
    confline(op, "TYPEOUTPUTALIAS", ".", "[no extension]", -1);
    confline(op, "TYPEOUTPUTALIAS", "./", "[directories]", -1);
#ifndef NODNS
    if (dnslevel != DNS_NONE) {
      dnstable = rehash(NULL, HASHSIZE, NULL);
      if ((tempf = my_fopen(dnsfile, "DNS input file")) != NULL) {
	pos = NULL;
	goodtimec = starttimec - (timecode_t)dnsgoodhrs * 60;
	badtimec = starttimec - (timecode_t)dnsbadhrs * 60;
	while((rc = nextdnsline(tempf, &timec, &name, &alias)) != EOF) {
	  if (rc == TRUE && ((STREQ(alias, "*") && timec >= badtimec) ||
			     (!STREQ(alias, "*") && timec >= goodtimec)) &&
	      !(timec > starttimec + MINS_IN_WEEK))
	    do_dns(name, alias, dnslevel);
	}
	(void)my_fclose(tempf, dnsfile, "DNS input file");
      }
      if (dnslevel == DNS_WRITE && (dnsfilep = fopen(dnsfile, "a")) == NULL)
	warn('F',
	     "Failed to open DNS output file %s for writing: ignoring it\n",
	     dnsfile);
    }
#endif
  }
}
