/*
    ras - Redundant Archive System
    Copyright (C) 1998  Nick Cleaton

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Nick Cleaton <nc@dial.pipex.com>
*/
/*

field.h

Polynomial interpolation over the finite field GF(256).

*/

typedef unsigned char field_t;
/*  the type over which finite field arithmetic will be performed  */


void init_field();
/*  Call once at the start, sets up lookup tables and so on.
*/

void free_field();
/*  Call at the end, frees resources allocated by init_field.
*/

field_t *Makevector(size_t segcount, int *gotpoints, int wantpoint);
/*  The set of "segcount" ints pointed to by "gotpoints" and the int
    "wantpoint" must all be distinct and in the range 0 to 255.
    "segcount" x,y pairs for distinct x define a polynomial of order
    "segcount"-1.  Makevector returns a vector of "segcount" field_ts
    which (when dot-producted with a vector of "segcount" y values) 
    has the effect of evaluating this polynomial at the x value
    "wantpoint".
*/

void dotproduct(size_t segcount, uchar *inbufbase, size_t inbufoffset,
                               uchar *outbuf, field_t *vector, size_t bytes);
/*  Reads "bytes" bytes of data from each of "segcount" input buffers, and
    writes "bytes" bytes of data out to "outbuf".  The ith byte is computed
    as the dot product of "vector" and the vector of the ith bytes of all
    the input buffers.  The first input buffer starts at "inbufbase", the
    second starts at "inbufbase" + "inbufoffset", and so on.
*/

