/* node.c	-- Henry S. Thompson Mon Nov 18 1996
 *
 * DSSSL node and nodelist types for Elk.
 * This is only a very preliminary set of stubs, included to give and
 * indication of how the interface to spgrove will look.
 * Much more remains to be done
 *
 */

#include "node.h"

int T_Node,T_Node_Size,T_NodeList,T_NodeList_Size;

// call with a raw node, not an Elk Object
Object Make_Node(Node *spNode) {
  Object n=Alloc_Object(T_Node_Size,T_Node,1);
  NODE(n)->node_=spNode;
  spNode->addRef();
  return n;
}

Object P_Nodep(Object k)
{
    return TYPE(k) == T_Node ? True : False;
}

int node_equal(Object a, Object b)
{
    return NODE(a)->node_ == NODE(b)->node_;
}

/* 
 * Nodes are printed as the raw node address
 */

int node_print(Object k, Object port, int raw, int length, int depth)
{
    Printf(port, "#n%lu",(unsigned long)(NODE(k)->node_));
    return 0;
}

/* ********* */

// call with a raw nodelist, not an Elk Object
Object Make_NodeList(NodeList *spNodeList) {
  Object n=Alloc_Object(T_NodeList_Size,T_NodeList,1);
  NODELIST(n)->nodelist_=spNodeList;
  spNodeList->addRef();
  return n;
}

Object P_NodeListp(Object k)
{
    return TYPE(k) == T_NodeList ? True : False;
}

int nodelist_equal(Object a, Object b)
{
    return NODELIST(a)->nodelist_ == NODELIST(b)->nodelist_;
}

/* 
 * Nodelists are printed as the raw nodelist address
 */

int nodelist_print(Object k, Object port, int raw, int length, int depth)
{
    Printf(port, "#nl%lu",(unsigned long)(NODELIST(k)->nodelist_));
    return 0;
}

/*
 * Token gestures at the wherewithal for core query language
 */

static NodePtr np;
Object P_Document_Element(Object node) {
  Check_Type(node,T_Node);
  switch (NODE(node)->node_->getDocumentElement(np)) {
  case accessOK:
    Object nn=Make_Node(&*np);
    np->addRef();
    np.clear();
    return nn;
  default:
    fprintf(stderr,"help2");
    exit(2);
  };
};

static NodeListPtr nlp;
Object P_Node_Children(Object node) {
  Check_Type(node,T_Node);
  switch (NODE(node)->node_->children(nlp)) {
  case accessOK:
    Object nl=Alloc_Object(T_NodeList_Size,T_NodeList,1);
    NODELIST(nl)->nodelist_=&*nlp;
    nlp->addRef();
    nlp.clear();
    return nl;
  default:
    fprintf(stderr,"help");
    exit(1);
  };
}

/* We should keep a weak list of all elk Nodes and NodeLists,
 * and release() their contents when they get GC'd */

void elk_init_node(void)
{
    T_Node = Define_Type(0, "node", 0, T_Node_Size=sizeof(struct S_Node), 
			    node_equal, node_equal,
			    node_print, 0);
    T_NodeList = Define_Type(0, "nodelist", 0,
			     T_NodeList_Size=sizeof(struct S_NodeList), 
			    nodelist_equal, nodelist_equal,
			    nodelist_print, 0);

    Define_Primitive(P_Nodep, "node?", 1, 1, EVAL);
    Define_Primitive(P_NodeListp, "nodelist?", 1, 1, EVAL);
    Define_Primitive(P_Node_Children, "node-children", 1, 1, EVAL);
    Define_Primitive(P_Document_Element, "document-element", 1, 1, EVAL);
}


