"""
    Package: PDA.Palm

    Code to interface to the Palm/USR/3Com PalmOS platform and its
    applications.  The general structure of this module is:

    PDA.Palm - all general functionality, sync functions, and Python
        classes for generic PalmOS databases.

    PDA.Palm.App.*
        Application-specific modules, which may hook into the generic
	code in order to provide app-specific record types and the like.
	eg. 'PDA.Palm.App.Memo', etc.  As more app modules are added,
	this directory should be organized into sub-packages or
	sub-directories (using __init__.dirs).

    PDA.Palm.Conduit.*
        Conduits for synchronization, and everything related to them.
"""

import sys, os

# Platform-specific binary module location
dirname = __path__[0]
__path__.insert(0, os.path.join(dirname, 'plat-'+sys.platform))

# Import all basic sync functions and classes
from DLP import *
