"""
  PDA.Palm.Tk.ConfigDialog -- Generic Configuration Dialog
  $Id: ConfigDialog.py,v 1.2 1998/08/29 01:09:01 rob Exp $

  Copyright 1998 Rob Tillotson <rob@io.com>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License, version 2,
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.


  This module implements a more or less generic interface to a
  collection of configuration variables; see *.Conduit.Conduit for
  more detail on its intended use.

  When the dialog is created, it must be passed a list of Option
  objects (see __.Config for the class definitions), which are used
  to construct the dialog, control validation, etc.  The supported
  object types and their representations are:

    String, Integer, Float -- an entry field with validation
    Boolean  -- a checkbox
    Choice   -- a menubutton
    Filename -- an entry field, plus a pop-up file selector

"""


import string

from PDA.Palm import Options

from Tkinter import *
import tkSimpleDialog
import tkFileDialog
import tkMessageBox

def badvalue(parent, title, msg):
    tkMessageBox.showerror("Bad Value",
			   "Value of %s is invalid.\n%s" % (title, msg),
			   parent=parent)

class ConfigDialog(tkSimpleDialog.Dialog):
    def __init__(self, parent, cfg_options, title='Configuration'):
	self.options = cfg_options
	tkSimpleDialog.Dialog.__init__(self, parent, title)

    def body(self, parent):
	i = parent
	r = 0
	self.widgets = []
	pady = 2
	
	for o in self.options:
	    Label(i, text=o.title).grid(row=r, column=0, padx=5, sticky=E)

	    if o.type == Options.STRING:
		w = Entry(i)
		w.grid(row=r, column=1, sticky='ew', pady=pady)
		if o.value:
		    w.insert(0, str(o.value))
		    w.select_range(0, END)

	    elif o.type == Options.FILENAME:
		f = Frame(i)
		f.grid(row=r, column=1, sticky='ew', pady=pady)
		f.grid_columnconfigure(1, weight=1)
		w = Entry(f)
		w.grid(row=0, column=1, sticky='ew')
		b = Button(f, text="Browse...",
			   command=lambda e=None, s=self, w=w, o=o:
			   s.file_select(w,o,e))
		b.grid(row=0, column=2)
		
	    elif o.type == Options.INTEGER:
		w = Entry(i)
		w.grid(row=r, column=1, sticky='ew', pady=pady)
		if o.value is None: w.insert(0, '0')
		else: w.insert(0, str(o.value))
		w.select_range(0, END)

	    elif o.type == Options.FLOAT:
		w = Entry(i)
		w.grid(row=r, column=1, sticky='ew', pady=pady)
		if o.value is None: w.insert(0, '0.0')
		else: w.insert(0, str(o.value))
		w.select_range(0, END)

	    elif o.type == Options.BOOLEAN:
		v = IntVar()
		if o.value: v.set(1)
		w = Checkbutton(i, variable=v)
		w.grid(row=r, column=1, sticky='w', pady=pady)
		w.var = v

	    elif o.type == Options.CHOICE:
		v = StringVar()
		if o.values:
		    if o.value not in o.values: v.set(o.items[0])
		    else:
			v.set(o.items[o.values.index(o.value)])
		else:
		    if o.value not in o.items: v.set(o.items[0])
		    else: v.set(o.value)
		w = apply(OptionMenu, (i, v)+tuple(o.items))
		w.grid(row=r, column=1, sticky='ew', pady=pady)
		w.var = v

	    else:
		w = None

	    if w: w.__option = o
	    r = r + 1
	    self.widgets.append(w)

    def file_select(self, wid, opt, event=None):
	d = {}
	if hasattr(opt, 'initialdir') and opt.initialdir:
	    d['initialdir'] = opt.initialdir
	if hasattr(opt, 'filetypes') and opt.filetypes:
	    d['filetypes'] = opt.filetypes
	d['parent'] = self
	f = apply(tkFileDialog.askopenfilename, (), d)
	wid.delete(0, END)
	wid.insert(0, f)
	wid.select_range(0, END)
	
    def apply(self):
	for wid in filter(None, self.widgets):
	    o = wid.__option

	    if o.type == Options.BOOLEAN:
		v = wid.var.get()
	    elif o.type == Options.STRING or o.type == Options.FILENAME:
		v = wid.get()
	    elif o.type == Options.INTEGER:
		v = string.atoi(wid.get())
	    elif o.type == Options.FLOAT:
		v = string.atof(wid.get())
	    elif o.type == Options.CHOICE:
		v = wid.var.get()
		if o.values:
		    try:
			v = o.values[o.items.index(v)]
		    except ValueError:
			pass
	    else:
		v = None

	    o.value = v
	    
    def validate(self):
	for wid in filter(None, self.widgets):
	    o = wid.__option

	    if o.type == Options.INTEGER:
		try:
		    v = string.atoi(wid.get())
		except ValueError:
		    badvalue(self, o.title, 'Must be an integer.')
		    return 0
	    elif o.type == Options.FLOAT:
		try:
		    v = string.atof(wid.get())
		except ValueError:
		    badvalue(self, o.title, 'Must be a real number.')
		    return 0
	    elif o.type == Options.CHOICE:
		if o.values:
		    try:
			v = o.values[o.items.index(wid.var.get())]
		    except ValueError:
			badvalue(self, o.title,
				 '%s is not a valid option.' % wid.var.get())
			return 0
		    except IndexError:
			badvalue(self, o.title,
				 "Help, my brain is melting.")
			return 0
		else:
		    v = wid.var.get()
	    elif hasattr(wid, 'var'):
		v = wid.var.get()
	    else:
		v = wid.get()

	    try:
		o.validate(v)
	    except Objects.ValidationError, s:
		badvalue(self, o.title, s)
		return 0
	    
	return 1
