/* 
 * LDAP module
 * $Id: ldapmodule.c,v 1.1.1.1 1997/08/07 01:14:12 leonard Exp $
 */

#include "version.h"
#include "constants.h"
#include "errors.h"
#include "functions.h"
/* #include "string_translators.h" */

#include "Python.h"

/* dummy module methods */

static PyMethodDef methods[]  = {
	{ NULL, NULL }
};

/* module initialisation */

void
initldap()
{
	PyObject *m, *d;

	/* Create the module and add the functions */
	m = Py_InitModule("ldap", methods);

	/* Add some symbolic constants to the module */
	d = PyModule_GetDict(m);

	LDAPinit_version(d);
	LDAPinit_constants(d);
	LDAPinit_errors(d);
	LDAPinit_functions(d);
/*	LDAPinit_string_translators(d); */

	/* Check for errors */
	if (PyErr_Occurred())
		Py_FatalError("can't initialize module ldap");
}
