!**************************************************************************
!*
!* Boot-ROM-Code to load an operating system across a TCP/IP network.
!*
!* Module:  bcc_lcmp.S
!* Purpose: Routines required by bcc
!* Entries: lcmpl, lcmpul
!*
!**************************************************************************
!*
!* Copyright (C) 1995-1998 Gero Kuhlmann <gero@gkminix.han.de>
!*
!*  This program is free software; you can redistribute it and/or modify
!*  it under the terms of the GNU General Public License as published by
!*  the Free Software Foundation; either version 2 of the License, or
!*  any later version.
!*
!*  This program is distributed in the hope that it will be useful,
!*  but WITHOUT ANY WARRANTY; without even the implied warranty of
!*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!*  GNU General Public License for more details.
!*
!*  You should have received a copy of the GNU General Public License
!*  along with this program; if not, write to the Free Software
!*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
!*


!
!**************************************************************************
!
! Include assembler macros:
!
#include <macros.inc>
#include <memory.inc>
#include "./libpriv.inc"


!
!**************************************************************************
!
! Start code segment.
!
	.text


! If we are using the peephole optimizer for BCC all routines in this
! file should be unnecessary, so prevent it from getting included by
! disabling all public definitions.
#ifndef OPT386
	public	lcmpl		! define entry points
	public	lcmpul
#endif


!
!**************************************************************************
!
! Define BCC support functions
!
! Compare
lcmpl:
lcmpul:	sub	bx,2[di]	
	jne	lcmp9
	cmp	ax,[di]
	jb	lcmp8
	jge	lcmp9
	add	bx,#2
lcmp8:	dec	bx
lcmp9:	ret


!
!**************************************************************************
!
	end

