#!/usr/bin/perl
#  by-payee.pl - Prints a report of the transactions sorted by payee.
#
#  Written by Kevin L. McWhirter Started December 17, 1999.
#
#  Copyright (C) 1994 - 1999  Curtis L. Olson  - curt@sledge.mn.org
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

# $Id: by-payee.pl,v 1.1 2000/01/05 20:38:03 curt Exp $


package CBB;

use strict;    # don't take no guff


my($credit_total, $debit_total);
my($subtotal);
my($result, $amt, $cmt, $lkey);
my($tamt, $tcat, $tpayee, $tcom);
my($key, $date, $check, $desc, $debit, $credit, $cat, $com, $cleared, $total);
my(%ALLTRANS) = ();
my(%tmp_payee) = ();
my(@keys, @splits);
my($name, $account);


# specify the installed location of the necessary pieces.
BEGIN {
$CBB::cbb_incl_dir = "/usr/local/lib/cbb/";
unshift(@INC, $CBB::cbb_incl_dir);
}

require "common.pl";
require "reports.pl";
require "engine.pl";
require "memorized.pl";


($#ARGV >= 0) || die "Usage: report [ -from date ] [ -to date] accounts";


# process arguments

my($date_fmt, $fromdate, $todate, @account_list) = &process_rep_args();

if ( $fromdate eq "all" ) {
    $fromdate = "";
}

if ( $todate eq "all" ) {
    $todate = "";
}

# print "'$fromdate' '$todate' '@account_list'\n";

# load all matching transactions from all specified accounts (ignoring
# those that are outside the specified date range)

foreach $account ( @account_list ) {
    $name = &file_basename($account);

    # open the account
    (&load_trans($account) eq "ok") || die "Cannot open account:  $account";

    $result = &first_trans();
    while ( $result ne "none" ) {
        ($key, $date, $check, $desc, $debit, $credit, $cat, $com, $cleared,
         $total) = split(/\t/, $result);

		$tpayee = $desc;

        $amt = $credit - $debit;

        if ( (($fromdate == 0) || ($fromdate <= $date)) && 
            (($todate == 0) || ($todate >= $date)) ) {

            $ALLTRANS{"$key$name"} = $result;

            $tmp_payee{$tpayee} .= "$key$name" . "," . $amt . ",  ,";
        }

        $result = &next_trans();
    }
}


$credit_total = 0.00;
$debit_total = 0.00;

foreach my $lpayee (sort keys(%tmp_payee)) {
    chop($tmp_payee{$lpayee});  # Delete final comma
    print "$lpayee\n";

    @keys = split(/,/, $tmp_payee{$lpayee});

    $subtotal = 0.00;

    while ( $#keys >= 0 ) {
        $lkey = shift(@keys);
        $amt  = shift(@keys);
        $cmt = shift(@keys);

        # print $cmt;

	$result = $ALLTRANS{$lkey};

        ($key, $date, $check, $desc, $debit, $credit, $cat, $com, $cleared,
         $total) = split(/\t/, $result);

        $subtotal = $subtotal + $amt;
        if ( $amt > 0 ) {
            $credit_total = $credit_total + $amt;
        } else {
            $debit_total = $debit_total + $amt;
        }

        &format_line( $result, $amt, $cmt );
    }

    printf("                                         ---------\n" );
    printf("                              Subtotal = %9.2f\n\n", $subtotal);
}

printf("                                         ---------\n" );
printf("                         Total Credits = %9.2f\n\n", $credit_total);

printf("                                         ---------\n" );
printf("                          Total Debits = %9.2f\n\n", $debit_total);

printf("                                         ---------\n" );
printf("                               Balance = %9.2f\n\n", 
       $credit_total + $debit_total);


sub format_line {
    my($result, $amt, $cmt) = @_;
    my($key, $date, $check, $desc, $debit, $credit, $cat, $com, $cleared,
          $total) = split(/\t/, $result);
    my($year,$mon,$day) = $date =~ /(\d\d\d\d)(\d\d)(\d\d)/;
    my($nicedate, $cutdesc, $nicecat);

    $year = substr($year, 2, 4);
    if ( $date_fmt == 1 ) {
	$nicedate = "$mon/$day/$year";
    } else {
	$nicedate = "$day.$mon.$year";
    }
    $cat = "$cat $cmt";
    $nicecat = substr($cat, 0, 20);
    if ( substr($cat, 0, 1) eq "|" ) {
        $nicecat = "-Splits-";
    }

    printf("  %5s  %-8s  %-20s  %9.2f  %-1s\n",
          $check, $nicedate, $nicecat, $amt, $cleared);
}
