/*  StationRef  Index information for a station in a harmonics file.
    Last modified 1998-04-26

    Copyright (C) 1998  David Flater.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "common.hh"

Station *ReferenceStationRef::load(TideContext *in_context) {
  HarmonicsFile h (*harmonicsFileName, in_context->settings);
  return h.getStation ((*this), in_context);
}

StationRef::StationRef () {
  fastload = 0;
  harmonicsFileName = NULL;
}

int ReferenceStationRef::is_reference_station() const {
  return 1;
}

int SubordinateStationRef::is_reference_station() const {
  return 0;
}

void StationRef::shortHarmonicsFileName (Dstr &text_out) {
  assert (harmonicsFileName);
  text_out = *harmonicsFileName;
  int index = text_out.strrchr ('/');
  if (index != -1)
    text_out /= index+1;
}

Station *SubordinateStationRef::load(TideContext *in_context) {
  if (!offsets) {
    Dstr details ("The offending station was ");
    details += name;
    barf (NOOFFSETSFOUND, details);
  }

  if (!rsr) {
    StationRef *sr;
    if (fastload)
      sr = in_context->fastload (source);
    else
      sr = (*(in_context->stationIndex()))[source];
    if (!sr) {
      Dstr details ("Could not find reference station ");
      details += source;
      details += "\nneeded by subordinate station ";
      details += name;
      details += ".";
      barf (STATION_NOT_FOUND, details);
    }
    if (!(sr->is_reference_station())) {
      Dstr details ("The subordinate station ");
      details += name;
      details +="\ndepends on ";
      details += source;
      details += "\nwhich matched the subordinate station named ";
      details += sr->name;
      details += ".";
      barf (SUB_SUBORDINATE, details);
    }
    rsr = (ReferenceStationRef*)sr; // Save for the next rainy day.
  }

  HarmonicsFile h (*(rsr->harmonicsFileName), in_context->settings);
  ReferenceStation *rs = (ReferenceStation *) h.getStation (*rsr, in_context);
  return new SubordinateStation (rs, this);
}

StationRef::~StationRef() {
}
