/*
   Pathetic Writer
   Copyright (C) 1997, 1998  Ulric Eriksson <ulric@edu.stockholm.se>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA.
*/

/*
   print.c

   Produces data suitable for printing on a Postscript device. I have made
   several assumptions to simplify things:
   - paper size is A4 = 595x842 points
   - margin on all sides = 72 points = 1 inch
   - 1 pixel = 1 point means no scaling is necessary
   - PS font has same geometry as X font
   - no background pattern
   - don't draw the grid
   - The lpr command is used for printing

   This works for me, but will probably break (more or less) for anyone
   not using my printer (a NEC S62P) with A4 paper.
 */

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <time.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/cursorfont.h>
#include <X11/Intrinsic.h>

#include "pw.h"
#include "../common/fonts.h"

int paper_height = 842;
int paper_width = 595;
int left_margin = 72, right_margin = 72, top_margin = 72, bottom_margin = 72;

extern int font_size[8];

extern char *psformat;	/* from fileio_ps.c */

void preview()
{
	char fn[256];

	sprintf(fn, "/tmp/siagprint%ld.ps", (long)getpid());
	if (!savematrix(fn, w_list->buf, psformat)) {
		if (!fork()) {
			execlp("gv", "GV", fn, (char *)0);
			llpr("Can't exec GV");

			exit(1);
		}
	} else
		llpr("Can\'t make postscript\n");
}

void printer(void)
{
	char fn[256];

	sprintf(fn, "/tmp/siagprint%ld.ps", (long)getpid());
	if (!savematrix(fn, w_list->buf, psformat)) {
		if (!fork()) {
			execlp("lpr", "lpr", fn, (char *)0);
			llpr("Can't exec lpr");

			exit(1);
		}
	}
}

