/***************************************************************
LanceMan's quickplot --- a fast interactive 2D plotter

Copyright (C) 1998  Lance Arsenault

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; version 2
of the License.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

***********************************************************************/
/* $Id: set_options.c,v 1.1 1998/02/28 18:09:06 lance Exp $ */
#include <assert.h>
#include <strings.h>
#include <stdio.h>
#include "option.h"

#define FILE_DEBUG 0

/* put Xt options in Xt_options and Quickplot options in Qp_options
 * method: if it's not a Xt option it's a quickplot option
 */

void set_options(int *Xt_optcount,char ***Xt_options,
		 int *Qp_optcount,char ***Qp_options,
			  int argc, char **argv)
{
  int i,j,k,got_one;

  assert(NULL != (*Xt_options = (char **) malloc(sizeof(char *) * (argc + 1))));
  assert(NULL != (*Qp_options = (char **) malloc(sizeof(char *) * (argc + 1))));

  for(i=0;i<argc;i++)
    {
      (*Xt_options)[i] = NULL;
      (*Qp_options)[i] = NULL;
    }

  (*Xt_options)[0] = argv[0];
  (*Qp_options)[0] = argv[0];

  *Xt_optcount = 1;
  *Qp_optcount = 1;
 
  for(i=1;i<argc;i++)
    {
      got_one= 0;
      for(j=0;((XtOptions[j]).arg) != NULL;j++)
	{
	  if(strncmp(argv[i],(XtOptions[j]).arg,strlen((XtOptions[j]).arg)) == 0)
	    {
	      got_one = 1;
	      (*Xt_options)[(*Xt_optcount)++] = argv[i];
	      for(k=1;k<=(XtOptions[j]).num_vals && i<argc ;k++)
		(*Xt_options)[(*Xt_optcount)++] = argv[++i];
	      break;
	    }
	}
      if(!got_one)
	(*Qp_options)[(*Qp_optcount)++] = argv[i];
    }

  (*Xt_options)[(*Xt_optcount)] = NULL;
  (*Qp_options)[(*Qp_optcount)] = NULL;


#if (FILE_DEBUG)
  fprintf(stderr,"ARGS =");
  for(i=0;i<argc;i++)
     fprintf(stderr," %s",argv[i]);
  fprintf(stderr,"\n");

  fprintf(stderr,"QuickPlot ARGS =");
  for(i=0;i<(*Qp_optcount);i++)
    fprintf(stderr," %s",(*Qp_options)[i]);
  fprintf(stderr,"\n");

  fprintf(stderr,"Xt ARGS =");
  for(i=0;i<(*Xt_optcount);i++)
    fprintf(stderr," %s",(*Xt_options)[i]);
  fprintf(stderr,"\n");
#endif
}
