/*
 * Grace - Graphics for Exploratory Data Analysis
 * 
 * Home page: http://plasma-gate.weizmann.ac.il/Grace/
 * 
 * Copyright (c) 1991-95 Paul J Turner, Portland, OR
 * Copyright (c) 1996-98 GRACE Development Team
 * 
 * Maintained by Evgeny Stambulchik <fnevgeny@plasma-gate.weizmann.ac.il>
 * 
 * 
 *                           All Rights Reserved
 * 
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 * 
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 * 
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* 
 *
 * Graph appearance
 *
 */

#include <config.h>

#include <Xm/Xm.h>
#include <Xm/DialogS.h>
#include <Xm/RowColumn.h>

#include "Tab.h"

#include "globals.h"
#include "protos.h"
#include "motifinc.h"

static Widget graphapp_dialog = NULL;
static Widget graphapp_panel;

/*
 * Widget item declarations
 */
static Widget define_view_xv1;
static Widget define_view_xv2;
static Widget define_view_yv1;
static Widget define_view_yv2;

static Widget *graph_type_choice_item;

static Widget label_title_text_item;
static Widget label_subtitle_text_item;
static Widget *title_color_item;
static OptionStructure title_font_item;
static Widget title_size_item;
static Widget *stitle_color_item;
static OptionStructure stitle_font_item;
static Widget stitle_size_item;

static Widget graph_flipxy_item;

static Widget *frame_framestyle_choice_item;
static Widget *frame_color_choice_item;
static Widget *frame_pattern_choice_item;
static Widget *frame_lines_choice_item;
static Widget *frame_linew_choice_item;
static Widget *frame_fillcolor_choice_item;
static Widget *frame_fillpattern_choice_item;
static Widget *frame_applyto_choice_item;

static Widget legend_x_item;
static Widget legend_y_item;
static Widget toggle_legends_item;
static Widget *toggle_legendloc_item;
static Widget *legends_vgap_item;
static Widget *legends_hgap_item;
static Widget *legends_len_item;
static OptionStructure legend_font_item;
static Widget legend_charsize_item;
static Widget *legend_color_item;
static Widget *legend_boxfillcolor_item;
static Widget *legend_boxfillpat_item;
static Widget *legend_boxlinew_item;
static Widget *legend_boxlines_item;
static Widget *legend_boxcolor_item;
static Widget *legend_boxpattern_item;

/*
 * Event and Notify proc declarations
 */
static void graphapp_aac_cb(Widget w, XtPointer client_data, XtPointer call_data);
static void updatelegends(int gno);

/*
 * 
 */
void create_graphapp_frame(Widget w, XtPointer client_data, XtPointer call_data)
{
    Widget graphapp_tab, graphapp_frame, graphapp_main, graphapp_titles,
         graphapp_legends, graphapp_legendbox, rc_head;
    Widget rc, rc1, rc2, fr;

    set_wait_cursor();
    
    if (graphapp_dialog == NULL) {
	graphapp_dialog = XmCreateDialogShell(app_shell, "GraphAppearance", NULL, 0);
	handle_close(graphapp_dialog);
        graphapp_panel = XtVaCreateWidget("graphapp_panel", xmFormWidgetClass, 
                                          graphapp_dialog, NULL, 0);

        rc_head = XmCreateRowColumn(graphapp_panel, "rc_head", NULL, 0);
        rc = XmCreateRowColumn(rc_head, "rc", NULL, 0);
        XtVaSetValues(rc, XmNorientation, XmHORIZONTAL, NULL);
        CreateGraphChoice(rc, "Graph: (N/I)", maxgraph, 0);
        XtManageChild(rc);
        XtManageChild(rc_head);
        XtVaSetValues(rc_head,
                      XmNtopAttachment, XmATTACH_FORM,
                      XmNleftAttachment, XmATTACH_FORM,
                      XmNrightAttachment, XmATTACH_FORM,
                      NULL);


        /* ------------ Tabs --------------*/

        graphapp_tab = CreateTab(graphapp_panel);        


        /* ------------ Main tab --------------*/
        
        graphapp_main = CreateTabPage(graphapp_tab, "Main");

	fr = CreateFrame(graphapp_main, NULL);
	rc = XtVaCreateWidget("rc", xmRowColumnWidgetClass, fr, NULL);
	graph_type_choice_item = CreatePanelChoice(rc, 
                                                   "Graph type:",
						   5,
						   "XY graph",
						   "Bar chart (N/I)",
						   "Polar graph",
						   "Smith chart (N/I)",
						   NULL,
						   NULL);
        XtManageChild(rc);

	fr = CreateFrame(graphapp_main, "Titles");
	rc = XtVaCreateWidget("rc", xmRowColumnWidgetClass, fr, NULL);
	label_title_text_item = CreateTextItem2(rc, 25, "Title:");
	label_subtitle_text_item = CreateTextItem2(rc, 22, "Subtitle:");
        XtManageChild(rc);

        fr = CreateFrame(graphapp_main, "Viewport");
        rc = XtVaCreateWidget("rc", xmRowColumnWidgetClass, fr, NULL);

        rc1 = XtVaCreateWidget("rc", xmRowColumnWidgetClass, rc, NULL);
	XtVaSetValues(rc1, XmNorientation, XmHORIZONTAL, NULL);
	define_view_xv1 = CreateTextItem2(rc1, 8, "Xmin:");
	define_view_xv2 = CreateTextItem2(rc1, 8, "Xmax:");
        XtManageChild(rc1);

        rc1 = XtVaCreateWidget("rc", xmRowColumnWidgetClass, rc, NULL);
	XtVaSetValues(rc1, XmNorientation, XmHORIZONTAL, NULL);
	define_view_yv1 = CreateTextItem2(rc1, 8, "Ymin:");
	define_view_yv2 = CreateTextItem2(rc1, 8, "Ymax:");
        XtManageChild(rc1);

        XtManageChild(rc);
        
        fr = CreateFrame(graphapp_main, "Display options");
        rc = XtVaCreateWidget("rc", xmRowColumnWidgetClass, fr, NULL);
	XtVaSetValues(rc, XmNorientation, XmHORIZONTAL, NULL);
	graph_flipxy_item = CreateToggleButton(rc, "Flip XY (N/I)");
	toggle_legends_item = CreateToggleButton(rc, "Display legend");
        XtManageChild(rc);



        /* ------------ Titles tab --------------*/
        
        graphapp_titles = CreateTabPage(graphapp_tab, "Titles");

	fr = CreateFrame(graphapp_titles, "Title");
	rc2 = XtVaCreateWidget("rc2", xmRowColumnWidgetClass, fr,
				      NULL);
	title_font_item = CreateFontChoice(rc2, "Font:");
	title_size_item = CreateCharSizeChoice(rc2, "Character size");

	title_color_item = CreateColorChoice(rc2, "Color:");

	XtManageChild(rc2);

	fr = CreateFrame(graphapp_titles, "Subtitle");
	rc2 = XtVaCreateWidget("rc2", xmRowColumnWidgetClass, fr, NULL);

	stitle_font_item = CreateFontChoice(rc2, "Font:");
	stitle_size_item = CreateCharSizeChoice(rc2, "Character size");
	stitle_color_item = CreateColorChoice(rc2, "Color:");

	XtManageChild(rc2);


        /* ------------ Frame tab --------------*/
        
        graphapp_frame = CreateTabPage(graphapp_tab, "Frame");

	fr = CreateFrame(graphapp_frame, "Frame box");
	rc = XtVaCreateWidget("rc", xmRowColumnWidgetClass, fr, NULL);
	frame_framestyle_choice_item = CreatePanelChoice(rc, "Frame type:",
							 7,
							 "Closed",
							 "Half open",
							 "Break top",
							 "Break bottom",
							 "Break left",
							 "Break right",
							 NULL,
							 NULL);

	frame_color_choice_item = CreateColorChoice(rc, "Line color:");
	frame_pattern_choice_item = CreatePatternChoice(rc, "Line pattern:");
	frame_linew_choice_item = CreateLineWidthChoice(rc, "Line width:");
	frame_lines_choice_item = CreateLineStyleChoice(rc, "Line style:");
        XtManageChild(rc);

	fr = CreateFrame(graphapp_frame, "Frame fill");
	rc = XtVaCreateWidget("rc", xmRowColumnWidgetClass, fr, NULL);
	frame_fillcolor_choice_item = CreateColorChoice(rc, "Fill color:");
	frame_fillpattern_choice_item = CreatePatternChoice(rc, "Fill pattern:");
        XtManageChild(rc);



        /* ------------ Legend frame tab --------------*/
        
        graphapp_legendbox = CreateTabPage(graphapp_tab, "Leg. box");

	fr = CreateFrame(graphapp_legendbox, "Location");
	rc = XtVaCreateWidget("rc", xmRowColumnWidgetClass, fr, NULL);
	toggle_legendloc_item = CreatePanelChoice(rc, "Locate in:",
						  3,
						  "World coords",
						  "Viewport coords",
						  0, 0);

        rc1 = XtVaCreateWidget("rc", xmRowColumnWidgetClass, rc, NULL);
	XtVaSetValues(rc1, XmNorientation, XmHORIZONTAL, NULL);
	legend_x_item = CreateTextItem2(rc1, 10, "X:");
	legend_y_item = CreateTextItem2(rc1, 10, "Y:");
	XtManageChild(rc1);
	XtManageChild(rc);

	fr = CreateFrame(graphapp_legendbox, "Frame box");
	rc = XtVaCreateWidget("rc", xmRowColumnWidgetClass, fr, NULL);

	legend_boxcolor_item = CreateColorChoice(rc, "Line color:");
	legend_boxpattern_item = CreatePatternChoice(rc, "Line pattern:");
	legend_boxlinew_item = CreateLineWidthChoice(rc, "Line width:");
	legend_boxlines_item = CreateLineStyleChoice(rc, "Line style:");
	XtManageChild(rc);

	fr = CreateFrame(graphapp_legendbox, "Frame fill");
	rc = XtVaCreateWidget("rc", xmRowColumnWidgetClass, fr, NULL);
	legend_boxfillcolor_item = CreateColorChoice(rc, "Color:");
	legend_boxfillpat_item = CreatePatternChoice(rc, "Pattern:");
	XtManageChild(rc);




        /* ------------ Legends tab --------------*/
        
        graphapp_legends = CreateTabPage(graphapp_tab, "Legends");

	fr = CreateFrame(graphapp_legends, "Text properties");
	rc = XtVaCreateWidget("rc", xmRowColumnWidgetClass, fr, NULL);
	legend_font_item = CreateFontChoice(rc, "Font:");

	legend_charsize_item = CreateCharSizeChoice(rc, "Char size");
	legend_color_item = CreateColorChoice(rc, "Color:");
        
        XtManageChild(rc);

	fr = CreateFrame(graphapp_legends, "Placement");
	rc = XtVaCreateWidget("rc", xmRowColumnWidgetClass, fr, NULL);
	
        rc1 = XtVaCreateWidget("rc", xmRowColumnWidgetClass, rc, NULL);
	XtVaSetValues(rc1, XmNorientation, XmHORIZONTAL, NULL);
        legends_vgap_item = CreatePanelChoice(rc1, "V-gap:",
					     7,
					     "0", "1", "2", "3", "4", "5",
					     0, 0);
        legends_hgap_item = CreatePanelChoice(rc1, "H-gap:",
					     7,
					     "0", "1", "2", "3", "4", "5",
					     0, 0);
	XtManageChild(rc1);

	legends_len_item = CreatePanelChoice(rc, "Legend line length:",
					     10,
				             "0", "1", "2", "3", "4",
                                             "5", "6", "7", "8",
					     0, 0);
	XtManageChild(rc);
        
        
        SelectTabPage(graphapp_tab, graphapp_main);


        fr = XmCreateFrame(graphapp_panel, "fr", NULL, 0); 
        rc = XmCreateRowColumn(fr, "rc", NULL, 0);

	frame_applyto_choice_item = CreatePanelChoice(rc, "Apply to:",
						      3,
						      "Current graph",
						      "All active graphs",
						      NULL,
						      NULL);
        CreateAACButtons(rc, graphapp_panel, graphapp_aac_cb);
        
        XtManageChild(rc);
        XtManageChild(fr);
        XtVaSetValues(fr,
                      XmNtopAttachment, XmATTACH_NONE,
                      XmNleftAttachment, XmATTACH_FORM,
                      XmNrightAttachment, XmATTACH_FORM,
                      XmNbottomAttachment, XmATTACH_FORM,
                      NULL);
        XtVaSetValues(graphapp_tab,
                      XmNtopAttachment, XmATTACH_WIDGET,
                      XmNtopWidget, rc_head,
                      XmNleftAttachment, XmATTACH_FORM,
                      XmNrightAttachment, XmATTACH_FORM,
                      XmNbottomAttachment, XmATTACH_WIDGET,
                      XmNbottomWidget, fr,
                      NULL);

        XtManageChild(graphapp_panel);

    }
    
    XtRaise(graphapp_dialog);
    update_graphapp_items(cg);
    unset_wait_cursor();
}

/*
 * Notify and event procs
 */

static void graphapp_aac_cb(Widget w, XtPointer client_data, XtPointer call_data)
{
    int i, ming, maxg;
    int which, aac_mode;
    view v;
    int graphtype;
    int flipxy;

    aac_mode = (int) client_data;
    
    if (aac_mode == AAC_CLOSE) {
        XtUnmanageChild(graphapp_dialog);
        return;
    }

    xv_evalexpr( define_view_xv1, &v.xv1 );  
    xv_evalexpr( define_view_xv2, &v.xv2 );  
    xv_evalexpr( define_view_yv1, &v.yv1 );  
    xv_evalexpr( define_view_yv2, &v.yv2 );  
    
    if (isvalid_viewport(v) == FALSE) {
        errmsg("Invalid viewport coordinates");
        return;
    } 
    
    graphtype = GetChoice(graph_type_choice_item);
    
    flipxy = GetToggleButtonState(graph_flipxy_item);

    
    which = GetChoice(frame_applyto_choice_item);
    if (which == 0) {
	ming = maxg = cg;
    } else {
	ming = 0;
	maxg = maxgraph - 1;
    }
    
    for (i = ming; i <= maxg; i++) {
	if (isactive_graph(i)) {

            g[i].type = graphtype;

            set_plotstr_string(&g[i].labs.title, xv_getstr(label_title_text_item));
            set_plotstr_string(&g[i].labs.stitle, xv_getstr(label_subtitle_text_item));

            g[i].labs.title.charsize = GetCharSizeChoice(title_size_item);
            g[i].labs.stitle.charsize = GetCharSizeChoice(stitle_size_item);

            g[i].labs.title.color = GetChoice(title_color_item);
            g[i].labs.stitle.color = GetChoice(stitle_color_item);
            
            g[i].labs.title.font = GetOptionChoice(title_font_item);
            g[i].labs.stitle.font = GetOptionChoice(stitle_font_item);
            
            g[i].xyflip = flipxy;
           
            g[i].v = v;

	    g[i].f.type = GetChoice(frame_framestyle_choice_item);
	    g[i].f.pen.color = GetChoice(frame_color_choice_item);
	    g[i].f.pen.pattern = GetChoice(frame_pattern_choice_item);
	    g[i].f.linew = GetChoice(frame_linew_choice_item);
	    g[i].f.lines = GetChoice(frame_lines_choice_item);
	    g[i].f.fillpen.color = GetChoice(frame_fillcolor_choice_item);
	    g[i].f.fillpen.pattern = GetChoice(frame_fillpattern_choice_item);

	    g[i].l.charsize = GetCharSizeChoice(legend_charsize_item);
	    g[i].l.active = GetToggleButtonState(toggle_legends_item);
	    g[i].l.vgap = GetChoice(legends_vgap_item);
	    g[i].l.hgap = GetChoice(legends_hgap_item);
	    g[i].l.len = GetChoice(legends_len_item);
	    g[i].l.loctype = GetChoice(toggle_legendloc_item) ? COORD_VIEW : COORD_WORLD;
	    xv_evalexpr(legend_x_item, &g[i].l.legx);
	    xv_evalexpr(legend_y_item, &g[i].l.legy);
	    g[i].l.font = GetOptionChoice(legend_font_item);
	    g[i].l.color = GetChoice(legend_color_item);
	    g[i].l.boxfillpen.color = GetChoice(legend_boxfillcolor_item);
	    g[i].l.boxfillpen.pattern = GetChoice(legend_boxfillpat_item);
	    g[i].l.boxpen.color = GetChoice(legend_boxcolor_item);
	    g[i].l.boxpen.pattern = GetChoice(legend_boxpattern_item);
	    g[i].l.boxlinew = GetChoice(legend_boxlinew_item);
	    g[i].l.boxlines = GetChoice(legend_boxlines_item);

	}
    }

    if (aac_mode == AAC_ACCEPT) {
        XtUnmanageChild(graphapp_dialog);
    }
    
    drawgraph();
    set_dirtystate();
}

void update_graphapp_items(int gno)
{
    if (graphapp_dialog != NULL) {
        update_view(gno);

        update_frame_items(gno);
 
        updatelegends(gno);
 
        SetChoice(graph_type_choice_item, g[gno].type);

        xv_setstr(label_title_text_item, g[gno].labs.title.s);
        xv_setstr(label_subtitle_text_item, g[gno].labs.stitle.s);
 
        SetCharSizeChoice(title_size_item, g[gno].labs.title.charsize);
        SetCharSizeChoice(stitle_size_item, g[gno].labs.stitle.charsize);

        SetChoice(title_color_item, g[gno].labs.title.color);
        SetChoice(stitle_color_item, g[gno].labs.stitle.color);

        SetOptionChoice(title_font_item, g[gno].labs.title.font);
        SetOptionChoice(stitle_font_item, g[gno].labs.stitle.font);

        SetToggleButtonState(graph_flipxy_item, g[gno].xyflip);
    }
}
/*
 * Viewport update
 */
void update_view(int gno)
{
    if (graphapp_dialog) {
	sprintf(buf, "%.9g", g[gno].v.xv1);
	xv_setstr(define_view_xv1, buf);
	sprintf(buf, "%.9g", g[gno].v.xv2);
	xv_setstr(define_view_xv2, buf);
	sprintf(buf, "%.9g", g[gno].v.yv1);
	xv_setstr(define_view_yv1, buf);
	sprintf(buf, "%.9g", g[gno].v.yv2);
	xv_setstr(define_view_yv2, buf);
    }
}

/*
 * legend popup
 */
static void updatelegends(int gno)
{
    if (graphapp_dialog != NULL) {
	SetCharSizeChoice(legend_charsize_item, g[gno].l.charsize);

	SetToggleButtonState(toggle_legends_item, g[gno].l.active == TRUE);

	sprintf(buf, "%.9g", g[gno].l.legx);
	xv_setstr(legend_x_item, buf);
	sprintf(buf, "%.9g", g[gno].l.legy);
	xv_setstr(legend_y_item, buf);

	SetChoice(legends_vgap_item, g[gno].l.vgap);
	SetChoice(legends_hgap_item, g[gno].l.hgap);
	SetChoice(legends_len_item, g[gno].l.len);

	SetChoice(toggle_legendloc_item, g[gno].l.loctype == COORD_VIEW);
	SetOptionChoice(legend_font_item, g[gno].l.font);
	SetChoice(legend_color_item, g[gno].l.color);
	SetChoice(legend_boxfillcolor_item, g[gno].l.boxfillpen.color);
	SetChoice(legend_boxfillpat_item, g[gno].l.boxfillpen.pattern);
	SetChoice(legend_boxcolor_item, g[gno].l.boxpen.color);
	SetChoice(legend_boxpattern_item, g[gno].l.boxpen.pattern);
	SetChoice(legend_boxlinew_item, g[gno].l.boxlinew);
	SetChoice(legend_boxlines_item, g[gno].l.boxlines);
    }
}

void update_frame_items(int gno)
{
    if (graphapp_dialog) {
	SetChoice(frame_framestyle_choice_item, g[gno].f.type);
	SetChoice(frame_color_choice_item, g[gno].f.pen.color);
	SetChoice(frame_pattern_choice_item, g[gno].f.pen.pattern);
	SetChoice(frame_linew_choice_item, g[gno].f.linew);
	SetChoice(frame_lines_choice_item, g[gno].f.lines);
	SetChoice(frame_fillcolor_choice_item, g[gno].f.fillpen.color);
	SetChoice(frame_fillpattern_choice_item, g[gno].f.fillpen.pattern);
    }
}


/*
 * activate the legend location flag
 */
void legend_loc_proc(Widget w, XtPointer client_data, XtPointer call_data)
{
    if (graphapp_dialog) {
	g[cg].l.loctype = GetChoice(toggle_legendloc_item) ? COORD_VIEW : COORD_WORLD;
    }
    set_action(0);
    set_action(LEG_LOC);
    set_dirtystate();
}

