/*
 * Copyright (c) 1997,1998 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Mon Sep 28 17:18:51 EDT 1998 */

#include <fftw-int.h>
#include <fftw.h>

/* Generated by: ./genfft -magic-alignment-check -magic-twiddle-load-all -magic-variables 4 -magic-loopi -hc2hc-forward 32 */

/*
 * This function contains 929 FP additions, 398 FP multiplications,
 * (or, 785 additions, 254 multiplications, 144 fused multiply/add),
 * 94 stack variables, and 256 memory accesses
 */
static const fftw_real K195090322 = FFTW_KONST(+0.195090322016128267848284868477022240927691618);
static const fftw_real K980785280 = FFTW_KONST(+0.980785280403230449126182236134239036973933731);
static const fftw_real K555570233 = FFTW_KONST(+0.555570233019602224742830813948532874374937191);
static const fftw_real K831469612 = FFTW_KONST(+0.831469612302545237078788377617905756738560812);
static const fftw_real K382683432 = FFTW_KONST(+0.382683432365089771728459984030398866761344562);
static const fftw_real K923879532 = FFTW_KONST(+0.923879532511286756128183189396788286822416626);
static const fftw_real K707106781 = FFTW_KONST(+0.707106781186547524400844362104849039284835938);

/*
 * Generator Id's : 
 * $Id: exprdag.ml,v 1.35 1998/09/25 19:14:16 athena Exp $
 * $Id: fft.ml,v 1.40 1998/09/14 14:43:06 fftw Exp $
 * $Id: to_c.ml,v 1.23 1998/09/14 14:43:08 fftw Exp $
 */

void fftw_hc2hc_forward_32(fftw_real *A, const fftw_complex *W, int iostride, int m, int dist)
{
     int i;
     fftw_real *X;
     fftw_real *Y;
     X = A;
     Y = A + (32 * iostride);
     {
	  fftw_real tmp900;
	  fftw_real tmp1028;
	  fftw_real tmp924;
	  fftw_real tmp976;
	  fftw_real tmp907;
	  fftw_real tmp1041;
	  fftw_real tmp927;
	  fftw_real tmp975;
	  fftw_real tmp1016;
	  fftw_real tmp1036;
	  fftw_real tmp964;
	  fftw_real tmp992;
	  fftw_real tmp1019;
	  fftw_real tmp1037;
	  fftw_real tmp969;
	  fftw_real tmp993;
	  fftw_real tmp915;
	  fftw_real tmp1029;
	  fftw_real tmp931;
	  fftw_real tmp973;
	  fftw_real tmp922;
	  fftw_real tmp1030;
	  fftw_real tmp934;
	  fftw_real tmp972;
	  fftw_real tmp1009;
	  fftw_real tmp1033;
	  fftw_real tmp947;
	  fftw_real tmp989;
	  fftw_real tmp1012;
	  fftw_real tmp1034;
	  fftw_real tmp952;
	  fftw_real tmp990;
	  ASSERT_ALIGNED_DOUBLE();
	  {
	       fftw_real tmp894;
	       fftw_real tmp895;
	       fftw_real tmp896;
	       fftw_real tmp897;
	       fftw_real tmp898;
	       fftw_real tmp899;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp894 = X[0];
	       tmp895 = X[16 * iostride];
	       tmp896 = tmp894 + tmp895;
	       tmp897 = X[8 * iostride];
	       tmp898 = X[24 * iostride];
	       tmp899 = tmp897 + tmp898;
	       tmp900 = tmp896 + tmp899;
	       tmp1028 = tmp896 - tmp899;
	       tmp924 = tmp894 - tmp895;
	       tmp976 = tmp897 - tmp898;
	  }
	  {
	       fftw_real tmp903;
	       fftw_real tmp925;
	       fftw_real tmp906;
	       fftw_real tmp926;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp901;
		    fftw_real tmp902;
		    fftw_real tmp904;
		    fftw_real tmp905;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp901 = X[4 * iostride];
		    tmp902 = X[20 * iostride];
		    tmp903 = tmp901 + tmp902;
		    tmp925 = tmp901 - tmp902;
		    tmp904 = X[28 * iostride];
		    tmp905 = X[12 * iostride];
		    tmp906 = tmp904 + tmp905;
		    tmp926 = tmp904 - tmp905;
	       }
	       tmp907 = tmp903 + tmp906;
	       tmp1041 = tmp906 - tmp903;
	       tmp927 = K707106781 * (tmp925 + tmp926);
	       tmp975 = K707106781 * (tmp926 - tmp925);
	  }
	  {
	       fftw_real tmp956;
	       fftw_real tmp1014;
	       fftw_real tmp968;
	       fftw_real tmp1015;
	       fftw_real tmp959;
	       fftw_real tmp1017;
	       fftw_real tmp962;
	       fftw_real tmp1018;
	       fftw_real tmp963;
	       fftw_real tmp965;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp954;
		    fftw_real tmp955;
		    fftw_real tmp966;
		    fftw_real tmp967;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp954 = X[31 * iostride];
		    tmp955 = X[15 * iostride];
		    tmp956 = tmp954 - tmp955;
		    tmp1014 = tmp954 + tmp955;
		    tmp966 = X[7 * iostride];
		    tmp967 = X[23 * iostride];
		    tmp968 = tmp966 - tmp967;
		    tmp1015 = tmp966 + tmp967;
	       }
	       {
		    fftw_real tmp957;
		    fftw_real tmp958;
		    fftw_real tmp960;
		    fftw_real tmp961;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp957 = X[3 * iostride];
		    tmp958 = X[19 * iostride];
		    tmp959 = tmp957 - tmp958;
		    tmp1017 = tmp957 + tmp958;
		    tmp960 = X[27 * iostride];
		    tmp961 = X[11 * iostride];
		    tmp962 = tmp960 - tmp961;
		    tmp1018 = tmp960 + tmp961;
	       }
	       tmp1016 = tmp1014 + tmp1015;
	       tmp1036 = tmp1014 - tmp1015;
	       tmp963 = K707106781 * (tmp959 + tmp962);
	       tmp964 = tmp956 + tmp963;
	       tmp992 = tmp956 - tmp963;
	       tmp1019 = tmp1017 + tmp1018;
	       tmp1037 = tmp1018 - tmp1017;
	       tmp965 = K707106781 * (tmp962 - tmp959);
	       tmp969 = tmp965 - tmp968;
	       tmp993 = tmp968 + tmp965;
	  }
	  {
	       fftw_real tmp911;
	       fftw_real tmp929;
	       fftw_real tmp914;
	       fftw_real tmp930;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp909;
		    fftw_real tmp910;
		    fftw_real tmp912;
		    fftw_real tmp913;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp909 = X[2 * iostride];
		    tmp910 = X[18 * iostride];
		    tmp911 = tmp909 + tmp910;
		    tmp929 = tmp909 - tmp910;
		    tmp912 = X[10 * iostride];
		    tmp913 = X[26 * iostride];
		    tmp914 = tmp912 + tmp913;
		    tmp930 = tmp912 - tmp913;
	       }
	       tmp915 = tmp911 + tmp914;
	       tmp1029 = tmp911 - tmp914;
	       tmp931 = (K923879532 * tmp929) - (K382683432 * tmp930);
	       tmp973 = (K382683432 * tmp929) + (K923879532 * tmp930);
	  }
	  {
	       fftw_real tmp918;
	       fftw_real tmp932;
	       fftw_real tmp921;
	       fftw_real tmp933;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp916;
		    fftw_real tmp917;
		    fftw_real tmp919;
		    fftw_real tmp920;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp916 = X[30 * iostride];
		    tmp917 = X[14 * iostride];
		    tmp918 = tmp916 + tmp917;
		    tmp932 = tmp916 - tmp917;
		    tmp919 = X[6 * iostride];
		    tmp920 = X[22 * iostride];
		    tmp921 = tmp919 + tmp920;
		    tmp933 = tmp919 - tmp920;
	       }
	       tmp922 = tmp918 + tmp921;
	       tmp1030 = tmp918 - tmp921;
	       tmp934 = (K923879532 * tmp932) + (K382683432 * tmp933);
	       tmp972 = (K382683432 * tmp932) - (K923879532 * tmp933);
	  }
	  {
	       fftw_real tmp939;
	       fftw_real tmp1007;
	       fftw_real tmp951;
	       fftw_real tmp1008;
	       fftw_real tmp942;
	       fftw_real tmp1010;
	       fftw_real tmp945;
	       fftw_real tmp1011;
	       fftw_real tmp946;
	       fftw_real tmp948;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp937;
		    fftw_real tmp938;
		    fftw_real tmp949;
		    fftw_real tmp950;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp937 = X[iostride];
		    tmp938 = X[17 * iostride];
		    tmp939 = tmp937 - tmp938;
		    tmp1007 = tmp937 + tmp938;
		    tmp949 = X[9 * iostride];
		    tmp950 = X[25 * iostride];
		    tmp951 = tmp949 - tmp950;
		    tmp1008 = tmp949 + tmp950;
	       }
	       {
		    fftw_real tmp940;
		    fftw_real tmp941;
		    fftw_real tmp943;
		    fftw_real tmp944;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp940 = X[5 * iostride];
		    tmp941 = X[21 * iostride];
		    tmp942 = tmp940 - tmp941;
		    tmp1010 = tmp940 + tmp941;
		    tmp943 = X[29 * iostride];
		    tmp944 = X[13 * iostride];
		    tmp945 = tmp943 - tmp944;
		    tmp1011 = tmp943 + tmp944;
	       }
	       tmp1009 = tmp1007 + tmp1008;
	       tmp1033 = tmp1007 - tmp1008;
	       tmp946 = K707106781 * (tmp942 + tmp945);
	       tmp947 = tmp939 + tmp946;
	       tmp989 = tmp939 - tmp946;
	       tmp1012 = tmp1010 + tmp1011;
	       tmp1034 = tmp1011 - tmp1010;
	       tmp948 = K707106781 * (tmp945 - tmp942);
	       tmp952 = tmp948 - tmp951;
	       tmp990 = tmp951 + tmp948;
	  }
	  {
	       fftw_real tmp908;
	       fftw_real tmp923;
	       fftw_real tmp1024;
	       fftw_real tmp1025;
	       fftw_real tmp1026;
	       fftw_real tmp1027;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp908 = tmp900 + tmp907;
	       tmp923 = tmp915 + tmp922;
	       tmp1024 = tmp908 + tmp923;
	       tmp1025 = tmp1009 + tmp1012;
	       tmp1026 = tmp1016 + tmp1019;
	       tmp1027 = tmp1025 + tmp1026;
	       X[8 * iostride] = tmp908 - tmp923;
	       Y[-8 * iostride] = tmp1026 - tmp1025;
	       X[16 * iostride] = tmp1024 - tmp1027;
	       X[0] = tmp1024 + tmp1027;
	  }
	  {
	       fftw_real tmp1006;
	       fftw_real tmp1022;
	       fftw_real tmp1021;
	       fftw_real tmp1023;
	       fftw_real tmp1013;
	       fftw_real tmp1020;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp1006 = tmp900 - tmp907;
	       tmp1022 = tmp922 - tmp915;
	       tmp1013 = tmp1009 - tmp1012;
	       tmp1020 = tmp1016 - tmp1019;
	       tmp1021 = K707106781 * (tmp1013 + tmp1020);
	       tmp1023 = K707106781 * (tmp1020 - tmp1013);
	       X[12 * iostride] = tmp1006 - tmp1021;
	       X[4 * iostride] = tmp1006 + tmp1021;
	       Y[-4 * iostride] = tmp1022 + tmp1023;
	       Y[-12 * iostride] = tmp1023 - tmp1022;
	  }
	  {
	       fftw_real tmp1032;
	       fftw_real tmp1048;
	       fftw_real tmp1042;
	       fftw_real tmp1044;
	       fftw_real tmp1039;
	       fftw_real tmp1043;
	       fftw_real tmp1047;
	       fftw_real tmp1049;
	       fftw_real tmp1031;
	       fftw_real tmp1040;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp1031 = K707106781 * (tmp1029 + tmp1030);
	       tmp1032 = tmp1028 + tmp1031;
	       tmp1048 = tmp1028 - tmp1031;
	       tmp1040 = K707106781 * (tmp1030 - tmp1029);
	       tmp1042 = tmp1040 - tmp1041;
	       tmp1044 = tmp1041 + tmp1040;
	       {
		    fftw_real tmp1035;
		    fftw_real tmp1038;
		    fftw_real tmp1045;
		    fftw_real tmp1046;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp1035 = (K923879532 * tmp1033) + (K382683432 * tmp1034);
		    tmp1038 = (K923879532 * tmp1036) - (K382683432 * tmp1037);
		    tmp1039 = tmp1035 + tmp1038;
		    tmp1043 = tmp1038 - tmp1035;
		    tmp1045 = (K923879532 * tmp1034) - (K382683432 * tmp1033);
		    tmp1046 = (K382683432 * tmp1036) + (K923879532 * tmp1037);
		    tmp1047 = tmp1045 + tmp1046;
		    tmp1049 = tmp1046 - tmp1045;
	       }
	       X[14 * iostride] = tmp1032 - tmp1039;
	       X[2 * iostride] = tmp1032 + tmp1039;
	       Y[-6 * iostride] = tmp1042 + tmp1043;
	       Y[-10 * iostride] = tmp1043 - tmp1042;
	       Y[-2 * iostride] = tmp1044 + tmp1047;
	       Y[-14 * iostride] = tmp1047 - tmp1044;
	       X[10 * iostride] = tmp1048 - tmp1049;
	       X[6 * iostride] = tmp1048 + tmp1049;
	  }
	  {
	       fftw_real tmp988;
	       fftw_real tmp1004;
	       fftw_real tmp1003;
	       fftw_real tmp1005;
	       fftw_real tmp995;
	       fftw_real tmp999;
	       fftw_real tmp998;
	       fftw_real tmp1000;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp986;
		    fftw_real tmp987;
		    fftw_real tmp1001;
		    fftw_real tmp1002;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp986 = tmp924 - tmp927;
		    tmp987 = tmp973 + tmp972;
		    tmp988 = tmp986 + tmp987;
		    tmp1004 = tmp986 - tmp987;
		    tmp1001 = (K831469612 * tmp990) - (K555570233 * tmp989);
		    tmp1002 = (K555570233 * tmp992) + (K831469612 * tmp993);
		    tmp1003 = tmp1001 + tmp1002;
		    tmp1005 = tmp1002 - tmp1001;
	       }
	       {
		    fftw_real tmp991;
		    fftw_real tmp994;
		    fftw_real tmp996;
		    fftw_real tmp997;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp991 = (K831469612 * tmp989) + (K555570233 * tmp990);
		    tmp994 = (K831469612 * tmp992) - (K555570233 * tmp993);
		    tmp995 = tmp991 + tmp994;
		    tmp999 = tmp994 - tmp991;
		    tmp996 = tmp934 - tmp931;
		    tmp997 = tmp976 + tmp975;
		    tmp998 = tmp996 - tmp997;
		    tmp1000 = tmp997 + tmp996;
	       }
	       X[13 * iostride] = tmp988 - tmp995;
	       X[3 * iostride] = tmp988 + tmp995;
	       Y[-5 * iostride] = tmp998 + tmp999;
	       Y[-11 * iostride] = tmp999 - tmp998;
	       Y[-3 * iostride] = tmp1000 + tmp1003;
	       Y[-13 * iostride] = tmp1003 - tmp1000;
	       X[11 * iostride] = tmp1004 - tmp1005;
	       X[5 * iostride] = tmp1004 + tmp1005;
	  }
	  {
	       fftw_real tmp936;
	       fftw_real tmp984;
	       fftw_real tmp983;
	       fftw_real tmp985;
	       fftw_real tmp971;
	       fftw_real tmp979;
	       fftw_real tmp978;
	       fftw_real tmp980;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp928;
		    fftw_real tmp935;
		    fftw_real tmp981;
		    fftw_real tmp982;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp928 = tmp924 + tmp927;
		    tmp935 = tmp931 + tmp934;
		    tmp936 = tmp928 + tmp935;
		    tmp984 = tmp928 - tmp935;
		    tmp981 = (K980785280 * tmp952) - (K195090322 * tmp947);
		    tmp982 = (K195090322 * tmp964) + (K980785280 * tmp969);
		    tmp983 = tmp981 + tmp982;
		    tmp985 = tmp982 - tmp981;
	       }
	       {
		    fftw_real tmp953;
		    fftw_real tmp970;
		    fftw_real tmp974;
		    fftw_real tmp977;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp953 = (K980785280 * tmp947) + (K195090322 * tmp952);
		    tmp970 = (K980785280 * tmp964) - (K195090322 * tmp969);
		    tmp971 = tmp953 + tmp970;
		    tmp979 = tmp970 - tmp953;
		    tmp974 = tmp972 - tmp973;
		    tmp977 = tmp975 - tmp976;
		    tmp978 = tmp974 - tmp977;
		    tmp980 = tmp977 + tmp974;
	       }
	       X[15 * iostride] = tmp936 - tmp971;
	       X[iostride] = tmp936 + tmp971;
	       Y[-7 * iostride] = tmp978 + tmp979;
	       Y[-9 * iostride] = tmp979 - tmp978;
	       Y[-iostride] = tmp980 + tmp983;
	       Y[-15 * iostride] = tmp983 - tmp980;
	       X[9 * iostride] = tmp984 - tmp985;
	       X[7 * iostride] = tmp984 + tmp985;
	  }
     }
     X = X + dist;
     Y = Y - dist;
     for (i = 2; i < m; i = i + 2, X = X + dist, Y = Y - dist, W = W + 31) {
	  fftw_real tmp416;
	  fftw_real tmp748;
	  fftw_real tmp868;
	  fftw_real tmp882;
	  fftw_real tmp838;
	  fftw_real tmp852;
	  fftw_real tmp588;
	  fftw_real tmp700;
	  fftw_real tmp558;
	  fftw_real tmp776;
	  fftw_real tmp673;
	  fftw_real tmp723;
	  fftw_real tmp783;
	  fftw_real tmp819;
	  fftw_real tmp656;
	  fftw_real tmp720;
	  fftw_real tmp439;
	  fftw_real tmp851;
	  fftw_real tmp598;
	  fftw_real tmp702;
	  fftw_real tmp751;
	  fftw_real tmp833;
	  fftw_real tmp593;
	  fftw_real tmp701;
	  fftw_real tmp581;
	  fftw_real tmp784;
	  fftw_real tmp779;
	  fftw_real tmp820;
	  fftw_real tmp667;
	  fftw_real tmp724;
	  fftw_real tmp676;
	  fftw_real tmp721;
	  fftw_real tmp463;
	  fftw_real tmp756;
	  fftw_real tmp610;
	  fftw_real tmp706;
	  fftw_real tmp755;
	  fftw_real tmp809;
	  fftw_real tmp605;
	  fftw_real tmp705;
	  fftw_real tmp511;
	  fftw_real tmp770;
	  fftw_real tmp646;
	  fftw_real tmp713;
	  fftw_real tmp767;
	  fftw_real tmp814;
	  fftw_real tmp629;
	  fftw_real tmp716;
	  fftw_real tmp486;
	  fftw_real tmp758;
	  fftw_real tmp621;
	  fftw_real tmp709;
	  fftw_real tmp761;
	  fftw_real tmp810;
	  fftw_real tmp616;
	  fftw_real tmp708;
	  fftw_real tmp534;
	  fftw_real tmp768;
	  fftw_real tmp773;
	  fftw_real tmp815;
	  fftw_real tmp640;
	  fftw_real tmp714;
	  fftw_real tmp649;
	  fftw_real tmp717;
	  ASSERT_ALIGNED_DOUBLE();
	  {
	       fftw_real tmp398;
	       fftw_real tmp836;
	       fftw_real tmp403;
	       fftw_real tmp835;
	       fftw_real tmp409;
	       fftw_real tmp585;
	       fftw_real tmp414;
	       fftw_real tmp586;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp398 = X[0];
	       tmp836 = Y[-31 * iostride];
	       {
		    fftw_real tmp400;
		    fftw_real tmp402;
		    fftw_real tmp399;
		    fftw_real tmp401;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp400 = X[16 * iostride];
		    tmp402 = Y[-15 * iostride];
		    tmp399 = c_re(W[15]);
		    tmp401 = c_im(W[15]);
		    tmp403 = (tmp399 * tmp400) - (tmp401 * tmp402);
		    tmp835 = (tmp401 * tmp400) + (tmp399 * tmp402);
	       }
	       {
		    fftw_real tmp406;
		    fftw_real tmp408;
		    fftw_real tmp405;
		    fftw_real tmp407;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp406 = X[8 * iostride];
		    tmp408 = Y[-23 * iostride];
		    tmp405 = c_re(W[7]);
		    tmp407 = c_im(W[7]);
		    tmp409 = (tmp405 * tmp406) - (tmp407 * tmp408);
		    tmp585 = (tmp407 * tmp406) + (tmp405 * tmp408);
	       }
	       {
		    fftw_real tmp411;
		    fftw_real tmp413;
		    fftw_real tmp410;
		    fftw_real tmp412;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp411 = X[24 * iostride];
		    tmp413 = Y[-7 * iostride];
		    tmp410 = c_re(W[23]);
		    tmp412 = c_im(W[23]);
		    tmp414 = (tmp410 * tmp411) - (tmp412 * tmp413);
		    tmp586 = (tmp412 * tmp411) + (tmp410 * tmp413);
	       }
	       {
		    fftw_real tmp404;
		    fftw_real tmp415;
		    fftw_real tmp866;
		    fftw_real tmp867;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp404 = tmp398 + tmp403;
		    tmp415 = tmp409 + tmp414;
		    tmp416 = tmp404 + tmp415;
		    tmp748 = tmp404 - tmp415;
		    tmp866 = tmp836 - tmp835;
		    tmp867 = tmp409 - tmp414;
		    tmp868 = tmp866 - tmp867;
		    tmp882 = tmp867 + tmp866;
	       }
	       {
		    fftw_real tmp834;
		    fftw_real tmp837;
		    fftw_real tmp584;
		    fftw_real tmp587;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp834 = tmp585 + tmp586;
		    tmp837 = tmp835 + tmp836;
		    tmp838 = tmp834 + tmp837;
		    tmp852 = tmp837 - tmp834;
		    tmp584 = tmp398 - tmp403;
		    tmp587 = tmp585 - tmp586;
		    tmp588 = tmp584 - tmp587;
		    tmp700 = tmp584 + tmp587;
	       }
	  }
	  {
	       fftw_real tmp540;
	       fftw_real tmp669;
	       fftw_real tmp556;
	       fftw_real tmp654;
	       fftw_real tmp545;
	       fftw_real tmp670;
	       fftw_real tmp551;
	       fftw_real tmp653;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp537;
		    fftw_real tmp539;
		    fftw_real tmp536;
		    fftw_real tmp538;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp537 = X[31 * iostride];
		    tmp539 = Y[0];
		    tmp536 = c_re(W[30]);
		    tmp538 = c_im(W[30]);
		    tmp540 = (tmp536 * tmp537) - (tmp538 * tmp539);
		    tmp669 = (tmp538 * tmp537) + (tmp536 * tmp539);
	       }
	       {
		    fftw_real tmp553;
		    fftw_real tmp555;
		    fftw_real tmp552;
		    fftw_real tmp554;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp553 = X[23 * iostride];
		    tmp555 = Y[-8 * iostride];
		    tmp552 = c_re(W[22]);
		    tmp554 = c_im(W[22]);
		    tmp556 = (tmp552 * tmp553) - (tmp554 * tmp555);
		    tmp654 = (tmp554 * tmp553) + (tmp552 * tmp555);
	       }
	       {
		    fftw_real tmp542;
		    fftw_real tmp544;
		    fftw_real tmp541;
		    fftw_real tmp543;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp542 = X[15 * iostride];
		    tmp544 = Y[-16 * iostride];
		    tmp541 = c_re(W[14]);
		    tmp543 = c_im(W[14]);
		    tmp545 = (tmp541 * tmp542) - (tmp543 * tmp544);
		    tmp670 = (tmp543 * tmp542) + (tmp541 * tmp544);
	       }
	       {
		    fftw_real tmp548;
		    fftw_real tmp550;
		    fftw_real tmp547;
		    fftw_real tmp549;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp548 = X[7 * iostride];
		    tmp550 = Y[-24 * iostride];
		    tmp547 = c_re(W[6]);
		    tmp549 = c_im(W[6]);
		    tmp551 = (tmp547 * tmp548) - (tmp549 * tmp550);
		    tmp653 = (tmp549 * tmp548) + (tmp547 * tmp550);
	       }
	       {
		    fftw_real tmp546;
		    fftw_real tmp557;
		    fftw_real tmp671;
		    fftw_real tmp672;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp546 = tmp540 + tmp545;
		    tmp557 = tmp551 + tmp556;
		    tmp558 = tmp546 + tmp557;
		    tmp776 = tmp546 - tmp557;
		    tmp671 = tmp669 - tmp670;
		    tmp672 = tmp551 - tmp556;
		    tmp673 = tmp671 + tmp672;
		    tmp723 = tmp671 - tmp672;
	       }
	       {
		    fftw_real tmp781;
		    fftw_real tmp782;
		    fftw_real tmp652;
		    fftw_real tmp655;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp781 = tmp669 + tmp670;
		    tmp782 = tmp653 + tmp654;
		    tmp783 = tmp781 - tmp782;
		    tmp819 = tmp781 + tmp782;
		    tmp652 = tmp540 - tmp545;
		    tmp655 = tmp653 - tmp654;
		    tmp656 = tmp652 - tmp655;
		    tmp720 = tmp652 + tmp655;
	       }
	  }
	  {
	       fftw_real tmp421;
	       fftw_real tmp589;
	       fftw_real tmp437;
	       fftw_real tmp596;
	       fftw_real tmp426;
	       fftw_real tmp590;
	       fftw_real tmp432;
	       fftw_real tmp595;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp418;
		    fftw_real tmp420;
		    fftw_real tmp417;
		    fftw_real tmp419;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp418 = X[4 * iostride];
		    tmp420 = Y[-27 * iostride];
		    tmp417 = c_re(W[3]);
		    tmp419 = c_im(W[3]);
		    tmp421 = (tmp417 * tmp418) - (tmp419 * tmp420);
		    tmp589 = (tmp419 * tmp418) + (tmp417 * tmp420);
	       }
	       {
		    fftw_real tmp434;
		    fftw_real tmp436;
		    fftw_real tmp433;
		    fftw_real tmp435;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp434 = X[12 * iostride];
		    tmp436 = Y[-19 * iostride];
		    tmp433 = c_re(W[11]);
		    tmp435 = c_im(W[11]);
		    tmp437 = (tmp433 * tmp434) - (tmp435 * tmp436);
		    tmp596 = (tmp435 * tmp434) + (tmp433 * tmp436);
	       }
	       {
		    fftw_real tmp423;
		    fftw_real tmp425;
		    fftw_real tmp422;
		    fftw_real tmp424;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp423 = X[20 * iostride];
		    tmp425 = Y[-11 * iostride];
		    tmp422 = c_re(W[19]);
		    tmp424 = c_im(W[19]);
		    tmp426 = (tmp422 * tmp423) - (tmp424 * tmp425);
		    tmp590 = (tmp424 * tmp423) + (tmp422 * tmp425);
	       }
	       {
		    fftw_real tmp429;
		    fftw_real tmp431;
		    fftw_real tmp428;
		    fftw_real tmp430;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp429 = X[28 * iostride];
		    tmp431 = Y[-3 * iostride];
		    tmp428 = c_re(W[27]);
		    tmp430 = c_im(W[27]);
		    tmp432 = (tmp428 * tmp429) - (tmp430 * tmp431);
		    tmp595 = (tmp430 * tmp429) + (tmp428 * tmp431);
	       }
	       {
		    fftw_real tmp427;
		    fftw_real tmp438;
		    fftw_real tmp594;
		    fftw_real tmp597;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp427 = tmp421 + tmp426;
		    tmp438 = tmp432 + tmp437;
		    tmp439 = tmp427 + tmp438;
		    tmp851 = tmp438 - tmp427;
		    tmp594 = tmp432 - tmp437;
		    tmp597 = tmp595 - tmp596;
		    tmp598 = tmp594 + tmp597;
		    tmp702 = tmp594 - tmp597;
	       }
	       {
		    fftw_real tmp749;
		    fftw_real tmp750;
		    fftw_real tmp591;
		    fftw_real tmp592;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp749 = tmp589 + tmp590;
		    tmp750 = tmp595 + tmp596;
		    tmp751 = tmp749 - tmp750;
		    tmp833 = tmp749 + tmp750;
		    tmp591 = tmp589 - tmp590;
		    tmp592 = tmp421 - tmp426;
		    tmp593 = tmp591 - tmp592;
		    tmp701 = tmp592 + tmp591;
	       }
	  }
	  {
	       fftw_real tmp563;
	       fftw_real tmp657;
	       fftw_real tmp568;
	       fftw_real tmp658;
	       fftw_real tmp659;
	       fftw_real tmp660;
	       fftw_real tmp574;
	       fftw_real tmp663;
	       fftw_real tmp579;
	       fftw_real tmp664;
	       fftw_real tmp662;
	       fftw_real tmp665;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp560;
		    fftw_real tmp562;
		    fftw_real tmp559;
		    fftw_real tmp561;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp560 = X[3 * iostride];
		    tmp562 = Y[-28 * iostride];
		    tmp559 = c_re(W[2]);
		    tmp561 = c_im(W[2]);
		    tmp563 = (tmp559 * tmp560) - (tmp561 * tmp562);
		    tmp657 = (tmp561 * tmp560) + (tmp559 * tmp562);
	       }
	       {
		    fftw_real tmp565;
		    fftw_real tmp567;
		    fftw_real tmp564;
		    fftw_real tmp566;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp565 = X[19 * iostride];
		    tmp567 = Y[-12 * iostride];
		    tmp564 = c_re(W[18]);
		    tmp566 = c_im(W[18]);
		    tmp568 = (tmp564 * tmp565) - (tmp566 * tmp567);
		    tmp658 = (tmp566 * tmp565) + (tmp564 * tmp567);
	       }
	       tmp659 = tmp657 - tmp658;
	       tmp660 = tmp563 - tmp568;
	       {
		    fftw_real tmp571;
		    fftw_real tmp573;
		    fftw_real tmp570;
		    fftw_real tmp572;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp571 = X[27 * iostride];
		    tmp573 = Y[-4 * iostride];
		    tmp570 = c_re(W[26]);
		    tmp572 = c_im(W[26]);
		    tmp574 = (tmp570 * tmp571) - (tmp572 * tmp573);
		    tmp663 = (tmp572 * tmp571) + (tmp570 * tmp573);
	       }
	       {
		    fftw_real tmp576;
		    fftw_real tmp578;
		    fftw_real tmp575;
		    fftw_real tmp577;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp576 = X[11 * iostride];
		    tmp578 = Y[-20 * iostride];
		    tmp575 = c_re(W[10]);
		    tmp577 = c_im(W[10]);
		    tmp579 = (tmp575 * tmp576) - (tmp577 * tmp578);
		    tmp664 = (tmp577 * tmp576) + (tmp575 * tmp578);
	       }
	       tmp662 = tmp574 - tmp579;
	       tmp665 = tmp663 - tmp664;
	       {
		    fftw_real tmp569;
		    fftw_real tmp580;
		    fftw_real tmp777;
		    fftw_real tmp778;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp569 = tmp563 + tmp568;
		    tmp580 = tmp574 + tmp579;
		    tmp581 = tmp569 + tmp580;
		    tmp784 = tmp580 - tmp569;
		    tmp777 = tmp657 + tmp658;
		    tmp778 = tmp663 + tmp664;
		    tmp779 = tmp777 - tmp778;
		    tmp820 = tmp777 + tmp778;
	       }
	       {
		    fftw_real tmp661;
		    fftw_real tmp666;
		    fftw_real tmp674;
		    fftw_real tmp675;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp661 = tmp659 - tmp660;
		    tmp666 = tmp662 + tmp665;
		    tmp667 = K707106781 * (tmp661 - tmp666);
		    tmp724 = K707106781 * (tmp661 + tmp666);
		    tmp674 = tmp662 - tmp665;
		    tmp675 = tmp660 + tmp659;
		    tmp676 = K707106781 * (tmp674 - tmp675);
		    tmp721 = K707106781 * (tmp675 + tmp674);
	       }
	  }
	  {
	       fftw_real tmp445;
	       fftw_real tmp601;
	       fftw_real tmp461;
	       fftw_real tmp608;
	       fftw_real tmp450;
	       fftw_real tmp602;
	       fftw_real tmp456;
	       fftw_real tmp607;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp442;
		    fftw_real tmp444;
		    fftw_real tmp441;
		    fftw_real tmp443;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp442 = X[2 * iostride];
		    tmp444 = Y[-29 * iostride];
		    tmp441 = c_re(W[1]);
		    tmp443 = c_im(W[1]);
		    tmp445 = (tmp441 * tmp442) - (tmp443 * tmp444);
		    tmp601 = (tmp443 * tmp442) + (tmp441 * tmp444);
	       }
	       {
		    fftw_real tmp458;
		    fftw_real tmp460;
		    fftw_real tmp457;
		    fftw_real tmp459;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp458 = X[26 * iostride];
		    tmp460 = Y[-5 * iostride];
		    tmp457 = c_re(W[25]);
		    tmp459 = c_im(W[25]);
		    tmp461 = (tmp457 * tmp458) - (tmp459 * tmp460);
		    tmp608 = (tmp459 * tmp458) + (tmp457 * tmp460);
	       }
	       {
		    fftw_real tmp447;
		    fftw_real tmp449;
		    fftw_real tmp446;
		    fftw_real tmp448;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp447 = X[18 * iostride];
		    tmp449 = Y[-13 * iostride];
		    tmp446 = c_re(W[17]);
		    tmp448 = c_im(W[17]);
		    tmp450 = (tmp446 * tmp447) - (tmp448 * tmp449);
		    tmp602 = (tmp448 * tmp447) + (tmp446 * tmp449);
	       }
	       {
		    fftw_real tmp453;
		    fftw_real tmp455;
		    fftw_real tmp452;
		    fftw_real tmp454;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp453 = X[10 * iostride];
		    tmp455 = Y[-21 * iostride];
		    tmp452 = c_re(W[9]);
		    tmp454 = c_im(W[9]);
		    tmp456 = (tmp452 * tmp453) - (tmp454 * tmp455);
		    tmp607 = (tmp454 * tmp453) + (tmp452 * tmp455);
	       }
	       {
		    fftw_real tmp451;
		    fftw_real tmp462;
		    fftw_real tmp606;
		    fftw_real tmp609;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp451 = tmp445 + tmp450;
		    tmp462 = tmp456 + tmp461;
		    tmp463 = tmp451 + tmp462;
		    tmp756 = tmp451 - tmp462;
		    tmp606 = tmp445 - tmp450;
		    tmp609 = tmp607 - tmp608;
		    tmp610 = tmp606 - tmp609;
		    tmp706 = tmp606 + tmp609;
	       }
	       {
		    fftw_real tmp753;
		    fftw_real tmp754;
		    fftw_real tmp603;
		    fftw_real tmp604;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp753 = tmp601 + tmp602;
		    tmp754 = tmp607 + tmp608;
		    tmp755 = tmp753 - tmp754;
		    tmp809 = tmp753 + tmp754;
		    tmp603 = tmp601 - tmp602;
		    tmp604 = tmp456 - tmp461;
		    tmp605 = tmp603 + tmp604;
		    tmp705 = tmp603 - tmp604;
	       }
	  }
	  {
	       fftw_real tmp493;
	       fftw_real tmp625;
	       fftw_real tmp509;
	       fftw_real tmp644;
	       fftw_real tmp498;
	       fftw_real tmp626;
	       fftw_real tmp504;
	       fftw_real tmp643;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp490;
		    fftw_real tmp492;
		    fftw_real tmp489;
		    fftw_real tmp491;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp490 = X[iostride];
		    tmp492 = Y[-30 * iostride];
		    tmp489 = c_re(W[0]);
		    tmp491 = c_im(W[0]);
		    tmp493 = (tmp489 * tmp490) - (tmp491 * tmp492);
		    tmp625 = (tmp491 * tmp490) + (tmp489 * tmp492);
	       }
	       {
		    fftw_real tmp506;
		    fftw_real tmp508;
		    fftw_real tmp505;
		    fftw_real tmp507;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp506 = X[25 * iostride];
		    tmp508 = Y[-6 * iostride];
		    tmp505 = c_re(W[24]);
		    tmp507 = c_im(W[24]);
		    tmp509 = (tmp505 * tmp506) - (tmp507 * tmp508);
		    tmp644 = (tmp507 * tmp506) + (tmp505 * tmp508);
	       }
	       {
		    fftw_real tmp495;
		    fftw_real tmp497;
		    fftw_real tmp494;
		    fftw_real tmp496;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp495 = X[17 * iostride];
		    tmp497 = Y[-14 * iostride];
		    tmp494 = c_re(W[16]);
		    tmp496 = c_im(W[16]);
		    tmp498 = (tmp494 * tmp495) - (tmp496 * tmp497);
		    tmp626 = (tmp496 * tmp495) + (tmp494 * tmp497);
	       }
	       {
		    fftw_real tmp501;
		    fftw_real tmp503;
		    fftw_real tmp500;
		    fftw_real tmp502;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp501 = X[9 * iostride];
		    tmp503 = Y[-22 * iostride];
		    tmp500 = c_re(W[8]);
		    tmp502 = c_im(W[8]);
		    tmp504 = (tmp500 * tmp501) - (tmp502 * tmp503);
		    tmp643 = (tmp502 * tmp501) + (tmp500 * tmp503);
	       }
	       {
		    fftw_real tmp499;
		    fftw_real tmp510;
		    fftw_real tmp642;
		    fftw_real tmp645;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp499 = tmp493 + tmp498;
		    tmp510 = tmp504 + tmp509;
		    tmp511 = tmp499 + tmp510;
		    tmp770 = tmp499 - tmp510;
		    tmp642 = tmp493 - tmp498;
		    tmp645 = tmp643 - tmp644;
		    tmp646 = tmp642 - tmp645;
		    tmp713 = tmp642 + tmp645;
	       }
	       {
		    fftw_real tmp765;
		    fftw_real tmp766;
		    fftw_real tmp627;
		    fftw_real tmp628;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp765 = tmp625 + tmp626;
		    tmp766 = tmp643 + tmp644;
		    tmp767 = tmp765 - tmp766;
		    tmp814 = tmp765 + tmp766;
		    tmp627 = tmp625 - tmp626;
		    tmp628 = tmp504 - tmp509;
		    tmp629 = tmp627 + tmp628;
		    tmp716 = tmp627 - tmp628;
	       }
	  }
	  {
	       fftw_real tmp468;
	       fftw_real tmp612;
	       fftw_real tmp484;
	       fftw_real tmp619;
	       fftw_real tmp473;
	       fftw_real tmp613;
	       fftw_real tmp479;
	       fftw_real tmp618;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp465;
		    fftw_real tmp467;
		    fftw_real tmp464;
		    fftw_real tmp466;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp465 = X[30 * iostride];
		    tmp467 = Y[-iostride];
		    tmp464 = c_re(W[29]);
		    tmp466 = c_im(W[29]);
		    tmp468 = (tmp464 * tmp465) - (tmp466 * tmp467);
		    tmp612 = (tmp466 * tmp465) + (tmp464 * tmp467);
	       }
	       {
		    fftw_real tmp481;
		    fftw_real tmp483;
		    fftw_real tmp480;
		    fftw_real tmp482;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp481 = X[22 * iostride];
		    tmp483 = Y[-9 * iostride];
		    tmp480 = c_re(W[21]);
		    tmp482 = c_im(W[21]);
		    tmp484 = (tmp480 * tmp481) - (tmp482 * tmp483);
		    tmp619 = (tmp482 * tmp481) + (tmp480 * tmp483);
	       }
	       {
		    fftw_real tmp470;
		    fftw_real tmp472;
		    fftw_real tmp469;
		    fftw_real tmp471;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp470 = X[14 * iostride];
		    tmp472 = Y[-17 * iostride];
		    tmp469 = c_re(W[13]);
		    tmp471 = c_im(W[13]);
		    tmp473 = (tmp469 * tmp470) - (tmp471 * tmp472);
		    tmp613 = (tmp471 * tmp470) + (tmp469 * tmp472);
	       }
	       {
		    fftw_real tmp476;
		    fftw_real tmp478;
		    fftw_real tmp475;
		    fftw_real tmp477;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp476 = X[6 * iostride];
		    tmp478 = Y[-25 * iostride];
		    tmp475 = c_re(W[5]);
		    tmp477 = c_im(W[5]);
		    tmp479 = (tmp475 * tmp476) - (tmp477 * tmp478);
		    tmp618 = (tmp477 * tmp476) + (tmp475 * tmp478);
	       }
	       {
		    fftw_real tmp474;
		    fftw_real tmp485;
		    fftw_real tmp617;
		    fftw_real tmp620;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp474 = tmp468 + tmp473;
		    tmp485 = tmp479 + tmp484;
		    tmp486 = tmp474 + tmp485;
		    tmp758 = tmp474 - tmp485;
		    tmp617 = tmp468 - tmp473;
		    tmp620 = tmp618 - tmp619;
		    tmp621 = tmp617 - tmp620;
		    tmp709 = tmp617 + tmp620;
	       }
	       {
		    fftw_real tmp759;
		    fftw_real tmp760;
		    fftw_real tmp614;
		    fftw_real tmp615;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp759 = tmp612 + tmp613;
		    tmp760 = tmp618 + tmp619;
		    tmp761 = tmp759 - tmp760;
		    tmp810 = tmp759 + tmp760;
		    tmp614 = tmp612 - tmp613;
		    tmp615 = tmp479 - tmp484;
		    tmp616 = tmp614 + tmp615;
		    tmp708 = tmp614 - tmp615;
	       }
	  }
	  {
	       fftw_real tmp516;
	       fftw_real tmp636;
	       fftw_real tmp521;
	       fftw_real tmp637;
	       fftw_real tmp635;
	       fftw_real tmp638;
	       fftw_real tmp527;
	       fftw_real tmp631;
	       fftw_real tmp532;
	       fftw_real tmp632;
	       fftw_real tmp630;
	       fftw_real tmp633;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp513;
		    fftw_real tmp515;
		    fftw_real tmp512;
		    fftw_real tmp514;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp513 = X[5 * iostride];
		    tmp515 = Y[-26 * iostride];
		    tmp512 = c_re(W[4]);
		    tmp514 = c_im(W[4]);
		    tmp516 = (tmp512 * tmp513) - (tmp514 * tmp515);
		    tmp636 = (tmp514 * tmp513) + (tmp512 * tmp515);
	       }
	       {
		    fftw_real tmp518;
		    fftw_real tmp520;
		    fftw_real tmp517;
		    fftw_real tmp519;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp518 = X[21 * iostride];
		    tmp520 = Y[-10 * iostride];
		    tmp517 = c_re(W[20]);
		    tmp519 = c_im(W[20]);
		    tmp521 = (tmp517 * tmp518) - (tmp519 * tmp520);
		    tmp637 = (tmp519 * tmp518) + (tmp517 * tmp520);
	       }
	       tmp635 = tmp516 - tmp521;
	       tmp638 = tmp636 - tmp637;
	       {
		    fftw_real tmp524;
		    fftw_real tmp526;
		    fftw_real tmp523;
		    fftw_real tmp525;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp524 = X[29 * iostride];
		    tmp526 = Y[-2 * iostride];
		    tmp523 = c_re(W[28]);
		    tmp525 = c_im(W[28]);
		    tmp527 = (tmp523 * tmp524) - (tmp525 * tmp526);
		    tmp631 = (tmp525 * tmp524) + (tmp523 * tmp526);
	       }
	       {
		    fftw_real tmp529;
		    fftw_real tmp531;
		    fftw_real tmp528;
		    fftw_real tmp530;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp529 = X[13 * iostride];
		    tmp531 = Y[-18 * iostride];
		    tmp528 = c_re(W[12]);
		    tmp530 = c_im(W[12]);
		    tmp532 = (tmp528 * tmp529) - (tmp530 * tmp531);
		    tmp632 = (tmp530 * tmp529) + (tmp528 * tmp531);
	       }
	       tmp630 = tmp527 - tmp532;
	       tmp633 = tmp631 - tmp632;
	       {
		    fftw_real tmp522;
		    fftw_real tmp533;
		    fftw_real tmp771;
		    fftw_real tmp772;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp522 = tmp516 + tmp521;
		    tmp533 = tmp527 + tmp532;
		    tmp534 = tmp522 + tmp533;
		    tmp768 = tmp533 - tmp522;
		    tmp771 = tmp636 + tmp637;
		    tmp772 = tmp631 + tmp632;
		    tmp773 = tmp771 - tmp772;
		    tmp815 = tmp771 + tmp772;
	       }
	       {
		    fftw_real tmp634;
		    fftw_real tmp639;
		    fftw_real tmp647;
		    fftw_real tmp648;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp634 = tmp630 - tmp633;
		    tmp639 = tmp635 + tmp638;
		    tmp640 = K707106781 * (tmp634 - tmp639);
		    tmp714 = K707106781 * (tmp639 + tmp634);
		    tmp647 = tmp638 - tmp635;
		    tmp648 = tmp630 + tmp633;
		    tmp649 = K707106781 * (tmp647 - tmp648);
		    tmp717 = K707106781 * (tmp647 + tmp648);
	       }
	  }
	  {
	       fftw_real tmp488;
	       fftw_real tmp828;
	       fftw_real tmp840;
	       fftw_real tmp842;
	       fftw_real tmp583;
	       fftw_real tmp843;
	       fftw_real tmp831;
	       fftw_real tmp841;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp440;
		    fftw_real tmp487;
		    fftw_real tmp832;
		    fftw_real tmp839;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp440 = tmp416 + tmp439;
		    tmp487 = tmp463 + tmp486;
		    tmp488 = tmp440 + tmp487;
		    tmp828 = tmp440 - tmp487;
		    tmp832 = tmp809 + tmp810;
		    tmp839 = tmp833 + tmp838;
		    tmp840 = tmp832 + tmp839;
		    tmp842 = tmp839 - tmp832;
	       }
	       {
		    fftw_real tmp535;
		    fftw_real tmp582;
		    fftw_real tmp829;
		    fftw_real tmp830;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp535 = tmp511 + tmp534;
		    tmp582 = tmp558 + tmp581;
		    tmp583 = tmp535 + tmp582;
		    tmp843 = tmp582 - tmp535;
		    tmp829 = tmp814 + tmp815;
		    tmp830 = tmp819 + tmp820;
		    tmp831 = tmp829 - tmp830;
		    tmp841 = tmp829 + tmp830;
	       }
	       Y[-16 * iostride] = tmp488 - tmp583;
	       X[0] = tmp488 + tmp583;
	       Y[-24 * iostride] = tmp828 - tmp831;
	       X[8 * iostride] = tmp828 + tmp831;
	       X[16 * iostride] = -(tmp840 - tmp841);
	       Y[0] = tmp841 + tmp840;
	       X[24 * iostride] = -(tmp842 - tmp843);
	       Y[-8 * iostride] = tmp843 + tmp842;
	  }
	  {
	       fftw_real tmp812;
	       fftw_real tmp824;
	       fftw_real tmp846;
	       fftw_real tmp848;
	       fftw_real tmp817;
	       fftw_real tmp825;
	       fftw_real tmp822;
	       fftw_real tmp826;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp808;
		    fftw_real tmp811;
		    fftw_real tmp844;
		    fftw_real tmp845;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp808 = tmp416 - tmp439;
		    tmp811 = tmp809 - tmp810;
		    tmp812 = tmp808 + tmp811;
		    tmp824 = tmp808 - tmp811;
		    tmp844 = tmp486 - tmp463;
		    tmp845 = tmp838 - tmp833;
		    tmp846 = tmp844 + tmp845;
		    tmp848 = tmp845 - tmp844;
	       }
	       {
		    fftw_real tmp813;
		    fftw_real tmp816;
		    fftw_real tmp818;
		    fftw_real tmp821;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp813 = tmp511 - tmp534;
		    tmp816 = tmp814 - tmp815;
		    tmp817 = tmp813 + tmp816;
		    tmp825 = tmp816 - tmp813;
		    tmp818 = tmp558 - tmp581;
		    tmp821 = tmp819 - tmp820;
		    tmp822 = tmp818 - tmp821;
		    tmp826 = tmp818 + tmp821;
	       }
	       {
		    fftw_real tmp823;
		    fftw_real tmp849;
		    fftw_real tmp827;
		    fftw_real tmp847;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp823 = K707106781 * (tmp817 + tmp822);
		    Y[-20 * iostride] = tmp812 - tmp823;
		    X[4 * iostride] = tmp812 + tmp823;
		    tmp849 = K707106781 * (tmp822 - tmp817);
		    X[28 * iostride] = -(tmp848 - tmp849);
		    Y[-12 * iostride] = tmp849 + tmp848;
		    tmp827 = K707106781 * (tmp825 - tmp826);
		    Y[-28 * iostride] = tmp824 - tmp827;
		    X[12 * iostride] = tmp824 + tmp827;
		    tmp847 = K707106781 * (tmp825 + tmp826);
		    X[20 * iostride] = -(tmp846 - tmp847);
		    Y[-4 * iostride] = tmp847 + tmp846;
	       }
	  }
	  {
	       fftw_real tmp752;
	       fftw_real tmp792;
	       fftw_real tmp763;
	       fftw_real tmp850;
	       fftw_real tmp795;
	       fftw_real tmp858;
	       fftw_real tmp775;
	       fftw_real tmp789;
	       fftw_real tmp853;
	       fftw_real tmp859;
	       fftw_real tmp799;
	       fftw_real tmp805;
	       fftw_real tmp786;
	       fftw_real tmp790;
	       fftw_real tmp802;
	       fftw_real tmp806;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp757;
		    fftw_real tmp762;
		    fftw_real tmp797;
		    fftw_real tmp798;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp752 = tmp748 - tmp751;
		    tmp792 = tmp748 + tmp751;
		    tmp757 = tmp755 - tmp756;
		    tmp762 = tmp758 + tmp761;
		    tmp763 = K707106781 * (tmp757 - tmp762);
		    tmp850 = K707106781 * (tmp757 + tmp762);
		    {
			 fftw_real tmp793;
			 fftw_real tmp794;
			 fftw_real tmp769;
			 fftw_real tmp774;
			 ASSERT_ALIGNED_DOUBLE();
			 tmp793 = tmp756 + tmp755;
			 tmp794 = tmp758 - tmp761;
			 tmp795 = K707106781 * (tmp793 + tmp794);
			 tmp858 = K707106781 * (tmp794 - tmp793);
			 tmp769 = tmp767 - tmp768;
			 tmp774 = tmp770 - tmp773;
			 tmp775 = (K923879532 * tmp769) + (K382683432 * tmp774);
			 tmp789 = (K382683432 * tmp769) - (K923879532 * tmp774);
		    }
		    tmp853 = tmp851 + tmp852;
		    tmp859 = tmp852 - tmp851;
		    tmp797 = tmp767 + tmp768;
		    tmp798 = tmp770 + tmp773;
		    tmp799 = (K382683432 * tmp797) + (K923879532 * tmp798);
		    tmp805 = (K923879532 * tmp797) - (K382683432 * tmp798);
		    {
			 fftw_real tmp780;
			 fftw_real tmp785;
			 fftw_real tmp800;
			 fftw_real tmp801;
			 ASSERT_ALIGNED_DOUBLE();
			 tmp780 = tmp776 - tmp779;
			 tmp785 = tmp783 - tmp784;
			 tmp786 = (K382683432 * tmp780) - (K923879532 * tmp785);
			 tmp790 = (K382683432 * tmp785) + (K923879532 * tmp780);
			 tmp800 = tmp776 + tmp779;
			 tmp801 = tmp783 + tmp784;
			 tmp802 = (K923879532 * tmp800) - (K382683432 * tmp801);
			 tmp806 = (K923879532 * tmp801) + (K382683432 * tmp800);
		    }
	       }
	       {
		    fftw_real tmp764;
		    fftw_real tmp787;
		    fftw_real tmp788;
		    fftw_real tmp791;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp764 = tmp752 + tmp763;
		    tmp787 = tmp775 + tmp786;
		    Y[-22 * iostride] = tmp764 - tmp787;
		    X[6 * iostride] = tmp764 + tmp787;
		    tmp788 = tmp752 - tmp763;
		    tmp791 = tmp789 - tmp790;
		    Y[-30 * iostride] = tmp788 - tmp791;
		    X[14 * iostride] = tmp788 + tmp791;
	       }
	       {
		    fftw_real tmp860;
		    fftw_real tmp861;
		    fftw_real tmp862;
		    fftw_real tmp863;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp860 = tmp858 + tmp859;
		    tmp861 = tmp789 + tmp790;
		    X[22 * iostride] = -(tmp860 - tmp861);
		    Y[-6 * iostride] = tmp861 + tmp860;
		    tmp862 = tmp859 - tmp858;
		    tmp863 = tmp786 - tmp775;
		    X[30 * iostride] = -(tmp862 - tmp863);
		    Y[-14 * iostride] = tmp863 + tmp862;
	       }
	       {
		    fftw_real tmp796;
		    fftw_real tmp803;
		    fftw_real tmp804;
		    fftw_real tmp807;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp796 = tmp792 + tmp795;
		    tmp803 = tmp799 + tmp802;
		    Y[-18 * iostride] = tmp796 - tmp803;
		    X[2 * iostride] = tmp796 + tmp803;
		    tmp804 = tmp792 - tmp795;
		    tmp807 = tmp805 - tmp806;
		    Y[-26 * iostride] = tmp804 - tmp807;
		    X[10 * iostride] = tmp804 + tmp807;
	       }
	       {
		    fftw_real tmp854;
		    fftw_real tmp855;
		    fftw_real tmp856;
		    fftw_real tmp857;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp854 = tmp850 + tmp853;
		    tmp855 = tmp805 + tmp806;
		    X[18 * iostride] = -(tmp854 - tmp855);
		    Y[-2 * iostride] = tmp855 + tmp854;
		    tmp856 = tmp853 - tmp850;
		    tmp857 = tmp802 - tmp799;
		    X[26 * iostride] = -(tmp856 - tmp857);
		    Y[-10 * iostride] = tmp857 + tmp856;
	       }
	  }
	  {
	       fftw_real tmp704;
	       fftw_real tmp732;
	       fftw_real tmp735;
	       fftw_real tmp874;
	       fftw_real tmp869;
	       fftw_real tmp875;
	       fftw_real tmp711;
	       fftw_real tmp864;
	       fftw_real tmp719;
	       fftw_real tmp729;
	       fftw_real tmp739;
	       fftw_real tmp745;
	       fftw_real tmp726;
	       fftw_real tmp730;
	       fftw_real tmp742;
	       fftw_real tmp746;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp703;
		    fftw_real tmp733;
		    fftw_real tmp734;
		    fftw_real tmp865;
		    fftw_real tmp707;
		    fftw_real tmp710;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp703 = K707106781 * (tmp701 + tmp702);
		    tmp704 = tmp700 - tmp703;
		    tmp732 = tmp700 + tmp703;
		    tmp733 = (K382683432 * tmp705) + (K923879532 * tmp706);
		    tmp734 = (K923879532 * tmp709) - (K382683432 * tmp708);
		    tmp735 = tmp733 + tmp734;
		    tmp874 = tmp734 - tmp733;
		    tmp865 = K707106781 * (tmp593 + tmp598);
		    tmp869 = tmp865 + tmp868;
		    tmp875 = tmp868 - tmp865;
		    tmp707 = (K923879532 * tmp705) - (K382683432 * tmp706);
		    tmp710 = (K923879532 * tmp708) + (K382683432 * tmp709);
		    tmp711 = tmp707 - tmp710;
		    tmp864 = tmp707 + tmp710;
	       }
	       {
		    fftw_real tmp715;
		    fftw_real tmp718;
		    fftw_real tmp737;
		    fftw_real tmp738;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp715 = tmp713 - tmp714;
		    tmp718 = tmp716 - tmp717;
		    tmp719 = (K555570233 * tmp715) + (K831469612 * tmp718);
		    tmp729 = (K555570233 * tmp718) - (K831469612 * tmp715);
		    tmp737 = tmp713 + tmp714;
		    tmp738 = tmp716 + tmp717;
		    tmp739 = (K980785280 * tmp737) + (K195090322 * tmp738);
		    tmp745 = (K980785280 * tmp738) - (K195090322 * tmp737);
	       }
	       {
		    fftw_real tmp722;
		    fftw_real tmp725;
		    fftw_real tmp740;
		    fftw_real tmp741;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp722 = tmp720 - tmp721;
		    tmp725 = tmp723 - tmp724;
		    tmp726 = (K555570233 * tmp722) - (K831469612 * tmp725);
		    tmp730 = (K831469612 * tmp722) + (K555570233 * tmp725);
		    tmp740 = tmp720 + tmp721;
		    tmp741 = tmp723 + tmp724;
		    tmp742 = (K980785280 * tmp740) - (K195090322 * tmp741);
		    tmp746 = (K195090322 * tmp740) + (K980785280 * tmp741);
	       }
	       {
		    fftw_real tmp712;
		    fftw_real tmp727;
		    fftw_real tmp728;
		    fftw_real tmp731;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp712 = tmp704 + tmp711;
		    tmp727 = tmp719 + tmp726;
		    Y[-21 * iostride] = tmp712 - tmp727;
		    X[5 * iostride] = tmp712 + tmp727;
		    tmp728 = tmp704 - tmp711;
		    tmp731 = tmp729 - tmp730;
		    Y[-29 * iostride] = tmp728 - tmp731;
		    X[13 * iostride] = tmp728 + tmp731;
	       }
	       {
		    fftw_real tmp876;
		    fftw_real tmp877;
		    fftw_real tmp878;
		    fftw_real tmp879;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp876 = tmp874 + tmp875;
		    tmp877 = tmp729 + tmp730;
		    X[21 * iostride] = -(tmp876 - tmp877);
		    Y[-5 * iostride] = tmp877 + tmp876;
		    tmp878 = tmp875 - tmp874;
		    tmp879 = tmp726 - tmp719;
		    X[29 * iostride] = -(tmp878 - tmp879);
		    Y[-13 * iostride] = tmp879 + tmp878;
	       }
	       {
		    fftw_real tmp736;
		    fftw_real tmp743;
		    fftw_real tmp744;
		    fftw_real tmp747;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp736 = tmp732 + tmp735;
		    tmp743 = tmp739 + tmp742;
		    Y[-17 * iostride] = tmp736 - tmp743;
		    X[iostride] = tmp736 + tmp743;
		    tmp744 = tmp732 - tmp735;
		    tmp747 = tmp745 - tmp746;
		    Y[-25 * iostride] = tmp744 - tmp747;
		    X[9 * iostride] = tmp744 + tmp747;
	       }
	       {
		    fftw_real tmp870;
		    fftw_real tmp871;
		    fftw_real tmp872;
		    fftw_real tmp873;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp870 = tmp864 + tmp869;
		    tmp871 = tmp745 + tmp746;
		    X[17 * iostride] = -(tmp870 - tmp871);
		    Y[-iostride] = tmp871 + tmp870;
		    tmp872 = tmp869 - tmp864;
		    tmp873 = tmp742 - tmp739;
		    X[25 * iostride] = -(tmp872 - tmp873);
		    Y[-9 * iostride] = tmp873 + tmp872;
	       }
	  }
	  {
	       fftw_real tmp600;
	       fftw_real tmp684;
	       fftw_real tmp687;
	       fftw_real tmp888;
	       fftw_real tmp883;
	       fftw_real tmp889;
	       fftw_real tmp623;
	       fftw_real tmp880;
	       fftw_real tmp651;
	       fftw_real tmp681;
	       fftw_real tmp691;
	       fftw_real tmp697;
	       fftw_real tmp678;
	       fftw_real tmp682;
	       fftw_real tmp694;
	       fftw_real tmp698;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp599;
		    fftw_real tmp685;
		    fftw_real tmp686;
		    fftw_real tmp881;
		    fftw_real tmp611;
		    fftw_real tmp622;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp599 = K707106781 * (tmp593 - tmp598);
		    tmp600 = tmp588 - tmp599;
		    tmp684 = tmp588 + tmp599;
		    tmp685 = (K923879532 * tmp605) + (K382683432 * tmp610);
		    tmp686 = (K382683432 * tmp621) - (K923879532 * tmp616);
		    tmp687 = tmp685 + tmp686;
		    tmp888 = tmp686 - tmp685;
		    tmp881 = K707106781 * (tmp702 - tmp701);
		    tmp883 = tmp881 + tmp882;
		    tmp889 = tmp882 - tmp881;
		    tmp611 = (K382683432 * tmp605) - (K923879532 * tmp610);
		    tmp622 = (K382683432 * tmp616) + (K923879532 * tmp621);
		    tmp623 = tmp611 - tmp622;
		    tmp880 = tmp611 + tmp622;
	       }
	       {
		    fftw_real tmp641;
		    fftw_real tmp650;
		    fftw_real tmp689;
		    fftw_real tmp690;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp641 = tmp629 - tmp640;
		    tmp650 = tmp646 - tmp649;
		    tmp651 = (K980785280 * tmp641) + (K195090322 * tmp650);
		    tmp681 = (K195090322 * tmp641) - (K980785280 * tmp650);
		    tmp689 = tmp629 + tmp640;
		    tmp690 = tmp646 + tmp649;
		    tmp691 = (K555570233 * tmp689) + (K831469612 * tmp690);
		    tmp697 = (K831469612 * tmp689) - (K555570233 * tmp690);
	       }
	       {
		    fftw_real tmp668;
		    fftw_real tmp677;
		    fftw_real tmp692;
		    fftw_real tmp693;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp668 = tmp656 - tmp667;
		    tmp677 = tmp673 - tmp676;
		    tmp678 = (K195090322 * tmp668) - (K980785280 * tmp677);
		    tmp682 = (K195090322 * tmp677) + (K980785280 * tmp668);
		    tmp692 = tmp656 + tmp667;
		    tmp693 = tmp673 + tmp676;
		    tmp694 = (K831469612 * tmp692) - (K555570233 * tmp693);
		    tmp698 = (K831469612 * tmp693) + (K555570233 * tmp692);
	       }
	       {
		    fftw_real tmp624;
		    fftw_real tmp679;
		    fftw_real tmp680;
		    fftw_real tmp683;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp624 = tmp600 + tmp623;
		    tmp679 = tmp651 + tmp678;
		    Y[-23 * iostride] = tmp624 - tmp679;
		    X[7 * iostride] = tmp624 + tmp679;
		    tmp680 = tmp600 - tmp623;
		    tmp683 = tmp681 - tmp682;
		    Y[-31 * iostride] = tmp680 - tmp683;
		    X[15 * iostride] = tmp680 + tmp683;
	       }
	       {
		    fftw_real tmp890;
		    fftw_real tmp891;
		    fftw_real tmp892;
		    fftw_real tmp893;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp890 = tmp888 + tmp889;
		    tmp891 = tmp681 + tmp682;
		    X[23 * iostride] = -(tmp890 - tmp891);
		    Y[-7 * iostride] = tmp891 + tmp890;
		    tmp892 = tmp889 - tmp888;
		    tmp893 = tmp678 - tmp651;
		    X[31 * iostride] = -(tmp892 - tmp893);
		    Y[-15 * iostride] = tmp893 + tmp892;
	       }
	       {
		    fftw_real tmp688;
		    fftw_real tmp695;
		    fftw_real tmp696;
		    fftw_real tmp699;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp688 = tmp684 + tmp687;
		    tmp695 = tmp691 + tmp694;
		    Y[-19 * iostride] = tmp688 - tmp695;
		    X[3 * iostride] = tmp688 + tmp695;
		    tmp696 = tmp684 - tmp687;
		    tmp699 = tmp697 - tmp698;
		    Y[-27 * iostride] = tmp696 - tmp699;
		    X[11 * iostride] = tmp696 + tmp699;
	       }
	       {
		    fftw_real tmp884;
		    fftw_real tmp885;
		    fftw_real tmp886;
		    fftw_real tmp887;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp884 = tmp880 + tmp883;
		    tmp885 = tmp697 + tmp698;
		    X[19 * iostride] = -(tmp884 - tmp885);
		    Y[-3 * iostride] = tmp885 + tmp884;
		    tmp886 = tmp883 - tmp880;
		    tmp887 = tmp694 - tmp691;
		    X[27 * iostride] = -(tmp886 - tmp887);
		    Y[-11 * iostride] = tmp887 + tmp886;
	       }
	  }
     }
     if (i == m) {
	  fftw_real tmp5;
	  fftw_real tmp166;
	  fftw_real tmp124;
	  fftw_real tmp20;
	  fftw_real tmp135;
	  fftw_real tmp171;
	  fftw_real tmp265;
	  fftw_real tmp12;
	  fftw_real tmp262;
	  fftw_real tmp129;
	  fftw_real tmp167;
	  fftw_real tmp106;
	  fftw_real tmp349;
	  fftw_real tmp256;
	  fftw_real tmp305;
	  fftw_real tmp356;
	  fftw_real tmp388;
	  fftw_real tmp233;
	  fftw_real tmp302;
	  fftw_real tmp121;
	  fftw_real tmp357;
	  fftw_real tmp247;
	  fftw_real tmp257;
	  fftw_real tmp352;
	  fftw_real tmp389;
	  fftw_real tmp240;
	  fftw_real tmp258;
	  fftw_real tmp27;
	  fftw_real tmp140;
	  fftw_real tmp174;
	  fftw_real tmp264;
	  fftw_real tmp51;
	  fftw_real tmp58;
	  fftw_real tmp334;
	  fftw_real tmp189;
	  fftw_real tmp292;
	  fftw_real tmp158;
	  fftw_real tmp163;
	  fftw_real tmp335;
	  fftw_real tmp186;
	  fftw_real tmp291;
	  fftw_real tmp90;
	  fftw_real tmp341;
	  fftw_real tmp212;
	  fftw_real tmp222;
	  fftw_real tmp346;
	  fftw_real tmp384;
	  fftw_real tmp205;
	  fftw_real tmp223;
	  fftw_real tmp75;
	  fftw_real tmp343;
	  fftw_real tmp221;
	  fftw_real tmp295;
	  fftw_real tmp340;
	  fftw_real tmp383;
	  fftw_real tmp198;
	  fftw_real tmp298;
	  fftw_real tmp36;
	  fftw_real tmp43;
	  fftw_real tmp332;
	  fftw_real tmp182;
	  fftw_real tmp289;
	  fftw_real tmp147;
	  fftw_real tmp152;
	  fftw_real tmp331;
	  fftw_real tmp179;
	  fftw_real tmp288;
	  ASSERT_ALIGNED_DOUBLE();
	  {
	       fftw_real tmp1;
	       fftw_real tmp3;
	       fftw_real tmp4;
	       fftw_real tmp2;
	       fftw_real tmp123;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp1 = X[0];
	       tmp3 = X[16 * iostride];
	       tmp2 = c_re(W[15]);
	       tmp4 = tmp2 * tmp3;
	       tmp5 = tmp1 + tmp4;
	       tmp166 = tmp1 - tmp4;
	       tmp123 = c_im(W[15]);
	       tmp124 = tmp123 * tmp3;
	  }
	  {
	       fftw_real tmp16;
	       fftw_real tmp132;
	       fftw_real tmp19;
	       fftw_real tmp134;
	       fftw_real tmp169;
	       fftw_real tmp170;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp15;
		    fftw_real tmp14;
		    fftw_real tmp131;
		    fftw_real tmp18;
		    fftw_real tmp17;
		    fftw_real tmp133;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp15 = X[4 * iostride];
		    tmp14 = c_re(W[3]);
		    tmp16 = tmp14 * tmp15;
		    tmp131 = c_im(W[3]);
		    tmp132 = tmp131 * tmp15;
		    tmp18 = X[20 * iostride];
		    tmp17 = c_re(W[19]);
		    tmp19 = tmp17 * tmp18;
		    tmp133 = c_im(W[19]);
		    tmp134 = tmp133 * tmp18;
	       }
	       tmp20 = tmp16 + tmp19;
	       tmp135 = tmp132 + tmp134;
	       tmp169 = tmp132 - tmp134;
	       tmp170 = tmp16 - tmp19;
	       tmp171 = tmp169 - tmp170;
	       tmp265 = tmp170 + tmp169;
	  }
	  {
	       fftw_real tmp8;
	       fftw_real tmp126;
	       fftw_real tmp11;
	       fftw_real tmp128;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp7;
		    fftw_real tmp6;
		    fftw_real tmp125;
		    fftw_real tmp10;
		    fftw_real tmp9;
		    fftw_real tmp127;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp7 = X[8 * iostride];
		    tmp6 = c_re(W[7]);
		    tmp8 = tmp6 * tmp7;
		    tmp125 = c_im(W[7]);
		    tmp126 = tmp125 * tmp7;
		    tmp10 = X[24 * iostride];
		    tmp9 = c_re(W[23]);
		    tmp11 = tmp9 * tmp10;
		    tmp127 = c_im(W[23]);
		    tmp128 = tmp127 * tmp10;
	       }
	       tmp12 = tmp8 + tmp11;
	       tmp262 = tmp8 - tmp11;
	       tmp129 = tmp126 + tmp128;
	       tmp167 = tmp126 - tmp128;
	  }
	  {
	       fftw_real tmp94;
	       fftw_real tmp251;
	       fftw_real tmp104;
	       fftw_real tmp231;
	       fftw_real tmp97;
	       fftw_real tmp253;
	       fftw_real tmp101;
	       fftw_real tmp229;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp93;
		    fftw_real tmp92;
		    fftw_real tmp250;
		    fftw_real tmp103;
		    fftw_real tmp102;
		    fftw_real tmp230;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp93 = X[31 * iostride];
		    tmp92 = c_re(W[30]);
		    tmp94 = tmp92 * tmp93;
		    tmp250 = c_im(W[30]);
		    tmp251 = tmp250 * tmp93;
		    tmp103 = X[23 * iostride];
		    tmp102 = c_re(W[22]);
		    tmp104 = tmp102 * tmp103;
		    tmp230 = c_im(W[22]);
		    tmp231 = tmp230 * tmp103;
	       }
	       {
		    fftw_real tmp96;
		    fftw_real tmp95;
		    fftw_real tmp252;
		    fftw_real tmp100;
		    fftw_real tmp99;
		    fftw_real tmp228;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp96 = X[15 * iostride];
		    tmp95 = c_re(W[14]);
		    tmp97 = tmp95 * tmp96;
		    tmp252 = c_im(W[14]);
		    tmp253 = tmp252 * tmp96;
		    tmp100 = X[7 * iostride];
		    tmp99 = c_re(W[6]);
		    tmp101 = tmp99 * tmp100;
		    tmp228 = c_im(W[6]);
		    tmp229 = tmp228 * tmp100;
	       }
	       {
		    fftw_real tmp98;
		    fftw_real tmp105;
		    fftw_real tmp254;
		    fftw_real tmp255;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp98 = tmp94 + tmp97;
		    tmp105 = tmp101 + tmp104;
		    tmp106 = tmp98 + tmp105;
		    tmp349 = tmp98 - tmp105;
		    tmp254 = tmp251 - tmp253;
		    tmp255 = tmp101 - tmp104;
		    tmp256 = tmp254 + tmp255;
		    tmp305 = tmp254 - tmp255;
	       }
	       {
		    fftw_real tmp354;
		    fftw_real tmp355;
		    fftw_real tmp227;
		    fftw_real tmp232;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp354 = tmp251 + tmp253;
		    tmp355 = tmp229 + tmp231;
		    tmp356 = tmp354 - tmp355;
		    tmp388 = tmp354 + tmp355;
		    tmp227 = tmp94 - tmp97;
		    tmp232 = tmp229 - tmp231;
		    tmp233 = tmp227 - tmp232;
		    tmp302 = tmp227 + tmp232;
	       }
	  }
	  {
	       fftw_real tmp109;
	       fftw_real tmp235;
	       fftw_real tmp119;
	       fftw_real tmp245;
	       fftw_real tmp112;
	       fftw_real tmp237;
	       fftw_real tmp116;
	       fftw_real tmp243;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp108;
		    fftw_real tmp107;
		    fftw_real tmp234;
		    fftw_real tmp118;
		    fftw_real tmp117;
		    fftw_real tmp244;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp108 = X[3 * iostride];
		    tmp107 = c_re(W[2]);
		    tmp109 = tmp107 * tmp108;
		    tmp234 = c_im(W[2]);
		    tmp235 = tmp234 * tmp108;
		    tmp118 = X[11 * iostride];
		    tmp117 = c_re(W[10]);
		    tmp119 = tmp117 * tmp118;
		    tmp244 = c_im(W[10]);
		    tmp245 = tmp244 * tmp118;
	       }
	       {
		    fftw_real tmp111;
		    fftw_real tmp110;
		    fftw_real tmp236;
		    fftw_real tmp115;
		    fftw_real tmp114;
		    fftw_real tmp242;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp111 = X[19 * iostride];
		    tmp110 = c_re(W[18]);
		    tmp112 = tmp110 * tmp111;
		    tmp236 = c_im(W[18]);
		    tmp237 = tmp236 * tmp111;
		    tmp115 = X[27 * iostride];
		    tmp114 = c_re(W[26]);
		    tmp116 = tmp114 * tmp115;
		    tmp242 = c_im(W[26]);
		    tmp243 = tmp242 * tmp115;
	       }
	       {
		    fftw_real tmp113;
		    fftw_real tmp120;
		    fftw_real tmp241;
		    fftw_real tmp246;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp113 = tmp109 + tmp112;
		    tmp120 = tmp116 + tmp119;
		    tmp121 = tmp113 + tmp120;
		    tmp357 = tmp120 - tmp113;
		    tmp241 = tmp116 - tmp119;
		    tmp246 = tmp243 - tmp245;
		    tmp247 = tmp241 + tmp246;
		    tmp257 = tmp241 - tmp246;
	       }
	       {
		    fftw_real tmp350;
		    fftw_real tmp351;
		    fftw_real tmp238;
		    fftw_real tmp239;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp350 = tmp235 + tmp237;
		    tmp351 = tmp243 + tmp245;
		    tmp352 = tmp350 - tmp351;
		    tmp389 = tmp350 + tmp351;
		    tmp238 = tmp235 - tmp237;
		    tmp239 = tmp109 - tmp112;
		    tmp240 = tmp238 - tmp239;
		    tmp258 = tmp239 + tmp238;
	       }
	  }
	  {
	       fftw_real tmp23;
	       fftw_real tmp137;
	       fftw_real tmp26;
	       fftw_real tmp139;
	       fftw_real tmp172;
	       fftw_real tmp173;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp22;
		    fftw_real tmp21;
		    fftw_real tmp136;
		    fftw_real tmp25;
		    fftw_real tmp24;
		    fftw_real tmp138;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp22 = X[28 * iostride];
		    tmp21 = c_re(W[27]);
		    tmp23 = tmp21 * tmp22;
		    tmp136 = c_im(W[27]);
		    tmp137 = tmp136 * tmp22;
		    tmp25 = X[12 * iostride];
		    tmp24 = c_re(W[11]);
		    tmp26 = tmp24 * tmp25;
		    tmp138 = c_im(W[11]);
		    tmp139 = tmp138 * tmp25;
	       }
	       tmp27 = tmp23 + tmp26;
	       tmp140 = tmp137 + tmp139;
	       tmp172 = tmp23 - tmp26;
	       tmp173 = tmp137 - tmp139;
	       tmp174 = tmp172 + tmp173;
	       tmp264 = tmp172 - tmp173;
	  }
	  {
	       fftw_real tmp47;
	       fftw_real tmp155;
	       fftw_real tmp57;
	       fftw_real tmp162;
	       fftw_real tmp50;
	       fftw_real tmp157;
	       fftw_real tmp54;
	       fftw_real tmp160;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp46;
		    fftw_real tmp45;
		    fftw_real tmp154;
		    fftw_real tmp56;
		    fftw_real tmp55;
		    fftw_real tmp161;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp46 = X[30 * iostride];
		    tmp45 = c_re(W[29]);
		    tmp47 = tmp45 * tmp46;
		    tmp154 = c_im(W[29]);
		    tmp155 = tmp154 * tmp46;
		    tmp56 = X[22 * iostride];
		    tmp55 = c_re(W[21]);
		    tmp57 = tmp55 * tmp56;
		    tmp161 = c_im(W[21]);
		    tmp162 = tmp161 * tmp56;
	       }
	       {
		    fftw_real tmp49;
		    fftw_real tmp48;
		    fftw_real tmp156;
		    fftw_real tmp53;
		    fftw_real tmp52;
		    fftw_real tmp159;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp49 = X[14 * iostride];
		    tmp48 = c_re(W[13]);
		    tmp50 = tmp48 * tmp49;
		    tmp156 = c_im(W[13]);
		    tmp157 = tmp156 * tmp49;
		    tmp53 = X[6 * iostride];
		    tmp52 = c_re(W[5]);
		    tmp54 = tmp52 * tmp53;
		    tmp159 = c_im(W[5]);
		    tmp160 = tmp159 * tmp53;
	       }
	       {
		    fftw_real tmp187;
		    fftw_real tmp188;
		    fftw_real tmp184;
		    fftw_real tmp185;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp51 = tmp47 + tmp50;
		    tmp58 = tmp54 + tmp57;
		    tmp334 = tmp51 - tmp58;
		    tmp187 = tmp47 - tmp50;
		    tmp188 = tmp160 - tmp162;
		    tmp189 = tmp187 - tmp188;
		    tmp292 = tmp187 + tmp188;
		    tmp158 = tmp155 + tmp157;
		    tmp163 = tmp160 + tmp162;
		    tmp335 = tmp158 - tmp163;
		    tmp184 = tmp155 - tmp157;
		    tmp185 = tmp54 - tmp57;
		    tmp186 = tmp184 + tmp185;
		    tmp291 = tmp184 - tmp185;
	       }
	  }
	  {
	       fftw_real tmp78;
	       fftw_real tmp208;
	       fftw_real tmp88;
	       fftw_real tmp203;
	       fftw_real tmp81;
	       fftw_real tmp210;
	       fftw_real tmp85;
	       fftw_real tmp201;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp77;
		    fftw_real tmp76;
		    fftw_real tmp207;
		    fftw_real tmp87;
		    fftw_real tmp86;
		    fftw_real tmp202;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp77 = X[5 * iostride];
		    tmp76 = c_re(W[4]);
		    tmp78 = tmp76 * tmp77;
		    tmp207 = c_im(W[4]);
		    tmp208 = tmp207 * tmp77;
		    tmp87 = X[13 * iostride];
		    tmp86 = c_re(W[12]);
		    tmp88 = tmp86 * tmp87;
		    tmp202 = c_im(W[12]);
		    tmp203 = tmp202 * tmp87;
	       }
	       {
		    fftw_real tmp80;
		    fftw_real tmp79;
		    fftw_real tmp209;
		    fftw_real tmp84;
		    fftw_real tmp83;
		    fftw_real tmp200;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp80 = X[21 * iostride];
		    tmp79 = c_re(W[20]);
		    tmp81 = tmp79 * tmp80;
		    tmp209 = c_im(W[20]);
		    tmp210 = tmp209 * tmp80;
		    tmp84 = X[29 * iostride];
		    tmp83 = c_re(W[28]);
		    tmp85 = tmp83 * tmp84;
		    tmp200 = c_im(W[28]);
		    tmp201 = tmp200 * tmp84;
	       }
	       {
		    fftw_real tmp82;
		    fftw_real tmp89;
		    fftw_real tmp206;
		    fftw_real tmp211;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp82 = tmp78 + tmp81;
		    tmp89 = tmp85 + tmp88;
		    tmp90 = tmp82 + tmp89;
		    tmp341 = tmp89 - tmp82;
		    tmp206 = tmp78 - tmp81;
		    tmp211 = tmp208 - tmp210;
		    tmp212 = tmp206 + tmp211;
		    tmp222 = tmp211 - tmp206;
	       }
	       {
		    fftw_real tmp344;
		    fftw_real tmp345;
		    fftw_real tmp199;
		    fftw_real tmp204;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp344 = tmp208 + tmp210;
		    tmp345 = tmp201 + tmp203;
		    tmp346 = tmp344 - tmp345;
		    tmp384 = tmp344 + tmp345;
		    tmp199 = tmp85 - tmp88;
		    tmp204 = tmp201 - tmp203;
		    tmp205 = tmp199 - tmp204;
		    tmp223 = tmp199 + tmp204;
	       }
	  }
	  {
	       fftw_real tmp63;
	       fftw_real tmp193;
	       fftw_real tmp73;
	       fftw_real tmp219;
	       fftw_real tmp66;
	       fftw_real tmp195;
	       fftw_real tmp70;
	       fftw_real tmp217;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp62;
		    fftw_real tmp61;
		    fftw_real tmp192;
		    fftw_real tmp72;
		    fftw_real tmp71;
		    fftw_real tmp218;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp62 = X[iostride];
		    tmp61 = c_re(W[0]);
		    tmp63 = tmp61 * tmp62;
		    tmp192 = c_im(W[0]);
		    tmp193 = tmp192 * tmp62;
		    tmp72 = X[25 * iostride];
		    tmp71 = c_re(W[24]);
		    tmp73 = tmp71 * tmp72;
		    tmp218 = c_im(W[24]);
		    tmp219 = tmp218 * tmp72;
	       }
	       {
		    fftw_real tmp65;
		    fftw_real tmp64;
		    fftw_real tmp194;
		    fftw_real tmp69;
		    fftw_real tmp68;
		    fftw_real tmp216;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp65 = X[17 * iostride];
		    tmp64 = c_re(W[16]);
		    tmp66 = tmp64 * tmp65;
		    tmp194 = c_im(W[16]);
		    tmp195 = tmp194 * tmp65;
		    tmp69 = X[9 * iostride];
		    tmp68 = c_re(W[8]);
		    tmp70 = tmp68 * tmp69;
		    tmp216 = c_im(W[8]);
		    tmp217 = tmp216 * tmp69;
	       }
	       {
		    fftw_real tmp67;
		    fftw_real tmp74;
		    fftw_real tmp215;
		    fftw_real tmp220;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp67 = tmp63 + tmp66;
		    tmp74 = tmp70 + tmp73;
		    tmp75 = tmp67 + tmp74;
		    tmp343 = tmp67 - tmp74;
		    tmp215 = tmp63 - tmp66;
		    tmp220 = tmp217 - tmp219;
		    tmp221 = tmp215 - tmp220;
		    tmp295 = tmp215 + tmp220;
	       }
	       {
		    fftw_real tmp338;
		    fftw_real tmp339;
		    fftw_real tmp196;
		    fftw_real tmp197;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp338 = tmp193 + tmp195;
		    tmp339 = tmp217 + tmp219;
		    tmp340 = tmp338 - tmp339;
		    tmp383 = tmp338 + tmp339;
		    tmp196 = tmp193 - tmp195;
		    tmp197 = tmp70 - tmp73;
		    tmp198 = tmp196 + tmp197;
		    tmp298 = tmp196 - tmp197;
	       }
	  }
	  {
	       fftw_real tmp32;
	       fftw_real tmp144;
	       fftw_real tmp42;
	       fftw_real tmp151;
	       fftw_real tmp35;
	       fftw_real tmp146;
	       fftw_real tmp39;
	       fftw_real tmp149;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp31;
		    fftw_real tmp30;
		    fftw_real tmp143;
		    fftw_real tmp41;
		    fftw_real tmp40;
		    fftw_real tmp150;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp31 = X[2 * iostride];
		    tmp30 = c_re(W[1]);
		    tmp32 = tmp30 * tmp31;
		    tmp143 = c_im(W[1]);
		    tmp144 = tmp143 * tmp31;
		    tmp41 = X[26 * iostride];
		    tmp40 = c_re(W[25]);
		    tmp42 = tmp40 * tmp41;
		    tmp150 = c_im(W[25]);
		    tmp151 = tmp150 * tmp41;
	       }
	       {
		    fftw_real tmp34;
		    fftw_real tmp33;
		    fftw_real tmp145;
		    fftw_real tmp38;
		    fftw_real tmp37;
		    fftw_real tmp148;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp34 = X[18 * iostride];
		    tmp33 = c_re(W[17]);
		    tmp35 = tmp33 * tmp34;
		    tmp145 = c_im(W[17]);
		    tmp146 = tmp145 * tmp34;
		    tmp38 = X[10 * iostride];
		    tmp37 = c_re(W[9]);
		    tmp39 = tmp37 * tmp38;
		    tmp148 = c_im(W[9]);
		    tmp149 = tmp148 * tmp38;
	       }
	       {
		    fftw_real tmp180;
		    fftw_real tmp181;
		    fftw_real tmp177;
		    fftw_real tmp178;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp36 = tmp32 + tmp35;
		    tmp43 = tmp39 + tmp42;
		    tmp332 = tmp36 - tmp43;
		    tmp180 = tmp32 - tmp35;
		    tmp181 = tmp149 - tmp151;
		    tmp182 = tmp180 - tmp181;
		    tmp289 = tmp180 + tmp181;
		    tmp147 = tmp144 + tmp146;
		    tmp152 = tmp149 + tmp151;
		    tmp331 = tmp147 - tmp152;
		    tmp177 = tmp144 - tmp146;
		    tmp178 = tmp39 - tmp42;
		    tmp179 = tmp177 + tmp178;
		    tmp288 = tmp177 - tmp178;
	       }
	  }
	  {
	       fftw_real tmp91;
	       fftw_real tmp386;
	       fftw_real tmp394;
	       fftw_real tmp396;
	       fftw_real tmp397;
	       fftw_real tmp391;
	       fftw_real tmp395;
	       fftw_real tmp122;
	       fftw_real tmp142;
	       fftw_real tmp392;
	       fftw_real tmp29;
	       fftw_real tmp380;
	       fftw_real tmp165;
	       fftw_real tmp381;
	       fftw_real tmp60;
	       fftw_real tmp393;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp382;
		    fftw_real tmp385;
		    fftw_real tmp387;
		    fftw_real tmp390;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp91 = tmp75 + tmp90;
		    tmp382 = tmp75 - tmp90;
		    tmp385 = tmp383 - tmp384;
		    tmp386 = tmp382 + tmp385;
		    tmp394 = tmp385 - tmp382;
		    tmp396 = tmp383 + tmp384;
		    tmp397 = tmp388 + tmp389;
		    tmp387 = tmp106 - tmp121;
		    tmp390 = tmp388 - tmp389;
		    tmp391 = tmp387 - tmp390;
		    tmp395 = tmp387 + tmp390;
	       }
	       {
		    fftw_real tmp130;
		    fftw_real tmp141;
		    fftw_real tmp13;
		    fftw_real tmp28;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp122 = tmp106 + tmp121;
		    tmp130 = tmp124 + tmp129;
		    tmp141 = tmp135 + tmp140;
		    tmp142 = tmp130 + tmp141;
		    tmp392 = tmp130 - tmp141;
		    tmp13 = tmp5 + tmp12;
		    tmp28 = tmp20 + tmp27;
		    tmp29 = tmp13 + tmp28;
		    tmp380 = tmp13 - tmp28;
		    {
			 fftw_real tmp153;
			 fftw_real tmp164;
			 fftw_real tmp44;
			 fftw_real tmp59;
			 ASSERT_ALIGNED_DOUBLE();
			 tmp153 = tmp147 + tmp152;
			 tmp164 = tmp158 + tmp163;
			 tmp165 = tmp153 + tmp164;
			 tmp381 = tmp153 - tmp164;
			 tmp44 = tmp36 + tmp43;
			 tmp59 = tmp51 + tmp58;
			 tmp60 = tmp44 + tmp59;
			 tmp393 = tmp59 - tmp44;
		    }
	       }
	       X[0] = tmp29 + tmp60 + tmp91 + tmp122;
	       Y[-8 * iostride] = tmp142 + tmp122 - (tmp165 + tmp91);
	       Y[0] = tmp142 + tmp165 + tmp396 + tmp397;
	       X[8 * iostride] = tmp29 + tmp396 - (tmp60 + tmp397);
	       X[4 * iostride] = tmp380 + tmp381 + (K707106781 * (tmp386 + tmp391));
	       Y[-12 * iostride] = tmp392 + (K707106781 * tmp391) - (tmp393 + (K707106781 * tmp386));
	       Y[-4 * iostride] = tmp392 + tmp393 + (K707106781 * (tmp394 + tmp395));
	       X[12 * iostride] = tmp380 + (K707106781 * tmp394) - (tmp381 + (K707106781 * tmp395));
	  }
	  {
	       fftw_real tmp330;
	       fftw_real tmp368;
	       fftw_real tmp372;
	       fftw_real tmp378;
	       fftw_real tmp375;
	       fftw_real tmp379;
	       fftw_real tmp359;
	       fftw_real tmp367;
	       fftw_real tmp348;
	       fftw_real tmp366;
	       fftw_real tmp362;
	       fftw_real tmp376;
	       fftw_real tmp365;
	       fftw_real tmp369;
	       fftw_real tmp337;
	       fftw_real tmp377;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp328;
		    fftw_real tmp329;
		    fftw_real tmp370;
		    fftw_real tmp371;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp328 = tmp5 - tmp12;
		    tmp329 = tmp135 - tmp140;
		    tmp330 = tmp328 - tmp329;
		    tmp368 = tmp328 + tmp329;
		    tmp370 = tmp340 + tmp341;
		    tmp371 = tmp343 + tmp346;
		    tmp372 = (K382683432 * tmp370) + (K923879532 * tmp371);
		    tmp378 = (K923879532 * tmp370) - (K382683432 * tmp371);
	       }
	       {
		    fftw_real tmp373;
		    fftw_real tmp374;
		    fftw_real tmp353;
		    fftw_real tmp358;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp373 = tmp349 + tmp352;
		    tmp374 = tmp356 + tmp357;
		    tmp375 = (K923879532 * tmp373) - (K382683432 * tmp374);
		    tmp379 = (K923879532 * tmp374) + (K382683432 * tmp373);
		    tmp353 = tmp349 - tmp352;
		    tmp358 = tmp356 - tmp357;
		    tmp359 = (K382683432 * tmp353) - (K923879532 * tmp358);
		    tmp367 = (K382683432 * tmp358) + (K923879532 * tmp353);
	       }
	       {
		    fftw_real tmp342;
		    fftw_real tmp347;
		    fftw_real tmp360;
		    fftw_real tmp361;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp342 = tmp340 - tmp341;
		    tmp347 = tmp343 - tmp346;
		    tmp348 = (K923879532 * tmp342) + (K382683432 * tmp347);
		    tmp366 = (K382683432 * tmp342) - (K923879532 * tmp347);
		    tmp360 = tmp124 - tmp129;
		    tmp361 = tmp27 - tmp20;
		    tmp362 = tmp360 - tmp361;
		    tmp376 = tmp360 + tmp361;
	       }
	       {
		    fftw_real tmp363;
		    fftw_real tmp364;
		    fftw_real tmp333;
		    fftw_real tmp336;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp363 = tmp334 - tmp335;
		    tmp364 = tmp332 + tmp331;
		    tmp365 = K707106781 * (tmp363 - tmp364);
		    tmp369 = K707106781 * (tmp364 + tmp363);
		    tmp333 = tmp331 - tmp332;
		    tmp336 = tmp334 + tmp335;
		    tmp337 = K707106781 * (tmp333 - tmp336);
		    tmp377 = K707106781 * (tmp333 + tmp336);
	       }
	       X[6 * iostride] = tmp330 + tmp337 + tmp348 + tmp359;
	       Y[-14 * iostride] = tmp362 + tmp359 - (tmp365 + tmp348);
	       Y[-6 * iostride] = tmp362 + tmp365 + tmp366 + tmp367;
	       X[14 * iostride] = tmp330 + tmp366 - (tmp337 + tmp367);
	       X[2 * iostride] = tmp368 + tmp369 + tmp372 + tmp375;
	       Y[-10 * iostride] = tmp376 + tmp375 - (tmp377 + tmp372);
	       Y[-2 * iostride] = tmp376 + tmp377 + tmp378 + tmp379;
	       X[10 * iostride] = tmp368 + tmp378 - (tmp369 + tmp379);
	  }
	  {
	       fftw_real tmp297;
	       fftw_real tmp318;
	       fftw_real tmp311;
	       fftw_real tmp317;
	       fftw_real tmp312;
	       fftw_real tmp313;
	       fftw_real tmp324;
	       fftw_real tmp287;
	       fftw_real tmp316;
	       fftw_real tmp307;
	       fftw_real tmp322;
	       fftw_real tmp304;
	       fftw_real tmp321;
	       fftw_real tmp300;
	       fftw_real tmp319;
	       fftw_real tmp294;
	       fftw_real tmp325;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp296;
		    fftw_real tmp309;
		    fftw_real tmp310;
		    fftw_real tmp285;
		    fftw_real tmp286;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp296 = K707106781 * (tmp212 + tmp205);
		    tmp297 = tmp295 - tmp296;
		    tmp318 = tmp295 + tmp296;
		    tmp309 = (K923879532 * tmp292) - (K382683432 * tmp291);
		    tmp310 = (K382683432 * tmp288) + (K923879532 * tmp289);
		    tmp311 = tmp309 - tmp310;
		    tmp317 = tmp310 + tmp309;
		    tmp312 = tmp124 + tmp262;
		    tmp313 = K707106781 * (tmp171 + tmp174);
		    tmp324 = tmp313 - tmp312;
		    tmp285 = tmp166 + tmp167;
		    tmp286 = K707106781 * (tmp265 + tmp264);
		    tmp287 = tmp285 - tmp286;
		    tmp316 = tmp285 + tmp286;
	       }
	       {
		    fftw_real tmp306;
		    fftw_real tmp303;
		    fftw_real tmp299;
		    fftw_real tmp290;
		    fftw_real tmp293;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp306 = K707106781 * (tmp240 + tmp247);
		    tmp307 = tmp305 - tmp306;
		    tmp322 = tmp305 + tmp306;
		    tmp303 = K707106781 * (tmp258 + tmp257);
		    tmp304 = tmp302 - tmp303;
		    tmp321 = tmp302 + tmp303;
		    tmp299 = K707106781 * (tmp222 + tmp223);
		    tmp300 = tmp298 - tmp299;
		    tmp319 = tmp298 + tmp299;
		    tmp290 = (K923879532 * tmp288) - (K382683432 * tmp289);
		    tmp293 = (K923879532 * tmp291) + (K382683432 * tmp292);
		    tmp294 = tmp290 - tmp293;
		    tmp325 = tmp290 + tmp293;
	       }
	       {
		    fftw_real tmp320;
		    fftw_real tmp323;
		    fftw_real tmp326;
		    fftw_real tmp327;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp320 = (K980785280 * tmp318) + (K195090322 * tmp319);
		    tmp323 = (K980785280 * tmp321) - (K195090322 * tmp322);
		    X[iostride] = tmp316 + tmp317 + tmp320 + tmp323;
		    Y[-9 * iostride] = tmp324 + tmp323 - (tmp325 + tmp320);
		    tmp326 = (K980785280 * tmp319) - (K195090322 * tmp318);
		    tmp327 = (K195090322 * tmp321) + (K980785280 * tmp322);
		    X[9 * iostride] = tmp316 + tmp326 - (tmp317 + tmp327);
		    Y[-iostride] = tmp324 + tmp325 + tmp326 + tmp327;
	       }
	       {
		    fftw_real tmp301;
		    fftw_real tmp308;
		    fftw_real tmp314;
		    fftw_real tmp315;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp301 = (K555570233 * tmp297) + (K831469612 * tmp300);
		    tmp308 = (K555570233 * tmp304) - (K831469612 * tmp307);
		    X[5 * iostride] = tmp287 + tmp294 + tmp301 + tmp308;
		    Y[-13 * iostride] = tmp308 - (tmp311 + tmp301) - (tmp312 + tmp313);
		    tmp314 = (K555570233 * tmp300) - (K831469612 * tmp297);
		    tmp315 = (K831469612 * tmp304) + (K555570233 * tmp307);
		    X[13 * iostride] = tmp287 + tmp314 - (tmp294 + tmp315);
		    Y[-5 * iostride] = tmp311 + tmp314 + tmp315 - (tmp312 + tmp313);
	       }
	  }
	  {
	       fftw_real tmp214;
	       fftw_real tmp275;
	       fftw_real tmp267;
	       fftw_real tmp281;
	       fftw_real tmp270;
	       fftw_real tmp274;
	       fftw_real tmp191;
	       fftw_real tmp282;
	       fftw_real tmp260;
	       fftw_real tmp279;
	       fftw_real tmp249;
	       fftw_real tmp278;
	       fftw_real tmp225;
	       fftw_real tmp276;
	       fftw_real tmp176;
	       fftw_real tmp273;
	       fftw_real tmp213;
	       fftw_real tmp263;
	       fftw_real tmp266;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp213 = K707106781 * (tmp205 - tmp212);
	       tmp214 = tmp198 - tmp213;
	       tmp275 = tmp198 + tmp213;
	       tmp263 = tmp262 - tmp124;
	       tmp266 = K707106781 * (tmp264 - tmp265);
	       tmp267 = tmp263 - tmp266;
	       tmp281 = tmp263 + tmp266;
	       {
		    fftw_real tmp268;
		    fftw_real tmp269;
		    fftw_real tmp183;
		    fftw_real tmp190;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp268 = (K382683432 * tmp189) - (K923879532 * tmp186);
		    tmp269 = (K923879532 * tmp179) + (K382683432 * tmp182);
		    tmp270 = tmp268 - tmp269;
		    tmp274 = tmp269 + tmp268;
		    tmp183 = (K382683432 * tmp179) - (K923879532 * tmp182);
		    tmp190 = (K382683432 * tmp186) + (K923879532 * tmp189);
		    tmp191 = tmp183 - tmp190;
		    tmp282 = tmp183 + tmp190;
	       }
	       {
		    fftw_real tmp259;
		    fftw_real tmp248;
		    fftw_real tmp224;
		    fftw_real tmp168;
		    fftw_real tmp175;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp259 = K707106781 * (tmp257 - tmp258);
		    tmp260 = tmp256 - tmp259;
		    tmp279 = tmp256 + tmp259;
		    tmp248 = K707106781 * (tmp240 - tmp247);
		    tmp249 = tmp233 - tmp248;
		    tmp278 = tmp233 + tmp248;
		    tmp224 = K707106781 * (tmp222 - tmp223);
		    tmp225 = tmp221 - tmp224;
		    tmp276 = tmp221 + tmp224;
		    tmp168 = tmp166 - tmp167;
		    tmp175 = K707106781 * (tmp171 - tmp174);
		    tmp176 = tmp168 - tmp175;
		    tmp273 = tmp168 + tmp175;
	       }
	       {
		    fftw_real tmp226;
		    fftw_real tmp261;
		    fftw_real tmp271;
		    fftw_real tmp272;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp226 = (K980785280 * tmp214) + (K195090322 * tmp225);
		    tmp261 = (K195090322 * tmp249) - (K980785280 * tmp260);
		    X[7 * iostride] = tmp176 + tmp191 + tmp226 + tmp261;
		    Y[-15 * iostride] = tmp267 + tmp261 - (tmp270 + tmp226);
		    tmp271 = (K195090322 * tmp214) - (K980785280 * tmp225);
		    tmp272 = (K195090322 * tmp260) + (K980785280 * tmp249);
		    X[15 * iostride] = tmp176 + tmp271 - (tmp191 + tmp272);
		    Y[-7 * iostride] = tmp267 + tmp270 + tmp271 + tmp272;
	       }
	       {
		    fftw_real tmp277;
		    fftw_real tmp280;
		    fftw_real tmp283;
		    fftw_real tmp284;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp277 = (K555570233 * tmp275) + (K831469612 * tmp276);
		    tmp280 = (K831469612 * tmp278) - (K555570233 * tmp279);
		    X[3 * iostride] = tmp273 + tmp274 + tmp277 + tmp280;
		    Y[-11 * iostride] = tmp281 + tmp280 - (tmp282 + tmp277);
		    tmp283 = (K831469612 * tmp275) - (K555570233 * tmp276);
		    tmp284 = (K831469612 * tmp279) + (K555570233 * tmp278);
		    X[11 * iostride] = tmp273 + tmp283 - (tmp274 + tmp284);
		    Y[-3 * iostride] = tmp281 + tmp282 + tmp283 + tmp284;
	       }
	  }
     }
}

static const int twiddle_order[] =
{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31};
fftw_codelet_desc fftw_hc2hc_forward_32_desc =
{
     "fftw_hc2hc_forward_32",
     (void (*)()) fftw_hc2hc_forward_32,
     32,
     FFTW_FORWARD,
     FFTW_HC2HC,
     515,
     31,
     twiddle_order,
};
