/*
The DsTool program is the property of:
 
                             Cornell University 
                        Center of Applied Mathematics 
                              Ithaca, NY 14853
                      dstool_bugs@macomb.tn.cornell.edu
 
and may be used, modified and distributed freely, subject to the following
restrictions:
 
       Any product which incorporates source code from the DsTool
       program or utilities, in whole or in part, is distributed
       with a copy of that source code, including this notice. You
       must give the recipients all the rights that you have with
       respect to the use of this software. Modifications of the
       software must carry prominent notices stating who changed
       the files and the date of any change.
 
DsTool is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of FITNESS FOR A PARTICULAR PURPOSE.
The software is provided as is without any obligation on the part of Cornell 
faculty, staff or students to assist in its use, correction, modification or
enhancement.
*/

/*
 * utilities.h
 *
 * Header file for declarations of many basic utilities and functions.
 *
 */

#ifndef UTILITIES_h
#define UTILITIES_h

#include <tcl.h>
#include <stdio.h>

/* system_mess.c */
void system_mess_proc(int mode, char *msg);

/* macros.c */
void get_n_all_types(int *pn_varb, int *pn_param, int *pn_funct);
int max_varb_index();
int index_to_type(int index);
int index_to_count(int index);
int type_count_to_index(int type, int count);

/* tcl_utils.c */
int prepend_to_auto_path(const char *path);
int tcl_script(char *script);
void tcl_update(void);
void setup_tcl_update(void);
ClientData get_ClientData(char *obj);

/* interrupt.c */
int interrupt(void);
void set_interrupt(void);
void reset_interrupt(void);

/* geomview.c */
void open_geomview(FILE **to, FILE **from);
void geomview_send(char *str);
void geomview_wait(void);
void geomview_transform(int n, double f[]);
FILE *geomview_get_fp(void);

/* dir_util.c */
int get_dstool_path(char *dirname, int dir_type);

/* get_cwd.c */
void get_cwd(char *dirname, int size);

/* file_util.c */
int check_file_to_write(char *fname);
int check_file_to_read(char *fname);
FILE *open_pm_file(char *pmfile, char *pmdir);

/* user_util.c */
char *get_user_info(void);

/* time_util.c */
char* get_the_time(void);

#endif
/* !_UTILITIES_h */
