/*
 * defs.h
 *
 *  Programmmed by Hirotsugu Kakugawa, Hiroshima University
 *  E-Mail:  h.kakugawa@computer.org
 *
 *  Edition History
 *     1 Apr 1996:  VF_MAX_HBF_FONTS added (WL)
 *
 */


/* This file is part of VFlib
 *
 * Copyright (C) 1995-1998 Hirotsugu KAKUGAWA.   All rights reserved.
 *
 * This file is part of the VFlib Library.  This library is free
 * software; you can redistribute it and/or modify it under the terms of
 * the GNU Library General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your
 * option) any later version.  This library is distributed in the hope
 * that it will be useful, but WITHOUT ANY WARRANTY; without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU Library General Public License for more details.
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __VFLIB_DEFS_H__
#define __VFLIB_DEFS_H__


/** for Font Management **/
/* Maximum number of Fonts */
#ifndef   MAX_FONTS
# define  MAX_FONTS       128
#endif /* MAX_FONTS */
/* The maximum number of fonts for each font class */
#define VF_MAX_SONY_FONTS   64
#define VF_MAX_ZEIT_FONTS   64
#define VF_MAX_JG_FONTS     64
#define VF_MAX_TT_FONTS     64
#define VF_MAX_BDF_FONTS    64
#define VF_MAX_HBF_FONTS    64
#define VF_MAX_FONTWAVE_FONTS 64

/** for Dynamic Opening/Closing Font File **/
/* Maximum number of Font Files */
#ifndef   MAX_FONT_FILES
# define   MAX_FONT_FILES  256
#endif /* MAX_FONT_FILES */

/* Maximum number of (internally) opened Font Files */
#ifndef   MAX_OPEN_FONT_FILES
# define  MAX_OPEN_FONT_FILES  6
#endif /* MAX_OPEN_FONT_FILES */

/* for opened font LRU list */
#define HASH_SIZE  31



#if defined(SYSV)||defined(SYSV_STRINGS)||defined(HAVE_MEMSET) 
# define bzero(b,l)      memset((char*)(b),(int)0,(l))
# define bcmp(b1,b2,l)   memcmp((char*)(b1),(char*)(b2),(l))
# define bcopy(b1,b2,l)  memmove((char*)(b2),(char*)(b1),(l))
#endif 
#if defined(SYSV)||defined(SYSV_STRINGS)||defined(HAVE_STRCHR) 
# define index(s,c)      strchr((s),(c))
#endif 

#endif /* __VFLIB_DEFS_H__ */
