// This program produces the contents of "fl_cmap.h" as stdout

// #include <gl/gl.h>
#include <stdio.h>

// This table is initialized with color values I got by reading the
// colormap on an IRIX 4.3 machine:

static short cmap[256][3] = {
// 3-bit colormap:
  {  0,  0,  0},	// black
  {255,  0,  0},	// red
  {  0,255,  0},	// green
  {255,255,  0},	// yellow
  {  0,  0,255},	// blue
  {255,  0,255},	// magenta
  {  0,255,255},	// cyan
  {255,255,255},	// white
// pastel versions of those colors:
  { 85, 85, 85},	// gray33.3
  {198,113,113},	// salmon? pale red?
  {113,198,113},	// pale green
  {142,142, 56},	// khaki
  {113,113,198},	// pale blue
  {142, 56,142},	// purple, orchid, pale magenta
  { 56,142,142},	// cadet blue, aquamarine, pale cyan
  {170,170,170},	// FL_GRAY is {166,166,166},
// These next 16 are the FL_FREE_COLOR area.  For compatability with
// some existing DD programs, I prefill them with the random colors
// you get on a 5.3 machine:
  { 16, 16, 16},
  {128, 40,128},
  {198, 30, 30},
  { 66, 30, 30},
  {176,140,140},
  {  0, 20, 20},
  { 20, 10, 10},
  { 40, 20, 20},
  { 60, 30, 30},
  {  0, 80, 80},
  {  0, 40, 40},
  { 20, 20,  0},
  { 40, 40,  0},
  { 80, 80, 10},
  {150,150, 20},
  {160, 10, 10},
// The rest of the colormap is a gray ramp and table, filled in below:
};

int main() {
  int i,r,g,b;
#if 0
  /* Read colormap colors into internal table */
  long cmwin;
  noport();
  cmwin = winopen("CM");
  for (i=0; i<256; i++)
    getmcolor(i,&cmap[i][0],&cmap[i][1],&cmap[i][2]);
  winclose(cmwin);
#endif
// overwrite the X allocation area with one color so people are
// discouraged from using it:
  for (i=16; i<32; i++) {cmap[i][0]=cmap[i][1]=cmap[i][2] = 85;}
  // fill in the gray ramp:
  for (i = 32; i < 56; i++) {
    int m = ((i-32)*255+11)/23;
    cmap[i][0] = cmap[i][1] = cmap[i][2] = m;
  }
  // modify the colors nearest 1/3 and 2/3 to be exactly that:
  cmap[47][0] = cmap[47][1] = cmap[47][2] = 170; // was 166
  cmap[40][0] = cmap[40][1] = cmap[40][2] = 85; // was 89
  // fill in the color cube
  i = 56;
  for (b=0; b<5; b++)
    for (r=0; r<5; r++)
      for (g=0; g<8; g++) {
	cmap[i][0] = r*255/4;
	cmap[i][1] = g*255/7;
	cmap[i][2] = b*255/4;
	i++;
      }

  for (i=0; i<256; i++) {
    printf("\t0x%02x%02x%02x00",cmap[i][0],cmap[i][1],cmap[i][2]);
    if (i < 255) printf(",\n");
  }
  printf("\n");
  return 0;
}
