// Fl_Menu_Button.C

// Emulation of the Forms menu widget, which was just a wrapper
// for the GL menus.  Fortunately, the Forms menu interface
// hid some of the GL interface, so I didn't have to reproduce
// all of the GL one.

// Not at all guaranteed to be compatable, especially with any
// string with a % sign in it!

#include <FL/Fl.H>
#include <FL/Fl_Menu_Button.H>
#include <FL/fl_draw.H>

void Fl_Menu_Button::draw() {
  if (!box()) return;
  uchar c1 = pushed ? color2() : color();
  draw_box(pushed ? (down_box()?down_box():box()+1) : box(), c1);
  draw_label();
  if (box() == FL_FLAT_BOX) return; // for XForms compatability
  int H = (labelsize()-3)&-2;
  int X = x()+w()-H*2;
  int Y = y()+(h()-H)/2;
  fl_color(FL_DARK3); fl_line(X+H/2, Y+H, X, Y, X+H, Y);
  fl_color(FL_LIGHT3); fl_line(X+H, Y, X+H/2, Y+H);
}

const Fl_Menu* Fl_Menu_::popup(int x, int y, int w, int h) {
  Fl_Menu::textfont(textfont());
  Fl_Menu::textsize(textsize());
  const Fl_Menu *v = menu()->popup(x, y, w, h, mvalue(), label());
  picked(v);
  return v;
}

const Fl_Menu* Fl_Menu_Button::popup() {
  if (!box()) return popup(Fl::event_x(),Fl::event_y(),0,0);
  Fl_Menu::textfont(textfont());
  Fl_Menu::textsize(textsize());
  pushed = 1; redraw();
  const Fl_Menu *v = menu()->popup(x(),y(),w(),h(),0);
  pushed = 0; redraw();
  picked(v);
  return v;
}

int Fl_Menu_Button::handle(int e) {
  if (!menu() || !menu()->text) return 0;
  switch (e) {
  case FL_ENTER:
  case FL_LEAVE:
    return box() ? 1 : 0;
  case FL_PUSH:
    if (!box() && Fl::event_button() != 3) return 0;
    popup();
    return 1;
  case FL_SHORTCUT:
    if (test_shortcut()) {popup(); return 1;}
    {const Fl_Menu *v = menu()->test_shortcut();
    if (v) {picked(v); return 1;}}
    return 0;
  default:
    return 0;
  }
}

Fl_Menu_Button::Fl_Menu_Button(int X,int Y,int W,int H,const char *l)
: Fl_Menu_(X,Y,W,H,l) {
  down_box(0);
  pushed = 0;
}

// end of Fl_Menu_Button.C
