// win32.H

// These are internal fltk symbols that are necessary or useful for
// calling win32 gdi.  You should include this file if (and ONLY if) you
// need to call the win32 gdi directly.  These symbols may not exist
// on non-windows systems.

#ifndef Fl_X_H
#define Fl_X_H

#include <windows.h>

// some random X equivalents
#define XPoint POINT
struct XRectangle {int x, y, width, height;};
struct Region {int x, y, r, b; void operator=(int x) {r = x;}};
inline void XClipBox(Region& i, XRectangle* o) {
  o->x = i.x; o->y = i.y; o->width = i.r-i.x; o->height = i.b-i.y;}
#define fl_clip_region(R) fl_clip((R).x,(R).y,(R).r-(R).x,(R).b-(R).y)

#include "Fl_Window.H"
// this object contains all win32-specific stuff about a window:
// Warning: this object is highly subject to change!
class Fl_X {
public:
  HWND xid;
  HBITMAP other_xid; // for double-buffered windows
  Fl_Window* w;
  Region region;
  Fl_X *next;
  HDC private_dc; // used for OpenGL
  HCURSOR cursor;
  static Fl_X* first;
  static Fl_X* i(const Fl_Window* w) {return w->i;}
  void setwindow(Fl_Window* wi) {w=wi; wi->i=this;}
  void flush() {w->flush();}
  void set_minmax(LPMINMAXINFO minmax);
  void mapraise();
  static Fl_X* make(Fl_Window*);
};
extern HCURSOR fl_default_cursor;
inline HWND fl_xid(const Fl_Window*w) {return Fl_X::i(w)->xid;}
Fl_Window* fl_find(HWND xid);
extern char fl_override_redirect; // hack into Fl_Window::make_xid()
extern int fl_background_pixel;  // hack into Fl_Window::make_xid()

// a selected color points at one of these:
struct Fl_XMap {
  COLORREF rgb;	// this should be the type the RGB() macro returns
  HPEN pen;	// pen, 0 if none created yet
  char brush;	// ref to solid brush, 0 if none created yet
};
extern Fl_XMap fl_xmap[256];
extern Fl_XMap *fl_current_xmap; // points at last fl_color() or fl_rgbcolor()

inline COLORREF fl_RGB() {return fl_current_xmap->rgb;}
inline HPEN fl_pen() {return fl_current_xmap->pen;}
HBRUSH fl_brush();

extern HINSTANCE fl_display;
extern HWND fl_window;
extern HDC fl_gc;
extern HPALETTE fl_colormap;

extern MSG fl_msg;

// off-screen pixmaps: create, destroy, draw into, copy to window
#define Fl_Offscreen HBITMAP
#define fl_create_offscreen(w, h) CreateCompatibleBitmap(fl_gc, w, h)
extern void fl_switch_offscreen(HBITMAP);
#define fl_begin_offscreen(b) HDC _sw=fl_gc; fl_switch_offscreen(b)
#define fl_end_offscreen() fl_gc = _sw
void fl_make_current(HBITMAP bitmap);
void fl_copy_offscreen(int x,int y,int w,int h,HBITMAP pixmap,int srcx,int srcy);
#define fl_delete_offscreen(bitmap) DeleteObject(bitmap);

#endif

