// Fl_Browser_.H

// This is the base class for browsers.  To be useful it must
// be subclassed and several virtual functions defined.  The
// Forms-compatable browser and the file chooser's browser are
// subclassed off of this.

// Yes, I know this should be a template...

#ifndef Fl_Browser__H
#define Fl_Browser__H

#ifndef Fl_Group_H
#include "Fl_Group.H"
#endif
#include "Fl_Slider.H"

#define FL_NORMAL_BROWSER	0
#define FL_SELECT_BROWSER	1
#define FL_HOLD_BROWSER		2
#define FL_MULTI_BROWSER	3

class Fl_Browser_ : public Fl_Group {
  int position_;	// where user wants it scrolled to
  int real_position_;	// the current scrolling position
  void *top_;		// which item scrolling position is in
  int offset_;		// and how far down that item it is
  void *selection_;	// which is selected (except for FL_MULTI_BROWSER)
  void update_top();
  void *redraw1,*redraw2; // minimal update pointers

protected:

  Fl_Slider scrollbar;

  // All of the following must be supplied by the subclass:
  virtual void *item_first() const = 0;
  virtual void *item_next(void *) const = 0;
  virtual void *item_prev(void *) const = 0;
  virtual int item_height(void *) const = 0;
  virtual int item_quick_height(void *) const ;
  virtual void item_draw(void *,int,int,int,int) const = 0;
  // you don't have to provide these but it may help speed it up:
  virtual int full_height() const ;	// current height of all items
  virtual int incr_height() const ;	// average height of an item
  // These only need to be done by subclass if you want a multi-browser:
  virtual void item_select(void *,int=1);
  virtual int item_selected(void *) const ;

  // things the subclass may want to call:
  void *top() const {return top_;}
  void *selection() const {return selection_;}
  void new_list(); // completely clobber all data, as though list replaced
  void deleting(void *a); // get rid of any pointers to a
  void replacing(void *a,void *b); // change a pointers to b
  int displayed(void *) const ; // true if this line is visible
  void redraw_line(void *); // minimal update, no change in size
  void redraw_lines() {damage(1);} // redraw all of them
  int leftedge();	// x postion after scrollbar & border
  void *find_item(int my); // item under mouse
  void draw(int,int,int,int);
  int handle(int,int,int,int,int);

  void draw();
  int handle(int);
  Fl_Browser_(int,int,int,int,const char * = 0);

public:

  void resize(int,int,int,int);

  int select(void *,int=1,int docallbacks=0);
  int select_only(void *,int docallbacks=0);
  int deselect(int docallbacks=0);
  int position() const {return position_;}
  void position(int); // scroll to here
  void display(void*); // scroll so this item is shown

  void selection_color(uchar n) {color2(n);}
  uchar selection_color() const {return color2();}

};

#endif
